/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.table.GroupableTableHeader;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class HeaderListener
extends MouseAdapter
implements ActionListener {
    static final byte[] _UpBytes = new byte[]{71, 73, 70, 56, 57, 97, 10, 0, 5, 0, -128, 0, 0, 0, 0, 0, -1, -1, -1, 33, -7, 4, 1, 0, 0, 1, 0, 44, 0, 0, 0, 0, 10, 0, 5, 0, 64, 2, 12, -116, 3, 112, -104, -19, -26, -46, 98, -14, -60, 22, 10, 0, 59, 0};
    static final byte[] _DownBytes = new byte[]{71, 73, 70, 56, 57, 97, 10, 0, 5, 0, -128, 0, 0, 0, 0, 0, -1, -1, -1, 33, -7, 4, 1, 0, 0, 1, 0, 44, 0, 0, 0, 0, 10, 0, 5, 0, 64, 2, 11, -124, -113, -95, 97, -69, -40, 20, 60, 46, -87, 2, 0, 59};
    public static final int ICON_WIDTH = 16;
    private HashMap _hiddenColumnCellEditor = new HashMap();
    private HashMap _hiddenColumnCellRenderer = new HashMap();
    private boolean _sortable = true;
    JCheckBoxMenuItem[] _cbmi;
    static ImageIcon _UpImage = new ImageIcon(_UpBytes);
    static ImageIcon _DownImage = new ImageIcon(_DownBytes);
    JPopupMenu _menu;
    KTable _table;
    SortRenderer _sortRenderer;
    boolean _isAscending = true;
    long _lastClickWhen;
    boolean _allowAddRemoveColumn = true;
    int _sortColumn = -1;

    public static final ImageIcon getUpImage() {
        return _UpImage;
    }

    public static final ImageIcon getDownImage() {
        return _DownImage;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this._sortable) {
            return;
        }
        KTable table = (KTable)((JTableHeader)e.getSource()).getTable();
        KTableModel model = (KTableModel)table.getModel();
        if (model.getRowCount() == 0) {
            return;
        }
        TableColumnModel columnModel = table.getColumnModel();
        int viewColumn = columnModel.getColumnIndexAtX(e.getX());
        int column = table.convertColumnIndexToModel(viewColumn);
        if (column == -1) {
            return;
        }
        if (table.isEditing()) {
            table.editingStopped(null);
        }
        if (((JComponent)e.getSource()).getCursor() == Cursor.getPredefinedCursor(11)) {
            if (e.getWhen() - this._lastClickWhen < 500L) {
                table.colWidthToWidest(viewColumn);
                table.revalidate();
            } else {
                this._lastClickWhen = e.getWhen();
            }
        } else {
            if (this._sortRenderer == null) {
                this._sortRenderer = new SortRenderer(table.getTableHeader().getDefaultRenderer());
                table.getTableHeader().setDefaultRenderer(this._sortRenderer);
            }
            table.setCursor(Cursor.getPredefinedCursor(3));
            this._isAscending = viewColumn == this._sortColumn ? !this._isAscending : true;
            ListSelectionModel selection = table.getSelectionModel();
            model.sort(column, this._isAscending, selection);
            this._sortColumn = viewColumn;
            table.getTableHeader().resizeAndRepaint();
            table.repaint(table.getVisibleRect());
            table.setCursor(Cursor.getDefaultCursor());
            if (table.isMultiRow()) {
                table.calcMultiRowHeight();
            }
            if (!selection.isSelectionEmpty()) {
                try {
                    table.see(selection.getLeadSelectionIndex(), 0);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void setAllowAddRemoveColumn(boolean on) {
        this._allowAddRemoveColumn = on;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    private void checkPopup(MouseEvent e) {
        if (this._allowAddRemoveColumn && e.isPopupTrigger()) {
            this._table = (KTable)((JTableHeader)e.getSource()).getTable();
            if (this._menu == null) {
                this._menu = this.buildMenu(((KTableModel)this._table.getModel()).getHeaders());
            }
            this._menu.show((JTableHeader)e.getSource(), e.getX(), e.getY());
            e.consume();
        }
    }

    public void reset(KTable table) {
        this._sortColumn = -1;
    }

    public void clear() {
        this._sortColumn = -1;
        this._menu = null;
        this._allowAddRemoveColumn = true;
        this._sortable = true;
    }

    JPopupMenu buildMenu(String[] headers) {
        JPopupMenu m = new JPopupMenu();
        JTableHeader header = this._table.getTableHeader();
        TableColumnModel columnModel = this._table.getColumnModel();
        this._cbmi = new JCheckBoxMenuItem[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            this._cbmi[i] = new JCheckBoxMenuItem(headers[i], true);
            int viewColumn = this._table.convertColumnIndexToView(i);
            if (viewColumn < 0) continue;
            if (!(header instanceof GroupableTableHeader) || ((GroupableTableHeader)header).getColumnGroups(columnModel.getColumn(viewColumn)) == null) {
                this._cbmi[i].addActionListener(this);
            } else {
                this._cbmi[i].setEnabled(false);
            }
            m.add(this._cbmi[i]);
        }
        return m;
    }

    public void showColumn(boolean show, KTable table, int col) {
        if (this._menu == null) {
            this._table = table;
            this._menu = this.buildMenu(((KTableModel)table.getModel()).getHeaders());
        }
        this._cbmi[col].setSelected(show);
        this.actionPerformed(new ActionEvent(this._cbmi[col], 1, "DESELECT"));
    }

    public String getCheckBoxMenuItemName(int col, KTable table) {
        if (this._menu == null) {
            this._table = table;
            this._menu = this.buildMenu(((KTableModel)table.getModel()).getHeaders());
        }
        if (this._cbmi != null && col < this._cbmi.length) {
            return this._cbmi[col].getText();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)e.getSource();
        if (cbmi.isSelected()) {
            int colIndex;
            String[] h = ((KTableModel)this._table.getModel()).getHeaders();
            for (colIndex = 0; colIndex < h.length && !h[colIndex].equals(cbmi.getText()); ++colIndex) {
            }
            TableColumn tc = new TableColumn(colIndex);
            this._table.addColumn(tc);
            try {
                tc.setCellRenderer((TableCellRenderer)this._hiddenColumnCellRenderer.get(cbmi.getText()));
                tc.setCellEditor((TableCellEditor)this._hiddenColumnCellEditor.get(cbmi.getText()));
                this._hiddenColumnCellRenderer.remove(cbmi.getText());
                this._hiddenColumnCellEditor.remove(cbmi.getText());
            }
            catch (Exception ex) {
                // empty catch block
            }
            int lastCol = this._table.getColumnCount() - 1;
            this._table.colWidthToWidest(lastCol);
            if (colIndex < lastCol) {
                this._table.moveColumn(lastCol, colIndex);
            }
        } else if (this._table.getColumnCount() > 1) {
            TableColumn tc = this._table.getColumn(cbmi.getText());
            this._hiddenColumnCellEditor.put(cbmi.getText(), tc.getCellEditor());
            this._hiddenColumnCellRenderer.put(cbmi.getText(), tc.getCellRenderer());
            this._table.removeColumn(tc);
        } else {
            cbmi.setSelected(true);
        }
    }

    public void setSortable(boolean sortable) {
        this._sortable = sortable;
    }

    public boolean getSortable() {
        return this._sortable;
    }

    public class SortRenderer
    implements TableCellRenderer {
        private final TableCellRenderer delegate;

        SortRenderer(TableCellRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == HeaderListener.this._sortColumn) {
                ((JLabel)comp).setHorizontalTextPosition(2);
                ((JLabel)comp).setIcon(HeaderListener.this._isAscending ? _UpImage : _DownImage);
            } else {
                ((JLabel)comp).setIcon(null);
            }
            return comp;
        }
    }
}

