/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.IvrDomainIf;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class IvrDomainFcidCellEditor
extends DefaultCellEditor
implements ActionListener,
IvrDomainIf {
    private static IvrDomainFcidCellEditor _Instance = null;
    private static Icon _more = Util.loadIcon("icons/more.gif");
    private JPanel _panel;
    private JTextField _data;
    int _row;
    int _column;
    JTable _table;
    private Object _value;
    IvrDomainDialog _domainChooser;

    public IvrDomainFcidCellEditor() {
        super(new JComboBox());
        this.setClickCountToStart(2);
        this._panel = new JPanel(new BorderLayout());
        this._data = new JTextField();
        this._data.setBorder(BorderFactory.createLineBorder(Color.black));
        this._data.setFont(ChangedCellRenderer.getChangeFont());
        this._panel.add((Component)this._data, "Center");
        JButton btn = new JButton("..."){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.setSize(12.0, dim.getHeight());
                return dim;
            }
        };
        btn.addActionListener(this);
        this._panel.add((Component)btn, "East");
        this._panel.setBorder(null);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = row;
        this._column = column;
        this._table = table;
        this._value = value;
        this._data.setText(value != null ? value.toString() : "");
        Component[] changeListeners = ((SnmpKTable)this._table).getChangeListener();
        if (changeListeners != null) {
            for (int i = 0; i < changeListeners.length; ++i) {
                changeListeners[i].setEnabled(true);
            }
        }
        return this._panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this._data.getText();
    }

    @Override
    public void IvrDomainIfCB(String domainId) {
        this._data.setText(domainId);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int col = this._table.getSelectedColumn();
        int row = this._table.getSelectedRow();
        int modelCol = this._table.convertColumnIndexToModel(col);
        int viewCol = this._table.convertColumnIndexToView(col);
        SnmpPeer peer = (SnmpPeer)this._table.getModel().getValueAt(row, 0);
        int[] oid = ((SnmpOID)this._table.getModel().getValueAt(row, 1)).getValue();
        int currentAfid = oid[1];
        int currentVsan = oid[2];
        if (this._domainChooser == null) {
            this._domainChooser = new IvrDomainDialog(Util.getFrameAncestor(this._table), peer, currentAfid, currentVsan);
        } else {
            this._domainChooser.setDomainList(peer, currentAfid, currentVsan);
        }
        this._domainChooser.setTarget(this);
        this._domainChooser.showPortDialog(this._panel);
    }

    public static String[] getDomainList(SnmpPeer peer, int currentAfid, int currentVsan) {
        int i;
        Array domainList = new Array();
        VarBindList vbl = new VarBindList();
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList());
        int[] index = new int[]{1, currentAfid, currentVsan};
        int[] domainIdOid = MibNode.get((String)"civrPfcidFcdomainID").getOid();
        pdu.addNull(new SnmpOID(domainIdOid, index));
        vbl.add(new SnmpVarBind(new SnmpOID(domainIdOid, index)));
        try {
            int[] oid;
            SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl);
            for (i = 0; i < resp.getVariables().size() && SnmpOID.startsWith((int[])(oid = resp.getVariables().get(i).getOid().getValue()), (int[])domainIdOid) && oid[domainIdOid.length + 1] == currentAfid && oid[domainIdOid.length + 2] == currentVsan; ++i) {
                domainList.addElement((Object)Long.toString(resp.getVariables().longValue(i)));
            }
        }
        catch (SnmpException ex) {
            return new String[0];
        }
        String[] list = new String[domainList.size()];
        for (i = 0; i < domainList.size(); ++i) {
            list[i] = (String)domainList.elementAt(i);
        }
        return list;
    }

    class IvrDomainDialog
    extends JDialog
    implements ActionListener {
        CheckBoxListPanel _listPanel;
        IvrDomainIf _target;
        JPanel _box;
        String[] _BtnLabel;

        private IvrDomainDialog(JFrame parent, SnmpPeer peer, int currentAfid, int currentVsan) {
            super(parent);
            this._BtnLabel = new String[]{"OK", "Close"};
            JPanel main = new JPanel(new BorderLayout());
            main.setBorder(DialogUtil._Margin);
            this._box = new JPanel(null);
            this._box.setLayout(new BoxLayout(this._box, 1));
            this._box.setBorder(BorderFactory.createTitledBorder(""));
            this._listPanel = new CheckBoxListPanel((Object[])IvrDomainFcidCellEditor.getDomainList(peer, currentAfid, currentVsan), true);
            this._listPanel.clearSelection();
            JScrollPane sp = new JScrollPane(this._listPanel);
            sp.setPreferredSize(new Dimension(30, 80));
            this._box.add(sp);
            this._box.setBorder(BorderFactory.createTitledBorder("Available Domains"));
            JPanel buttons = new JPanel(new FlowLayout(2, 6, 3));
            for (int i = 0; i < this._BtnLabel.length; ++i) {
                JButton b = new JButton(this._BtnLabel[i]);
                b.addActionListener(this);
                buttons.add(b);
            }
            main.add("Center", this._box);
            main.add("South", buttons);
            this.getContentPane().add(main);
            this._box.setVisible(true);
            StringBuffer sb = new StringBuffer();
            sb.append(peer);
            sb.append(" currentAfid/Vsan ");
            sb.append(currentAfid);
            sb.append("/");
            sb.append(currentVsan);
            sb.append(" - Available Domains");
            this.setTitle(sb.toString());
            this.pack();
        }

        public void setDomainList(SnmpPeer peer, int currentAfid, int currentVsan) {
            this._listPanel.clearChoices();
            this._listPanel.setChoices(IvrDomainFcidCellEditor.getDomainList(peer, currentAfid, currentVsan));
            this._listPanel.clearSelection();
            StringBuffer sb = new StringBuffer();
            sb.append(peer);
            sb.append(" currentAfid/Vsan ");
            sb.append(currentAfid);
            sb.append("/");
            sb.append(currentVsan);
            sb.append(" - Available Domains");
            this.setTitle(sb.toString());
            this.setVisible(true);
            this.toFront();
        }

        public final void setTarget(IvrDomainIf target) {
            this._target = target;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            char ch = ((JButton)e.getSource()).getText().charAt(0);
            if (ch == 'O') {
                StringBuffer sb = new StringBuffer("0x");
                Object selection = this._listPanel.getSelectedValue();
                if (selection != null) {
                    sb.append(Integer.toHexString(Integer.parseInt((String)selection)));
                    sb.append("0000");
                    this._target.IvrDomainIfCB(sb.toString());
                }
            }
            super.setVisible(false);
        }

        public void showPortDialog(JComponent c) {
            this.pack();
            this.setLocation(DialogUtil.getPointOnScreen(new Point(c.getWidth(), 0), c, this.getSize()));
            this.setVisible(true);
            this.toFront();
        }
    }
}

