/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.tree;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Tree
extends JTree {
    private boolean _tooltipsShownAlways = false;
    private boolean _scrollPaneChecked = false;
    private JScrollBar _scrollBar = null;
    protected Point _tooltipLocation = null;

    public Tree(TreeNode tn) {
        super(tn);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setRowHeight();
    }

    public Tree(TreeModel tm) {
        super(tm);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setRowHeight();
    }

    private void setRowHeight() {
        int height = this.getFontMetrics(this.getFont()).getHeight() + 2;
        if (this.getRowHeight() < height) {
            this.setRowHeight(height);
        }
    }

    public void setTooltipsShownAlways(boolean always) {
        this._tooltipsShownAlways = always;
    }

    public boolean isTooltipsShownAlways() {
        return this._tooltipsShownAlways;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            TreeCellRenderer r = this.getCellRenderer();
            if (selRow != -1 && r != null) {
                TreePath path = this.getPathForRow(selRow);
                Object lastPath = path.getLastPathComponent();
                Component rComponent = r.getTreeCellRendererComponent(this, lastPath, this.isRowSelected(selRow), this.isExpanded(selRow), this.getModel().isLeaf(lastPath), selRow, true);
                Rectangle pathBounds = this.getPathBounds(path);
                if (!this._tooltipsShownAlways) {
                    try {
                        int startX = 0;
                        int tWidth = 0;
                        if (!this._scrollPaneChecked) {
                            try {
                                this._scrollPaneChecked = true;
                                this._scrollBar = ((JScrollPane)this.getParent().getParent()).getHorizontalScrollBar();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (this._scrollBar != null && this._scrollBar.isVisible()) {
                            startX = this._scrollBar.getValue();
                            Rectangle rec = ((JViewport)this.getParent()).getViewRect();
                            tWidth = (int)rec.getWidth();
                            rec = null;
                        } else {
                            tWidth = (int)this.getPreferredScrollableViewportSize().getWidth();
                        }
                        if (pathBounds.getX() >= (double)startX && pathBounds.getX() + pathBounds.getWidth() - (double)startX <= (double)tWidth) {
                            return null;
                        }
                        int offset = -4;
                        try {
                            DefaultTreeCellRenderer dr = (DefaultTreeCellRenderer)r;
                            TreeNode tnode = (TreeNode)path.getLastPathComponent();
                            Icon icon = tnode.isLeaf() ? dr.getLeafIcon() : dr.getClosedIcon();
                            if (icon != null) {
                                offset = icon.getIconWidth();
                                if (pathBounds.getX() + 2.0 + (double)offset >= (double)startX && pathBounds.getX() + pathBounds.getWidth() - (double)startX <= (double)tWidth) {
                                    return null;
                                }
                            }
                        }
                        catch (Exception ex) {
                            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                        this.setTooltipLocation((int)pathBounds.getX() + offset, (int)pathBounds.getY());
                        return ((JLabel)rComponent).getText();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (rComponent instanceof JComponent) {
                    p.translate(-pathBounds.x, -pathBounds.y);
                    MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                    return ((JComponent)rComponent).getToolTipText(newEvent);
                }
                return rComponent.toString();
            }
        }
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return this._tooltipLocation;
    }

    public void setTooltipLocation(int x, int y) {
        if (this._tooltipLocation == null) {
            this._tooltipLocation = new Point(x, y);
        } else {
            this._tooltipLocation.setLocation(x, y);
        }
    }

    public TreePath getNextEqualsMatch(String matchString, DefaultMutableTreeNode rootNode) {
        if (matchString == null || matchString.length() == 0) {
            return null;
        }
        if (rootNode == null) {
            rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        }
        Enumeration<TreeNode> i = rootNode.breadthFirstEnumeration();
        while (i.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)i.nextElement();
            if (!(next != null && next.getUserObject() != null && next.getUserObject().toString() != null ? next.getUserObject().toString().equals(matchString) : next != null && next.toString().equals(matchString))) continue;
            return new TreePath(next.getPath());
        }
        return null;
    }
}

