/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.wizard;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class WizardPanel
extends JPanel {
    JTextArea _explain;
    boolean _validData;
    JWizard _wizard;
    JLabel _title;
    private JPanel _north;

    public void dispose() {
        if (this._wizard != null) {
            this._wizard.setVisible(false);
        }
        this._wizard = null;
    }

    public WizardPanel(String name, String description, ImageIcon image) {
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.setLayout(new BorderLayout());
        this._north = new JPanel(new BorderLayout());
        JPanel northContent = new JPanel(new GridBagLayout());
        northContent.setBorder(new EmptyBorder(8, 8, 8, 8));
        Color foregroundColor = this.getForeground();
        if (foregroundColor == null || !foregroundColor.equals(Color.white)) {
            northContent.setBackground(Color.white);
        }
        this._title = new JLabel(name);
        Font font = UIManager.getDefaults().getFont("Table.font");
        this._title.setFont(new Font(font.getFontName(), 1, font.getSize()));
        this._title.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this._explain = new JTextArea();
        this._explain.setWrapStyleWord(true);
        this._explain.setEditable(false);
        this._explain.setLineWrap(true);
        this._explain.setOpaque(false);
        this._explain.setFont((Font)UIManager.getDefaults().get("Table.font"));
        if (description != null) {
            this.setDescription(description);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = DialogUtil.getInsets();
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        northContent.add((Component)this._title, gbc);
        gbc.gridy = 1;
        northContent.add((Component)this._explain, gbc);
        JLabel icon = new JLabel(image);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        northContent.add((Component)icon, gbc);
        this._north.add((Component)northContent, "Center");
        this._north.add((Component)new DialogSeparator(false), "South");
    }

    public JPanel getNorthDescPanel() {
        return this._north;
    }

    public WizardPanel(String name, String description) {
        this(name, description, (ImageIcon)null);
    }

    public WizardPanel(String name, String description, JWizard wizard) {
        this(name, description, wizard, null);
    }

    public WizardPanel(String name, String description, JWizard wizard, ImageIcon image) {
        this(name, description, image);
        this._wizard = wizard;
    }

    public void setTitle(String title) {
        this._title.setText(title);
    }

    public String getTitle() {
        return this._title.getText();
    }

    public void setDescription(String description) {
        if (description != null) {
            try {
                this._explain.getDocument().remove(0, this._explain.getDocument().getLength() - 1);
                this._explain.setText(description);
            }
            catch (Exception ex) {
                System.out.println("Incorrect location");
            }
        }
    }

    public void addDescription(String description) {
        this._explain.append(description);
    }

    public JWizard getWizard() {
        if (null == this._wizard) {
            for (Container pn = this.getParent(); null != pn; pn = pn.getParent()) {
                if (!(pn instanceof JWizard)) continue;
                this._wizard = (JWizard)pn;
                break;
            }
        }
        return this._wizard;
    }

    public void setBusy(boolean busy) {
        this.getWizard().setBusy(busy);
    }

    public void setModelValue(String name, Object value) {
        if (this.getWizard() != null) {
            this.getWizard().setModelValue(name, value);
        }
    }

    public Object getModelValue(String name) {
        return this.getWizard().getModelValue(name);
    }

    public void doHelp() {
    }

    public void doCancel() {
        this.getWizard().dispose();
    }

    public void doNext() {
        if (!this._validData) {
            WizardPanel pnl = this.getWizard().getNext();
            if (null != pnl) {
                pnl.setDataValid(false);
            }
            this._validData = true;
        }
        this.getWizard().next();
    }

    public void doFinish() {
        this._validData = true;
        this.getWizard().getNavigator().getNextBtn().setEnabled(false);
    }

    public void doPrevious() {
        this.getWizard().previous();
        this.getWizard().getNavigator().getNextBtn().setEnabled(true);
    }

    public boolean refresh() {
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this._validData) {
            this._validData = this.refresh();
        }
        super.setVisible(b);
    }

    public void setDataValid(boolean b) {
        this._validData = b;
    }

    public boolean isDataValid() {
        return this._validData;
    }

    public void actionFinished(boolean success) {
    }
}

