/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.util.GenUtil;
import java.io.Serializable;
import java.util.Arrays;

public class IntArray
implements Serializable {
    static final long serialVersionUID = 1L;
    private int _elementCount;
    private int[] _element;

    public IntArray() {
        this(10);
    }

    public IntArray(int initialSize) {
        this._element = new int[initialSize == 0 ? 1 : initialSize];
        this._elementCount = 0;
    }

    public IntArray(int[] values) {
        if (values != null && values.length != 0) {
            this._element = values;
            this._elementCount = values.length;
        } else {
            this._element = new int[1];
            this._elementCount = 0;
        }
    }

    public IntArray(IntArray ia) {
        this(ia.size());
        this._elementCount = ia._elementCount;
        System.arraycopy(ia._element, 0, this._element, 0, this._elementCount);
    }

    public int size() {
        return this._elementCount;
    }

    public void clear() {
        this._elementCount = 0;
    }

    public void add(int newInt) {
        if (this._elementCount == this._element.length) {
            int[] ai = new int[this._element.length * 2];
            System.arraycopy(this._element, 0, ai, 0, this._element.length);
            this._element = ai;
        }
        this._element[this._elementCount++] = newInt;
    }

    public void add(int[] values) {
        int i = this._elementCount + values.length;
        if (i > this._element.length) {
            int[] ai1 = new int[i];
            System.arraycopy(this._element, 0, ai1, 0, this._element.length);
            this._element = ai1;
        }
        System.arraycopy(values, 0, this._element, this._elementCount, values.length);
        this._elementCount = i;
    }

    public int get(int index) {
        if (index < 0 || index >= this._elementCount) {
            throw new IndexOutOfBoundsException();
        }
        return this._element[index];
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this._elementCount) {
            throw new IndexOutOfBoundsException();
        }
        this._element[index] = value;
    }

    public int remove(int index) {
        if (index < 0 || index >= this._elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int value = this._element[index];
        System.arraycopy(this._element, index + 1, this._element, index, this._element.length - index - 1);
        --this._elementCount;
        return value;
    }

    public void removeInt(int value) {
        int index = this.indexOf(value);
        if (index != -1) {
            this.remove(index);
        }
    }

    public int[] toArray() {
        int[] values = new int[this._elementCount];
        System.arraycopy(this._element, 0, values, 0, this._elementCount);
        return values;
    }

    public int[] toArray(int[] values) {
        int[] ai1 = null;
        ai1 = values.length >= this._elementCount ? values : new int[this._elementCount];
        System.arraycopy(this._element, 0, ai1, 0, this._elementCount);
        return ai1;
    }

    public void sort() {
        Arrays.sort(this._element, 0, this._elementCount);
    }

    public int indexOf(int value) {
        return GenUtil.linearSearch(this._element, value, this._elementCount);
    }

    public boolean contains(int value) {
        int[] sa = this.toArray();
        Arrays.sort(sa);
        return Arrays.binarySearch(sa, value) >= 0;
    }

    public boolean containsAll(int[] values) {
        int[] sa = this.toArray();
        Arrays.sort(sa);
        for (int i = 0; i < values.length; ++i) {
            if (Arrays.binarySearch(sa, values[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof IntArray)) {
            return false;
        }
        int[] ia1 = this.toArray();
        int[] ia2 = ((IntArray)x).toArray();
        Arrays.sort(ia1);
        Arrays.sort(ia2);
        return Arrays.equals(ia1, ia2);
    }
}

