/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TechSupport {
    static final String NMS_ROOT_DIR = ClientCache.getInstallDir();
    static final String NMS_LOG_DIR = ClientCache.getInstallDir() + File.separator + "logs";
    static final String NMS_JBOSS_DIR = ClientCache.getInstallDir() + File.separator + ".." + File.separator + "jboss-as-7.2.0.Final";
    static final String NMS_JSERVER_DIR = ClientCache.getInstallDir() + File.separator + ".." + File.separator + "smis" + File.separator + "server" + File.separator + "jserver";
    static final String NMS_JBOSS_LOG_DIR = NMS_JBOSS_DIR + File.separator + "standalone" + File.separator + "log";
    static final String NMS_JSERVER_LOG_DIR = NMS_JSERVER_DIR + File.separator + "logs";
    static final String PSTGRES_DB_DIR = ClientCache.getInstallDir() + File.separator + "db" + File.separator + "data" + File.separator + "pg_log";
    static final String ZIP_FILE_NAME = ClientCache.getInstallDir() + File.separator + "logs" + File.separator + "techsupport.zip";
    static final String DUMP_CMD = "show tech";
    static final String DUMP_FILE_PREFIX = "fms_dump";
    static final String DEBUG_PERM_FILE = "debug.properties";
    static final String PG_LOG_PATTERN = "postgresql.*.log";
    static final int ASCII_BS = 10;
    static final int BUF_SIZE = 1024;
    static final int LOOP_TIME = 10;
    static final long WAIT_TIME = 2000L;
    static File debugFile = new File(ClientCache.getInstallDir() + File.separator + "debug.properties");
    static File debugFileBak = new File(ClientCache.getInstallDir() + File.separator + "debug.properties" + ".bak");
    public static final int MAG_NUM = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressLogs(String dumpFName) {
        String f2zip = null;
        byte[] buf = new byte[1024];
        int result = 0;
        FileInputStream fin = null;
        ZipOutputStream zout = null;
        ArrayList<String> files2zip = TechSupport.getFiles2zip(dumpFName);
        try {
            zout = new ZipOutputStream(new FileOutputStream(ZIP_FILE_NAME));
            System.out.println("Start compressing .... ");
            for (int i = 0; i < files2zip.size(); ++i) {
                f2zip = files2zip.get(i).trim();
                fin = new FileInputStream(f2zip);
                zout.putNextEntry(new ZipEntry(f2zip));
                while ((result = fin.read(buf)) > 0) {
                    zout.write(buf, 0, result);
                }
                zout.closeEntry();
                fin.close();
                System.out.println("Done with " + f2zip);
            }
            System.out.println(ZIP_FILE_NAME + " is generated.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (zout != null) {
                try {
                    zout.flush();
                    zout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (debugFileBak.exists()) {
                debugFileBak.renameTo(debugFile);
                debugFileBak.deleteOnExit();
            } else {
                debugFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dumpServerInfo() {
        Socket _socket = null;
        FilterOutputStream _lout = null;
        FilterInputStream _rin = null;
        String dumpFName = null;
        try {
            TechSupport.loadProperties();
            _socket = new Socket("localhost", Integer.parseInt(System.getProperty("debug.server")));
            _lout = new DataOutputStream(_socket.getOutputStream());
            _rin = new DataInputStream(_socket.getInputStream());
            _lout.write(DUMP_CMD.getBytes());
            ((DataOutputStream)_lout).writeByte(10);
            ((DataOutputStream)_lout).flush();
            byte[] buf = new byte[1024];
            for (int i = 0; i < 3; ++i) {
                int r = ((DataInputStream)_rin).read(buf);
                if (i != 1) continue;
                String ret = new String(buf, 0, r);
                if (ret.indexOf("Exception") >= 0) {
                    System.out.println(ret);
                    String string = null;
                    return string;
                }
                String ext = "";
                ext = ret.indexOf(10) >= 0 ? ret.substring(ret.lastIndexOf(46), ret.indexOf(10)) : ret.substring(ret.lastIndexOf(46), ret.length());
                dumpFName = DUMP_FILE_PREFIX + ext;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(e.getMessage() + " Can't not dump server information to file.");
        }
        finally {
            if (_lout != null) {
                try {
                    _lout.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (_rin != null) {
                try {
                    _rin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (_socket != null) {
                try {
                    _socket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return dumpFName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDebugPermission() {
        if (debugFile.exists()) {
            debugFile.renameTo(debugFileBak);
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(debugFile));
            bw.write("allowed=localhost");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void loadProperties() throws IOException {
        GenUtil.loadServerProperties(null);
    }

    private static ArrayList<String> getFiles2zip(String dumpFName) {
        String[] pgLogs;
        File pgDir;
        String[] serverLogFiles;
        File jserverLogDir;
        String[] serverLogFiles2;
        File jbossLogDir;
        String[] fmLogFiles;
        String fmLogDir;
        File fmLogs;
        int i;
        ArrayList<String> zipList = new ArrayList<String>();
        String[] zipProps = System.getProperty("tech_support").split(",");
        String[] logDirFiles = new File(NMS_LOG_DIR).list();
        String zipProp = null;
        for (i = 0; i < zipProps.length; ++i) {
            zipProp = zipProps[i].trim();
            if (!zipProp.endsWith(".*")) {
                zipList.add(NMS_LOG_DIR + File.separator + zipProp);
                continue;
            }
            for (String fn : logDirFiles) {
                if (!fn.matches(zipProp)) continue;
                zipList.add(NMS_LOG_DIR + File.separator + fn);
            }
        }
        System.out.println("dumpFName: '" + dumpFName + "'");
        if (dumpFName != null) {
            String dumpFileFullPath = NMS_LOG_DIR + File.separator + dumpFName;
            for (i = 0; i < 10; ++i) {
                File file = new File(dumpFileFullPath);
                if (file.exists()) {
                    zipList.add(NMS_LOG_DIR + File.separator + dumpFName);
                    System.out.println("adding " + dumpFileFullPath);
                    break;
                }
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    System.out.println(e.getMessage());
                    break;
                }
            }
        }
        if ((fmLogs = new File(fmLogDir = System.getProperty("user.home") + File.separator + ".cisco_mds9000" + File.separator + "logs")).exists() && (fmLogFiles = fmLogs.list()) != null) {
            for (String fn : fmLogFiles) {
                zipList.add(fmLogDir + File.separator + fn);
            }
        }
        if ((jbossLogDir = new File(NMS_JBOSS_LOG_DIR)).exists() && (serverLogFiles2 = jbossLogDir.list()) != null) {
            for (String serverLog : serverLogFiles2) {
                if (!serverLog.endsWith(".log")) continue;
                zipList.add(NMS_JBOSS_LOG_DIR + File.separator + serverLog);
            }
        }
        if ((jserverLogDir = new File(NMS_JSERVER_LOG_DIR)).exists() && (serverLogFiles = jserverLogDir.list()) != null) {
            for (String serverLog : serverLogFiles) {
                if (!serverLog.endsWith(".log")) continue;
                zipList.add(NMS_JSERVER_LOG_DIR + File.separator + serverLog);
            }
        }
        if ((pgDir = new File(PSTGRES_DB_DIR)).exists() && (pgLogs = pgDir.list()) != null) {
            for (String pgLog : pgLogs) {
                if (!pgLog.matches(PG_LOG_PATTERN)) continue;
                zipList.add(PSTGRES_DB_DIR + File.separator + pgLog);
            }
        }
        return zipList;
    }

    public static void main(String[] args) {
        TechSupport.setDebugPermission();
        String dumpFName = TechSupport.dumpServerInfo();
        TechSupport.compressLogs(dumpFName);
        Scanner in = new Scanner(System.in);
        while (true) {
            System.out.print("Press Enter to exit ");
            String answer = in.nextLine();
            if (answer == null) continue;
            System.exit(0);
        }
    }
}

