/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.jboss_4_2;

import com.cisco.dcbu.lib.util.ClientCache;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBoss_4_2XMLFileParser {
    public static final String login_config = ClientCache.getJBossHome() + File.separator + "server" + File.separator + "fm" + File.separator + "conf" + File.separator + "login-config.xml";
    static String xmlFile = null;
    static Document dom = null;

    public JBoss_4_2XMLFileParser(String fileName) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (publicId.equals("-//JBoss//DTD JBOSS Security Config 3.0//EN")) {
                    return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return null;
            }
        });
        xmlFile = fileName;
        dom = builder.parse(new File(fileName));
        System.out.println("Finish loading the xml file.");
    }

    private void updateComponent(String elementName, String updatedContent) throws Exception {
        Element rootElement = dom.getDocumentElement();
        NodeList nl = rootElement.getElementsByTagName("application-policy");
        if (nl == null || nl.getLength() == 0) {
            throw new Exception("Fail to parse, File is not formatted correctly!");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Element element = (Element)nl.item(i);
            if (!element.getAttribute("name").equalsIgnoreCase(elementName)) continue;
            Element subE = (Element)element.getChildNodes().item(1).getChildNodes().item(1);
            NodeList subNL = subE.getChildNodes();
            if (subNL == null || subNL.getLength() == 0) {
                throw new Exception("Fail to parse, sub component is not formatted correctly!");
            }
            for (int j = 0; j < subNL.getLength(); ++j) {
                Element target;
                Node node = subNL.item(j);
                if (!(node instanceof Element) || !(target = (Element)subNL.item(j)).getAttribute("name").equalsIgnoreCase("password")) continue;
                Text textContent = (Text)target.getFirstChild();
                textContent.setData(updatedContent);
                System.out.println("Element has been updated");
                return;
            }
        }
        throw new Exception("Couldn't locate the right attribute from the xml file!");
    }

    private void writeXMLFile() throws TransformerFactoryConfigurationError, TransformerException, Exception {
        DOMSource source = new DOMSource(dom);
        File file = new File(xmlFile);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("doctype-public", "-//JBoss//DTD JBOSS Security Config 3.0//EN");
        xformer.setOutputProperty("doctype-system", "http://www.jboss.org/j2ee/dtd/security_config.dtd");
        xformer.transform(source, result);
    }

    public void updateXMLFile(String elementName, String updatedContent) throws Exception {
        this.updateComponent(elementName, updatedContent);
        this.writeXMLFile();
    }

    public static void main(String[] args) throws Exception {
        JBoss_4_2XMLFileParser xmlParser = new JBoss_4_2XMLFileParser(login_config);
        xmlParser.updateXMLFile("encryptDBPassword", "going back");
    }
}

