/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class UserAuthKeyboardInteractive
extends UserAuth {
    UserInfo userinfo;

    UserAuthKeyboardInteractive(UserInfo userinfo) {
        this.userinfo = userinfo;
    }

    @Override
    public boolean start(Session session) throws Exception {
        Packet packet = session.packet;
        Buffer buf = session.buf;
        String username = session.username;
        String dest = username + "@" + session.host;
        if (session.port != 22) {
            dest = dest + ":" + session.port;
        }
        boolean cancel = false;
        byte[] _username = null;
        try {
            _username = username.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            _username = username.getBytes();
        }
        int connectAttempts = 0;
        block7: do {
            block22: {
                packet.reset();
                buf.putByte((byte)50);
                buf.putString(_username);
                buf.putString("ssh-connection".getBytes());
                buf.putString("keyboard-interactive".getBytes());
                buf.putString("".getBytes());
                buf.putString("".getBytes());
                session.write(packet);
                boolean firsttime = true;
                while (true) {
                    try {
                        buf = session.read(buf);
                    }
                    catch (JSchException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                    if (buf.buffer[5] == 52) {
                        return true;
                    }
                    if (buf.buffer[5] == 53) {
                        buf.getInt();
                        buf.getByte();
                        buf.getByte();
                        byte[] _message = buf.getString();
                        byte[] lang = buf.getString();
                        String message = null;
                        try {
                            message = new String(_message, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            message = new String(_message);
                        }
                        if (this.userinfo == null) continue;
                        this.userinfo.showMessage(message);
                        continue;
                    }
                    if (buf.buffer[5] == 51) {
                        buf.getInt();
                        buf.getByte();
                        buf.getByte();
                        byte[] foo = buf.getString();
                        int partial_success = buf.getByte();
                        if (partial_success != 0) {
                            throw new JSchPartialAuthException(new String(foo));
                        }
                        if (connectAttempts >= Session.MAX_CONNECT_ATTEMPTS) {
                            System.out.println("UserAuthKeyInteractive: Failed To Connect to " + session.host + " after " + connectAttempts + " attempts");
                            throw new Exception("Failed To Connect after " + connectAttempts + " attempts");
                        }
                        if (!firsttime) continue block7;
                        throw new JSchException("USERAUTH KI is not supported");
                    }
                    if (buf.buffer[5] != 60) break block22;
                    firsttime = false;
                    buf.getInt();
                    buf.getByte();
                    buf.getByte();
                    String name = new String(buf.getString());
                    String instruction = new String(buf.getString());
                    String languate_tag = new String(buf.getString());
                    int num = buf.getInt();
                    String[] prompt = new String[num];
                    boolean[] echo = new boolean[num];
                    for (int i = 0; i < num; ++i) {
                        prompt[i] = new String(buf.getString());
                        echo[i] = buf.getByte() != 0;
                    }
                    String[] response = null;
                    if (num > 0 || name.length() > 0 || instruction.length() > 0) {
                        UIKeyboardInteractive kbi = (UIKeyboardInteractive)((Object)this.userinfo);
                        if (this.userinfo != null) {
                            response = kbi.promptKeyboardInteractive(dest, name, instruction, prompt, echo);
                        }
                    }
                    packet.reset();
                    buf.putByte((byte)61);
                    if (num > 0 && (response == null || num != response.length)) {
                        buf.putInt(0);
                        if (response == null) {
                            cancel = true;
                        }
                    } else {
                        buf.putInt(num);
                        for (int i = 0; i < num; ++i) {
                            buf.putString(response[i].getBytes());
                        }
                    }
                    session.write(packet);
                    ++connectAttempts;
                    if (cancel) break;
                }
                continue;
            }
            return false;
        } while (!cancel);
        throw new JSchAuthCancelException("keyboard-interactive");
    }
}

