/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdUpdater;

class RrdInt {
    private RrdFile file;
    private long pointer;
    private boolean cached = false;
    private int cachedValue;

    RrdInt(RrdUpdater updater, int count) throws IOException {
        this.file = updater.getRrdFile();
        this.pointer = this.file.allocate(4, count);
    }

    RrdInt(RrdUpdater updater) throws IOException {
        this(updater, 1);
    }

    RrdInt(int initValue, RrdUpdater updater) throws IOException {
        this.file = updater.getRrdFile();
        this.pointer = this.file.allocate(initValue);
        this.cached = true;
        this.cachedValue = initValue;
    }

    void set(int index, int value) throws IOException {
        long readPointer = this.pointer + (long)(index * 4);
        this.file.writeInt(readPointer, value);
    }

    void set(int value) throws IOException {
        this.cached = true;
        this.cachedValue = value;
        this.set(0, value);
    }

    int get(int index) throws IOException {
        long readPointer = this.pointer + (long)(index * 4);
        return this.file.readInt(readPointer);
    }

    int get() throws IOException {
        if (!this.cached) {
            this.cachedValue = this.get(0);
            this.cached = true;
        }
        return this.cachedValue;
    }
}

