/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.chart.Changeable;
import jclass.chart.ChartDataView;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartConverter;
import jclass.chart.JCDataCoord;
import jclass.chart.JCDataIndex;
import jclass.chart.JCTitle;
import jclass.util.JCUtilConverter;

public class JCChartLabel
extends JCTitle
implements Serializable,
HTMLHandler {
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int EAST = 4;
    public static final int WEST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTH = 7;
    public static final int SOUTHWEST = 8;
    public static final int CENTER = 9;
    public static final int AUTO = 10;
    public static final int ATTACH_NONE = 0;
    public static final int ATTACH_COORD = 1;
    public static final int ATTACH_DATACOORD = 2;
    public static final int ATTACH_DATAINDEX = 3;
    public static final int[] attachMethod_values;
    public static final String[] attachMethod_strings;
    public static final int[] anchor_values;
    public static final String[] anchor_strings;
    private static int index_no;
    int anchor = 9;
    int attachMethod = 1;
    int attachX = 0;
    int attachY = 0;
    double dataAttachX = 0.0;
    double dataAttachY = 0.0;
    int offsetX = 0;
    int offsetY = 0;
    JCDataIndex attachDataIndex = null;
    ChartDataView dataView = null;
    boolean isDwellLabel = false;
    int dwellDelay = 0;
    boolean isConnected = false;
    private Point attachBeforeAnchor = null;
    private Point attachPoint = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        attachMethod_values = nArray;
        attachMethod_strings = new String[]{"Attach_None", "Attach_Coord", "Attach_Datacoord", "Attach_Dataindex"};
        anchor_values = new int[]{10, 9, 1, 6, 3, 8, 2, 7, 4, 5};
        anchor_strings = new String[]{"Auto", "Center", "Northeast", "Southeast", "Northwest", "Southwest", "North", "South", "East", "West"};
        index_no = 0;
    }

    public JCChartLabel() {
        this.setText("label", false);
        this.isShowing = true;
    }

    public JCChartLabel(String string, boolean bl) {
        this.setText(string, bl);
        this.setParentAxis(null);
        this.isShowing = true;
    }

    public void draw(Graphics graphics) {
        block15: {
            Object object = this.getRegionLock();
            synchronized (object) {
                block16: {
                    block17: {
                        if (this.attachBeforeAnchor == null) break block15;
                        ChartDataView chartDataView = this.getDataView();
                        if (chartDataView == null || this.attachMethod != 2 && this.attachMethod != 3) break block16;
                        Rectangle rectangle = this.getChart().getChartArea().plotRect;
                        Rectangle rectangle2 = this.getChart().getChartArea().getDrawingArea();
                        if (this.attachBeforeAnchor.x < rectangle.x + rectangle2.x || this.attachBeforeAnchor.x > rectangle.x + rectangle2.x + rectangle.width || this.attachBeforeAnchor.y < rectangle.y + rectangle2.y) break block17;
                        if (this.attachBeforeAnchor.y <= rectangle.y + rectangle2.y + rectangle.height) break block16;
                    }
                    Object var3_8 = null;
                    return;
                }
                if (this.isConnected && this.attachPoint != null) {
                    int n = this.getWidth();
                    int n2 = this.getHeight();
                    Point point = null;
                    if (this.attachPoint.y + n2 < this.attachBeforeAnchor.y) {
                        point = new Point(this.attachPoint.x + n / 2, this.attachPoint.y + n2);
                    } else if (this.attachPoint.y > this.attachBeforeAnchor.y) {
                        point = new Point(this.attachPoint.x + n / 2, this.attachPoint.y);
                    } else if (this.attachPoint.x > this.attachBeforeAnchor.x) {
                        point = new Point(this.attachPoint.x, this.attachPoint.y + n2 / 2);
                    } else if (this.attachPoint.x + n < this.attachBeforeAnchor.x) {
                        point = new Point(this.attachPoint.x + n, this.attachPoint.y + n2 / 2);
                    }
                    if (point != null) {
                        graphics.drawLine(this.attachBeforeAnchor.x, this.attachBeforeAnchor.y, point.x, point.y);
                    }
                }
                super.draw(graphics);
            }
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getAttachMethod() {
        return this.attachMethod;
    }

    public JCChart getChart() {
        return this.getParent();
    }

    public Point getCoord() {
        return new Point(this.attachX, this.attachY);
    }

    public JCDataCoord getDataCoord() {
        return new JCDataCoord(this.dataAttachX, this.dataAttachY);
    }

    public JCDataIndex getDataIndex() {
        return this.attachDataIndex;
    }

    public ChartDataView getDataView() {
        try {
            return this.dataView == null ? this.getParent().getDataView(0) : this.dataView;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getDwellDelay() {
        return this.dwellDelay;
    }

    public boolean getIsConnected() {
        return this.isConnected;
    }

    public boolean getIsDwellLabel() {
        return this.isDwellLabel;
    }

    public Point getOffset() {
        return new Point(this.offsetX, this.offsetY);
    }

    public void loadParams(String string, JCChart jCChart) {
        super.loadParams(string, jCChart);
        this.setAnchor(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".anchor"), "anchor", anchor_strings, anchor_values, this.getAnchor()));
        this.setAttachMethod(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".attachMethod"), "attachMethod", attachMethod_strings, attachMethod_values, this.getAttachMethod()));
        this.attachX = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".attachX"), this.attachX);
        this.attachY = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".attachY"), this.attachY);
        this.dataAttachX = JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".dataAttachX"), this.dataAttachX);
        this.dataAttachY = JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".dataAttachY"), this.dataAttachY);
        this.offsetX = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".offsetX"), this.offsetX);
        this.offsetY = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".offsetY"), this.offsetY);
        this.setIsDwellLabel(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isDwellLabel"), this.getIsDwellLabel()));
        this.setIsConnected(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isConnected"), this.getIsConnected()));
        this.setIsShowing(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), this.getIsShowing()));
        this.setDwellDelay(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".dwellDelay"), this.getDwellDelay()));
        JCChartConverter jCChartConverter = new JCChartConverter();
        this.setDataView(jCChartConverter.toDataView(jCChart, jCChart.getParam(String.valueOf(string) + ".dataView"), this.getDataView()));
        this.setDataIndex(jCChartConverter.toDataIndex(jCChart, jCChart.getParam(String.valueOf(string) + ".dataIndex"), this.getDataIndex()));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recalc() {
        this.setChanged(true, 2, false);
        var1_1 = this.getRegionLock();
        synchronized (var1_1) {
            super.recalc();
            var3_2 = this.getDataView();
            if (var3_2 == null) {
                return;
            }
            var4_5 = null;
            var5_6 = this.getWidth() / 2;
            var6_7 = this.getHeight() / 2;
            var7_8 = 0.0;
            var9_9 = 0.0;
            try {
                switch (this.attachMethod) {
                    case 1: {
                        var4_5 = new Point(this.attachX, this.attachY);
                        break;
                    }
                    case 2: {
                        if (var3_2.getChartType() == 11) break;
                        var4_5 = var3_2.dataCoordToCoord(this.dataAttachX, this.dataAttachY);
                        var7_8 = this.dataAttachX;
                        var9_9 = this.dataAttachY;
                        try {
                            var11_10 /* !! */  = this.getChart().getDrawingArea();
                            var4_5.x -= var11_10 /* !! */ .x;
                            var4_5.y -= var11_10 /* !! */ .y;
                        }
                        catch (Exception v0) {}
                        break;
                    }
                    case 3: {
                        var4_5 = var3_2.dataIndexToCoord(this.attachDataIndex);
                        var7_8 = this.attachDataIndex.getSeries().getX(this.attachDataIndex.point);
                        var9_9 = this.attachDataIndex.getSeries().getY(this.attachDataIndex.point);
                        try {
                            var11_10 /* !! */  = this.getChart().getDrawingArea();
                            var4_5.x -= var11_10 /* !! */ .x;
                            var4_5.y -= var11_10 /* !! */ .y;
                        }
                        catch (Exception v1) {}
                        break;
                    }
                    default: {
                        return;
                    }
                }
                var11_10 /* !! */  = var3_2.getXAxis();
                var12_11 = var3_2.getYAxis();
                switch (this.attachMethod) {
                    case 2: 
                    case 3: {
                        if (var7_8 < var11_10 /* !! */ .getMin() || var7_8 > var11_10 /* !! */ .getMax() || var9_9 < var12_11.getMin() || var9_9 > var12_11.getMax()) {
                            var4_5 = null;
                        }
                        ** GOTO lbl59
                    }
                    default: {
                        ** if (var4_5 != null) goto lbl-1000
lbl55:
                        // 1 sources

                        break;
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Exception v2) {
                var4_5 = null;
            }
lbl59:
            // 2 sources

            if (var4_5 == null) lbl-1000:
            // 2 sources

            {
                this.attachBeforeAnchor = null;
                var4_5 = new Point(-9999, -9999);
            } else lbl-1000:
            // 2 sources

            {
                this.attachBeforeAnchor = new Point(var4_5.x, var4_5.y);
                var4_5.x -= var5_6;
                var4_5.y -= var6_7;
                switch (this.anchor) {
                    case 1: 
                    case 4: 
                    case 6: {
                        var4_5.x += var5_6;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 8: {
                        var4_5.x -= var5_6;
                        break;
                    }
                }
                switch (this.anchor) {
                    case 1: 
                    case 2: 
                    case 3: {
                        var4_5.y -= var6_7;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        var4_5.y += var6_7;
                        break;
                    }
                }
                var4_5.x += this.offsetX;
                var4_5.y += this.offsetY;
                this.setChanged(false, 0);
            }
            this.move(var4_5.x, var4_5.y);
            this.attachPoint = new Point(var4_5.x, var4_5.y);
            return;
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        Object object;
        JCChartLabel jCChartLabel = new JCChartLabel();
        super.saveParams(string, hTMLSaveDriver);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".attachMethod", JCUtilConverter.fromEnum(this.attachMethod, attachMethod_strings, attachMethod_values));
        switch (this.attachMethod) {
            case 2: {
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataAttachX", this.dataAttachX);
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataAttachY", this.dataAttachY);
                break;
            }
            case 3: {
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataIndex", "AttachIndex" + (index_no + 1));
                hTMLSaveDriver.writeParam("IndexName" + (index_no + 1), "AttachIndex" + (index_no + 1));
                object = this.getDataIndex();
                ((JCDataIndex)object).saveParams("AttachIndex" + (index_no + 1), hTMLSaveDriver);
                ++index_no;
                break;
            }
            default: {
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".attachX", this.attachX);
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".attachY", this.attachY);
            }
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".anchor", JCUtilConverter.fromEnum(jCChartLabel.anchor, anchor_strings, anchor_values), JCUtilConverter.fromEnum(this.anchor, anchor_strings, anchor_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".offsetX", jCChartLabel.offsetX, this.offsetX);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".offsetY", jCChartLabel.offsetX, this.offsetY);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isDwellLabel", jCChartLabel.isDwellLabel, this.isDwellLabel);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isConnected", jCChartLabel.isConnected, this.isConnected);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowing", jCChartLabel.isShowing, this.isShowing);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".dwellDelay", jCChartLabel.dwellDelay, this.dwellDelay);
        if (this.dataView != null) {
            object = new JCChartConverter();
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataView", ((JCChartConverter)object).toDataViewName(this.getParent(), this.dataView.getName(), "data"));
        }
    }

    public void setAnchor(int n) {
        JCChartLabel jCChartLabel = this;
        synchronized (jCChartLabel) {
            if (n == this.anchor) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.anchor = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key48"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setAttachMethod(int n) {
        if (n == this.attachMethod) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.attachMethod = n;
                this.setChanged(true, 2);
                break;
            }
            default: {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key52"));
            }
        }
    }

    public void setCoord(Point point) {
        this.attachX = point.x;
        this.attachY = point.y;
        this.setChanged(true, 2);
    }

    public void setDataCoord(JCDataCoord jCDataCoord) {
        this.dataAttachX = jCDataCoord.x;
        this.dataAttachY = jCDataCoord.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataIndex(JCDataIndex jCDataIndex) {
        this.attachDataIndex = jCDataIndex;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        this.setChanged(true, 2);
    }

    public void setDwellDelay(int n) {
        this.dwellDelay = n;
    }

    public void setIsConnected(boolean bl) {
        if (bl == this.isConnected) {
            return;
        }
        JCChartLabel jCChartLabel = this;
        synchronized (jCChartLabel) {
            this.isConnected = bl;
        }
        this.setChanged(true, 2);
    }

    public void setIsDwellLabel(boolean bl) {
        if (bl == this.isDwellLabel) {
            return;
        }
        Changeable changeable = this;
        synchronized (changeable) {
            this.isDwellLabel = bl;
            this.isShowing = bl ^ true;
        }
        changeable = this.getParent();
        if (changeable != null) {
            if (bl) {
                ((JCChart)changeable).addToDwellLabels(this);
            } else {
                ((JCChart)changeable).removeFromDwellLabels(this);
            }
        }
        this.setChanged(true, 2);
    }

    public void setOffset(Point point) {
        this.offsetX = point.x;
        this.offsetY = point.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public boolean shouldPopupHere(JCDataIndex jCDataIndex) {
        if (this.attachMethod != 3) {
            return false;
        }
        return jCDataIndex != null && jCDataIndex.equals(this.attachDataIndex);
    }
}

