/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class HSSFRow
implements Comparable {
    public static final int INITIAL_CAPACITY = 5;
    private int rowNum;
    private HSSFCell[] cells = new HSSFCell[5];
    private RowRecord row;
    private HSSFWorkbook book;
    private HSSFSheet sheet;
    public static final MissingCellPolicy RETURN_NULL_AND_BLANK = new MissingCellPolicy();
    public static final MissingCellPolicy RETURN_BLANK_AS_NULL = new MissingCellPolicy();
    public static final MissingCellPolicy CREATE_NULL_AS_BLANK = new MissingCellPolicy();

    HSSFRow(HSSFWorkbook book, HSSFSheet sheet, int rowNum) {
        this.rowNum = rowNum;
        this.book = book;
        this.sheet = sheet;
        this.row = new RowRecord(rowNum);
        this.setRowNum(rowNum);
    }

    HSSFRow(HSSFWorkbook book, HSSFSheet sheet, RowRecord record) {
        this.book = book;
        this.sheet = sheet;
        this.row = record;
        this.setRowNum(record.getRowNumber());
    }

    public HSSFCell createCell(short columnIndex) {
        return this.createCell((int)columnIndex);
    }

    public HSSFCell createCell(int columnIndex) {
        return this.createCell(columnIndex, 3);
    }

    public HSSFCell createCell(short columnIndex, int type) {
        return this.createCell((int)columnIndex, type);
    }

    public HSSFCell createCell(int columnIndex, int type) {
        HSSFCell cell = new HSSFCell(this.book, this.sheet, this.getRowNum(), (short)columnIndex, type);
        this.addCell(cell);
        this.sheet.getSheet().addValueRecord(this.getRowNum(), cell.getCellValueRecord());
        return cell;
    }

    public void removeCell(HSSFCell cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        this.removeCell(cell, true);
    }

    private void removeCell(HSSFCell cell, boolean alsoRemoveRecords) {
        int column = cell.getColumnIndex();
        if (column < 0) {
            throw new RuntimeException("Negative cell indexes not allowed");
        }
        if (column >= this.cells.length || cell != this.cells[column]) {
            throw new RuntimeException("Specified cell is not from this row");
        }
        this.cells[column] = null;
        if (alsoRemoveRecords) {
            CellValueRecordInterface cval = cell.getCellValueRecord();
            this.sheet.getSheet().removeValueRecord(this.getRowNum(), cval);
        }
        if (cell.getColumnIndex() + 1 == this.row.getLastCol()) {
            this.row.setLastCol((short)(this.findLastCell(this.row.getLastCol()) + 1));
        }
        if (cell.getColumnIndex() == this.row.getFirstCol()) {
            this.row.setFirstCol(this.findFirstCell(this.row.getFirstCol()));
        }
    }

    protected void removeAllCells() {
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            this.removeCell(this.cells[i], true);
        }
        this.cells = new HSSFCell[5];
    }

    protected HSSFCell createCellFromRecord(CellValueRecordInterface cell) {
        HSSFCell hcell = new HSSFCell(this.book, this.sheet, cell);
        this.addCell(hcell);
        return hcell;
    }

    public void setRowNum(int rowNum) {
        if (rowNum < 0 || rowNum > 65535) {
            throw new IllegalArgumentException("Invalid row number (" + rowNum + ") outside allowable range (0.." + 65535 + ")");
        }
        this.rowNum = rowNum;
        if (this.row != null) {
            this.row.setRowNumber(rowNum);
        }
    }

    public int getRowNum() {
        return this.rowNum;
    }

    protected int getOutlineLevel() {
        return this.row.getOutlineLevel();
    }

    public void moveCell(HSSFCell cell, short newColumn) {
        if (this.cells.length > newColumn && this.cells[newColumn] != null) {
            throw new IllegalArgumentException("Asked to move cell to column " + newColumn + " but there's already a cell there");
        }
        if (!this.cells[cell.getColumnIndex()].equals(cell)) {
            throw new IllegalArgumentException("Asked to move a cell, but it didn't belong to our row");
        }
        this.removeCell(cell, false);
        cell.updateCellNum(newColumn);
        this.addCell(cell);
    }

    private void addCell(HSSFCell cell) {
        int column = cell.getColumnIndex();
        if (column >= this.cells.length) {
            HSSFCell[] oldCells = this.cells;
            int newSize = oldCells.length * 2;
            if (newSize < column + 1) {
                newSize = column + 1;
            }
            this.cells = new HSSFCell[newSize];
            System.arraycopy(oldCells, 0, this.cells, 0, oldCells.length);
        }
        this.cells[column] = cell;
        if (this.row.getFirstCol() == -1 || column < this.row.getFirstCol()) {
            this.row.setFirstCol((short)column);
        }
        if (this.row.getLastCol() == -1 || column >= this.row.getLastCol()) {
            this.row.setLastCol((short)(column + 1));
        }
    }

    private HSSFCell retrieveCell(int cellnum) {
        if (cellnum < 0 || cellnum >= this.cells.length) {
            return null;
        }
        return this.cells[cellnum];
    }

    public HSSFCell getCell(short cellnum) {
        int ushortCellNum = cellnum & 0xFFFF;
        return this.getCell(ushortCellNum);
    }

    public HSSFCell getCell(int cellnum) {
        return this.getCell(cellnum, this.book.getMissingCellPolicy());
    }

    public HSSFCell getCell(int cellnum, MissingCellPolicy policy) {
        HSSFCell cell = this.retrieveCell(cellnum);
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell(cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    public short getFirstCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getFirstCol();
    }

    public short getLastCellNum() {
        if (this.getPhysicalNumberOfCells() == 0) {
            return -1;
        }
        return this.row.getLastCol();
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++count;
        }
        return count;
    }

    public void setHeight(short height) {
        this.row.setBadFontHeight(true);
        this.row.setHeight(height);
    }

    public void setZeroHeight(boolean zHeight) {
        this.row.setZeroHeight(zHeight);
    }

    public boolean getZeroHeight() {
        return this.row.getZeroHeight();
    }

    public void setHeightInPoints(float height) {
        this.row.setBadFontHeight(true);
        this.row.setHeight((short)(height * 20.0f));
    }

    public short getHeight() {
        short height = this.row.getHeight();
        height = (height & 0x8000) != 0 ? this.sheet.getSheet().getDefaultRowHeight() : (short)(height & Short.MAX_VALUE);
        return height;
    }

    public float getHeightInPoints() {
        return (float)this.getHeight() / 20.0f;
    }

    protected RowRecord getRowRecord() {
        return this.row;
    }

    private short findLastCell(short lastcell) {
        short cellnum;
        HSSFCell r = this.getCell(cellnum);
        for (cellnum = (short)(lastcell - 1); r == null && cellnum >= 0; cellnum = (short)(cellnum - 1)) {
            r = this.getCell(cellnum);
        }
        return cellnum;
    }

    private short findFirstCell(short firstcell) {
        short cellnum;
        HSSFCell r = this.getCell(cellnum);
        for (cellnum = (short)(firstcell + 1); r == null && cellnum <= this.getLastCellNum(); cellnum = (short)(cellnum + 1)) {
            r = this.getCell(cellnum);
        }
        if (cellnum > this.getLastCellNum()) {
            return -1;
        }
        return cellnum;
    }

    public boolean isFormatted() {
        return this.row.getFormatted();
    }

    public HSSFCellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        short styleIndex = this.row.getXFIndex();
        ExtendedFormatRecord xf = this.book.getWorkbook().getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this.book);
    }

    public void setRowStyle(HSSFCellStyle style) {
        this.row.setFormatted(true);
        this.row.setXFIndex(style.getIndex());
    }

    public Iterator cellIterator() {
        return new CellIterator();
    }

    public Iterator iterator() {
        return this.cellIterator();
    }

    public int compareTo(Object obj) {
        HSSFRow loc = (HSSFRow)obj;
        if (this.getRowNum() == loc.getRowNum()) {
            return 0;
        }
        if (this.getRowNum() < loc.getRowNum()) {
            return -1;
        }
        if (this.getRowNum() > loc.getRowNum()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HSSFRow)) {
            return false;
        }
        HSSFRow loc = (HSSFRow)obj;
        return this.getRowNum() == loc.getRowNum();
    }

    private class CellIterator
    implements Iterator {
        int thisId = -1;
        int nextId = -1;

        public CellIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextId < HSSFRow.this.cells.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            HSSFCell cell = HSSFRow.this.cells[this.nextId];
            this.thisId = this.nextId;
            this.findNext();
            return cell;
        }

        public void remove() {
            if (this.thisId == -1) {
                throw new IllegalStateException("remove() called before next()");
            }
            ((HSSFRow)HSSFRow.this).cells[this.thisId] = null;
        }

        private void findNext() {
            int i;
            for (i = this.nextId + 1; i < HSSFRow.this.cells.length && HSSFRow.this.cells[i] == null; ++i) {
            }
            this.nextId = i;
        }
    }

    public static class MissingCellPolicy {
        private static int NEXT_ID = 1;
        private final int id = NEXT_ID++;

        MissingCellPolicy() {
        }
    }
}

