/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class IlvGraphicVector
implements Cloneable,
Serializable {
    protected IlvGraphic[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public IlvGraphicVector(int n2, int n3) {
        this.elementData = new IlvGraphic[n2];
        this.capacityIncrement = n3;
    }

    public IlvGraphicVector(int n2) {
        this(n2, 0);
    }

    public IlvGraphicVector() {
        this(10);
    }

    public final void copyInto(IlvGraphic[] ilvGraphicArray) {
        System.arraycopy(this.elementData, 0, ilvGraphicArray, 0, this.elementCount);
    }

    public final void trimToSize() {
        int n2 = this.elementData.length;
        if (this.elementCount < n2) {
            IlvGraphic[] ilvGraphicArray = this.elementData;
            this.elementData = new IlvGraphic[this.elementCount];
            System.arraycopy(ilvGraphicArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void ensureCapacity(int n2) {
        int n3 = this.elementData.length;
        if (n2 > n3) {
            int n4;
            IlvGraphic[] ilvGraphicArray = this.elementData;
            int n5 = n4 = this.capacityIncrement > 0 ? n3 + this.capacityIncrement : n3 * 3 / 2 + 1;
            if (n4 < n2) {
                n4 = n2;
            }
            this.elementData = new IlvGraphic[n4];
            System.arraycopy(ilvGraphicArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final void setSize(int n2) {
        if (n2 > this.elementCount) {
            this.ensureCapacity(n2);
        } else {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = n2;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final IlvGraphicEnumeration elements() {
        return new IlvGraphicVectorEnumerator(this);
    }

    public final boolean contains(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0) >= 0;
    }

    public final int indexOf(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0);
    }

    public final int indexOf(IlvGraphic ilvGraphic, int n2) {
        for (int i2 = n2; i2 < this.elementCount; ++i2) {
            if (!ilvGraphic.equals(this.elementData[i2])) continue;
            return i2;
        }
        return -1;
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic) {
        return this.lastIndexOf(ilvGraphic, this.elementCount);
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            if (!ilvGraphic.equals(this.elementData[n3])) continue;
            return n3;
        }
        return -1;
    }

    public final IlvGraphic elementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n2 + " < 0");
        }
    }

    public final IlvGraphic firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final IlvGraphic lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final IlvGraphic setElementAt(IlvGraphic ilvGraphic, int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        IlvGraphic ilvGraphic2 = this.elementData[n2];
        this.elementData[n2] = ilvGraphic;
        return ilvGraphic2;
    }

    public final void removeElementAt(int n2) {
        if (n2 >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount);
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void insertElementAt(IlvGraphic ilvGraphic, int n2) {
        if (n2 >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.elementCount + 1);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        this.elementData[n2] = ilvGraphic;
        ++this.elementCount;
    }

    public final void addElement(IlvGraphic ilvGraphic) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = ilvGraphic;
    }

    public final boolean removeElement(IlvGraphic ilvGraphic) {
        int n2 = this.indexOf(ilvGraphic);
        if (n2 >= 0) {
            this.removeElementAt(n2);
            return true;
        }
        return false;
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public Object clone() {
        try {
            IlvGraphicVector ilvGraphicVector = (IlvGraphicVector)super.clone();
            ilvGraphicVector.elementData = new IlvGraphic[this.elementCount];
            System.arraycopy(this.elementData, 0, ilvGraphicVector.elementData, 0, this.elementCount);
            return ilvGraphicVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        IlvGraphicEnumeration ilvGraphicEnumeration = this.elements();
        stringBuffer.append("[");
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = ilvGraphicEnumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static final class IlvGraphicVectorEnumerator
    implements IlvGraphicEnumeration {
        private IlvGraphicVector a;
        private int b;

        IlvGraphicVectorEnumerator(IlvGraphicVector ilvGraphicVector) {
            this.a = ilvGraphicVector;
        }

        public boolean hasMoreElements() {
            return this.b < this.a.elementCount;
        }

        public IlvGraphic nextElement() {
            if (this.b < this.a.elementCount) {
                return this.a.elementData[this.b++];
            }
            throw new NoSuchElementException("IlvGraphicVectorEnumerator");
        }
    }
}

