/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.docview;

import ilog.views.appframe.docview.IlvAbstractFileDocument;
import ilog.views.appframe.docview.IlvFileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IlvTextDocument
extends IlvAbstractFileDocument {
    private transient Document a;
    private transient UndoableEditListener b = null;

    public boolean initializeDocument(Object object) {
        if (!super.initializeDocument(object)) {
            return false;
        }
        this.a = this.c();
        if (this.a == null) {
            return false;
        }
        if (object != null && object instanceof String) {
            try {
                this.a.insertString(0, (String)object, null);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void clean() {
        super.clean();
        if (this.a != null && this.b != null) {
            this.a.removeUndoableEditListener(this.b);
            this.a = null;
            this.b = null;
        }
    }

    protected boolean readDocument(Reader reader, IlvFileFilter ilvFileFilter) {
        Document document = this.c();
        if (document == null) {
            return false;
        }
        try {
            int n2;
            document.remove(0, document.getLength());
            String string = new String();
            char[] cArray = new char[1024];
            while ((n2 = reader.read(cArray)) > 0) {
                string = string + new String(cArray, 0, n2);
            }
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("IlvTextDocument[readDocument]: " + badLocationException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println("IlvTextDocument[readDocument]: " + iOException.getMessage());
        }
        return true;
    }

    public boolean writeDocument(Writer writer, IlvFileFilter ilvFileFilter) {
        Document document = this.c();
        if (this.a == null) {
            return false;
        }
        try {
            String string = document.getText(0, document.getLength());
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            writer.write(cArray);
        }
        catch (IOException iOException) {
            System.err.println("IlvTextDocument[writeDocument]: " + iOException.getMessage());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("IlvTextDocument[writeDocument]: " + badLocationException.getMessage());
        }
        return true;
    }

    public Document getTextDocument() {
        return this.a;
    }

    protected Document createTextDocument() {
        return new PlainDocument();
    }

    protected void initializeTextDocument(Document document) {
        this.b = new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                IlvTextDocument.this.addEdit(undoableEditEvent.getEdit());
            }
        };
        document.addUndoableEditListener(this.b);
    }

    Document c() {
        if (this.a != null) {
            return this.a;
        }
        this.a = this.createTextDocument();
        if (this.a == null) {
            System.err.println(this.getClass().getName() + "[ensureTextDocument]: Can not create a text document");
        } else {
            this.initializeTextDocument(this.a);
        }
        return this.a;
    }
}

