/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing;

import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.swing.IlvPanelView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IlvTreeView
extends IlvPanelView {
    JTree a;
    public static final String DEFAULT_SETTINGS_TYPE = "treeView";
    public static final String DEFAULT_SETTINGS_NAME = "default";

    protected IlvTreeView(String string, String string2) {
        super(string, string2);
    }

    public IlvTreeView() {
        this(DEFAULT_SETTINGS_TYPE, DEFAULT_SETTINGS_NAME);
    }

    public void initializeView(IlvDocument ilvDocument) {
        this.h();
    }

    JTree h() {
        if (this.a != null) {
            return this.a;
        }
        JTree jTree = this.createTree();
        if (jTree != null) {
            jTree.setCellRenderer(this.createTreeCellRenderer(jTree));
            this.setTree(jTree);
        }
        return jTree;
    }

    protected JTree createTree() {
        return new JTree();
    }

    protected void initializeTree(JTree jTree) {
        jTree.setRootVisible(true);
        jTree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16) {
                    JTree jTree = (JTree)mouseEvent.getSource();
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    for (int i2 = 0; treePathArray != null && i2 < treePathArray.length; ++i2) {
                        TreePath treePath = treePathArray[i2];
                        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                        if (!treeNode.isLeaf()) continue;
                        IlvTreeView.this.nodeDoubleClicked(mouseEvent, treeNode, treeNode instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)treeNode).getUserObject() : null);
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    JTree jTree = (JTree)mouseEvent.getSource();
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        jTree.setSelectionPath(null);
                    }
                    if (mouseEvent.getModifiers() == 4) {
                        TreeNode treeNode;
                        if (treePath == null) {
                            return;
                        }
                        if (jTree.getSelectionCount() != 1 || treePath != jTree.getSelectionPath()) {
                            jTree.getSelectionModel().setSelectionPath(treePath);
                        }
                        IlvTreeView.this.nodeRightClicked(mouseEvent, treeNode, (treeNode = (TreeNode)treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)treeNode).getUserObject() : null);
                    }
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }
        });
    }

    protected void addTree(JTree jTree) {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jTree);
        this.add((Component)jScrollPane, "Center");
    }

    public JTree getTree() {
        return this.h();
    }

    public void setTree(JTree jTree) {
        if (this.a != null) {
            this.remove(this.a);
        }
        this.a = jTree;
        if (jTree != null) {
            this.initializeTree(jTree);
            this.addTree(jTree);
        }
    }

    public void viewClosing() {
    }

    public void viewClosed() {
    }

    protected TreeCellRenderer createTreeCellRenderer(JTree jTree) {
        return new DefaultTreeCellRenderer();
    }

    public Object setProperty(String string, Object object) {
        Object object2 = this.getClientProperty(string);
        this.putClientProperty(string, object);
        return object2;
    }

    public Object getProperty(String string) {
        return this.getClientProperty(string);
    }

    protected void nodeDoubleClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
    }

    protected void nodeRightClicked(MouseEvent mouseEvent, TreeNode treeNode, Object object) {
    }
}

