/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.docking;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.settings.LocaleSettingsEvent;
import ilog.views.appframe.swing.docking.IlvDockingManager;
import ilog.views.appframe.swing.docking.dockable.IlvDockable;
import ilog.views.appframe.swing.docking.dockable.IlvDockablePane;
import ilog.views.appframe.util.IlvDefaultPropertyManager;
import ilog.views.appframe.util.IlvPropertyManager;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;

class IlvDockablePaneStyle
implements IlvPropertyManager {
    protected String title;
    protected String tabIconPathKey;
    protected String iconPathKey;
    IlvDefaultPropertyManager a = new IlvDefaultPropertyManager(this);
    protected String tooltipKey;
    private transient IlvDockablePaneStyle b;
    private transient boolean c;
    private transient boolean d;
    private transient Class e;
    private transient String f;
    private transient IlvSettingsElement g;
    public static final String NAME_PROPERTY = "name";
    public static final String TITLE_PROPERTY = "title";
    public static final String ICON_PROPERTY = "icon";
    public static final String TAB_ICON_PROPERTY = "tabIcon";
    public static final String TOOLTIP_PROPERTY = "tooltip";
    public static final String PINABLE_PROPERTY = "pinable";
    public static final String CLOSABLE_PROPERTY = "closable";
    public static final String DOCKABLE_PROPERTY = "dockable";
    public static final String SCROLLABLE_PROPERTY = "scrollable";
    public static final String TITLE_VISIBLE_PROPERTY = "titleVisible";
    public static final String FIXED_WIDTH_PROPERTY = "fixedWidth";
    public static final String FIXED_HEIGHT_PROPERTY = "fixedHeight";
    public static final String ACTIVABLE_PROPERTY = "ActivableByClick";
    public static final String MINIMUM_SIZE_PROPERTY = "minimumSize";

    public IlvDockablePaneStyle(String string) {
        this.setProperty(NAME_PROPERTY, string);
        this.setProperty(CLOSABLE_PROPERTY, Boolean.TRUE);
        this.setProperty(TITLE_VISIBLE_PROPERTY, Boolean.TRUE);
        this.setProperty(DOCKABLE_PROPERTY, Boolean.TRUE);
        this.setProperty(ACTIVABLE_PROPERTY, Boolean.TRUE);
    }

    public IlvDockablePaneStyle(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
        this(ilvSettingsElement.getString(NAME_PROPERTY));
        this.readSettings(ilvSettingsElement, ilvApplication);
    }

    public String getName() {
        return (String)this.getProperty(NAME_PROPERTY);
    }

    public void setName(String string) {
        this.setProperty(NAME_PROPERTY, string);
    }

    public String getTitle() {
        return (String)this.getProperty(TITLE_PROPERTY);
    }

    public void setTitle(String string) {
        this.setProperty(TITLE_PROPERTY, string);
    }

    public ImageIcon getIcon() {
        return (ImageIcon)this.getProperty(ICON_PROPERTY);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.setProperty(ICON_PROPERTY, imageIcon);
    }

    public ImageIcon getTabIcon() {
        return (ImageIcon)this.getProperty(TAB_ICON_PROPERTY);
    }

    public void setTabIcon(ImageIcon imageIcon) {
        this.setProperty(TAB_ICON_PROPERTY, imageIcon);
    }

    public String getTooltip() {
        return (String)this.getProperty(TOOLTIP_PROPERTY);
    }

    public void setTooltip(String string) {
        this.setProperty(TOOLTIP_PROPERTY, string);
    }

    protected void readSettings(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
        ImageIcon imageIcon;
        this.g = ilvSettingsElement;
        this.title = ilvSettingsElement.getString(TITLE_PROPERTY);
        if (this.title != null) {
            this.setProperty(TITLE_PROPERTY, ilvApplication.getString(this.title));
        }
        this.tabIconPathKey = ilvSettingsElement.getString(TAB_ICON_PROPERTY);
        if (this.tabIconPathKey != null && (imageIcon = ilvApplication.getImageIcon(this.tabIconPathKey)) != null) {
            this.setProperty(TAB_ICON_PROPERTY, imageIcon);
        }
        this.iconPathKey = ilvSettingsElement.getString(ICON_PROPERTY);
        if (this.iconPathKey != null && (imageIcon = ilvApplication.getImageIcon(this.iconPathKey)) != null) {
            this.setProperty(ICON_PROPERTY, imageIcon);
        }
        this.tooltipKey = ilvSettingsElement.getString(TOOLTIP_PROPERTY, this.title);
        if (this.tooltipKey != null) {
            this.setProperty(TOOLTIP_PROPERTY, ilvApplication.getString(this.tooltipKey));
        }
        this.c = ilvSettingsElement.getBoolean("viewContainer", false);
        this.f = ilvSettingsElement.getString("contentJavaClass");
        this.setDockable(ilvSettingsElement.getBoolean(DOCKABLE_PROPERTY, true));
        this.setScrollable(ilvSettingsElement.getBoolean(SCROLLABLE_PROPERTY, false));
        this.setClosable(ilvSettingsElement.getBoolean(CLOSABLE_PROPERTY, true));
        this.setPinable(ilvSettingsElement.getBoolean(PINABLE_PROPERTY, false));
        this.setFixedWidth(ilvSettingsElement.getBoolean(FIXED_WIDTH_PROPERTY, false));
        this.setFixedHeight(ilvSettingsElement.getBoolean(FIXED_HEIGHT_PROPERTY, false));
        this.setTitleVisible(ilvSettingsElement.getBoolean(TITLE_VISIBLE_PROPERTY, true));
        this.setActivable(ilvSettingsElement.getBoolean("activable", true));
        String string = ilvSettingsElement.getString("minimumWidth");
        String string2 = ilvSettingsElement.getString("minimumHeight");
        if (string != null && string.length() != 0 || string2 != null && string2.length() != 0) {
            this.setMinimumSize(new Dimension(ilvSettingsElement.getInt("minimumWidth", 0), ilvSettingsElement.getInt("minimumHeight", 0)));
        }
    }

    protected void writeSettings(IlvSettingsElement ilvSettingsElement) {
        ilvSettingsElement.setString(TITLE_PROPERTY, this.title);
        if (this.tabIconPathKey != null) {
            ilvSettingsElement.setString(TAB_ICON_PROPERTY, this.tabIconPathKey);
        }
        if (this.iconPathKey != null) {
            ilvSettingsElement.setString(ICON_PROPERTY, this.iconPathKey);
        }
        ilvSettingsElement.setBoolean("viewContainer", this.c);
        if (this.f != null) {
            ilvSettingsElement.setString("contentJavaClass", this.f);
        }
        ilvSettingsElement.setBoolean(DOCKABLE_PROPERTY, this.isDockable());
        ilvSettingsElement.setBoolean(SCROLLABLE_PROPERTY, this.isScrollable());
        ilvSettingsElement.setBoolean(CLOSABLE_PROPERTY, this.isClosable());
        ilvSettingsElement.setBoolean(PINABLE_PROPERTY, this.isPinable());
        ilvSettingsElement.setBoolean(FIXED_WIDTH_PROPERTY, this.isFixedWidth());
        ilvSettingsElement.setBoolean(FIXED_HEIGHT_PROPERTY, this.isFixedHeight());
        ilvSettingsElement.setBoolean(TITLE_VISIBLE_PROPERTY, this.isTitleVisible());
        ilvSettingsElement.setBoolean("activable", this.isActivable());
        Dimension dimension = this.getMinimumSize();
        if (dimension != null) {
            ilvSettingsElement.setInt("minimumWidth", dimension.width);
            ilvSettingsElement.setInt("minimumHeight", dimension.height);
        }
    }

    protected void localeSettingsChanged(LocaleSettingsEvent localeSettingsEvent) {
        IlvApplication ilvApplication = localeSettingsEvent.getApplication();
        if (ilvApplication == null) {
            return;
        }
        if (this.title != null) {
            this.setProperty(TITLE_PROPERTY, ilvApplication.getString(this.title));
        }
        if (this.tabIconPathKey != null) {
            this.setProperty(TAB_ICON_PROPERTY, ilvApplication.getImageIcon(this.tabIconPathKey));
        }
        if (this.iconPathKey != null) {
            this.setProperty(ICON_PROPERTY, ilvApplication.getImageIcon(this.iconPathKey));
        }
    }

    public IlvSettingsElement getSettingsElement() {
        return this.g;
    }

    public Object setProperty(String string, Object object) {
        Object object2 = this.a.getProperty(string);
        this.a.setProperty(string, object);
        return object2;
    }

    public Object getProperty(String string) {
        Object object = this.a.getProperty(string);
        if (object != null) {
            return object;
        }
        return this.b == null ? null : this.b.getProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.a.addPropertyChangeListener(propertyChangeListener);
        if (this.b != null) {
            this.b.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.a.removePropertyChangeListener(propertyChangeListener);
        if (this.b != null) {
            this.b.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public boolean isDockable() {
        return this.a(DOCKABLE_PROPERTY);
    }

    public void setDockable(boolean bl) {
        this.a(DOCKABLE_PROPERTY, bl);
    }

    public boolean isScrollable() {
        return this.a(SCROLLABLE_PROPERTY);
    }

    public void setScrollable(boolean bl) {
        this.a(SCROLLABLE_PROPERTY, bl);
    }

    public boolean isTitleVisible() {
        return this.a(TITLE_VISIBLE_PROPERTY);
    }

    public void setTitleVisible(boolean bl) {
        this.a(TITLE_VISIBLE_PROPERTY, bl);
    }

    public void setClosable(boolean bl) {
        this.a(CLOSABLE_PROPERTY, bl);
    }

    public boolean isClosable() {
        return this.a(CLOSABLE_PROPERTY);
    }

    public void setPinable(boolean bl) {
        this.a(PINABLE_PROPERTY, bl);
    }

    public boolean isPinable() {
        return this.a(PINABLE_PROPERTY);
    }

    boolean a(String string) {
        Boolean bl = (Boolean)this.getProperty(string);
        return bl == null ? false : bl;
    }

    void a(String string, boolean bl) {
        this.setProperty(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setFixedWidth(boolean bl) {
        this.a(FIXED_WIDTH_PROPERTY, bl);
    }

    public boolean isFixedWidth() {
        return this.a(FIXED_WIDTH_PROPERTY);
    }

    public void setFixedHeight(boolean bl) {
        this.a(FIXED_HEIGHT_PROPERTY, bl);
    }

    public boolean isFixedHeight() {
        return this.a(FIXED_HEIGHT_PROPERTY);
    }

    public void setActivable(boolean bl) {
        this.a(ACTIVABLE_PROPERTY, bl);
    }

    public boolean isActivable() {
        Boolean bl = (Boolean)this.getProperty(ACTIVABLE_PROPERTY);
        return bl == null ? true : bl;
    }

    public void setMinimumSize(Dimension dimension) {
        this.setProperty(MINIMUM_SIZE_PROPERTY, dimension);
    }

    public Dimension getMinimumSize() {
        return (Dimension)this.getProperty(MINIMUM_SIZE_PROPERTY);
    }

    public void setParentStyle(IlvDockablePaneStyle ilvDockablePaneStyle) {
        this.b = ilvDockablePaneStyle;
    }

    public IlvDockablePaneStyle getParentStyle() {
        return this.b;
    }

    public boolean isViewContainer() {
        return this.c;
    }

    public Class getContentPaneClass(IlvApplication ilvApplication) {
        if (this.e != null || this.f == null || this.f.length() == 0) {
            return this.e;
        }
        this.e = ilvApplication.getClassForName(this.f);
        return this.e;
    }

    public boolean isExtension() {
        return this.d;
    }

    public void setExtension(boolean bl) {
        this.d = bl;
    }

    public void apply(IlvDockingManager ilvDockingManager) {
        IlvDockablePane ilvDockablePane = (IlvDockablePane)ilvDockingManager.c(this.getName());
        if (ilvDockablePane != null) {
            ilvDockingManager.a((IlvDockable)ilvDockablePane, this);
            return;
        }
        Class clazz = this.getContentPaneClass(ilvDockingManager.ac());
        if (clazz == null) {
            return;
        }
        if (this.isViewContainer()) {
            ilvDockingManager.a(this.getName(), this);
        } else {
            Component component = this.createUserComponent(ilvDockingManager);
            if (component != null) {
                ilvDockingManager.a(this.getName(), component);
            }
        }
    }

    public Component createUserComponent(IlvDockingManager ilvDockingManager) {
        Class clazz = this.getContentPaneClass(ilvDockingManager.ac());
        Component component = null;
        try {
            component = (Component)clazz.newInstance();
        }
        catch (Exception exception) {
            IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, exception, "Logging.Docking.CannotInstantiateContentPane", new Object[]{clazz.getName(), this.getName()});
            return null;
        }
        return component;
    }
}

