/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.plaf;

import ilog.views.appframe.swing.plaf.ComponentDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

public class ButtonDecorator
implements ComponentDecorator {
    private Border a;
    private Border b;
    private Border c;
    private HashMap d = new HashMap();
    private Hashtable e = new Hashtable();
    private static PropertyChangeListener f;
    public static String IS_ROLLOVER;

    public ButtonDecorator() {
        this.a = this.createRolloverBorder();
        this.b = this.createNonRolloverBorder();
        this.c = this.a();
    }

    protected Border createRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new RolloverButtonBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight")), new RolloverMarginBorder());
    }

    protected Border createNonRolloverBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight")), new RolloverMarginBorder());
    }

    private Border a() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RadioButtonBorder(uIDefaults.getColor("ToggleButton.shadow"), uIDefaults.getColor("ToggleButton.darkShadow"), uIDefaults.getColor("ToggleButton.light"), uIDefaults.getColor("ToggleButton.highlight")), new RolloverMarginBorder());
    }

    protected void installRolloverBorders(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof JComponent)) continue;
            ((JComponent)componentArray[i2]).updateUI();
            this.setRolloverBorder(componentArray[i2], bl);
        }
    }

    protected void setRolloverBorder(Component component, boolean bl) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.d.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.d.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() != null) {
                if (bl) {
                    abstractButton.setBorder(this.a);
                } else if (abstractButton instanceof JToggleButton) {
                    abstractButton.setBorder(this.c);
                } else {
                    abstractButton.setBorder(this.b);
                }
            }
            this.e.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(bl);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = (Border)this.d.remove(abstractButton);
            abstractButton.setBorder(border);
            Boolean bl = (Boolean)this.e.remove(abstractButton);
            if (bl != null) {
                abstractButton.setRolloverEnabled(bl);
            }
        }
    }

    protected boolean isRolloverBorders(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return false;
        }
        Object object = ((JComponent)container).getClientProperty(IS_ROLLOVER);
        return object != null ? (Boolean)object : false;
    }

    public boolean canHandle(Component component) {
        return component instanceof AbstractButton;
    }

    public Object installContainer(final Container container) {
        if (f == null) {
            f = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (IS_ROLLOVER.equals(propertyChangeEvent.getPropertyName())) {
                        ButtonDecorator.this.installRolloverBorders(container, (Boolean)propertyChangeEvent.getNewValue());
                    }
                }
            };
        }
        container.addPropertyChangeListener(f);
        return null;
    }

    public Object uninstallContainer(Container container) {
        container.removePropertyChangeListener(f);
        return null;
    }

    public Object saveComponentProperties(Component component) {
        return new ButtonProperties((AbstractButton)component);
    }

    public void restoreComponentProperties(Component component, Object object) {
        ((ButtonProperties)object).restore((AbstractButton)component);
    }

    public void installComponent(Component component) {
        this.setRolloverBorder(component, this.isRolloverBorders(component));
    }

    public void uninstallComponent(Component component) {
    }

    static {
        IS_ROLLOVER = "JToolBar.isRollover";
    }

    private static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends BasicBorders.ButtonBorder {
        public RolloverButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = this.shadow;
            Container container = abstractButton.getParent();
            if (container != null && container.getBackground().equals(this.shadow)) {
                color = this.darkShadow;
            }
            if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                Color color2 = graphics.getColor();
                graphics.translate(n2, n3);
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(color);
                    graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                    graphics.setColor(this.lightHighlight);
                    graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
                    graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
                } else {
                    graphics.setColor(this.lightHighlight);
                    graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                    graphics.setColor(color);
                    graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
                    graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
                }
                graphics.translate(-n2, -n3);
                graphics.setColor(color2);
            }
        }
    }

    protected class ButtonProperties {
        private Border a;
        private boolean b;

        public ButtonProperties(AbstractButton abstractButton) {
            this.a = abstractButton.getBorder();
            this.b = abstractButton.isRolloverEnabled();
        }

        public void restore(AbstractButton abstractButton) {
            abstractButton.setBorder(this.a);
            abstractButton.setRolloverEnabled(this.b);
        }
    }
}

