/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.applications.util.palettebar;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.applications.util.palettebar.IlvActionToolBar;
import ilog.views.applications.util.palettebar.IlvMakeIconInteractor;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.IlvReliefLabel;
import ilog.views.graphic.IlvShadowLabel;
import ilog.views.graphic.IlvShadowRectangle;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.interactor.IlvEditLabelInteractor;
import ilog.views.interactor.IlvLabelledObjectFactory;
import ilog.views.interactor.IlvMakeArcInteractor;
import ilog.views.interactor.IlvMakeArrowPolylineInteractor;
import ilog.views.interactor.IlvMakeEllipseInteractor;
import ilog.views.interactor.IlvMakeLineInteractor;
import ilog.views.interactor.IlvMakePolyPointsInteractor;
import ilog.views.interactor.IlvMakePolygonInteractor;
import ilog.views.interactor.IlvMakePolylineInteractor;
import ilog.views.interactor.IlvMakeRectangleInteractor;
import ilog.views.interactor.IlvMakeReliefRectangleInteractor;
import ilog.views.interactor.IlvMakeSplineInteractor;
import ilog.views.interactor.IlvRectangularObjectFactory;
import ilog.views.util.swing.context.ComponentAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.Action;

public class IlvGraphicPaletteBar
extends IlvActionToolBar {
    private Font a;
    private Color b;
    private Color c;
    private Cursor d = Cursor.getPredefinedCursor(1);
    private ResourceBundle e;
    public InteractorAction labelAction;
    public InteractorAction zoomableLabelAction;
    public InteractorAction textAction;
    public InteractorAction lineAction;
    public InteractorAction polylineAction;
    public InteractorAction arrowPolylineAction;
    public InteractorAction polygonAction;
    public InteractorAction splineAction;
    public InteractorAction closedSplineAction;
    public InteractorAction rectangleAction;
    public InteractorAction roundRectangleAction;
    public InteractorAction reliefRectangleAction;
    public InteractorAction reliefLabelAction;
    public InteractorAction shadowRectangleAction;
    public InteractorAction shadowLabelAction;
    public InteractorAction ellipseAction;
    public InteractorAction arcAction;
    public InteractorAction iconAction;
    private static final int f = 100;
    private static final int g = 75;

    public IlvGraphicPaletteBar() {
        this((ResourceBundle)null);
    }

    public IlvGraphicPaletteBar(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle("ilog.views.applications.util.palettebar.palettebar");
        }
        this.e = resourceBundle;
        this.a();
    }

    private void a() {
        this.a = this.getFont();
        this.b = this.getForeground();
        this.c = this.getBackground();
        this.b();
        this.setActions(this.getPredefinedActions());
    }

    public Font getPaletteFont() {
        return this.a;
    }

    public void setPaletteFont(Font font) {
        this.a = font;
    }

    public Color getPaletteForeground() {
        return this.b;
    }

    public void setPaletteForeground(Color color) {
        this.b = color;
        Action[] actionArray = this.getActions();
        for (int i2 = 0; i2 < actionArray.length; ++i2) {
            if (!(actionArray[i2] instanceof InteractorAction)) continue;
            IlvManagerViewInteractor ilvManagerViewInteractor = ((InteractorAction)actionArray[i2]).getInteractor();
            if (ilvManagerViewInteractor instanceof IlvMakePolyPointsInteractor) {
                ((IlvMakePolyPointsInteractor)ilvManagerViewInteractor).setForeground(color);
            }
            if (!(ilvManagerViewInteractor instanceof IlvMakeRectangleInteractor)) continue;
            ((IlvMakeRectangleInteractor)ilvManagerViewInteractor).setForeground(color);
        }
    }

    public Color getPaletteBackground() {
        return this.c;
    }

    public void setPaletteBackground(Color color) {
        this.c = color;
        Action[] actionArray = this.getActions();
        for (int i2 = 0; i2 < actionArray.length; ++i2) {
            if (!(actionArray[i2] instanceof InteractorAction)) continue;
            IlvManagerViewInteractor ilvManagerViewInteractor = ((InteractorAction)actionArray[i2]).getInteractor();
            if (ilvManagerViewInteractor instanceof IlvMakePolyPointsInteractor) {
                ((IlvMakePolyPointsInteractor)ilvManagerViewInteractor).setBackground(color);
            }
            if (!(ilvManagerViewInteractor instanceof IlvMakeRectangleInteractor)) continue;
            ((IlvMakeRectangleInteractor)ilvManagerViewInteractor).setBackground(color);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.e;
    }

    private void b() {
        this.labelAction = new InteractorAction("GraphicPalette.Action.CreateLabel", new EditLabelInteractor(), this.e);
        this.lineAction = new InteractorAction("GraphicPalette.Action.CreateLine", new IlvMakeLineInteractor(), this.e);
        this.polylineAction = new InteractorAction("GraphicPalette.Action.CreatePolyline", new IlvMakePolylineInteractor(), this.e);
        this.arrowPolylineAction = new InteractorAction("GraphicPalette.Action.CreateArrowPolyline", new IlvMakeArrowPolylineInteractor(), this.e);
        this.polygonAction = new InteractorAction("GraphicPalette.Action.CreatePolygon", new IlvMakePolygonInteractor(), this.e);
        this.splineAction = new InteractorAction("GraphicPalette.Action.CreateSpline", new IlvMakeSplineInteractor(), this.e);
        IlvMakeSplineInteractor ilvMakeSplineInteractor = new IlvMakeSplineInteractor();
        ilvMakeSplineInteractor.setClosed(true);
        this.closedSplineAction = new InteractorAction("GraphicPalette.Action.CreateClosedSpline", ilvMakeSplineInteractor, this.e);
        IlvMakeRectangleInteractor ilvMakeRectangleInteractor = new IlvMakeRectangleInteractor(){

            protected IlvGraphic makeObject(IlvRect ilvRect) {
                if (ilvRect.width == 0.0f && ilvRect.height == 0.0f) {
                    ilvRect.width = 100.0f;
                    ilvRect.height = 75.0f;
                }
                return super.makeObject(ilvRect);
            }
        };
        ilvMakeRectangleInteractor.setCursor(this.d);
        this.rectangleAction = new InteractorAction("GraphicPalette.Action.CreateRectangle", ilvMakeRectangleInteractor, this.e);
        ilvMakeRectangleInteractor = new IlvMakeRectangleInteractor(){

            protected IlvGraphic makeObject(IlvRect ilvRect) {
                if (ilvRect.width == 0.0f && ilvRect.height == 0.0f) {
                    ilvRect.width = 100.0f;
                    ilvRect.height = 75.0f;
                }
                IlvRectangle ilvRectangle = (IlvRectangle)super.makeObject(ilvRect);
                ilvRectangle.setRadius(15);
                return ilvRectangle;
            }
        };
        ilvMakeRectangleInteractor.setCursor(this.d);
        this.roundRectangleAction = new InteractorAction("GraphicPalette.Action.CreateRoundRectangle", ilvMakeRectangleInteractor, this.e);
        ilvMakeRectangleInteractor = new IlvMakeReliefRectangleInteractor(){

            protected IlvGraphic makeObject(IlvRect ilvRect) {
                if (ilvRect.width == 0.0f && ilvRect.height == 0.0f) {
                    ilvRect.width = 100.0f;
                    ilvRect.height = 75.0f;
                }
                return super.makeObject(ilvRect);
            }
        };
        ilvMakeRectangleInteractor.setCursor(this.d);
        this.reliefRectangleAction = new InteractorAction("GraphicPalette.Action.CreateReliefRectangle", ilvMakeRectangleInteractor, this.e);
        EditLabelInteractor editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabelledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvZoomableLabel ilvZoomableLabel = new IlvZoomableLabel(ilvPoint, string);
                IlvGraphicPaletteBar.this.initializeGraphicAttributes(ilvZoomableLabel);
                return ilvZoomableLabel;
            }
        });
        this.zoomableLabelAction = new InteractorAction("GraphicPalette.Action.CreateZoomableLabel", editLabelInteractor, this.e);
        editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabelledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvText ilvText = new IlvText(ilvPoint, string);
                IlvGraphicPaletteBar.this.initializeGraphicAttributes(ilvText);
                return ilvText;
            }
        });
        this.textAction = new InteractorAction("GraphicPalette.Action.CreateText", editLabelInteractor, this.e);
        editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabelledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvReliefLabel ilvReliefLabel = new IlvReliefLabel(ilvPoint, string, 2);
                IlvGraphicPaletteBar.this.initializeGraphicAttributes(ilvReliefLabel);
                return ilvReliefLabel;
            }
        });
        this.reliefLabelAction = new InteractorAction("GraphicPalette.Action.CreateReliefLabel", editLabelInteractor, this.e);
        IlvMakeRectangleInteractor ilvMakeRectangleInteractor2 = new IlvMakeRectangleInteractor();
        ilvMakeRectangleInteractor2.setCursor(this.d);
        ilvMakeRectangleInteractor2.setObjectFactory(new IlvRectangularObjectFactory(){

            public IlvGraphic createObject(IlvRect ilvRect) {
                if (ilvRect.width == 0.0f && ilvRect.height == 0.0f) {
                    ilvRect.width = 100.0f;
                    ilvRect.height = 75.0f;
                }
                IlvShadowRectangle ilvShadowRectangle = new IlvShadowRectangle(ilvRect);
                return ilvShadowRectangle;
            }
        });
        this.shadowRectangleAction = new InteractorAction("GraphicPalette.Action.CreateShadowRectangle", ilvMakeRectangleInteractor2, this.e);
        editLabelInteractor = new EditLabelInteractor();
        editLabelInteractor.setObjectFactory(new IlvLabelledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                IlvShadowLabel ilvShadowLabel = new IlvShadowLabel(ilvPoint, string, 2.0f, 6.0f, 6.0f, 10);
                IlvGraphicPaletteBar.this.initializeGraphicAttributes(ilvShadowLabel);
                return ilvShadowLabel;
            }
        });
        this.shadowLabelAction = new InteractorAction("GraphicPalette.Action.CreateShadowLabel", editLabelInteractor, this.e);
        ilvMakeRectangleInteractor = new IlvMakeEllipseInteractor(){

            protected IlvGraphic makeObject(IlvRect ilvRect) {
                if (ilvRect.width == 0.0f && ilvRect.height == 0.0f) {
                    ilvRect.width = 100.0f;
                    ilvRect.height = 75.0f;
                }
                return super.makeObject(ilvRect);
            }
        };
        ilvMakeRectangleInteractor.setCursor(this.d);
        this.ellipseAction = new InteractorAction("GraphicPalette.Action.CreateEllipse", ilvMakeRectangleInteractor, this.e);
        ilvMakeRectangleInteractor = new IlvMakeArcInteractor(){

            protected IlvGraphic makeObject(IlvRect ilvRect) {
                if (ilvRect.width == 0.0f && ilvRect.height == 0.0f) {
                    ilvRect.width = 100.0f;
                    ilvRect.height = 75.0f;
                }
                return super.makeObject(ilvRect);
            }
        };
        ilvMakeRectangleInteractor.setCursor(this.d);
        this.arcAction = new InteractorAction("GraphicPalette.Action.CreateArc", ilvMakeRectangleInteractor, this.e);
        this.iconAction = new InteractorAction("GraphicPalette.Action.CreateIcon", new IlvMakeIconInteractor(this, this.e), this.e);
    }

    public void initializeGraphicAttributes(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvFontInterface) {
            ((IlvFontInterface)((Object)ilvGraphic)).setFont(this.a);
        }
        ilvGraphic.setForeground(this.b);
        ilvGraphic.setBackground(this.c);
    }

    public Cursor getInteractorCursor() {
        return this.d;
    }

    public void setInteractorCursor(Cursor cursor) {
        this.d = cursor;
    }

    public Action[] getPredefinedActions() {
        return new Action[]{this.labelAction, this.zoomableLabelAction, this.textAction, this.lineAction, this.polylineAction, this.arrowPolylineAction, this.polygonAction, this.splineAction, this.closedSplineAction, this.rectangleAction, this.roundRectangleAction, this.reliefRectangleAction, this.reliefLabelAction, this.shadowRectangleAction, this.shadowLabelAction, this.ellipseAction, this.arcAction, this.iconAction};
    }

    public class EditLabelInteractor
    extends IlvEditLabelInteractor {
        private Cursor a;

        protected void attach(IlvManagerView ilvManagerView) {
            super.attach(ilvManagerView);
            this.a = ilvManagerView.getCursor();
            ilvManagerView.setCursor(IlvGraphicPaletteBar.this.getInteractorCursor());
        }

        protected void detach() {
            this.getManagerView().setCursor(this.a);
            super.detach();
        }

        protected Component createEditComponent(boolean bl, boolean bl2, ActionListener actionListener, FocusListener focusListener) {
            Component component = super.createEditComponent(bl, bl2, actionListener, focusListener);
            component.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        EditLabelInteractor.this.getManagerView().popInteractor();
                    }
                }
            });
            return component;
        }

        protected void addObject(IlvGraphic ilvGraphic) {
            ilvGraphic.setForeground(IlvGraphicPaletteBar.this.getPaletteForeground());
            super.addObject(ilvGraphic);
        }
    }

    public static class InteractorAction
    extends ComponentAction {
        private IlvManagerViewInteractor a;

        public InteractorAction(String string, IlvManagerViewInteractor ilvManagerViewInteractor, ResourceBundle resourceBundle) {
            super(string, resourceBundle);
            this.a = ilvManagerViewInteractor;
        }

        public boolean isSelectable() {
            return true;
        }

        protected boolean isSelected(Component component) throws Exception {
            IlvManagerView ilvManagerView = this.a(component);
            if (ilvManagerView != null) {
                return ilvManagerView.getInteractor() == this.a;
            }
            return false;
        }

        public void perform(ActionEvent actionEvent, Component component) throws Exception {
            IlvManagerView ilvManagerView = this.a(component);
            if (ilvManagerView != null) {
                boolean bl = this.isSelected(ilvManagerView);
                if (bl) {
                    ilvManagerView.popInteractor();
                } else {
                    ilvManagerView.pushInteractor(this.a);
                }
                this.setSelected(!bl);
                if (!GraphicsEnvironment.isHeadless()) {
                    ilvManagerView.requestFocus();
                }
            }
        }

        private IlvManagerView a(Component component) {
            if (component instanceof IlvManagerView) {
                return (IlvManagerView)component;
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n2 = container.getComponentCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    IlvManagerView ilvManagerView = this.a(container.getComponent(i2));
                    if (ilvManagerView == null) continue;
                    return ilvManagerView;
                }
            }
            return null;
        }

        protected boolean isEnabled(Component component) throws Exception {
            return true;
        }

        public IlvManagerViewInteractor getInteractor() {
            return this.a;
        }

        public void setInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
            this.a = ilvManagerViewInteractor;
        }
    }
}

