/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.docview;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvAbstractFileDocument;
import ilog.views.appframe.docview.IlvDocumentView;
import ilog.views.appframe.docview.IlvFileDocumentTemplate;
import ilog.views.appframe.docview.IlvFileFilter;
import ilog.views.appframe.event.IlvMessageMapper;
import ilog.views.appframe.swing.IlvSwingMainWindow;
import ilog.views.appframe.util.IlvFileChooserSelection;
import ilog.views.builder.docview.IlvCustomizerView;
import ilog.views.builder.docview.IlvMessageView;
import ilog.views.builder.docview.IlvPropertySheetView;
import ilog.views.builder.docview.IlvRuleTreeView;
import ilog.views.builder.docview.selector.IlvSelectorEdition;
import ilog.views.builder.editor.IlvCSSCustomizer;
import ilog.views.builder.event.BuilderSelectionEvent;
import ilog.views.builder.event.BuilderSelectionListener;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeEvent;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.builder.gui.IlvContextualFileChooser;
import ilog.views.builder.gui.IlvCustomizerHandler;
import ilog.views.builder.gui.IlvExpressionCustomizer;
import ilog.views.builder.gui.IlvVariableDialog;
import ilog.views.builder.selection.IlvBuilderSelectionManager;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.css.model.IlvRuleModel;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.selector.IlvSelectorContext;
import ilog.views.css.swing.IlvCSSExpressionEditor;
import ilog.views.util.css.IlvCSSBeans;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.IlvParserHandler;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.css.parser.Parser;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvCSSAttributeSelector;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSFunction;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public abstract class IlvBuilderDocument
extends IlvAbstractFileDocument
implements StyleChangeListener {
    public static final int SEVERITY_NODES_LINKS = 2;
    public static final int SEVERITY_RENDERER = 5;
    public static final int SEVERITY_GRAPH_LAYOUT = 500;
    public static final int SEVERITY_GRAPH_LAYOUT_IMMEDIATELY = 501;
    private IlvBuilderSelectionManager a = new IlvBuilderSelectionManager();
    private IlvBuilderSelectionManager b = new IlvBuilderSelectionManager();
    private HashMap c = new HashMap();
    private static Object d;
    private IlvStyleChangeSupport e = new IlvStyleChangeSupport(this);
    private CompoundEdit f = null;
    private Logger g;
    private IlvExpressionCustomizer h;
    private Object i;
    protected static final int RULE_ACTION_REMOVE = 0;
    protected static final int RULE_ACTION_CHANGE = 1;
    protected static final int RULE_ACTION_ADD = 2;
    public static final String RULE_EVENT_NAME = "XX-rule-event";
    public static final String DECLARATION_EVENT_NAME = "XX-rule-event";
    public static final Object NEW_VALUE;
    public static final Object CHANGED_VALUE;
    private HashMap j = new HashMap();
    private ArrayList k = new ArrayList();
    public static final boolean WITH_DISABLED = true;
    public static final int SEVERITY_UNDEFINED = -1;
    public static final int SEVERITY_NONE = 0;
    public static final int SEVERITY_ADJUSTMENT = -10;
    public static final int SEVERITY_MAX = 100;
    private IlvParserHandler l;
    private HashMap m = new HashMap(3);
    private IlvFileDocumentTemplate n;

    public IlvBuilderDocument() {
        LocalBuilderSelectionListener localBuilderSelectionListener = new LocalBuilderSelectionListener();
        this.getSelectionManager().addSelectionListener(localBuilderSelectionListener, 60);
        String string = IlvRuleTreeView.class.getName();
        string = string.substring(0, string.lastIndexOf(46));
        this.g = Logger.getLogger(string);
        IlvMessageView.addLogPublisher(string, new CheckRulesLogPublisher());
        this.l = this.makeParserHandler();
        Parser.setParserHandler(this.l);
    }

    public String getEditAsTextHelpMessage(IlvCSSCustomizer ilvCSSCustomizer, String string) {
        return IlvCSSExpressionEditor.getEditAsTextHelpMessage(this.getSelectorContext(), this.getSelectedEditableRule());
    }

    public void setApplication(IlvApplication ilvApplication) {
        super.setApplication(ilvApplication);
        if (ilvApplication != null) {
            this.a(ilvApplication);
        }
    }

    private void a(IlvApplication ilvApplication) {
        ImageIcon imageIcon;
        if (IlvCSSCustomizer.INHERITANCE_ICONS[0] != null) {
            return;
        }
        IlvCSSCustomizer.INHERITANCE_ICONS[0] = imageIcon = ilvApplication.getImageIcon("Builder.Icons.TriangleRight");
        IlvCSSCustomizer.INHERITANCE_ICONS[1] = imageIcon;
        IlvCSSCustomizer.INHERITANCE_ICONS[2] = imageIcon = ilvApplication.getImageIcon("Builder.Icons.TriangleUp");
        IlvCSSCustomizer.INHERITANCE_ICONS[3] = imageIcon;
        IlvCSSCustomizer.INHERITANCE_ICONS[4] = imageIcon;
    }

    public IlvRule[] getRules() {
        return this.getRules(false);
    }

    public abstract IlvRule[] getRules(boolean var1);

    public IlvRule makeRuleTree() {
        this.getCSS().buildTree();
        return this.getCSS().getRootRule();
    }

    public String getLocalizedName(IlvRule ilvRule) {
        return ilvRule.toString();
    }

    protected boolean softEquals(String string, String string2) {
        return string != null && string.equals(string2);
    }

    protected boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    protected IlvRule[] getEditableRules(IlvRule[] ilvRuleArray) {
        return ilvRuleArray;
    }

    public abstract Object[] getMatchingObjects(IlvRule var1);

    public abstract IlvRule[] getMatchedRules(Object var1);

    protected void registerMappings(IlvMessageMapper ilvMessageMapper) {
        super.registerMappings(ilvMessageMapper);
        ilvMessageMapper.registerActionMethod("RuleDeleteAction", "deleteRule");
        ilvMessageMapper.registerActionStateMethod("RuleDeleteAction", "deleteRuleUI");
        ilvMessageMapper.registerActionMethod("RuleCutAction", "cutRule");
        ilvMessageMapper.registerActionStateMethod("RuleCutAction", "cutRuleUI");
        ilvMessageMapper.registerActionMethod("RuleCopyAction", "copyRule");
        ilvMessageMapper.registerActionStateMethod("RuleCopyAction", "copyRuleUI");
        ilvMessageMapper.registerActionMethod("RulePasteAction", "pasteRule");
        ilvMessageMapper.registerActionStateMethod("RulePasteAction", "pasteRuleUI");
        ilvMessageMapper.registerActionMethod("DeclarationsPasteAction", "pasteDeclarations");
        ilvMessageMapper.registerActionStateMethod("DeclarationsPasteAction", "pasteDeclarationsUI");
        ilvMessageMapper.registerActionMethod("RuleEnableAction", "enableRule");
        ilvMessageMapper.registerActionStateMethod("RuleEnableAction", "enableRuleUI");
        ilvMessageMapper.registerActionMethod("RuleDisableAction", "disableRule");
        ilvMessageMapper.registerActionStateMethod("RuleDisableAction", "disableRuleUI");
        ilvMessageMapper.registerActionMethod("RuleAddAction", "addRule");
        ilvMessageMapper.registerActionStateMethod("RuleAddAction", "addRuleUI");
        ilvMessageMapper.registerActionMethod("RuleChangeAction", "changeRule");
        ilvMessageMapper.registerActionStateMethod("RuleChangeAction", "changeRuleUI");
        ilvMessageMapper.registerActionMethod("CheckRulesAction", "checkRules");
        ilvMessageMapper.registerActionStateMethod("CheckRulesAction", "checkRulesUI");
        ilvMessageMapper.registerActionMethod("ApplyStyle", "applyStyle");
        ilvMessageMapper.registerActionMethod("PageSetup", "pageSetup");
        ilvMessageMapper.registerActionMethod("PrintPreview", "printPreview");
        ilvMessageMapper.registerActionMethod("Print", "print");
        ilvMessageMapper.registerActionMethod("EditVariables", "editVariables");
        ilvMessageMapper.registerActionMethod("EditFunctions", "editFunctions");
    }

    public void deleteRule() {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            this.getSelectionManager().setSelection(null);
            this.getRedSelectionManager().setSelection(null);
            this.deleteRule((IlvRule)object);
        }
    }

    public void deleteRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object == null || this.selectionIsRequiredRule()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.isDeleteRuleEnable(object));
        }
    }

    public void cutRule() {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            this.getSelectionManager().setSelection(null);
            this.getRedSelectionManager().setSelection(null);
            this.cutRule((IlvRule)object);
        }
    }

    public void cutRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object == null || this.selectionIsRequiredRule()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.isCutRuleEnable(object));
        }
    }

    public void copyRule() {
        Object object = this.getSelectionManager().getSelection();
        IlvRule ilvRule = (IlvRule)object;
        if (ilvRule != null) {
            this.copyRule(ilvRule);
        }
    }

    public void copyRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            action.setEnabled(this.isCopyRuleEnable(object));
        } else {
            action.setEnabled(false);
        }
    }

    public void pasteRuleUI(Action action) {
        Object object = IlvBuilderDocument.getClipboard();
        if (object != null) {
            action.setEnabled(this.isPasteRuleEnable(object));
        } else {
            action.setEnabled(false);
        }
    }

    public void pasteDeclarationsUI(Action action) {
        Object object = IlvBuilderDocument.getClipboard();
        if (object != null) {
            action.setEnabled(this.isPasteRuleEnable(object) && this.getSelectedEditableRule() != null);
        } else {
            action.setEnabled(false);
        }
    }

    public void editVariables() {
        IlvVariableDialog ilvVariableDialog = new IlvVariableDialog(this);
        ilvVariableDialog.showDialog();
        if (this.h != null) {
            this.h.refresh();
        }
    }

    public void editFunctions() {
        if (this.h != null) {
            this.h.refresh();
        }
    }

    private void a(IlvRule ilvRule, IlvRule[] ilvRuleArray, long l2) {
        this.a(ilvRuleArray, l2);
        this.getUndoManager().addEdit(new VisibilityEdit(ilvRule, ilvRuleArray));
        if (l2 == 0L) {
            this.getSelectionManager().resetSelection();
        } else {
            this.getSelectionManager().setSelection(null);
        }
    }

    private void a(IlvRule[] ilvRuleArray, long l2) {
        if (ilvRuleArray.length > 0) {
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                IlvRule ilvRule = ilvRuleArray[i2];
                ilvRule.setDisabledGroup(l2);
            }
            IlvRule ilvRule = ilvRuleArray[0];
            this.ruleEnabledChangedNotify(ilvRule, ilvRule.isEnabled());
        }
    }

    public void enableRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (ilvRule == null) {
            return;
        }
        IlvRule[] ilvRuleArray = (IlvRule[])this.m.get(ilvRule);
        if (ilvRuleArray == null || ilvRuleArray.length == 1) {
            ilvRuleArray = new IlvRule[]{ilvRule};
            if (ilvRule.getDisabledGroup() > 1L) {
                ilvRuleArray = this.a(ilvRule);
            }
        }
        this.b(ilvRule, null, 0L);
        this.a(ilvRule, ilvRuleArray, 0L);
    }

    private IlvRule[] a(IlvRule ilvRule) {
        long l2 = ilvRule.getDisabledGroup();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray[i2];
            if (l2 != ilvRule2.getDisabledGroup()) continue;
            arrayList.add(ilvRule2);
        }
        this.m.put(ilvRule, arrayList);
        return arrayList.toArray(new IlvRule[arrayList.size()]);
    }

    private void b(IlvRule ilvRule, IlvRule[] ilvRuleArray, long l2) {
        if (ilvRuleArray == null) {
            this.m.remove(ilvRule);
        } else {
            this.m.put(ilvRule, ilvRuleArray);
            ilvRule.setDisabledGroup(l2);
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                IlvRule ilvRule2 = ilvRuleArray[i2];
                ilvRule2.setDisabledGroup(l2);
            }
        }
    }

    public void disableRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (ilvRule == null) {
            return;
        }
        IlvRule[] ilvRuleArray = this.getSelectedRuleAndSubrules(ilvRule);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l2 = System.currentTimeMillis();
        this.a(ilvRule, ilvRuleArray, l2);
        this.b(ilvRule, ilvRuleArray, l2);
    }

    protected IlvRule[] getSelectedRuleAndSubrules(IlvRule ilvRule) {
        IlvRule ilvRule2 = ilvRule;
        HashSet<IlvRule> hashSet = new HashSet<IlvRule>();
        hashSet.add(ilvRule2);
        this.getCSS().getAdditionalRules(ilvRule2, this.getCSS().getParentRules(ilvRule2, true), hashSet, false);
        hashSet.remove(ilvRule2);
        IlvRule[] ilvRuleArray = hashSet.toArray(new IlvRule[hashSet.size()]);
        IlvRule[] ilvRuleArray2 = new IlvRule[ilvRuleArray.length + 1];
        ilvRuleArray2[0] = ilvRule2;
        System.arraycopy(ilvRuleArray, 0, ilvRuleArray2, 1, ilvRuleArray.length);
        return ilvRuleArray2;
    }

    public void enableRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object == null) {
            action.setEnabled(false);
            return;
        }
        if (object != null && object instanceof IlvRule) {
            IlvRule ilvRule = (IlvRule)object;
            action.setEnabled(!ilvRule.isAlwaysEnabled() && !ilvRule.isEnabled());
        } else {
            action.setEnabled(false);
        }
    }

    public void disableRuleUI(Action action) {
        Object object = this.getSelectionManager().getSelection();
        if (object != null) {
            action.setEnabled(this.isDisableRuleEnable(object));
        } else {
            action.setEnabled(false);
        }
    }

    public static synchronized Object getClipboard() {
        return d;
    }

    public static synchronized Object setClipboard(Object object) {
        Object object2 = d;
        d = object;
        return object2;
    }

    public synchronized boolean isPasteRuleEnable(Object object) {
        return object instanceof IlvRule[];
    }

    public synchronized boolean isCopyRuleEnable(Object object) {
        return object instanceof IlvRule;
    }

    public synchronized boolean isCutRuleEnable(Object object) {
        return object instanceof IlvRule;
    }

    public synchronized boolean isDeleteRuleEnable(Object object) {
        return object instanceof IlvRule;
    }

    public synchronized boolean isDisableRuleEnable(Object object) {
        if (object instanceof IlvRule) {
            IlvRule ilvRule = (IlvRule)object;
            return !ilvRule.isAlwaysEnabled() && ilvRule.isEnabled();
        }
        return false;
    }

    public synchronized void deleteRule(IlvRule ilvRule) {
        this.deleteRules(this.b(ilvRule));
    }

    private IlvRule[] b(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray;
        ArrayList arrayList = new ArrayList();
        this.fillListWithChildren(arrayList, ilvRule);
        HashSet<IlvRule[]> hashSet = new HashSet<IlvRule[]>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ilvRuleArray = (IlvRule[])iterator.next();
            hashSet.add(ilvRuleArray);
            this.getCSS().getAdditionalRules((IlvRule)ilvRuleArray, this.getCSS().getParentRules((IlvRule)ilvRuleArray, true), hashSet, false);
        }
        ilvRuleArray = hashSet.toArray(new IlvRule[hashSet.size()]);
        return ilvRuleArray;
    }

    public synchronized void deleteRules(IlvRule[] ilvRuleArray) {
        StyleChangeEvent.Remove remove = new StyleChangeEvent.Remove(this, null, null, ilvRuleArray);
        remove.setSeverity(100);
        this.styleChange(remove);
    }

    public synchronized void cutRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.copyRule(ilvRule);
        if (IlvBuilderDocument.getClipboard() != null && IlvBuilderDocument.getClipboard() instanceof IlvRule[]) {
            this.deleteRules(ilvRuleArray);
        }
    }

    public synchronized IlvRule[] copyRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.b(ilvRule);
        IlvBuilderDocument.setClipboard(this.getEditableRules(ilvRuleArray));
        return ilvRuleArray;
    }

    protected void fillListWithChildren(ArrayList arrayList, IlvRule ilvRule) {
        List list;
        if (ilvRule == null) {
            return;
        }
        if (!arrayList.contains(ilvRule)) {
            arrayList.add(ilvRule);
        }
        if ((list = ilvRule.getChildren()) == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IlvRule ilvRule2 = (IlvRule)iterator.next();
            this.fillListWithChildren(arrayList, ilvRule2);
        }
    }

    public synchronized void pasteRule() {
        if (IlvBuilderDocument.getClipboard() != null && IlvBuilderDocument.getClipboard() instanceof IlvRule[]) {
            IlvRule[] ilvRuleArray = (IlvRule[])IlvBuilderDocument.getClipboard();
            IlvRule[] ilvRuleArray2 = new IlvRule[ilvRuleArray.length];
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                ilvRuleArray2[i2] = ilvRuleArray[i2].copy();
            }
            StyleChangeEvent.Add add = new StyleChangeEvent.Add(this, null, null, ilvRuleArray2);
            this.styleChange(add);
        }
    }

    public synchronized void pasteDeclarations() {
        if (IlvBuilderDocument.getClipboard() != null && IlvBuilderDocument.getClipboard() instanceof IlvRule[] && this.getSelectedEditableRule() != null) {
            Object object;
            IlvRule[] ilvRuleArray = (IlvRule[])IlvBuilderDocument.getClipboard();
            ArrayList<IlvCSSDeclaration> arrayList = new ArrayList<IlvCSSDeclaration>();
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                object = ilvRuleArray[i2];
                IlvCSSDeclaration[] ilvCSSDeclarationArray = object.getCSSDeclarations();
                arrayList.addAll(Arrays.asList(ilvCSSDeclarationArray));
            }
            IlvCSSDeclaration[] ilvCSSDeclarationArray = arrayList.toArray(new IlvCSSDeclaration[arrayList.size()]);
            object = new StyleChangeEvent.Add(this, this.getSelectedEditableRule(), ilvCSSDeclarationArray, null);
            this.styleChange((StyleChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        IlvSelectorContext ilvSelectorContext = this.getSelectorContext();
        IlvSelector ilvSelector = ilvRule.getSelector();
        String string = ilvRule.getName();
        IlvRule ilvRule2 = null;
        try {
            ilvSelectorContext.setInitialEditableRule(ilvRule);
            ilvSelectorContext.setSelectorEditor(true);
            ilvRule2 = IlvSelectorEdition.changeRule(this.getApplication().getMainComponent(), ilvRule, ilvSelectorContext, this.ruleEditionWithDataModel() ? this : null);
        }
        finally {
            ilvSelectorContext.setInitialEditableRule(null);
            ilvSelectorContext.setSelectorEditor(false);
        }
        if (ilvRule2 != null) {
            String string2 = ilvRule2.getName();
            ilvRule.copyAttributes(ilvRule2);
            IlvSelector ilvSelector2 = ilvRule2.getSelector();
            ilvRule.setSelector(ilvSelector);
            ilvRule.updateRule();
            StyleChangeEvent.SelectorChange selectorChange = new StyleChangeEvent.SelectorChange((Object)this, ilvRule, ilvSelector2, string, string2);
            this.styleChange(selectorChange);
        }
    }

    public void changeRuleUI(Action action) {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (this.selectionIsRequiredRule()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(ilvRule != null && !ilvRule.isConfigurationRule() && ilvRule.isEnabled());
        }
    }

    protected boolean selectionIsRequiredRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        if (ilvRule == null) {
            return false;
        }
        return "true".equalsIgnoreCase(ilvRule.getMetaDeclarationValue("_REQUIRED_SELECTOR"));
    }

    protected void checkRulesForErrors() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRules() {
        IlvMessageView ilvMessageView = IlvMessageView.getMessageView(this.getApplication());
        ilvMessageView.clearEntries();
        int n2 = ilvMessageView.getCount(Level.SEVERE);
        int n3 = ilvMessageView.getCount(Level.WARNING);
        Level level = ilvMessageView.getLevel();
        ilvMessageView.setLevel(Level.INFO);
        Logger.getLogger("ilog.views.builder").log(Level.INFO, MessageFormat.format(this.getApplication().getString("Builder.CheckRules.CheckingRules"), this.getTitle()));
        ilvMessageView.setLevel(Level.WARNING);
        try {
            this.checkRulesForErrors();
            this.c(this.e());
            ilvMessageView.setLevel(Level.INFO);
            n2 = ilvMessageView.getCount(Level.SEVERE) - n2;
            n3 = ilvMessageView.getCount(Level.WARNING) - n3;
        }
        catch (Exception exception) {
            try {
                Logger.getLogger("ilog.views.builder").log(Level.WARNING, this.getApplication().getString("Builder.CheckRules.Error"), exception);
                ilvMessageView.setLevel(Level.INFO);
                n2 = ilvMessageView.getCount(Level.SEVERE) - n2;
                n3 = ilvMessageView.getCount(Level.WARNING) - n3;
            }
            catch (Throwable throwable) {
                ilvMessageView.setLevel(Level.INFO);
                n2 = ilvMessageView.getCount(Level.SEVERE) - n2;
                n3 = ilvMessageView.getCount(Level.WARNING) - n3;
                String string = MessageFormat.format(this.getApplication().getString("Builder.CheckRules.ErrorsWarnings"), new Integer(n2), new Integer(n3));
                Logger.getLogger("ilog.views.builder").log(Level.INFO, string);
                ilvMessageView.setLevel(level);
                throw throwable;
            }
            String string = MessageFormat.format(this.getApplication().getString("Builder.CheckRules.ErrorsWarnings"), new Integer(n2), new Integer(n3));
            Logger.getLogger("ilog.views.builder").log(Level.INFO, string);
            ilvMessageView.setLevel(level);
        }
        String string = MessageFormat.format(this.getApplication().getString("Builder.CheckRules.ErrorsWarnings"), new Integer(n2), new Integer(n3));
        Logger.getLogger("ilog.views.builder").log(Level.INFO, string);
        ilvMessageView.setLevel(level);
    }

    private void c(IlvRule ilvRule) {
        IlvCSSEngine.CSSrules cSSrules = this.getCSSBeans().getMatchedRules();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < ilvRule.getChildCount(); ++i2) {
            IlvRule ilvRule2 = (IlvRule)ilvRule.getChildAt(i2);
            if (ilvRule2.isFake()) continue;
            this.a(cSSrules, ilvRule2, arrayList);
        }
        if (arrayList.size() > 0) {
            Object[] objectArray = new Object[arrayList.size() + 1];
            objectArray[0] = this;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                objectArray[i3 + 1] = arrayList.get(i3);
            }
            this.g.log(Level.WARNING, this.getApplication().getString("Builder.CheckRules.NoMatch"), objectArray);
        }
    }

    private void a(IlvCSSEngine.CSSrules cSSrules, IlvRule ilvRule, List list) {
        if (cSSrules.getObjects(((IlvRuleImpl)ilvRule).getRule()).isEmpty()) {
            list.add(ilvRule);
            ilvRule.setUsed(false);
            this.d(ilvRule);
        }
        for (int i2 = 0; i2 < ilvRule.getChildCount(); ++i2) {
            IlvRule ilvRule2 = (IlvRule)ilvRule.getChildAt(i2);
            this.a(cSSrules, ilvRule2, list);
        }
    }

    public void checkRulesUI(Action action) {
        action.setEnabled(this.getCSS().getAllRules(true) != null);
    }

    private IlvRule e() {
        return this.getCSS().getRootRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRule() {
        IlvRule ilvRule = this.getSelectedEditableRule();
        IlvSelectorContext ilvSelectorContext = this.getSelectorContext();
        IlvRule ilvRule2 = null;
        try {
            ilvSelectorContext.setInitialEditableRule(ilvRule);
            ilvSelectorContext.setSelectorEditor(true);
            ilvRule2 = IlvSelectorEdition.createNewRule(this.getApplication().getMainComponent(), ilvRule, ilvSelectorContext, this.ruleEditionWithDataModel() ? this : null);
            if (!IlvBuilderDocument.manageRedundantRule(ilvRule2, this, this.getApplication().getMainComponent())) {
                ilvRule2 = null;
            }
        }
        finally {
            ilvSelectorContext.setInitialEditableRule(null);
            ilvSelectorContext.setSelectorEditor(false);
        }
        if (ilvRule2 != null) {
            StyleChangeEvent.Add add = new StyleChangeEvent.Add((Object)this, null, null, new IlvRule[]{ilvRule2}, ilvRule);
            this.styleChange(add);
            this.getSelectionManager().setSelection(ilvRule2);
        }
    }

    public static boolean manageRedundantRule(IlvRule ilvRule, IlvBuilderDocument ilvBuilderDocument, Component component) {
        if (ilvRule == null) {
            return false;
        }
        IlvRule[] ilvRuleArray = ilvBuilderDocument.getRules(true);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray[i2];
            if (!ilvRule2.isIdentical(ilvRule)) continue;
            int n2 = JOptionPane.showOptionDialog(component, ilvBuilderDocument.getApplication().getString("Builder.Conflict.Message"), ilvBuilderDocument.getApplication().getString("Builder.Conflict.Title"), 0, 2, null, null, null);
            if (n2 == 0) {
                ilvBuilderDocument.deleteRule(ilvRule2);
                return true;
            }
            return false;
        }
        return true;
    }

    public void addRuleUI(Action action) {
        this.changeRuleUI(action);
    }

    public void clean() {
        this.c.clear();
        this.getSelectionManager().setSelection(null);
    }

    public void writeCSS(PrintWriter printWriter) {
        this.writeCSS(printWriter, new IlvCSSDocument(null, null));
    }

    public void writeCSS(PrintWriter printWriter, URL uRL) {
        this.writeCSS(printWriter, new IlvCSSDocument(uRL, null));
    }

    public void writeCSS(PrintWriter printWriter, IlvCSSDocument ilvCSSDocument) {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvRule ilvRule = ilvRuleArray[i2];
            boolean bl = true;
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getMetadata();
            for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i3];
                if (ilvCSSDeclaration.getProperty() != "_WRITABLE") continue;
                if (!ilvCSSDeclaration.getValue().equals("false")) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ilvRule.printCSS(printWriter, ilvCSSDocument);
        }
    }

    public IlvBuilderSelectionManager getSelectionManager() {
        return this.a;
    }

    public IlvBuilderSelectionManager getRedSelectionManager() {
        return this.b;
    }

    public abstract IlvSelectorContext getSelectorContext();

    public void styleChange(StyleChangeEvent styleChangeEvent) {
        Object object;
        Object object2;
        if (styleChangeEvent instanceof StyleChangeEvent.SelectorChange) {
            object2 = (StyleChangeEvent.SelectorChange)styleChangeEvent;
            object = styleChangeEvent.getRule();
            if (object != null) {
                object.setSelector(((StyleChangeEvent.SelectorChange)object2).getNewSelector());
                Object[] objectArray = object;
                objectArray.updateRule();
                String string = ((StyleChangeEvent.SelectorChange)object2).getNewName();
                if (string != null) {
                    objectArray.setName(string);
                }
                this.ruleChangedNotifyImpl((IlvRule)objectArray, 1, true);
            }
        } else if (styleChangeEvent instanceof StyleChangeEvent.MoveBefore) {
            object2 = (StyleChangeEvent.MoveBefore)styleChangeEvent;
            object = ((StyleChangeEvent.MoveBefore)object2).getMovedRules();
            IlvRule ilvRule = ((StyleChangeEvent.MoveBefore)object2).getDestinationRule();
            IlvRule[] ilvRuleArray = this.getAllRules(true);
            this.a((IlvRule[])object, ilvRule, ilvRuleArray);
        } else if (styleChangeEvent instanceof StyleChangeEvent.AddRemove) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray;
            IlvRule[] ilvRuleArray;
            int n2;
            Object object3;
            object2 = styleChangeEvent.getRule();
            object = styleChangeEvent.getDeclarations();
            if (object != null && object2 != null) {
                object3 = object2;
                for (n2 = 0; n2 < ((Object[])object).length; ++n2) {
                    ilvRuleArray = object[n2];
                    if (styleChangeEvent.getMode() == StyleChangeEvent.DELETE) {
                        object2.removeDeclaration(ilvRuleArray.getProperty());
                        continue;
                    }
                    object3.setModified(ilvRuleArray.getProperty());
                    object2.setDeclaration((IlvCSSDeclaration)ilvRuleArray);
                }
                object3.setModified(true);
                this.d((IlvRule)object3);
            }
            if ((object3 = styleChangeEvent.getAdditionalRules()) != null && ((IlvRule[])object3).length > 0) {
                IlvRule ilvRule;
                int n3 = n2 = styleChangeEvent.isDeleteMode() ? 0 : 2;
                if (styleChangeEvent.isDeleteMode()) {
                    ilvRuleArray = this.getAllRules(true);
                    ((StyleChangeEvent.Remove)styleChangeEvent).setLocation(this.a((IlvRule[])object3, ilvRuleArray));
                }
                for (int i2 = 0; i2 < ((Object)object3).length; ++i2) {
                    Object object4 = object3[i2];
                    if (this.checkDuplicateRule() && !styleChangeEvent.isDeleteMode()) {
                        try {
                            if (this.getCSS().getRule(object4.getSelectorString(), false) != null) continue;
                            this.ruleChangedNotifyImpl((IlvRule)object4, n2, false);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    this.ruleChangedNotifyImpl((IlvRule)object4, n2, false);
                }
                if (!styleChangeEvent.isDeleteMode() && (ilvRule = ((StyleChangeEvent.Add)styleChangeEvent).getLocation()) != null) {
                    this.a((IlvRule[])object3, ilvRule, this.getAllRules(true));
                }
            }
            if ((ilvCSSDeclarationArray = styleChangeEvent.getDeclarations()) != null) {
                Integer n4 = new Integer(1);
                for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                    IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i3];
                    if (styleChangeEvent.isDeleteMode()) {
                        IlvRule ilvRule = this.getCSS().getRuleWithDeclaration((IlvRule)object2, ilvCSSDeclaration.getProperty());
                        this.j.put(ilvCSSDeclaration.getProperty(), new Integer(ilvRule == null ? 3 : 2));
                        continue;
                    }
                    this.j.put(ilvCSSDeclaration.getProperty(), n4);
                }
            }
        }
        this.setModified(true);
        boolean bl = this.applyChanges(styleChangeEvent);
        if (!(styleChangeEvent.getSource() instanceof StyleChangeEdit)) {
            object = new StyleChangeEdit(styleChangeEvent);
            if (styleChangeEvent.getSeverity() == -10) {
                if (this.f == null) {
                    this.f = new CompoundEdit(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void undo() throws CannotUndoException {
                            StyleChangeEdit styleChangeEdit = (StyleChangeEdit)this.edits.get(0);
                            StyleChangeEdit styleChangeEdit2 = (StyleChangeEdit)this.lastEdit();
                            if (styleChangeEdit != null && styleChangeEdit2 != null) {
                                int n2 = styleChangeEdit2.h.getSeverity();
                                try {
                                    styleChangeEdit.h.setSeverity(n2);
                                    styleChangeEdit2.h.setSeverity(-10);
                                    super.undo();
                                }
                                finally {
                                    styleChangeEdit.h.setSeverity(-10);
                                    styleChangeEdit2.h.setSeverity(n2);
                                }
                            }
                        }
                    };
                }
                this.a(this.f, (UndoableEdit)object);
            } else if (this.f != null) {
                this.a(this.f, (UndoableEdit)object);
                this.f.end();
                this.a(this.getUndoManager(), this.f);
                this.f = null;
            } else {
                this.a(this.getUndoManager(), (UndoableEdit)object);
            }
        }
        if (!bl) {
            this.notifyStyleChangeEvent(styleChangeEvent);
        }
    }

    protected boolean checkDuplicateRule() {
        return true;
    }

    private void a(CompoundEdit compoundEdit, UndoableEdit undoableEdit) {
        compoundEdit.addEdit(undoableEdit);
    }

    private String a(StyleChangeEvent styleChangeEvent) {
        IlvRule[] ilvRuleArray;
        IlvCSSDeclaration[] ilvCSSDeclarationArray;
        StringBuffer stringBuffer = new StringBuffer(styleChangeEvent.isDeleteMode() ? "(del) " : "(add)");
        IlvRule ilvRule = styleChangeEvent.getRule();
        if (ilvRule != null) {
            stringBuffer.append(((IlvRuleImpl)ilvRule).getRule().__selector).append(" ");
        }
        if ((ilvCSSDeclarationArray = styleChangeEvent.getDeclarations()) != null) {
            for (int i2 = 0; i2 < ilvCSSDeclarationArray.length; ++i2) {
                IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i2];
                stringBuffer.append(ilvCSSDeclaration.getProperty()).append(" : ").append(ilvCSSDeclaration.getValue()).append("; ");
            }
        }
        if ((ilvRuleArray = styleChangeEvent.getAdditionalRules()) != null) {
            for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
                IlvRule ilvRule2 = ilvRuleArray[i3];
                stringBuffer.append(" + ").append(((IlvRuleImpl)ilvRule).getRule().__selector);
            }
        }
        return stringBuffer.toString();
    }

    protected final void notifyStyleChangeEvent(StyleChangeEvent styleChangeEvent) {
        this.e.fireStyleChangeEvent(styleChangeEvent);
    }

    protected boolean applyChanges(StyleChangeEvent styleChangeEvent) {
        return false;
    }

    private void a(IlvRule[] ilvRuleArray, IlvRule ilvRule, IlvRule[] ilvRuleArray2) {
        int n2;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>(Arrays.asList(ilvRuleArray2));
        for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
            IlvRule ilvRule2 = ilvRuleArray[n2];
            arrayList.remove(ilvRule2);
        }
        n2 = arrayList.indexOf(ilvRule);
        if (n2 == -1) {
            arrayList.addAll(Arrays.asList(ilvRuleArray));
        } else {
            arrayList.addAll(n2, Arrays.asList(ilvRuleArray));
        }
        ilvRuleArray2 = arrayList.toArray(new IlvRule[arrayList.size()]);
        this.validateRules(ilvRuleArray2, true);
        this.getCSS().setProperty("XX-rule-event", new Object());
    }

    private IlvRule a(IlvRule[] ilvRuleArray, IlvRule[] ilvRuleArray2) {
        int n2 = 0;
        IlvRule ilvRule = ilvRuleArray[n2];
        for (int i2 = 0; i2 < ilvRuleArray2.length - 1; ++i2) {
            IlvRule ilvRule2 = ilvRuleArray2[i2];
            if (ilvRule2 != ilvRule) continue;
            IlvRule ilvRule3 = ilvRuleArray2[i2 + 1];
            boolean bl = true;
            for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
                if (ilvRuleArray[i3] != ilvRule3) continue;
                bl = false;
                break;
            }
            if (bl) {
                return ilvRule3;
            }
            if (++n2 == ilvRuleArray.length) {
                return null;
            }
            ilvRule = ilvRuleArray[n2];
            i2 = -1;
        }
        return null;
    }

    public void ruleEnabledChangedNotify(IlvRule ilvRule, boolean bl) {
        this.validateRules(this.getAllRules(true), true);
        IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
        if (ilvRuleTreeView != null) {
            ilvRuleTreeView.refreshLine(ilvRule);
        }
    }

    public void ruleNameChangedNotify(IlvRule ilvRule) {
        IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
        if (ilvRuleTreeView != null) {
            ilvRuleTreeView.repaint();
        }
        this.setModified(true);
    }

    public final IlvRuleTreeView getTreeView() {
        int n2 = this.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDocumentView ilvDocumentView = this.getView(i2);
            if (!(ilvDocumentView instanceof IlvRuleTreeView)) continue;
            return (IlvRuleTreeView)ilvDocumentView;
        }
        return null;
    }

    private void d(IlvRule ilvRule) {
        IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
        if (ilvRuleTreeView != null) {
            ilvRuleTreeView.refreshLine(ilvRule);
        }
    }

    public final IlvPropertySheetView getPropertySheetView() {
        int n2 = this.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDocumentView ilvDocumentView = this.getView(i2);
            if (!(ilvDocumentView instanceof IlvPropertySheetView)) continue;
            return (IlvPropertySheetView)ilvDocumentView;
        }
        return null;
    }

    public final IlvCustomizerView getCustomizerView() {
        int n2 = this.getViewCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDocumentView ilvDocumentView = this.getView(i2);
            if (!(ilvDocumentView instanceof IlvCustomizerView)) continue;
            return (IlvCustomizerView)ilvDocumentView;
        }
        return null;
    }

    public IlvDocumentView getModelView() {
        return null;
    }

    public abstract IlvRuleModel getCSS();

    protected void selectionChanged(BuilderSelectionEvent builderSelectionEvent) {
        Action action = this.getApplication().getAction("RuleDeleteAction");
        this.deleteRuleUI(action);
        action = this.getApplication().getAction("RuleCutAction");
        this.cutRuleUI(action);
        action = this.getApplication().getAction("RuleCopyAction");
        this.copyRuleUI(action);
        action = this.getApplication().getAction("RulePasteAction");
        this.pasteRuleUI(action);
        action = this.getApplication().getAction("RuleDisableAction");
        this.disableRuleUI(action);
        action = this.getApplication().getAction("DeclarationsPasteAction");
        this.pasteDeclarationsUI(action);
        action = this.getApplication().getAction("RuleAddAction");
        this.addRuleUI(action);
        action = this.getApplication().getAction("RuleChangeAction");
        this.changeRuleUI(action);
        Object object = builderSelectionEvent.getNewSelection();
        if (object instanceof IlvRule) {
            this.cleanDeclarationStatusCache();
        }
    }

    public void cleanDeclarationStatusCache() {
        if (this.j != null) {
            this.j.clear();
        }
    }

    public Object makeBeanFromRule(IlvRule ilvRule) {
        IlvRule[] ilvRuleArray = this.getCSS().getParentRules(ilvRule, true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRuleArray[i2].getCSSDeclarations();
            for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i3];
                hashMap.put(ilvCSSDeclaration.getProperty(), ilvCSSDeclaration.getValue());
            }
        }
        ilvRuleArray = this.getCSS().getAdditionalRules(ilvRuleArray);
        Object object = null;
        try {
            object = IlvRuleUtils.createBeanFromDeclarations(this, null, new ReflectModel(), hashMap, null, false, false, ilvRuleArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public Object makeBeanFromRule2(IlvRule ilvRule) {
        Object object = this.makeBeanFromRule(ilvRule);
        if (object == null) {
            object = this.getExistingBeanFromRule(ilvRule);
        }
        return object;
    }

    public Object getExistingBeanFromRule(IlvRule ilvRule) {
        Object[] objectArray = this.getMatchingObjects(ilvRule);
        if (objectArray != null && objectArray.length > 0) {
            return objectArray[0];
        }
        IlvRule[] ilvRuleArray = this.getCSS().getParentRules(ilvRule);
        if (ilvRuleArray != null) {
            for (int i2 = ilvRuleArray.length - 1; i2 >= 0; --i2) {
                IlvRule ilvRule2 = ilvRuleArray[i2];
                objectArray = this.getMatchingObjects(ilvRule2);
                if (objectArray == null || objectArray.length <= 0) continue;
                return objectArray[0];
            }
        }
        return null;
    }

    public int getDeclarationStatus(IlvRule ilvRule, String string) {
        if (ilvRule == null || ilvRule.getDeclarationValue(string) == null) {
            return 2;
        }
        return 0;
    }

    public IlvRule getSelectedEditableRule() {
        Object object = this.getSelectionManager().getSelection();
        if (object instanceof IlvRule) {
            return (IlvRule)object;
        }
        return null;
    }

    public IlvRule getRedSelectedEditableRule() {
        Object object = this.getRedSelectionManager().getSelection();
        if (object instanceof IlvRule) {
            return (IlvRule)object;
        }
        return null;
    }

    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.e.addStyleChangeListener(styleChangeListener);
    }

    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.e.removeStyleChangeListener(styleChangeListener);
    }

    protected IlvRule[] getAllRules() {
        return this.getCSS().getAllRules(false);
    }

    protected IlvRule[] getAllRules(boolean bl) {
        return this.getCSS().getAllRules(bl);
    }

    protected abstract IlvCSSBeans getCSSBeans();

    public IlvCSSFunction[] getCSSFunctions() {
        IlvCSSBeans ilvCSSBeans = this.getCSSBeans();
        ilvCSSBeans.getFunction("decimalFormat");
        ilvCSSBeans.getFunction("simpleDateFormat");
        ilvCSSBeans.getFunction("messageFormat");
        return this.getCSSBeans().getAllFunctions();
    }

    public IlvCSSEngine getCSSEngine() {
        return this.getCSSBeans().getCSSengine();
    }

    protected void ruleChangedNotifyImpl(IlvRule ilvRule, int n2, boolean bl) {
        this.getCSSBeans().clear();
        switch (n2) {
            case 0: {
                this.addRemoveRuleImpl(ilvRule, false, bl);
                this.c.remove(ilvRule);
                this.getCSS().setProperty("XX-rule-event", new Object());
                if (this.getSelectionManager().getSelection() != ilvRule || !bl) break;
                this.getSelectionManager().setSelection(null);
                this.getRedSelectionManager().setSelection(null);
                break;
            }
            case 2: {
                this.addRemoveRuleImpl(ilvRule, true, bl);
                ilvRule.setModified(true);
                this.d(ilvRule);
                this.getCSS().setProperty("XX-rule-event", new Object());
                IlvRuleTreeView ilvRuleTreeView = this.getTreeView();
                if (ilvRuleTreeView != null) {
                    ilvRuleTreeView.ensureVisible(ilvRule);
                }
                if (!bl) break;
                this.getSelectionManager().setSelection(ilvRule);
                break;
            }
            case 1: {
                this.validateRules(this.getAllRules(true), true);
                ilvRule.setModified(true);
                this.d(ilvRule);
                this.getCSS().setProperty("XX-rule-event", new Object());
            }
        }
    }

    public boolean known(IlvRule ilvRule) {
        return true;
    }

    protected void addRemoveRuleImpl(IlvRule ilvRule, boolean bl, boolean bl2) {
        IlvRule[] ilvRuleArray;
        IlvRule[] ilvRuleArray2 = this.getAllRules(true);
        if (bl) {
            ilvRuleArray = new IlvRule[ilvRuleArray2.length + 1];
            ilvRuleArray[ilvRuleArray2.length] = ilvRule;
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, ilvRuleArray2.length);
        } else {
            int n2 = -1;
            for (int i2 = 0; i2 < ilvRuleArray2.length; ++i2) {
                IlvRule ilvRule2 = ilvRuleArray2[i2];
                if (ilvRule2 != ilvRule) continue;
                n2 = i2;
                break;
            }
            if (n2 == -1) {
                return;
            }
            ilvRuleArray = new IlvRule[ilvRuleArray2.length - 1];
            System.arraycopy(ilvRuleArray2, 0, ilvRuleArray, 0, n2);
            System.arraycopy(ilvRuleArray2, n2 + 1, ilvRuleArray, n2, ilvRuleArray2.length - n2 - 1);
        }
        this.validateRules(ilvRuleArray, bl2);
    }

    protected void validateRules(IlvRule[] ilvRuleArray, boolean bl) {
        this.getCSSBeans().clear();
        Rule[] ruleArray = new Rule[ilvRuleArray.length];
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ruleArray[i2] = ((IlvRuleImpl)ilvRuleArray[i2]).getRule();
        }
        this.getCSSEngine().setRules(ruleArray);
        if (bl) {
            this.getCSS().rulesChanged();
        }
    }

    public void addCustomizerHandler(IlvCustomizerHandler ilvCustomizerHandler) {
        if (ilvCustomizerHandler == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.k.add(ilvCustomizerHandler);
    }

    public boolean removeCustomizerHandler(IlvCustomizerHandler ilvCustomizerHandler) {
        if (ilvCustomizerHandler == null) {
            throw new IllegalArgumentException("null parameter");
        }
        boolean bl = this.k.contains(ilvCustomizerHandler);
        if (bl) {
            this.k.remove(ilvCustomizerHandler);
        }
        return bl;
    }

    public ListIterator getCustomizerHandlerIterator() {
        return this.k.listIterator();
    }

    public IlvCustomizerHandler getCustomizerHandler(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        IlvCustomizerHandler ilvCustomizerHandler = null;
        do {
            if ((ilvCustomizerHandler = this.a(object, clazz)) == null) continue;
            return ilvCustomizerHandler;
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private IlvCustomizerHandler a(Object object, Class clazz) {
        ListIterator listIterator = this.getCustomizerHandlerIterator();
        while (listIterator.hasNext()) {
            IlvCustomizerHandler ilvCustomizerHandler = (IlvCustomizerHandler)listIterator.next();
            if (!ilvCustomizerHandler.match(object, clazz)) continue;
            return ilvCustomizerHandler;
        }
        return null;
    }

    void a(Object object) {
        this.i = object;
    }

    Object c() {
        return this.i;
    }

    public IlvParserHandler makeParserHandler() {
        return new InteractiveParserHandler(this);
    }

    protected void applyStyleImpl(URL uRL, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyStyle() {
        IlvApplication ilvApplication = this.getApplication();
        IlvFileChooserSelection[] ilvFileChooserSelectionArray = ilvApplication.showFileChooser(null, ilvApplication.getString("Builder.ApplyStyle.FileChooserTitle"), 10, this.b(ilvApplication), null);
        if (ilvFileChooserSelectionArray != null && ilvFileChooserSelectionArray.length > 0) {
            Object[] objectArray = new String[3];
            objectArray[0] = ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Replace");
            objectArray[1] = ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Append");
            objectArray[2] = ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Cancel");
            Object[] objectArray2 = objectArray;
            int n2 = JOptionPane.showOptionDialog(((IlvSwingMainWindow)ilvApplication.getMainWindow()).getFrame(), new JLabel(ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Message")), ilvApplication.getString("Builder.ApplyStyle.ReplaceOrAppend.Title"), 2, 3, null, objectArray2, objectArray2[0]);
            IlvMessageView ilvMessageView = IlvMessageView.getMessageView(ilvApplication);
            Level level = ilvMessageView.getLevel();
            ilvMessageView.setLevel(Level.WARNING);
            try {
                if (n2 == 0) {
                    this.applyStyleImpl(ilvFileChooserSelectionArray[0].getURL(), true);
                } else if (n2 == 1) {
                    this.applyStyleImpl(ilvFileChooserSelectionArray[0].getURL(), false);
                }
            }
            finally {
                ilvMessageView.setLevel(level);
            }
        }
    }

    private IlvFileDocumentTemplate b(IlvApplication ilvApplication) {
        if (this.n == null) {
            this.n = new IlvFileDocumentTemplate();
            IlvFileFilter ilvFileFilter = new IlvFileFilter(this.n, ".css", ilvApplication.getString("Builder.ApplyStyle.CSSDescription"));
            this.n.addFilter(ilvFileFilter);
            this.n.setDefaultFilter(ilvFileFilter);
        }
        return this.n;
    }

    public void pageSetup() {
    }

    public void printPreview() {
    }

    public void print() {
    }

    public boolean ruleEditionWithDataModel() {
        return false;
    }

    static {
        NEW_VALUE = "XX-new";
        CHANGED_VALUE = "XX-changed";
    }

    protected static class InteractiveParserHandler
    extends IlvParserHandler {
        IlvContextualFileChooser a;
        IlvBuilderDocument b;
        boolean c = true;

        public InteractiveParserHandler(IlvBuilderDocument ilvBuilderDocument) {
            this.b = ilvBuilderDocument;
            ilvBuilderDocument.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("Application")) {
                        InteractiveParserHandler.this.a((IlvApplication)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        private void a(IlvApplication ilvApplication) {
            if (ilvApplication != null) {
                this.a = new IlvContextualFileChooser(ilvApplication);
            }
        }

        public boolean missingSymbolPalette(Map map, String string, String string2, String string3) {
            return false;
        }

        public String resolvDeclarationURL(Declaration declaration, Rule rule, IlvCSSDocument ilvCSSDocument) {
            String string;
            block3: {
                string = super.resolvDeclarationURL(declaration, rule, ilvCSSDocument);
                try {
                    URL uRL = new URL(string);
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                catch (Exception exception) {
                    String string2 = declaration.getTarget();
                    String string3 = string2.substring(4, string2.length() - 1).trim();
                    if (string3.startsWith("\"") || string3.startsWith("'")) {
                        string3 = string3.substring(1, string2.length() - 1);
                    }
                    boolean bl = this.c;
                    this.c = false;
                    String string4 = this.a.requestNewFile(this.b.getApplication().getMainComponent(), ilvCSSDocument.getBaseURL(), string3, declaration, bl);
                    if (string4 == string3) break block3;
                    this.b.setModified(true);
                    return string4;
                }
            }
            return string;
        }

        public void reset() {
            this.c = true;
        }
    }

    private static class CheckRulesLogPublisher
    extends IlvMessageView.LogPublisher {
        private CheckRulesLogPublisher() {
        }

        public Object getHashKey(LogRecord logRecord) {
            return logRecord.getParameters()[1];
        }

        public IlvMessageView.LogDetail[] getDetails(LogRecord logRecord, final IlvMessageView ilvMessageView) {
            Object[] objectArray = logRecord.getParameters();
            IlvMessageView.LogDetail[] logDetailArray = new IlvMessageView.LogDetail[objectArray.length - 1];
            String string = ilvMessageView.getApplication().getString("Builder.MessageView.Rule");
            final IlvBuilderDocument ilvBuilderDocument = (IlvBuilderDocument)objectArray[0];
            for (int i2 = 1; i2 < objectArray.length; ++i2) {
                final IlvRule ilvRule = (IlvRule)objectArray[i2];
                logDetailArray[i2 - 1] = new IlvMessageView.LogDetail(MessageFormat.format(string, ilvRule)){

                    public boolean isClickable() {
                        return ilvMessageView.getDocument() == ilvBuilderDocument && this.a();
                    }

                    public void click() {
                        if (ilvMessageView.getDocument() == ilvBuilderDocument && this.a()) {
                            ilvBuilderDocument.getSelectionManager().setSelection(ilvRule);
                        }
                    }

                    private boolean a() {
                        return ilvBuilderDocument.known(ilvRule);
                    }
                };
            }
            return logDetailArray;
        }
    }

    protected static class ReflectModel
    implements IlvCSSModel {
        public Object[] getChildrenAsArray(Object object) {
            return new Object[0];
        }

        public String getType(Object object) {
            return null;
        }

        public String getCSSclasses(Object object) {
            return null;
        }

        public String getID(Object object) {
            return null;
        }

        public String getValue(Object object, String string) {
            return "@" + string;
        }

        public Object getValueAsObject(Object object, String string) {
            return this.getValue(object, string);
        }
    }

    public class StyleChangeEdit
    extends AbstractUndoableEdit {
        IlvRule a;
        IlvRule b;
        IlvRule[] c;
        IlvCSSDeclaration[] d;
        IlvCSSDeclaration[] e;
        IlvCSSAttributeSelector[] f;
        IlvCSSAttributeSelector[] g;
        StyleChangeEvent h;

        public StyleChangeEdit(StyleChangeEvent styleChangeEvent) {
            this.h = styleChangeEvent;
            StyleChangeEvent.Mode mode = styleChangeEvent.getMode();
            if (mode == StyleChangeEvent.MOVE_BEFORE) {
                StyleChangeEvent.MoveBefore moveBefore = (StyleChangeEvent.MoveBefore)styleChangeEvent;
                IlvRule ilvRule = null;
                IlvRule[] ilvRuleArray = IlvBuilderDocument.this.getAllRules(true);
                this.b = moveBefore.getDestinationRule();
                for (int i2 = 0; i2 < ilvRuleArray.length - 1; ++i2) {
                    if (this.b != ilvRuleArray[i2]) continue;
                    ilvRule = ilvRuleArray[i2 + 1];
                    break;
                }
                this.c = moveBefore.getMovedRules();
                this.a = ilvRule;
            } else if (styleChangeEvent instanceof StyleChangeEvent.AddRemove) {
                this.a = styleChangeEvent.getRule();
                this.c = styleChangeEvent.getAdditionalRules();
                this.d = this.a(styleChangeEvent.getDeclarations());
                this.e = ((StyleChangeEvent.AddRemove)styleChangeEvent).getPreviousDeclarations();
            } else if (mode == StyleChangeEvent.SELECTOR_CHANGE) {
                // empty if block
            }
        }

        private IlvCSSDeclaration[] a(IlvCSSDeclaration[] ilvCSSDeclarationArray) {
            Declaration[] declarationArray = null;
            if (ilvCSSDeclarationArray != null && ilvCSSDeclarationArray.length > 0) {
                declarationArray = new Declaration[ilvCSSDeclarationArray.length];
                for (int i2 = 0; i2 < ilvCSSDeclarationArray.length; ++i2) {
                    Declaration declaration;
                    Declaration declaration2 = (Declaration)ilvCSSDeclarationArray[i2];
                    declarationArray[i2] = declaration = Declaration.copy(declaration2);
                }
            }
            return declarationArray;
        }

        public boolean isSignificant() {
            return this.h.getSeverity() != 0;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            StyleChangeEvent.Mode mode = this.h.getMode();
            if (mode == StyleChangeEvent.MOVE_BEFORE) {
                StyleChangeEvent.MoveBefore moveBefore = new StyleChangeEvent.MoveBefore(this, this.c, this.a);
                moveBefore.setSeverity(this.h.getSeverity());
                IlvBuilderDocument.this.styleChange(moveBefore);
            } else if (mode == StyleChangeEvent.OVERRIDE) {
                int n2;
                Serializable serializable;
                StyleChangeEvent[] styleChangeEventArray = new StyleChangeEvent[3];
                if (this.e != null) {
                    ArrayList<IlvCSSDeclaration> arrayList = new ArrayList<IlvCSSDeclaration>(this.e.length);
                    serializable = new ArrayList(this.e.length);
                    for (int i2 = 0; i2 < this.e.length; ++i2) {
                        IlvCSSDeclaration ilvCSSDeclaration = this.e[i2];
                        if (ilvCSSDeclaration.getValue() == null) {
                            ((ArrayList)serializable).add(ilvCSSDeclaration);
                            continue;
                        }
                        arrayList.add(ilvCSSDeclaration);
                    }
                    if (((ArrayList)serializable).size() > 0) {
                        styleChangeEventArray[0] = new StyleChangeEvent.Remove(this, this.a, ((ArrayList)serializable).toArray(new Declaration[((ArrayList)serializable).size()]), null);
                        styleChangeEventArray[0].setSeverity(-10);
                    }
                    if (arrayList.size() > 0) {
                        styleChangeEventArray[1] = new StyleChangeEvent.Add(this, this.a, arrayList.toArray(new Declaration[arrayList.size()]), null);
                        styleChangeEventArray[1].setSeverity(-10);
                    }
                }
                if (this.c != null && this.c.length > 0) {
                    styleChangeEventArray[2] = new StyleChangeEvent.Remove(this, null, null, this.c);
                    styleChangeEventArray[2].setSeverity(-10);
                    ((StyleChangeEvent.Remove)styleChangeEventArray[2]).setLocation(((StyleChangeEvent.AddRemove)this.h).getLocation());
                }
                for (n2 = 2; n2 >= 0; --n2) {
                    serializable = styleChangeEventArray[n2];
                    if (serializable == null) continue;
                    ((StyleChangeEvent)serializable).setSeverity(this.h.getSeverity());
                    break;
                }
                for (n2 = 0; n2 < styleChangeEventArray.length; ++n2) {
                    serializable = styleChangeEventArray[n2];
                    if (serializable == null) continue;
                    IlvBuilderDocument.this.styleChange((StyleChangeEvent)serializable);
                }
            } else if (mode == StyleChangeEvent.DELETE) {
                StyleChangeEvent.Add add = new StyleChangeEvent.Add((Object)this, (Object)this.a, this.e, this.c, ((StyleChangeEvent.AddRemove)this.h).getLocation());
                add.setSeverity(this.h.getSeverity());
                IlvBuilderDocument.this.styleChange(add);
            } else if (mode == StyleChangeEvent.SELECTOR_CHANGE) {
                StyleChangeEvent.SelectorChange selectorChange = (StyleChangeEvent.SelectorChange)this.h;
                StyleChangeEvent.SelectorChange selectorChange2 = new StyleChangeEvent.SelectorChange((Object)this, this.h.getRule(), selectorChange.getOldSelector(), selectorChange.getNewName(), selectorChange.getOldName());
                selectorChange2.setSeverity(this.h.getSeverity());
                IlvBuilderDocument.this.styleChange(selectorChange2);
            } else {
                throw new RuntimeException("to be done.");
            }
        }

        public void redo() throws CannotRedoException {
            StyleChangeEvent styleChangeEvent;
            super.redo();
            StyleChangeEvent.Mode mode = this.h.getMode();
            if (mode == StyleChangeEvent.MOVE_BEFORE) {
                styleChangeEvent = new StyleChangeEvent.MoveBefore(this, this.c, this.b);
            } else if (mode == StyleChangeEvent.OVERRIDE) {
                styleChangeEvent = new StyleChangeEvent.Add(this, this.a, this.d, this.c);
            } else if (mode == StyleChangeEvent.DELETE) {
                styleChangeEvent = new StyleChangeEvent.Remove(this, this.a, this.d, this.c);
            } else if (mode == StyleChangeEvent.SELECTOR_CHANGE) {
                StyleChangeEvent.SelectorChange selectorChange = (StyleChangeEvent.SelectorChange)this.h;
                styleChangeEvent = new StyleChangeEvent.SelectorChange((Object)this, this.h.getRule(), selectorChange.getNewSelector(), selectorChange.getOldName(), selectorChange.getNewName());
            } else {
                throw new RuntimeException("to be done.");
            }
            styleChangeEvent.setSeverity(this.h.getSeverity());
            IlvBuilderDocument.this.styleChange(styleChangeEvent);
        }

        public String getPresentationName() {
            return super.getPresentationName();
        }
    }

    protected class VisibilityEdit
    extends AbstractUndoableEdit {
        IlvRule[] a;
        IlvRule b;

        public VisibilityEdit(IlvRule ilvRule, IlvRule[] ilvRuleArray) {
            this.a = ilvRuleArray;
            this.b = ilvRule;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            long l2 = this.a();
            this.a(this.b.isEnabled(), l2);
        }

        private long a() {
            long l2 = System.currentTimeMillis();
            if (this.a.length > 0) {
                IlvRule ilvRule = this.a[0];
                IlvBuilderDocument.this.a(this.a, ilvRule.isEnabled() ? l2 : 0L);
                if (ilvRule.isEnabled()) {
                    IlvBuilderDocument.this.getSelectionManager().resetSelection();
                } else {
                    IlvBuilderDocument.this.getSelectionManager().setSelection(null);
                }
            }
            return l2;
        }

        public void redo() throws CannotUndoException {
            super.redo();
            long l2 = this.a();
            this.a(this.b.isEnabled(), l2);
        }

        private void a(boolean bl, long l2) {
            IlvBuilderDocument.this.b(this.b, bl ? null : this.a, l2);
        }
    }

    class LocalBuilderSelectionListener
    implements BuilderSelectionListener {
        LocalBuilderSelectionListener() {
        }

        public void selectionChanged(BuilderSelectionEvent builderSelectionEvent) {
            IlvBuilderDocument.this.selectionChanged(builderSelectionEvent);
        }
    }
}

