/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.gui;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.appframe.form.IlvFormReaderContext;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.event.StyleChangeEvent;
import ilog.views.builder.gui.IlvObjectFormCustomizer;
import ilog.views.builder.gui.csseditors.IlvCSSFloatPointPropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSNumberEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPaintPropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPathNamePropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPropertyEditor;
import ilog.views.builder.gui.csseditors.IlvCSSPropertyEditorManager;
import ilog.views.builder.gui.csseditors.IlvCSSShapeEditor;
import ilog.views.builder.util.IlvRuleUtils;
import ilog.views.css.model.internal.IlvCSSWriter;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.graphic.composite.decoration.IlvRectBalloon;
import ilog.views.graphic.composite.decoration.IlvRoundRectBalloon;
import ilog.views.util.beans.IlvPropertyEditorManager;
import ilog.views.util.beans.editor.IlvPaintPropertyEditor;
import ilog.views.util.css.IlvCSSBeans;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.java2d.IlvLinearGradientPaint;
import ilog.views.util.java2d.IlvRadialGradientPaint;
import ilog.views.util.java2d.internal.IlvPaintChooser;
import ilog.views.util.java2d.internal.PaintSelectionModel;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Shape;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.w3c.dom.Element;

public class IlvGraphicEditor
extends IlvObjectFormCustomizer {
    private IlvGraphic a;
    private IlvRuleUtils.CSSBeansEngineOptionalExpression b = new IlvRuleUtils.CSSBeansEngineOptionalExpression();
    private IlvManagerView c;
    private static List d = new ArrayList();

    public IlvGraphicEditor() {
        this.getPreviewComponent();
    }

    public Component getPreviewComponent() {
        if (this.c != null) {
            return this.c;
        }
        this.a = this.createPreviewGraphic();
        if (this.a == null) {
            return null;
        }
        IlvManager ilvManager = new IlvManager();
        ilvManager.addObject(this.a, false);
        IlvManagerView ilvManagerView = new IlvManagerView(ilvManager);
        ilvManagerView.setAutoFitToContents(true);
        ilvManagerView.setKeepingAspectRatio(true);
        ilvManagerView.setMaxZoomXFactor(1.0);
        ilvManagerView.setMinZoomXFactor(1.0);
        ilvManagerView.setAntialiasing(true);
        this.c = ilvManagerView;
        return this.c;
    }

    protected URL resolveFormResourceURL(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return uRL;
        }
        uRL = IlvGraphicEditor.class.getResource(string);
        if (uRL != null) {
            return uRL;
        }
        return super.resolveFormResourceURL(string);
    }

    protected IlvGraphic createPreviewGraphic() {
        return null;
    }

    protected void applyDeclarations(StyleChangeEvent styleChangeEvent) {
        this.a((Declaration[])styleChangeEvent.getDeclarations());
        super.applyDeclarations(styleChangeEvent);
    }

    private void a(Declaration[] declarationArray) {
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < declarationArray.length; ++i2) {
            Declaration declaration = declarationArray[i2];
            hashMap.put(declaration.getSource(), declaration.getTarget());
        }
        if (this.a != null) {
            this.a.getGraphicBag().applyToObject(this.a, new IlvApplyObject(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicEditor.this.b.setResolvingExpression(false);
                    boolean bl = IlvCSSBeans.isLoggingEnabled();
                    try {
                        IlvCSSBeans.setLoggingEnabled(false);
                        IlvGraphicEditor.this.b.applyDeclarations(null, null, IlvGraphicEditor.this.a, hashMap, null);
                    }
                    finally {
                        IlvCSSBeans.setLoggingEnabled(bl);
                    }
                }
            }, null, true);
        }
    }

    protected IlvCSSPropertyEditor createPropertyEditor(String string, Class clazz, Class clazz2, Element element, IlvFormReaderContext ilvFormReaderContext) {
        if ("width".equals(string)) {
            return new SizeEditor(string, Integer.class, element, true, ilvFormReaderContext);
        }
        if ("height".equals(string)) {
            return new SizeEditor(string, Integer.class, element, false, ilvFormReaderContext);
        }
        if (clazz2 == Paint.class) {
            IlvCSSPaintPropertyEditor ilvCSSPaintPropertyEditor = (IlvCSSPaintPropertyEditor)super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
            if (!(ilvCSSPaintPropertyEditor.getPropertyEditor() instanceof GFPaintEditor)) {
                ilvCSSPaintPropertyEditor.setPropertyEditor(new GFPaintEditor());
            }
            return ilvCSSPaintPropertyEditor;
        }
        return super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
    }

    public static void RegisterEditorFactory(Class clazz, IlvObjectFormCustomizer.EditorFactory editorFactory) {
        d.add(clazz);
        d.add(editorFactory);
    }

    public static void UnregisterEditorFactory(Class clazz) {
        int n2 = d.lastIndexOf(clazz);
        if (n2 < 0) {
            return;
        }
        d.remove(n2 + 1);
        d.remove(n2);
    }

    static {
        IlvGraphicEditor.RegisterEditorFactory(IlvText.class, new IlvObjectFormCustomizer.EditorFactory(){

            public IlvObjectFormCustomizer createEditor(Object object) {
                return new TextEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvZoomableLabel.class, new IlvObjectFormCustomizer.EditorFactory(){

            public IlvObjectFormCustomizer createEditor(Object object) {
                return new ZoomableLabelEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvIcon.class, new IlvObjectFormCustomizer.EditorFactory(){

            public IlvObjectFormCustomizer createEditor(Object object) {
                return new IconEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvRoundRectBalloon.class, new IlvObjectFormCustomizer.EditorFactory(){

            public IlvObjectFormCustomizer createEditor(Object object) {
                return new RoundRectBalloonEditor();
            }
        });
        IlvGraphicEditor.RegisterEditorFactory(IlvRectBalloon.class, new IlvObjectFormCustomizer.EditorFactory(){

            public IlvObjectFormCustomizer createEditor(Object object) {
                return new RectBalloonEditor();
            }
        });
        IlvPropertyEditorManager.registerEditor(IlvPoint.class, IlvCSSFloatPointPropertyEditor.class);
        IlvCSSPropertyEditorManager.RegisterMicroEditorFactory(Shape.class, new IlvCSSPropertyEditorManager.CSSPropertyEditorFactory(){

            public IlvCSSPropertyEditor createPropertyEditor(Element element, IlvFormReaderContext ilvFormReaderContext) {
                return new IlvCSSShapeEditor(element.getAttribute("name"));
            }
        });
        IlvCSSWriter.setConstructorDescriptor(ilog.views.java2d.IlvLinearGradientPaint.class, new IlvCSSWriter.ConstructorDescriptor(){

            public String[] getParameters(Object object) {
                return new String[]{"start", "end", "stops", "colors", "spreadMethod", "colorSpace", "transform", "adapting"};
            }
        });
        IlvCSSWriter.setConstructorDescriptor(ilog.views.java2d.IlvRadialGradientPaint.class, new IlvCSSWriter.ConstructorDescriptor(){

            public String[] getParameters(Object object) {
                return new String[]{"center", "radius", "stops", "colors", "focal", "spreadMethod", "colorSpace", "transform", "adapting"};
            }
        });
    }

    public static class Handler
    extends IlvObjectFormCustomizer.CustomizerHandler {
        public Handler(IlvBuilderDocument ilvBuilderDocument) {
            super(ilvBuilderDocument);
        }

        protected List getFactories() {
            return d;
        }
    }

    public static class RectBalloonEditor
    extends IlvGraphicEditor {
        protected IlvGraphic createPreviewGraphic() {
            return new IlvRectBalloon();
        }
    }

    public static class RoundRectBalloonEditor
    extends IlvGraphicEditor {
        protected IlvGraphic createPreviewGraphic() {
            return new IlvRoundRectBalloon();
        }
    }

    public static class IconEditor
    extends IlvGraphicEditor {
        protected IlvGraphic createPreviewGraphic() {
            return new IlvIcon();
        }

        protected IlvCSSPropertyEditor createPropertyEditor(String string, Class clazz, Class clazz2, Element element, IlvFormReaderContext ilvFormReaderContext) {
            if ("imageLocation".equals(string)) {
                return new IlvCSSPathNamePropertyEditor(string);
            }
            return super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
        }
    }

    public static class ZoomableLabelEditor
    extends IlvGraphicEditor {
        public ZoomableLabelEditor() {
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(true), "fillPaint", "fillOn");
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(true), "backgroundPaint", "backgroundOn");
            IlvObjectFormCustomizer.Enabler enabler = new IlvObjectFormCustomizer.Enabler(){

                public boolean isEnabled(Object object, Object object2) {
                    if (object instanceof IlvZoomableLabel) {
                        IlvZoomableLabel ilvZoomableLabel = (IlvZoomableLabel)object;
                        return ilvZoomableLabel.isStrokeOn() || ilvZoomableLabel.isBorderOn();
                    }
                    return false;
                }
            };
            this.addEnabler(enabler, "strokePaint", "strokeOn");
            this.addEnabler(enabler, "stroke", "strokeOn");
        }

        protected IlvGraphic createPreviewGraphic() {
            return new IlvZoomableLabel();
        }
    }

    public static class TextEditor
    extends IlvGraphicEditor {
        public TextEditor() {
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(true), "fillPaint", "fillOn");
            this.addEnabler(new IlvObjectFormCustomizer.BooleanEnabler(true), "strokeColor", "strokeOn");
            IlvObjectFormCustomizer.Enabler enabler = new IlvObjectFormCustomizer.Enabler(){

                public boolean isEnabled(Object object, Object object2) {
                    return (Short)object2 != 0;
                }
            };
            this.addEnabler(enabler, "wrappingWidth", "wrappingMode");
            this.addEnabler(enabler, "wrappingHeight", "wrappingMode");
        }

        protected IlvGraphic createPreviewGraphic() {
            return new IlvText();
        }

        protected IlvCSSPropertyEditor createPropertyEditor(String string, Class clazz, Class clazz2, Element element, IlvFormReaderContext ilvFormReaderContext) {
            return super.createPropertyEditor(string, clazz, clazz2, element, ilvFormReaderContext);
        }
    }

    private static class GFPaintEditor
    extends IlvPaintPropertyEditor {
        public void stateChanged(ChangeEvent changeEvent) {
            Paint paint = ((PaintSelectionModel)changeEvent.getSource()).getSelectedPaint();
            paint = this.a(paint);
            this.setValue(paint);
        }

        public Component getCustomEditor() {
            IlvPaintChooser ilvPaintChooser = (IlvPaintChooser)super.getCustomEditor();
            Paint paint = ilvPaintChooser.getPaint();
            paint = this.b(paint);
            ilvPaintChooser.setPaint(paint);
            return ilvPaintChooser;
        }

        private Paint a(Paint paint) {
            if (paint instanceof IlvLinearGradientPaint) {
                IlvLinearGradientPaint ilvLinearGradientPaint = (IlvLinearGradientPaint)paint;
                paint = new ilog.views.java2d.IlvLinearGradientPaint(ilvLinearGradientPaint.getStart(), ilvLinearGradientPaint.getEnd(), ilvLinearGradientPaint.getStops(), ilvLinearGradientPaint.getColors(), ilvLinearGradientPaint.getSpreadMethod(), ilvLinearGradientPaint.getColorSpace(), ilvLinearGradientPaint.getTransform(), ilvLinearGradientPaint.isAdapting());
            } else if (paint instanceof IlvRadialGradientPaint) {
                IlvRadialGradientPaint ilvRadialGradientPaint = (IlvRadialGradientPaint)paint;
                paint = new ilog.views.java2d.IlvRadialGradientPaint(ilvRadialGradientPaint.getCenter(), ilvRadialGradientPaint.getRadius(), ilvRadialGradientPaint.getStops(), ilvRadialGradientPaint.getColors(), ilvRadialGradientPaint.getFocal(), ilvRadialGradientPaint.getSpreadMethod(), ilvRadialGradientPaint.getColorSpace(), ilvRadialGradientPaint.getTransform(), ilvRadialGradientPaint.isAdapting());
            }
            return paint;
        }

        private Paint b(Paint paint) {
            if (paint instanceof ilog.views.java2d.IlvLinearGradientPaint) {
                ilog.views.java2d.IlvLinearGradientPaint ilvLinearGradientPaint = (ilog.views.java2d.IlvLinearGradientPaint)paint;
                paint = new IlvLinearGradientPaint(ilvLinearGradientPaint.getStart(), ilvLinearGradientPaint.getEnd(), ilvLinearGradientPaint.getStops(), ilvLinearGradientPaint.getColors(), ilvLinearGradientPaint.getSpreadMethod(), ilvLinearGradientPaint.getColorSpace(), ilvLinearGradientPaint.getTransform(), ilvLinearGradientPaint.isAdapting());
            } else if (paint instanceof ilog.views.java2d.IlvRadialGradientPaint) {
                ilog.views.java2d.IlvRadialGradientPaint ilvRadialGradientPaint = (ilog.views.java2d.IlvRadialGradientPaint)paint;
                paint = new IlvRadialGradientPaint(ilvRadialGradientPaint.getCenter(), ilvRadialGradientPaint.getRadius(), ilvRadialGradientPaint.getStops(), ilvRadialGradientPaint.getColors(), ilvRadialGradientPaint.getFocal(), ilvRadialGradientPaint.getSpreadMethod(), ilvRadialGradientPaint.getColorSpace(), ilvRadialGradientPaint.getTransform(), ilvRadialGradientPaint.isAdapting());
            }
            return paint;
        }
    }

    private static class SizeEditor
    extends IlvCSSNumberEditor {
        private boolean a;

        public SizeEditor(String string, Class clazz, Element element, boolean bl, IlvFormReaderContext ilvFormReaderContext) {
            super(string, clazz, element, ilvFormReaderContext);
            this.a = bl;
        }

        public void setPropertyValue(Object object, Object object2) {
            IlvRect ilvRect = ((IlvGraphic)object).boundingBox();
            super.setPropertyValue(object, new Integer(this.a ? (int)ilvRect.width : (int)ilvRect.height));
        }

        protected String getStringValue(double d2) {
            return Integer.toString((int)d2);
        }

        public Declaration[] getDeclarations() {
            Declaration declaration = new Declaration();
            declaration.setSource(this.a ? "width" : "height");
            int n2 = (int)this.getValue();
            declaration.setTarget(this.getStringValue(n2));
            return new Declaration[]{declaration};
        }
    }
}

