/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.gui;

import ilog.views.builder.editor.IlvCSSMicroCustomizer;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.css.model.IlvRule;
import ilog.views.util.css.parser.Declaration;
import java.awt.Component;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderCustomizer
extends JSlider
implements IlvCSSMicroCustomizer {
    private static final NumberFormat a = NumberFormat.getInstance(Locale.US);
    private int b;
    private Declaration c;
    private JLabel d;
    private String e;
    private IlvStyleChangeSupport f = new IlvStyleChangeSupport(this);
    private MessageFormat g;

    public SliderCustomizer() {
        this(0, 100, 10, null, null, null);
    }

    public SliderCustomizer(int n2, int n3, int n4, String string, JLabel jLabel) {
        this(n2, n3, n4, string, jLabel, null);
    }

    public SliderCustomizer(int n2, int n3, int n4, String string, JLabel jLabel, MessageFormat messageFormat) {
        super(n2, n3, n2);
        if (n4 <= 0) {
            throw new IllegalArgumentException("increment cannot be 0");
        }
        this.b = n4;
        this.c = new Declaration();
        this.c.setSource(string);
        this.setLabel(jLabel);
        this.g = messageFormat;
        this.setPaintTicks(true);
        this.setMajorTickSpacing((this.getMaximum() - this.getMinimum()) / 10);
        this.addChangeListener(new ChangeListener(){
            int a = Integer.MIN_VALUE;

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = ((SliderCustomizer)changeEvent.getSource()).getValue();
                if (n2 == this.a) {
                    return;
                }
                this.a = n2;
                SliderCustomizer.this.fireStyleChangeEvent(true);
            }
        });
    }

    public void fireStyleChangeEvent(boolean bl) {
        int n2 = this.getValue();
        float f2 = 1.0f * (float)n2 / (float)this.b;
        this.c.setTarget(a.format(f2));
        if (this.d != null) {
            String string = this.g != null ? this.g.format(new Object[]{new Float(f2)}) : this.c.getTarget();
            this.d.setText(this.e + string);
        }
        this.f.fireStyleChangeEvent(null, this.getDeclarations(), !bl, this.a());
    }

    public void setPropertyName(String string) {
        this.c.setSource(string);
    }

    public String getPropertyName() {
        return this.c.getSource();
    }

    public int getIncrement() {
        return this.b;
    }

    public void setIncrement(int n2) {
        this.b = n2;
    }

    public void setMaximum(int n2) {
        super.setMaximum(n2);
        this.setMajorTickSpacing((this.getMaximum() - this.getMinimum()) / 10);
    }

    public void setMinimum(int n2) {
        super.setMaximum(n2);
        this.setMajorTickSpacing((this.getMaximum() - this.getMinimum()) / 10);
    }

    public void setLabel(JLabel jLabel) {
        this.d = jLabel;
        this.e = jLabel == null ? "" : this.d.getText() + " ";
    }

    public JLabel getLabel() {
        return this.d;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.g = messageFormat;
    }

    public MessageFormat getMessageFormat() {
        return this.g;
    }

    protected Declaration[] getDeclarations() {
        Declaration declaration = null;
        if (this.c.getSource() != null) {
            declaration = new Declaration();
            declaration.setSource(this.c.getSource());
            declaration.setTarget(this.c.getTarget());
        }
        return new Declaration[]{declaration};
    }

    private IlvRule[] a() {
        return new IlvRule[0];
    }

    public void setNormalizedValue(int n2) {
        super.setValue(n2 * this.b);
    }

    public int getNormalizedValue() {
        return super.getValue() / this.b;
    }

    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.f.addStyleChangeListener(styleChangeListener);
    }

    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.f.removeStyleChangeListener(styleChangeListener);
    }

    public String getStateName() {
        return this.c.getTarget();
    }

    public void setObject(Object object) {
    }

    public Component getPreviewComponent() {
        return null;
    }
}

