/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.faces.dhtml.renderkit;

import ilog.views.faces.IlvFacesConstants;
import ilog.views.faces.IlvFacesUtil;
import ilog.views.faces.component.IlvFacesComponent;
import ilog.views.faces.dhtml.IlvDHTMLConstants;
import ilog.views.faces.dhtml.renderkit.ComponentCreationListener;
import ilog.views.faces.dhtml.renderkit.IlvDHTMLResponseWriter;
import ilog.views.faces.dhtml.renderkit.IlvDHTMLUtil;
import ilog.views.faces.dhtml.renderkit.IlvDependencyManager;
import ilog.views.faces.dhtml.renderkit.IlvFacesManager;
import ilog.views.faces.dhtml.renderkit.IlvRendererManager;
import ilog.views.faces.dhtml.renderkit.IlvScriptDescriptor;
import ilog.views.faces.dhtml.renderkit.IlvScriptManager;
import ilog.views.faces.internalutil.IlvFacesConfig;
import java.beans.Beans;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public abstract class IlvDHTMLRenderer
extends Renderer
implements Serializable,
IlvDHTMLConstants,
IlvFacesConstants {
    private HashMap a;
    public static final IlvScriptDescriptor scriptDescriptor = new IlvScriptDescriptor("managedRenderer"){

        public void addScriptsToLoad(IlvScriptManager ilvScriptManager, Writer writer) {
            ilvScriptManager.addScript(writer, this.getJSResource("jviews", "IlvUtil.js"));
            ilvScriptManager.addScript(writer, this.getJSResource("IlvEventHandler.js"));
            ilvScriptManager.addScript(writer, this.getJSResource("IlvFacesProxy.js"));
        }
    };

    protected IlvDHTMLRenderer() {
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        super.decode(facesContext, uIComponent);
        ((IlvFacesComponent)uIComponent).resetDecodedProperties();
        if (IlvFacesConfig.debug) {
            IlvDHTMLUtil.debugDecodedParameters(uIComponent, this.getParameterMap(facesContext, uIComponent));
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        super.encodeBegin(facesContext, uIComponent);
        if (Beans.isDesignTime()) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            this.renderStartDT(facesContext, uIComponent, responseWriter);
            this.renderAttributesDT(facesContext, uIComponent, responseWriter);
        } else {
            IlvFacesManager ilvFacesManager = IlvDHTMLUtil.findManager(facesContext);
            ilvFacesManager.b(uIComponent);
            IlvDependencyManager ilvDependencyManager = ilvFacesManager.getDependencyManager();
            IlvScriptManager ilvScriptManager = ilvFacesManager.getScriptManager();
            IlvRendererManager ilvRendererManager = ilvFacesManager.getRendererManager();
            ilvRendererManager.setRendered(uIComponent);
            this.resolveDependencies(uIComponent, ilvDependencyManager);
            ilvScriptManager.emitScriptToLoad(ilvFacesManager.a(), this.getScriptDescriptor(uIComponent));
            ilvDependencyManager.notifyComponentCreation(ilvFacesManager.a(uIComponent), uIComponent);
            IlvFacesUtil.storeNamespaceInSession(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        IlvFacesManager ilvFacesManager = IlvDHTMLUtil.findManager(facesContext);
        ilvFacesManager.b(uIComponent);
        super.encodeEnd(facesContext, uIComponent);
        if (Beans.isDesignTime()) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            this.renderEndDT(facesContext, uIComponent, responseWriter);
        }
    }

    protected void renderStartDT(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
    }

    protected void renderEndDT(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
    }

    protected void renderAttributesDT(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
    }

    protected abstract void resolveDependencies(UIComponent var1, IlvDependencyManager var2);

    protected abstract void emitJSCreation(FacesContext var1, UIComponent var2) throws IOException;

    protected void emitScriptsLoad(ResponseWriter responseWriter) throws IOException {
        IlvFacesManager ilvFacesManager = IlvDHTMLUtil.findManager(FacesContext.getCurrentInstance());
        ilvFacesManager.a(responseWriter);
    }

    protected void emitResolvedDependencies(ResponseWriter responseWriter) throws IOException {
        IlvFacesManager ilvFacesManager = IlvDHTMLUtil.findManager(FacesContext.getCurrentInstance());
        ilvFacesManager.b(responseWriter);
    }

    protected void emitStateSavingHTMLObject(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        String string = IlvDHTMLUtil.getJSRef(uIComponent) + "_state";
        responseWriter.write("<input type='hidden' id='" + string + "' name='" + string + "' />");
    }

    protected void emitJSToHTML(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        String string = IlvDHTMLUtil.getJSRef(uIComponent);
        responseWriter.write(string + ".toHTML();\n");
    }

    protected void emitJSSetProperties(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        IlvDHTMLResponseWriter ilvDHTMLResponseWriter = new IlvDHTMLResponseWriter(facesContext, uIComponent);
        ilvDHTMLResponseWriter.writeJSStringProperty("absoluteId", IlvFacesUtil.buildAbsoluteId(uIComponent));
    }

    protected void emitOnLoadHandler(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        IlvFacesManager ilvFacesManager = IlvDHTMLUtil.findManager(facesContext);
        if (!ilvFacesManager.isLockPropertiesHandlerSent()) {
            ilvFacesManager.setLockPropertiesHandlerSent(true);
            IlvDHTMLResponseWriter ilvDHTMLResponseWriter = new IlvDHTMLResponseWriter(facesContext, uIComponent);
            ilvDHTMLResponseWriter.writeJSBodyEventHandler("load", "IlvFacesProxyLoad");
        }
    }

    protected void resolveVBDependency(UIComponent uIComponent, String string, String string2, IlvDependencyManager ilvDependencyManager, ComponentCreationListener componentCreationListener) {
        UIComponent uIComponent2 = (UIComponent)uIComponent.getAttributes().get(string);
        if (uIComponent2 != null) {
            if (ilvDependencyManager.isRendered(uIComponent2)) {
                uIComponent.getAttributes().put(string2, IlvFacesUtil.buildAbsoluteId(uIComponent2));
            } else {
                ilvDependencyManager.addDependencyListener(uIComponent, uIComponent2, componentCreationListener);
            }
        }
    }

    protected void resolveVBDependency(UIComponent uIComponent, String string, String string2, IlvDependencyManager ilvDependencyManager) {
        ComponentCreationListener componentCreationListener = new ComponentCreationListener(uIComponent, null, string){

            public void onComponentCreated(Writer writer, UIComponent uIComponent) throws IOException {
                String string = IlvDHTMLUtil.getJSRef(this.getComponent());
                String string2 = IlvDHTMLUtil.getJSRef(uIComponent);
                writer.write(string + "." + this.getJSMethod() + "(" + string2 + ");");
            }
        };
        this.resolveVBDependency(uIComponent, string, string2, ilvDependencyManager, componentCreationListener);
    }

    protected void resolveDependency(UIComponent uIComponent, String string, String string2, IlvDependencyManager ilvDependencyManager, ComponentCreationListener componentCreationListener) {
        if (string2 != null) {
            UIComponent uIComponent2 = uIComponent.findComponent(string2);
            if (uIComponent2 == null || !ilvDependencyManager.isRendered(uIComponent2)) {
                ilvDependencyManager.addDependencyListener(uIComponent, string2, componentCreationListener);
            } else {
                uIComponent.getAttributes().put(string, uIComponent2);
            }
        }
    }

    protected void resolveDependency(UIComponent uIComponent, String string, String string2, IlvDependencyManager ilvDependencyManager) {
        if (string2 != null) {
            this.resolveDependency(uIComponent, string, string2, ilvDependencyManager, new ComponentCreationListener(uIComponent, string2, string));
        }
    }

    protected HashMap getParameterMap(FacesContext facesContext, UIComponent uIComponent) {
        if (IlvFacesConfig.isTesting) {
            return this.getTestParameterMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = IlvDHTMLUtil.getJSRef(uIComponent) + "_state";
        String string2 = (String)facesContext.getExternalContext().getRequestParameterMap().get(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n2 = string3.indexOf(":");
                if (n2 != -1) {
                    String string4 = this.a(string3.substring(0, n2));
                    String string5 = string3.substring(n2 + 1, string3.length());
                    hashMap.put(string4, string5);
                    continue;
                }
                IlvFacesUtil.getLogger().log(Level.WARNING, "Error during the decoding of component " + uIComponent.getId() + " state, the parameter '" + string3 + "' is not valid.\n" + " The complete state is: \"" + string2 + "\"");
            }
        }
        return hashMap;
    }

    public HashMap getTestParameterMap() {
        return this.a;
    }

    public void setTestParameterMap(HashMap hashMap) {
        this.a = hashMap;
    }

    private String a(String string) {
        if (string.length() > 1) {
            if (Character.isUpperCase(string.charAt(1))) {
                return string;
            }
            return string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string.toUpperCase();
    }

    public IlvScriptDescriptor getScriptDescriptor() {
        return scriptDescriptor;
    }

    public IlvScriptDescriptor getScriptDescriptor(UIComponent uIComponent) {
        return this.getScriptDescriptor();
    }
}

