/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvFixedSizeGraphic;
import ilog.views.graphic.IlvGraphicHandleSelection;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPopupMenu;

public class IlvHalfZoomingGraphic
extends IlvFixedSizeGraphic {
    private double a;
    private double b;
    private double c;
    private Color d;
    private Color e;
    private boolean f = true;
    private float g = 1.0f;
    private boolean h = true;
    private IlvTransformer[] i = new IlvTransformer[3];
    private IlvTransformer[] j = new IlvTransformer[3];

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, int n2, IlvPoint ilvPoint, double d2, double d3, double d4) {
        super(ilvGraphic, n2, ilvPoint);
        this.a = d2;
        this.b = d3;
        this.c = d4;
        this.d = Color.black;
        this.e = Color.gray;
    }

    public IlvHalfZoomingGraphic(IlvHalfZoomingGraphic ilvHalfZoomingGraphic) {
        super(ilvHalfZoomingGraphic);
        this.a = ilvHalfZoomingGraphic.a;
        this.b = ilvHalfZoomingGraphic.b;
        this.c = ilvHalfZoomingGraphic.c;
        this.d = ilvHalfZoomingGraphic.d;
        this.e = ilvHalfZoomingGraphic.e;
        this.f = ilvHalfZoomingGraphic.f;
        this.g = ilvHalfZoomingGraphic.g;
        this.h = ilvHalfZoomingGraphic.h;
    }

    public IlvGraphic copy() {
        return new IlvHalfZoomingGraphic(this);
    }

    public IlvHalfZoomingGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readDouble("minZoom");
        this.b = ilvInputStream.readDouble("maxZoom");
        this.c = ilvInputStream.readDouble("initialZoom");
        this.d = ilvInputStream.readColor("foreground");
        this.e = ilvInputStream.readColor("background");
        try {
            this.f = ilvInputStream.readBoolean("grayedWhenUnzoomed");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.g = ilvInputStream.readFloat("alpha");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.h = ilvInputStream.readBoolean("useAlphaBuffer");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("minZoom", this.a);
        ilvOutputStream.write("maxZoom", this.b);
        ilvOutputStream.write("initialZoom", this.c);
        ilvOutputStream.write("foreground", this.d);
        ilvOutputStream.write("background", this.e);
        ilvOutputStream.write("grayedWhenUnzoomed", this.f);
        ilvOutputStream.write("alpha", this.g);
        ilvOutputStream.write("useAlphaBuffer", this.h);
    }

    public final void setPosition(int n2) {
        super.setPosition(n2);
        this.a();
    }

    public final void setPoint(IlvPoint ilvPoint) {
        super.setPoint(ilvPoint);
        this.a();
    }

    public double getMinZoom() {
        return this.a;
    }

    public void setMinZoom(double d2) {
        this.a = d2;
    }

    public double getMaxZoom() {
        return this.b;
    }

    public void setMaxZoom(double d2) {
        this.b = d2;
    }

    public double getInitialZoom() {
        return this.c;
    }

    public void setInitialZoom(double d2) {
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        this.c = d2;
    }

    public void setUnzoomedForeground(Color color) {
        this.d = color;
    }

    public Color getUnzoomedForeground() {
        return this.d;
    }

    public void setUnzoomedBackground(Color color) {
        this.e = color;
    }

    public Color getUnzoomedBackground() {
        return this.e;
    }

    public void setGrayedWhenUnzoomed(boolean bl) {
        this.f = bl;
    }

    public boolean isGrayedWhenUnzoomed() {
        return this.f;
    }

    public void setAlpha(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.g = f2;
    }

    public float getAlpha() {
        return this.g;
    }

    public void setAlphaBufferEnabled(boolean bl) {
        this.h = bl;
        if (!bl) {
            IlvDrawWithBufferedImage.clearCache();
        }
    }

    public boolean isAlphaBufferEnabled() {
        return this.h;
    }

    public IlvTransformer computeTransformer(IlvTransformer ilvTransformer) {
        int n2;
        for (n2 = 0; n2 < this.i.length; ++n2) {
            IlvTransformer ilvTransformer2;
            IlvTransformer ilvTransformer3 = this.j[n2];
            if (ilvTransformer3 == null || (ilvTransformer2 = this.i[n2]) == null || (ilvTransformer != null || !ilvTransformer2.isIdentity()) && !ilvTransformer2.equals(ilvTransformer)) continue;
            return this.j[n2];
        }
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvPoint ilvPoint = this.getPoint();
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
        }
        IlvTransformer ilvTransformer4 = new IlvTransformer();
        ilvTransformer4.setValues(1.0, 0.0, 0.0, 1.0, (double)ilvPoint2.x - (double)ilvPoint.x, (double)ilvPoint2.y - (double)ilvPoint.y);
        if (d2 < this.a * this.b()) {
            if (!this.f) {
                d2 = this.a;
            }
        } else {
            d2 = d2 > this.b * this.b() ? this.b : (d2 /= this.b());
        }
        ilvTransformer4.scale(ilvPoint.x, ilvPoint.y, d2, d2);
        int n3 = 0;
        for (n2 = 0; n2 < this.i.length; ++n2) {
            if (this.i[n2] != null) continue;
            n3 = n2;
            break;
        }
        this.j[n3] = ilvTransformer4;
        this.i[n3] = new IlvTransformer(ilvTransformer);
        return ilvTransformer4;
    }

    private void a() {
        this.i = new IlvTransformer[3];
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f2 != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f2);
            }
        }
        if (bl && this.isAlphaBufferEnabled()) {
            this.g = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.g = f2;
        } else {
            this.a(graphics2D, ilvTransformer);
        }
        if (bl && f2 != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void a(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                IlvRect ilvRect = this.boundingBox(ilvTransformer);
                graphics2D.setColor(this.e);
                graphics2D.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                graphics2D.setColor(this.d);
                graphics2D.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                return;
            }
        }
        this.getObject().draw(graphics2D, this.computeTransformer(ilvTransformer));
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                IlvRect ilvRect = this.unzoomedBBox();
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvRect);
                }
                return ilvRect;
            }
        }
        return this.getObject().boundingBox(this.computeTransformer(ilvTransformer));
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        super.applyTransform(ilvTransformer);
        for (int i2 = 0; i2 < this.i.length; ++i2) {
            this.j[i2] = null;
        }
    }

    protected IlvRect unzoomedBBox() {
        return this.boundingBox(null);
    }

    protected double getReferenceZoom() {
        return 1.0;
    }

    private double b() {
        if (this.c == 0.0) {
            return 1.0;
        }
        return this.getReferenceZoom() / this.c;
    }

    public boolean zoomable() {
        IlvPoint ilvPoint = this.getPoint();
        IlvRect ilvRect = this.getObject().boundingBox(null);
        if (ilvPoint.x < ilvRect.x || ilvPoint.y < ilvRect.y || ilvPoint.x > ilvRect.x + ilvRect.width || ilvPoint.y > ilvRect.y + ilvRect.height) {
            return false;
        }
        return (this.f || this.a == 0.0) && this.b >= this.c && this.getObject().zoomable();
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                return this.boundingBox(ilvTransformer).inside(ilvPoint2.x, ilvPoint2.y);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvPoint3);
        }
        if (!ilvTransformer2.isIdentity()) {
            ilvTransformer2.inverse(ilvPoint3);
        }
        return this.getObject().contains(ilvPoint3, ilvPoint2, ilvTransformer2);
    }

    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                return this.boundingBox(ilvTransformer).intersects(ilvRect2);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        return this.getObject().intersects(ilvRect, ilvRect2, ilvTransformer2);
    }

    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                return ilvRect2.contains(this.boundingBox(ilvTransformer));
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        return this.getObject().inside(ilvRect, ilvRect2, ilvTransformer2);
    }

    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                return this.getToolTipText();
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        String string = this.getObject().getToolTipText(ilvPoint, ilvTransformer2);
        if (string != null) {
            return string;
        }
        return this.getToolTipText();
    }

    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.b()) {
                return super.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        JPopupMenu jPopupMenu = this.getObject().getPopupMenu(ilvPoint, ilvTransformer2, ilvManagerView, ilvPopupMenuManager);
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    public IlvSelection makeSelection() {
        IlvSelection ilvSelection = this.getObject().makeSelection();
        return new IlvGraphicHandleSelection(this, ilvSelection){

            protected IlvTransformer getVirtualViewTransformer(IlvTransformer ilvTransformer) {
                return IlvHalfZoomingGraphic.this.computeTransformer(ilvTransformer);
            }
        };
    }
}

