/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.internal.IlvUtility;
import ilog.views.util.text.IlvAttributedStringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

class IlvLayoutTextRenderer
implements IlvText.Renderer {
    private transient boolean a = false;
    private transient boolean b = false;
    private transient Rectangle2D c;
    private transient float d;
    private transient int e;
    private transient TextLayout[] f;
    private transient FontRenderContext g = null;
    private transient TextLayout h = null;
    private transient InfoForFRCDependentTreatment i;
    private transient Integer[] j;
    private IlvText k;

    public IlvLayoutTextRenderer(IlvText ilvText) {
        this.k = ilvText;
        this.i = IlvText.IsTransformerDependentRendering() ? new InfoForFRCDependentTreatment() : null;
    }

    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2;
        TextLayout textLayout;
        if ((this.k.getWrappingMode() & 2) == 2) {
            return null;
        }
        double d2 = this.k.getAnchorPoint().x;
        double d3 = this.k.getAnchorPoint().y;
        this.g();
        Path2D path2D = null;
        this.b();
        int n2 = this.e;
        if (n2 == 0) {
            return null;
        }
        double d4 = this.c.getWidth();
        double d5 = 0.0;
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d2 -= d4 / 2.0;
                d3 -= this.c.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d2 -= (double)this.d;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            textLayout = this.f[i2];
            if (textLayout == null) continue;
            if (i2 > 0) {
                d3 += (double)textLayout.getAscent();
            }
            switch (this.k.getAlignment()) {
                case 256: {
                    d5 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d5 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d5 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 2: {
                    d5 = this.d - textLayout.getAdvance();
                }
            }
            int n3 = this.j[i2];
            int n4 = this.a(i2);
            Shape shape = null;
            int n5 = textLayout.getCharacterCount();
            if (range.isCollapsed()) {
                if (range.from >= n3 && range.from <= n4) {
                    shape = textLayout.getCaretShapes(Math.min(range.from - n3, n5))[0];
                }
            } else {
                int n6 = Math.max(range.from - n3, 0);
                int n7 = Math.min(n5, range.to - n3);
                if (n6 >= 0 && n6 < n7) {
                    shape = textLayout.getLogicalHighlightShape(n6, n7);
                }
            }
            if (shape != null) {
                AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d2 + d5, d3);
                shape = affineTransform.createTransformedShape(shape);
                if (path2D == null) {
                    path2D = new GeneralPath();
                }
                path2D.append(shape, false);
                if (range.isCollapsed()) break;
            }
            d3 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        if ((ilvTransformer2 = this.k.getTransformer()) != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        textLayout = ilvTransformer2 != null ? IlvUtility.IlvToJava2DTransformer(ilvTransformer2, null) : null;
        if (textLayout != null & path2D != null) {
            return path2D.createTransformedShape((AffineTransform)((Object)textLayout));
        }
        return path2D;
    }

    private int a(int n2) {
        if (n2 < this.j.length - 1) {
            return this.j[n2 + 1] - 1;
        }
        return this.k.getLabel().length();
    }

    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        double d2 = this.k.getAnchorPoint().x;
        double d3 = this.k.getAnchorPoint().y;
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint);
        }
        if (this.k.getTransformer() != null) {
            this.k.getTransformer().inverse(ilvPoint);
        }
        this.g();
        this.b();
        int n2 = this.e;
        if (n2 == 0) {
            return -1;
        }
        double d4 = this.c.getWidth();
        double d5 = 0.0;
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d2 -= d4 / 2.0;
                d3 -= this.c.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d2 -= (double)this.d;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            TextHitInfo textHitInfo;
            int n3;
            TextLayout textLayout = this.f[i2];
            if (textLayout == null) continue;
            if (i2 > 0) {
                d3 += (double)textLayout.getAscent();
            }
            switch (this.k.getAlignment()) {
                case 256: {
                    d5 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d5 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d5 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 2: {
                    d5 = this.d - textLayout.getAdvance();
                }
            }
            int n4 = textLayout.getCharacterCount();
            if ((double)ilvPoint.y >= d3 - (double)textLayout.getAscent() && (double)ilvPoint.y <= d3 + (double)textLayout.getDescent() && (n3 = (textHitInfo = textLayout.hitTestChar((float)((double)ilvPoint.x - d2 - d5), (float)((double)ilvPoint.y - d3))).getInsertionIndex()) >= 0 && n3 <= n4) {
                if (this.a()) {
                    return this.lineOffset(i2);
                }
                return this.lineOffset(i2) + n3;
            }
            d3 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
        return -1;
    }

    boolean a() {
        return this.k.getLabel() == null || this.k.getLabel().length() == 0;
    }

    public int lineCount() {
        this.g();
        return this.j.length;
    }

    public int lineOffset(int n2) {
        this.g();
        if (n2 < 0 || n2 >= this.lineCount()) {
            return -1;
        }
        return this.j[n2];
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        AffineTransform affineTransform;
        IlvTransformer ilvTransformer2;
        this.g();
        graphics = graphics.create();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.k.isAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.k.isFractionalMetrics()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        if ((ilvTransformer2 = this.k.getTransformer()) != null) {
            ilvTransformer2.compose(ilvTransformer);
        } else {
            ilvTransformer2 = ilvTransformer;
        }
        AffineTransform affineTransform2 = affineTransform = ilvTransformer2 != null ? IlvUtility.IlvToJava2DTransformer(ilvTransformer2, null) : null;
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        graphics.setColor(this.k.getForeground());
        graphics2D.setFont(this.k.getFont());
        TextLayout[] textLayoutArray = this.f;
        if (this.i != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this.f = this.a(fontRenderContext);
        }
        if (this.e > 0) {
            if (this.e > 1) {
                this.b(graphics2D, this.k.ac.x, this.k.ac.y);
            } else {
                this.a(graphics2D, this.k.ac.x, this.k.ac.y);
            }
        }
        if (this.i != null) {
            this.f = textLayoutArray;
        }
        graphics.dispose();
    }

    private void a(Graphics2D graphics2D, double d2, double d3) {
        TextLayout textLayout = this.f[0];
        if (textLayout == null) {
            return;
        }
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d2 -= textLayout.isLeftToRight() ? 0.0 : (double)textLayout.getAdvance();
                break;
            }
            case 257: {
                d2 -= textLayout.isLeftToRight() ? (double)textLayout.getAdvance() : 0.0;
                break;
            }
            case 16: {
                d2 -= this.getBounds().getWidth() / 2.0;
                d3 += (double)((textLayout.getAscent() - textLayout.getDescent()) / 2.0f);
                break;
            }
            case 2: {
                d2 -= (double)textLayout.getAdvance();
            }
        }
        textLayout.draw(graphics2D, (float)d2, (float)d3);
    }

    private void b(Graphics2D graphics2D, double d2, double d3) {
        this.b();
        int n2 = this.e;
        double d4 = this.c.getWidth();
        double d5 = 0.0;
        switch (this.k.getAnchorPosition()) {
            case 256: {
                d2 -= this.f[0].isLeftToRight() ? 0.0 : (double)this.d;
                break;
            }
            case 257: {
                d2 -= this.f[0].isLeftToRight() ? (double)this.d : 0.0;
                break;
            }
            case 16: {
                d2 -= d4 / 2.0;
                d3 -= this.c.getHeight() / 2.0 - (double)this.f[0].getAscent();
                break;
            }
            case 2: {
                d2 -= (double)this.d;
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            TextLayout textLayout = this.f[i2];
            if (textLayout == null) continue;
            if (i2 > 0) {
                d3 += (double)textLayout.getAscent();
            }
            switch (this.k.getAlignment()) {
                case 256: {
                    d5 = textLayout.isLeftToRight() ? 0.0 : (double)(this.d - textLayout.getAdvance());
                    break;
                }
                case 257: {
                    d5 = textLayout.isLeftToRight() ? (double)(this.d - textLayout.getAdvance()) : 0.0;
                    break;
                }
                case 16: {
                    d5 = (this.d - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                case 2: {
                    d5 = this.d - textLayout.getAdvance();
                }
            }
            textLayout.draw(graphics2D, (float)(d2 + d5), (float)d3);
            d3 += (double)(textLayout.getDescent() + this.a(textLayout));
        }
    }

    public final Rectangle2D getBounds() {
        this.g();
        this.b();
        return this.c;
    }

    private void b() {
        if (this.a) {
            return;
        }
        if (this.i != null) {
            this.c();
        } else {
            this.d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        this.d();
        Rectangle2D rectangle2D = (Rectangle2D)this.c.clone();
        AffineTransform affineTransform = new AffineTransform(100.0f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f);
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, this.k.isAntialiasing(), this.k.isFractionalMetrics());
        TextLayout[] textLayoutArray = this.f;
        try {
            this.f = this.a(fontRenderContext);
            this.d();
            this.c = this.c.createUnion(rectangle2D);
        }
        finally {
            this.f = textLayoutArray;
        }
    }

    private void d() {
        TextLayout textLayout = this.f.length == 0 ? null : this.f[0];
        Rectangle2D rectangle2D = textLayout == null ? null : textLayout.getBounds();
        float f2 = textLayout == null || !textLayout.isLeftToRight() || rectangle2D.getX() > 0.0 ? 0.0f : (float)rectangle2D.getX();
        float f3 = textLayout == null || textLayout.isLeftToRight() || rectangle2D.getX() < 0.0 ? 0.0f : (float)rectangle2D.getX();
        float f4 = textLayout == null ? 0.0f : textLayout.getAdvance();
        float f5 = textLayout == null ? 0.0f : textLayout.getAscent() + textLayout.getDescent();
        int n2 = this.e;
        for (int i2 = 1; i2 < n2; ++i2) {
            textLayout = this.f[i2];
            if (textLayout == null) continue;
            if (textLayout.isLeftToRight()) {
                f2 = Math.min(f2, (float)textLayout.getBounds().getX());
            } else {
                f3 = Math.max(f3, (float)textLayout.getBounds().getX());
            }
            f4 = Math.max(f4, textLayout.getAdvance());
            f5 += textLayout.getAscent() + textLayout.getDescent() + this.a(textLayout);
        }
        this.d = f4;
        f4 += f3 - f2;
        float f6 = f2;
        f6 += this.k.ac.x;
        textLayout = this.f.length == 0 ? null : this.f[0];
        float f7 = this.k.ac.y - (textLayout != null ? textLayout.getAscent() : 0.0f);
        if (textLayout != null) {
            switch (this.k.getAnchorPosition()) {
                case 256: {
                    f6 -= this.f[0].isLeftToRight() ? 0.0f : this.d;
                    break;
                }
                case 257: {
                    f6 -= this.f[0].isLeftToRight() ? this.d : 0.0f;
                    break;
                }
                case 16: {
                    if (n2 == 1) {
                        f6 = (float)((double)f6 - (double)f4 / 2.0);
                        f7 += (this.f[0].getAscent() - this.f[0].getDescent()) / 2.0f;
                        break;
                    }
                    f6 = (float)((double)f6 - (double)f4 / 2.0);
                    f7 = (float)((double)f7 - ((double)f5 / 2.0 - (double)this.f[0].getAscent()));
                    break;
                }
                case 2: {
                    f6 -= this.d;
                }
            }
        }
        if (this.c == null) {
            this.c = new Rectangle2D.Double(f6, f7, f4, f5);
        } else {
            this.c.setRect(f6, f7, f4, f5);
        }
        this.a = true;
    }

    private final FontRenderContext e() {
        if (this.g == null) {
            this.g = new FontRenderContext(null, this.k.isAntialiasing(), this.k.isFractionalMetrics());
        }
        return this.g;
    }

    private final TextLayout f() {
        if (this.h == null) {
            this.h = new TextLayout("\u2026", this.k.getFont(), this.e());
        }
        return this.h;
    }

    private void g() {
        if (this.b) {
            return;
        }
        int n2 = 0;
        Object[] objectArray = IlvLayoutTextRenderer.a(this.k.getLabel(), this.k.a());
        String[] stringArray = (String[])objectArray[0];
        AttributedString[] attributedStringArray = (AttributedString[])objectArray[1];
        int n3 = stringArray.length;
        FontRenderContext fontRenderContext = this.e();
        Hashtable<TextAttribute, Serializable> hashtable = new Hashtable<TextAttribute, Serializable>();
        hashtable.put(TextAttribute.FONT, this.k.getFont());
        if (this.k.isStrikethrough()) {
            hashtable.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.k.isUnderline()) {
            hashtable.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        float f2 = this.k.getWrappingWidth();
        switch (this.k.getWrappingMode()) {
            case 1: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList2 = this.i != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string = stringArray[i2];
                    AttributedString attributedString = attributedStringArray[i2];
                    IlvLayoutTextRenderer.a(attributedString, hashtable);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), breakIterator, fontRenderContext);
                    int n4 = string.length();
                    int n5 = 0;
                    while (n5 < n4) {
                        TextLayout textLayout;
                        int n6;
                        int n7 = lineBreakMeasurer.nextOffset(f2, n4, true);
                        if (n7 == n5) {
                            n7 = n6 = breakIterator.following(n5);
                        }
                        n6 = n7;
                        while (--n6 > n5 && Character.isSpaceChar(string.charAt(n6))) {
                        }
                        if (arrayList2 != null) {
                            TextLayoutCreationInfo textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString.getIterator(null, n5, n6 + 1));
                            textLayout = textLayoutCreationInfo.a(fontRenderContext);
                            arrayList2.add(textLayoutCreationInfo);
                        } else {
                            textLayout = new TextLayout(attributedString.getIterator(null, n5, n6 + 1), fontRenderContext);
                        }
                        arrayList.add(textLayout);
                        arrayList3.add(new Integer(n2 + n5));
                        lineBreakMeasurer.setPosition(n7);
                        n5 = n7;
                    }
                    n2 += n4 + 1;
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                this.j = arrayList3.toArray(new Integer[this.e]);
                if (arrayList2 == null) break;
                this.i.a = arrayList2.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            case 2: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList4 = this.i != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                TextLayout textLayout = this.f();
                TextLayout textLayout2 = null;
                TextLayoutCreationInfo textLayoutCreationInfo = null;
                String string = null;
                AttributedString attributedString = null;
                float f3 = 0.0f;
                boolean bl = false;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n8;
                    TextMeasurer textMeasurer;
                    if (i3 > 0) {
                        f3 += textLayout2.getAscent();
                    }
                    String string2 = stringArray[i3];
                    AttributedString attributedString2 = attributedStringArray[i3];
                    IlvLayoutTextRenderer.a(attributedString2, hashtable);
                    if (arrayList4 != null) {
                        textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString2.getIterator());
                        textLayout2 = textLayoutCreationInfo.a(fontRenderContext);
                    } else {
                        textLayout2 = new TextLayout(attributedString2.getIterator(), fontRenderContext);
                    }
                    boolean bl2 = false;
                    if (textLayout2.getAdvance() > f2) {
                        bl2 = true;
                        textMeasurer = new TextMeasurer(attributedString2.getIterator(), fontRenderContext);
                        n8 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                        attributedString2 = n8 == -1 ? new AttributedString(" ") : IlvLayoutTextRenderer.a(string2, attributedString2, n8);
                        if (arrayList4 != null) {
                            textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString2.getIterator());
                            textLayout2 = textLayoutCreationInfo.a(fontRenderContext);
                        } else {
                            textLayout2 = new TextLayout(attributedString2.getIterator(), fontRenderContext);
                        }
                    }
                    if ((f3 += textLayout2.getDescent() + this.a(textLayout2)) < this.k.getWrappingHeight()) {
                        arrayList.add(textLayout2);
                        if (arrayList4 != null) {
                            arrayList4.add(textLayoutCreationInfo);
                        }
                    } else {
                        if (bl || string == null) break;
                        string2 = string;
                        attributedString2 = attributedString;
                        textMeasurer = new TextMeasurer(attributedString2.getIterator(), fontRenderContext);
                        n8 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                        attributedString2 = n8 == -1 ? new AttributedString(" ") : IlvLayoutTextRenderer.a(string2, attributedString2, n8);
                        if (arrayList4 != null) {
                            textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString2.getIterator());
                            textLayout2 = textLayoutCreationInfo.a(fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout2);
                            arrayList4.set(arrayList4.size() - 1, textLayoutCreationInfo);
                        } else {
                            textLayout2 = new TextLayout(attributedString2.getIterator(), fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout2);
                        }
                        bl = true;
                        break;
                    }
                    bl = bl2;
                    string = string2;
                    attributedString = attributedString2;
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                if (arrayList4 == null) break;
                this.i.a = arrayList4.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            case 3: {
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<TextLayoutCreationInfo> arrayList5 = this.i != null ? new ArrayList<TextLayoutCreationInfo>() : null;
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                TextLayout textLayout = this.f();
                TextLayout textLayout3 = null;
                TextLayoutCreationInfo textLayoutCreationInfo = null;
                String string = null;
                AttributedString attributedString = null;
                float f4 = 0.0f;
                boolean bl = false;
                block9: for (int i4 = 0; i4 < n3; ++i4) {
                    String string3 = stringArray[i4];
                    AttributedString attributedString3 = attributedStringArray[i4];
                    IlvLayoutTextRenderer.a(attributedString3, hashtable);
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString3.getIterator(), breakIterator, fontRenderContext);
                    int n9 = string3.length();
                    int n10 = 0;
                    int n11 = -1;
                    while (n10 < n9) {
                        int n12;
                        TextMeasurer textMeasurer;
                        int n13;
                        if (i4 > 0 || n11 != -1) {
                            f4 += textLayout3.getAscent();
                        }
                        if ((n13 = lineBreakMeasurer.nextOffset(f2, n9, true)) == n10) {
                            n13 = n11 = breakIterator.following(n10);
                        }
                        n11 = n13;
                        while (--n11 > n10 && Character.isSpaceChar(string3.charAt(n11))) {
                        }
                        String string4 = string3.substring(n10, n11 + 1);
                        AttributedString attributedString4 = new AttributedString(attributedString3.getIterator(null, n10, n11 + 1));
                        if (arrayList5 != null) {
                            textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString4.getIterator());
                            textLayout3 = textLayoutCreationInfo.a(fontRenderContext);
                        } else {
                            textLayout3 = new TextLayout(attributedString4.getIterator(), fontRenderContext);
                        }
                        boolean bl3 = false;
                        if (textLayout3.getAdvance() > f2) {
                            bl3 = true;
                            textMeasurer = new TextMeasurer(attributedString4.getIterator(), fontRenderContext);
                            n12 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                            attributedString4 = n12 == -1 ? new AttributedString(" ") : IlvLayoutTextRenderer.a(string4, attributedString4, n12);
                            if (arrayList5 != null) {
                                textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString4.getIterator());
                                textLayout3 = textLayoutCreationInfo.a(fontRenderContext);
                            } else {
                                textLayout3 = new TextLayout(attributedString4.getIterator(), fontRenderContext);
                            }
                        }
                        if ((f4 += textLayout3.getDescent() + this.a(textLayout3)) < this.k.getWrappingHeight()) {
                            arrayList.add(textLayout3);
                            if (arrayList5 != null) {
                                arrayList5.add(textLayoutCreationInfo);
                            }
                            bl = bl3;
                            string = string4;
                            attributedString = attributedString4;
                            lineBreakMeasurer.setPosition(n13);
                            n10 = n13;
                            continue;
                        }
                        i4 = n3;
                        if (bl || string == null) continue block9;
                        string3 = string;
                        attributedString3 = attributedString;
                        textMeasurer = new TextMeasurer(attributedString3.getIterator(), fontRenderContext);
                        n12 = textMeasurer.getLineBreakIndex(0, f2 - textLayout.getAdvance());
                        attributedString3 = n12 == -1 ? new AttributedString(" ") : IlvLayoutTextRenderer.a(string3, attributedString3, n12);
                        if (arrayList5 != null) {
                            textLayoutCreationInfo = new TextLayoutCreationInfo(attributedString3.getIterator());
                            textLayout3 = textLayoutCreationInfo.a(fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout3);
                            arrayList5.set(arrayList5.size() - 1, textLayoutCreationInfo);
                        } else {
                            textLayout3 = new TextLayout(attributedString3.getIterator(), fontRenderContext);
                            arrayList.set(arrayList.size() - 1, textLayout3);
                        }
                        bl = true;
                        continue block9;
                    }
                }
                this.e = arrayList.size();
                this.f = arrayList.toArray(new TextLayout[this.e]);
                if (arrayList5 == null) break;
                this.i.a = arrayList5.toArray(new TextLayoutCreationInfo[this.e]);
                break;
            }
            default: {
                this.e = stringArray.length;
                this.f = new TextLayout[n3];
                this.j = new Integer[n3];
                if (this.i != null) {
                    this.i.a = new TextLayoutCreationInfo[n3];
                }
                for (int i5 = 0; i5 < n3; ++i5) {
                    String string = stringArray[i5];
                    AttributedString attributedString = attributedStringArray[i5];
                    IlvLayoutTextRenderer.a(attributedString, hashtable);
                    if (string.length() > 0) {
                        if (this.i != null) {
                            this.i.a[i5] = new TextLayoutCreationInfo(attributedString.getIterator());
                        }
                        this.f[i5] = new TextLayout(attributedString.getIterator(), fontRenderContext);
                    } else {
                        if (this.i != null) {
                            this.i.a[i5] = null;
                        }
                        this.f[i5] = null;
                    }
                    this.j[i5] = new Integer(n2);
                    n2 += string.length() + 1;
                }
            }
        }
        this.b = true;
        this.a = false;
    }

    private static void a(AttributedString attributedString, Map map) {
        if (map == null || attributedString == null || map.size() == 0) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        Hashtable[] hashtableArray = new Hashtable[n3];
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
            Object v2 = entry.getValue();
            for (n2 = attributedCharacterIterator.getBeginIndex(); n2 < n3; ++n2) {
                attributedCharacterIterator.setIndex(n2);
                Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
                if (map2 != null && map2.get(attribute) != null) continue;
                if (hashtableArray[n2] == null) {
                    hashtableArray[n2] = new Hashtable();
                }
                hashtableArray[n2].put(attribute, v2);
            }
        }
        for (n2 = attributedCharacterIterator.getBeginIndex(); n2 < n3; ++n2) {
            if (hashtableArray[n2] == null) continue;
            attributedString.addAttributes(hashtableArray[n2], n2, n2 + 1);
        }
    }

    private static AttributedString a(String string, AttributedString attributedString, int n2) {
        if (n2 > 0) {
            return IlvAttributedStringUtil.concat(IlvAttributedStringUtil.substring(attributedString, 0, n2), "\u2026");
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        attributedCharacterIterator.first();
        return new AttributedString("\u2026", attributedCharacterIterator.getAttributes());
    }

    private static Object[] a(String string, AttributedString attributedString) {
        int n2;
        int n3 = string.length();
        int n4 = 1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (string.charAt(n2) != '\n') continue;
            ++n4;
        }
        String[] stringArray = new String[n4];
        AttributedString[] attributedStringArray = new AttributedString[n4];
        if (n4 == 1) {
            if (string.length() == 0) {
                stringArray[0] = " ";
                attributedStringArray[0] = new AttributedString(" ");
            } else {
                stringArray[0] = string;
                attributedStringArray[0] = attributedString == null ? new AttributedString(stringArray[0]) : new AttributedString(attributedString.getIterator());
            }
        } else {
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = string.indexOf(10, n5);
                if (n6 == -1) {
                    n6 = n3;
                }
                if (n6 == n5) {
                    stringArray[n2] = " ";
                    attributedStringArray[n2] = new AttributedString(" ");
                } else {
                    stringArray[n2] = string.substring(n5, n6);
                    attributedStringArray[n2] = attributedString == null ? new AttributedString(stringArray[n2]) : new AttributedString(attributedString.getIterator(), n5, n6);
                }
                n5 = n6 + 1;
            }
        }
        return new Object[]{stringArray, attributedStringArray};
    }

    private float a(TextLayout textLayout) {
        if (this.k.getInterlineSpacing() != -1.0f) {
            return this.k.getInterlineSpacing();
        }
        return textLayout.getLeading();
    }

    public void invalidate(boolean bl) {
        this.b = false;
        this.a = false;
        if (bl) {
            this.h = null;
            this.g = null;
        }
        this.h();
    }

    private TextLayout[] a(FontRenderContext fontRenderContext) {
        InfoForFRCDependentTreatment infoForFRCDependentTreatment = this.i;
        if (fontRenderContext.equals(infoForFRCDependentTreatment.b[0])) {
            infoForFRCDependentTreatment.d = true;
            return infoForFRCDependentTreatment.c[0];
        }
        if (fontRenderContext.equals(infoForFRCDependentTreatment.b[1])) {
            infoForFRCDependentTreatment.d = false;
            return infoForFRCDependentTreatment.c[1];
        }
        int n2 = infoForFRCDependentTreatment.d ? 1 : 0;
        infoForFRCDependentTreatment.b[n2] = fontRenderContext;
        TextLayout[] textLayoutArray = new TextLayout[infoForFRCDependentTreatment.a.length];
        for (int i2 = 0; i2 < textLayoutArray.length; ++i2) {
            if (infoForFRCDependentTreatment.a[i2] == null) continue;
            textLayoutArray[i2] = infoForFRCDependentTreatment.a[i2].a(fontRenderContext);
        }
        infoForFRCDependentTreatment.c[n2] = textLayoutArray;
        return textLayoutArray;
    }

    private void h() {
        InfoForFRCDependentTreatment infoForFRCDependentTreatment = this.i;
        if (infoForFRCDependentTreatment == null) {
            return;
        }
        infoForFRCDependentTreatment.b[1] = null;
        infoForFRCDependentTreatment.b[0] = null;
    }

    static class TextLayoutCreationInfo {
        private String a;
        private Map b;
        private AttributedString c;

        TextLayoutCreationInfo(String string, Map map) {
            this.a = string;
            this.b = map;
            this.c = null;
        }

        TextLayoutCreationInfo(AttributedCharacterIterator attributedCharacterIterator) {
            this.a = null;
            this.b = null;
            this.c = new AttributedString(attributedCharacterIterator);
        }

        TextLayout a(FontRenderContext fontRenderContext) {
            if (this.a != null) {
                return new TextLayout(this.a, this.b, fontRenderContext);
            }
            return new TextLayout(this.c.getIterator(), fontRenderContext);
        }
    }

    static class InfoForFRCDependentTreatment {
        transient TextLayoutCreationInfo[] a;
        transient FontRenderContext[] b = new FontRenderContext[2];
        transient TextLayout[][] c = new TextLayout[2][];
        transient boolean d;

        InfoForFRCDependentTreatment() {
        }
    }
}

