/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.layout;

import ilog.views.IlvRect;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IlvStackerLayout
implements IlvLayoutManager {
    private int a = 3;
    private int b = 4;
    private int c = 0;
    private LinkedList d = new LinkedList();

    public IlvStackerLayout() {
    }

    public IlvStackerLayout(int n2, int n3, int n4) {
        this.setSpacing(n4);
        this.setOrientation(n2);
        this.setAlignment(n3);
        this.checkValues();
    }

    public IlvStackerLayout(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.setAlignment(ilvInputStream.readInt("alignment"));
        this.setOrientation(ilvInputStream.readInt("orientation"));
        this.setSpacing(ilvInputStream.readInt("spacing"));
    }

    protected void checkValues() {
        if (this.b == 4 || this.b == 2) {
            if (this.c != 1 && this.c != 3 && this.c != 0) {
                this.c = 0;
            }
        } else if (this.b == 1 || this.b == 3) {
            if (this.c != 2 && this.c != 4 && this.c != 0) {
                this.c = 0;
            }
        } else {
            this.b = 4;
            this.c = 0;
        }
    }

    public void setOrientation(int n2) {
        this.b = n2;
    }

    public int getOrientation() {
        return this.b;
    }

    public void setAlignment(int n2) {
        this.c = n2;
    }

    public int getAlignment() {
        return this.c;
    }

    public void setSpacing(int n2) {
        this.a = n2;
    }

    public int getSpacing() {
        return this.a;
    }

    public void setConstraints(IlvAttachable ilvAttachable, Object object) {
        this.d.add(ilvAttachable);
    }

    public void removeConstraints(IlvAttachable ilvAttachable) {
        this.d.remove(ilvAttachable);
    }

    public void layoutGroup(IlvAttachable ilvAttachable) {
        this.computeChildrenAttachmentCoordinates(ilvAttachable);
    }

    public void attach(IlvAttachable ilvAttachable) {
        if (this.d.size() > 0) {
            return;
        }
        IlvAttachable[] ilvAttachableArray = ilvAttachable.getAttachables();
        for (int i2 = 0; i2 < ilvAttachableArray.length; ++i2) {
            if (ilvAttachableArray[i2] == null) continue;
            this.setConstraints(ilvAttachableArray[i2], null);
        }
    }

    protected void computeChildrenAttachmentCoordinates(IlvAttachable ilvAttachable) {
        block6: {
            float f2;
            float f3;
            float f4;
            Iterator iterator;
            block7: {
                iterator = this.a().iterator();
                IlvRect ilvRect = ilvAttachable.getAttachmentBounds();
                if (!iterator.hasNext()) break block6;
                f4 = ilvRect.width;
                float f5 = ilvRect.height;
                f3 = this.b == 2 ? ilvRect.x + f4 : ilvRect.x;
                float f6 = f2 = this.b == 1 ? ilvRect.y + f5 : ilvRect.y;
                if (this.b != 4 && this.b != 2) break block7;
                while (iterator.hasNext()) {
                    IlvAttachable ilvAttachable2 = (IlvAttachable)iterator.next();
                    IlvRect ilvRect2 = ilvAttachable2.getAttachmentBounds();
                    float f7 = this.c == 3 ? f2 + f5 - ilvRect2.height : (ilvRect2.y = this.c == 0 ? f2 + 0.5f * f5 - 0.5f * ilvRect2.height : f2);
                    if (this.b == 4) {
                        ilvRect2.x = f3;
                        f3 = f3 + ilvRect2.width + (float)this.a;
                    } else {
                        ilvRect2.x = f3 -= ilvRect2.width;
                        f3 -= (float)this.a;
                    }
                    ilvAttachable2.move(ilvRect2.x, ilvRect2.y);
                }
                break block6;
            }
            if (this.b != 1 && this.b != 3) break block6;
            while (iterator.hasNext()) {
                IlvAttachable ilvAttachable3 = (IlvAttachable)iterator.next();
                IlvRect ilvRect = ilvAttachable3.getAttachmentBounds();
                float f8 = this.c == 4 ? f3 + f4 - ilvRect.width : (ilvRect.x = this.c == 0 ? f3 + 0.5f * f4 - 0.5f * ilvRect.width : f3);
                if (this.b == 3) {
                    ilvRect.y = f2;
                    f2 = f2 + ilvRect.height + (float)this.a;
                } else {
                    ilvRect.y = f2 -= ilvRect.height;
                    f2 -= (float)this.a;
                }
                ilvAttachable3.move(ilvRect.x, ilvRect.y);
            }
        }
    }

    private List a() {
        LinkedList<IlvAttachable> linkedList = new LinkedList<IlvAttachable>();
        Iterator iterator = this.d.iterator();
        while (iterator.hasNext()) {
            IlvAttachable ilvAttachable = (IlvAttachable)iterator.next();
            if (!ilvAttachable.isVisible()) continue;
            linkedList.add(ilvAttachable);
        }
        return linkedList;
    }

    public void reset() {
        this.d = new LinkedList();
    }

    public Object clone() {
        try {
            IlvStackerLayout ilvStackerLayout = (IlvStackerLayout)super.clone();
            ilvStackerLayout.reset();
            return ilvStackerLayout;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
    }

    public boolean resizeFirstChildOnly() {
        return false;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("alignment", this.getAlignment());
        ilvOutputStream.write("orientation", this.getOrientation());
        ilvOutputStream.write("spacing", this.getSpacing());
    }
}

