/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.objectinteractor;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvReshapeSelection;
import ilog.views.IlvTextInterface;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvTextSelection;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;

public class IlvTextEditor
extends IlvReshapeSelection
implements ClipboardOwner {
    public static boolean EnableEditing = true;
    private transient int a = 0;
    transient int b = 0;
    transient int c = 0;
    private static LabelSetter d = new LabelSetter();

    public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
        if (!(ilvGraphic instanceof IlvTextSelection)) {
            return false;
        }
        IlvTextSelection ilvTextSelection = (IlvTextSelection)ilvGraphic;
        if (ilvTextSelection.supportsResize() && super.processEvent(ilvGraphic, aWTEvent, ilvObjectInteractorContext)) {
            return true;
        }
        if (!(ilvTextSelection.getObject() instanceof IlvTextInterface)) {
            return false;
        }
        IlvTextInterface ilvTextInterface = (IlvTextInterface)((Object)ilvTextSelection.getObject());
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            IlvTransformer ilvTransformer = ilvObjectInteractorContext.getTransformer();
            IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.getID() == 503) {
                Cursor cursor = null;
                if (ilvTextSelection.isOnBorder(ilvPoint, ilvTransformer)) {
                    int n2 = 0;
                    if (ilvTextSelection.supportsResize()) {
                        n2 = ilvTextSelection.direction(ilvPoint, ilvTransformer);
                    }
                    cursor = n2 != 0 ? this.getCursor(n2) : Cursor.getPredefinedCursor(13);
                } else {
                    cursor = !ilvTextSelection.isEditable() || !EnableEditing ? Cursor.getPredefinedCursor(13) : Cursor.getPredefinedCursor(2);
                }
                if (cursor != null && cursor != ilvObjectInteractorContext.getCursor()) {
                    ilvObjectInteractorContext.setCursor(cursor);
                }
            }
            if (ilvTextSelection.isOnBorder(ilvPoint, ilvTransformer)) {
                return false;
            }
            if (!ilvTextSelection.isEditable() || !EnableEditing) {
                return false;
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    this.b = ilvTextInterface.pickCharacter(ilvPoint, ilvTransformer);
                    this.a(this.a(aWTEvent));
                    this.a(ilvTextInterface, this.b);
                    this.a(ilvTextSelection);
                    this.b(ilvTextSelection);
                    return true;
                }
                case 506: {
                    this.b = ilvTextInterface.pickCharacter(ilvPoint, ilvTransformer);
                    this.a(ilvTextInterface, this.b);
                    this.a(ilvTextSelection);
                    this.b(ilvTextSelection);
                    return true;
                }
            }
            return false;
        }
        if (aWTEvent instanceof KeyEvent) {
            boolean bl = false;
            if (!ilvTextSelection.isEditable()) {
                return false;
            }
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            switch (keyEvent.getID()) {
                case 400: {
                    bl = this.b(keyEvent, ilvTextSelection, ilvTextInterface);
                    break;
                }
                case 401: {
                    bl = this.a(keyEvent, ilvTextSelection, ilvTextInterface);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (bl) {
                ((KeyEvent)aWTEvent).consume();
            }
            return bl;
        }
        return false;
    }

    private void a(boolean bl) {
        if (!bl) {
            this.a = this.b;
        }
    }

    private boolean a(KeyEvent keyEvent, IlvTextSelection ilvTextSelection, IlvTextInterface ilvTextInterface) {
        String string = ilvTextInterface.getLabel();
        IlvTextSelection.Range range = ilvTextSelection.getRange();
        if (range.isEmpty()) {
            return false;
        }
        int n2 = keyEvent.getKeyCode();
        if (keyEvent.getModifiers() == 2) {
            switch (n2) {
                case 67: {
                    if (range.isCollapsed()) {
                        return true;
                    }
                    String string2 = string.substring(range.from, range.to);
                    this.a(string2);
                    return true;
                }
                case 86: {
                    String string3 = this.a();
                    if (string3 == null || string3.length() == 0) {
                        return true;
                    }
                    IlvTextSelection.Range range2 = new IlvTextSelection.Range(range.from, range.to);
                    this.b = range.from + string3.length();
                    this.a(false);
                    this.a(ilvTextInterface, this.b);
                    this.a(ilvTextSelection);
                    this.replaceSelection(ilvTextInterface, range2.from, range2.to, string3);
                    return true;
                }
            }
        }
        switch (n2) {
            case 37: {
                this.a(ilvTextInterface);
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 39: {
                this.b(ilvTextInterface);
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 38: {
                this.d(ilvTextInterface);
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 40: {
                this.c(ilvTextInterface);
                this.a(this.a(keyEvent));
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.b(ilvTextSelection);
                return true;
            }
            case 127: {
                if (string.length() == 0) {
                    return true;
                }
                if (range.isCollapsed() && range.from == string.length()) {
                    return true;
                }
                int n3 = range.from;
                int n4 = range.to;
                if (range.isCollapsed()) {
                    ++n4;
                } else {
                    this.b = range.from;
                    this.a(false);
                    this.a(ilvTextInterface, this.b);
                    this.a(ilvTextSelection);
                }
                this.deleteSelection(ilvTextInterface, n3, n4);
                keyEvent.consume();
                return true;
            }
        }
        return true;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    String a() {
        boolean bl;
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println(unsupportedFlavorException);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        return string;
    }

    void a(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private boolean b(KeyEvent keyEvent, IlvTextSelection ilvTextSelection, IlvTextInterface ilvTextInterface) {
        String string = ilvTextInterface.getLabel();
        IlvTextSelection.Range range = ilvTextSelection.getRange();
        if (range.isEmpty()) {
            return false;
        }
        if (keyEvent.getModifiers() == 2) {
            return false;
        }
        char c2 = keyEvent.getKeyChar();
        switch (c2) {
            case '\u001b': 
            case '\uffff': {
                return false;
            }
            case '\u007f': {
                return true;
            }
            case '\b': {
                if (string.length() == 0) {
                    return true;
                }
                if (range.isCollapsed() && range.from == 0) {
                    return true;
                }
                int n2 = range.from;
                int n3 = range.to;
                if (range.isCollapsed()) {
                    --n2;
                    this.b = Math.max(0, range.from - 1);
                } else {
                    this.b = range.from;
                }
                this.a(false);
                this.a(ilvTextInterface, this.b);
                this.a(ilvTextSelection);
                this.deleteSelection(ilvTextInterface, n2, n3);
                return true;
            }
        }
        int n4 = range.from;
        int n5 = range.to;
        this.b = range.from + 1;
        this.a(false);
        this.a(ilvTextInterface, this.b);
        this.a(ilvTextSelection);
        this.replaceSelection(ilvTextInterface, n4, n5, "" + c2);
        return true;
    }

    private boolean a(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent) {
            return ((InputEvent)aWTEvent).getModifiers() == 1;
        }
        return false;
    }

    private void a(IlvTextInterface ilvTextInterface, int n2) {
        int n3 = this.c(ilvTextInterface, n2);
        this.c = n2 - ilvTextInterface.lineOffset(n3);
    }

    private static int b(IlvTextInterface ilvTextInterface, int n2) {
        int n3 = ilvTextInterface.lineCount();
        if (n3 == 1 || n2 < 0 || n2 >= n3 - 1) {
            return ilvTextInterface.getLabel().length() - 1;
        }
        return ilvTextInterface.lineOffset(n2 + 1) - 1;
    }

    private void a(IlvTextSelection ilvTextSelection) {
        ilvTextSelection.setRange(new IlvTextSelection.Range(Math.min(this.a, this.b), Math.max(this.a, this.b)));
    }

    private void b(IlvTextSelection ilvTextSelection) {
        ilvTextSelection.reDraw();
    }

    private void a(IlvTextInterface ilvTextInterface) {
        this.b = Math.max(0, this.b - 1);
    }

    private void b(IlvTextInterface ilvTextInterface) {
        this.b = Math.min(ilvTextInterface.getLabel().length(), this.b + 1);
    }

    private void c(IlvTextInterface ilvTextInterface) {
        int n2 = this.c(ilvTextInterface, this.b);
        if (n2 == ilvTextInterface.lineCount() - 1) {
            return;
        }
        int n3 = n2 + 1;
        int n4 = ilvTextInterface.lineOffset(n3) + this.c;
        int n5 = IlvTextEditor.b(ilvTextInterface, n3);
        this.b = Math.min(n5, n4);
    }

    private void d(IlvTextInterface ilvTextInterface) {
        int n2 = this.c(ilvTextInterface, this.b);
        if (n2 == 0) {
            return;
        }
        int n3 = ilvTextInterface.lineOffset(n2 - 1) + this.c;
        this.b = Math.min(ilvTextInterface.lineOffset(n2) - 1, n3);
    }

    private int c(IlvTextInterface ilvTextInterface, int n2) {
        if (ilvTextInterface.lineCount() == 1) {
            return 0;
        }
        int n3 = ilvTextInterface.lineCount();
        int n4 = n3 - 1;
        if (n2 >= ilvTextInterface.lineOffset(n4)) {
            return n4;
        }
        for (int i2 = 1; i2 <= n4; ++i2) {
            if (n2 >= ilvTextInterface.lineOffset(i2)) continue;
            return i2 - 1;
        }
        return n4;
    }

    protected void deleteSelection(IlvTextInterface ilvTextInterface, int n2, int n3) {
        String string = ilvTextInterface.getLabel();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= string.length()) {
            return;
        }
        String string2 = n3 >= string.length() || n3 <= n2 ? string.substring(0, n2) : string.substring(0, n2) + string.substring(n3);
        this.a((IlvGraphic)((Object)ilvTextInterface), string2);
    }

    protected void replaceSelection(IlvTextInterface ilvTextInterface, int n2, int n3, String string) {
        String string2 = ilvTextInterface.getLabel();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > string2.length()) {
            n2 = string2.length();
        }
        String string3 = n3 >= string2.length() || n3 < n2 ? string2.substring(0, n2) + string : string2.substring(0, n2) + string + string2.substring(n3);
        this.a((IlvGraphic)((Object)ilvTextInterface), string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, String string) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic.getTopLevelGraphicBag();
        IlvManager ilvManager = null;
        if (ilvGraphicBag2 != ilvGraphicBag && ilvGraphicBag2 != null) {
            ilvManager = (IlvManager)ilvGraphicBag2;
            ilvManager.setContentsAdjusting(true);
        }
        try {
            ilvGraphicBag.applyToObject(ilvGraphic, d, string, true);
        }
        finally {
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false);
            }
        }
    }

    private static final class LabelSetter
    implements IlvApplyObject {
        public void apply(IlvGraphic ilvGraphic, Object object) {
            String string = (String)object;
            if (!(ilvGraphic instanceof IlvLabelInterface)) {
                throw new IllegalArgumentException("object must implement IlvLabelInterface");
            }
            ((IlvLabelInterface)((Object)ilvGraphic)).setLabel(string);
        }
    }
}

