/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes.beans;

import ilog.views.prototypes.beans.IntHashtableEntry;
import ilog.views.prototypes.beans.IntHashtableEnumerator;
import java.util.Dictionary;
import java.util.Enumeration;

class IntHashtable
extends Dictionary
implements Cloneable {
    private IntHashtableEntry[] a;
    private int b;
    private int c;
    private float d;

    public IntHashtable(int n2, float f2) {
        if (n2 <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.d = f2;
        this.a = new IntHashtableEntry[n2];
        this.c = (int)((float)n2 * f2);
    }

    public IntHashtable(int n2) {
        this(n2, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.b == 0;
    }

    public synchronized Enumeration keys() {
        return new IntHashtableEnumerator(this.a, true);
    }

    public synchronized Enumeration elements() {
        return new IntHashtableEnumerator(this.a, false);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n2 = intHashtableEntryArray.length;
        while (n2-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n2];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.c.equals(object)) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.d;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.a == n3 && intHashtableEntry.b == n2) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.d;
        }
        return false;
    }

    public synchronized Object get(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.a == n3 && intHashtableEntry.b == n2) {
                return intHashtableEntry.c;
            }
            intHashtableEntry = intHashtableEntry.d;
        }
        return null;
    }

    public Object get(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n2 = (Integer)object;
        int n3 = n2;
        return this.get(n3);
    }

    protected void rehash() {
        int n2 = this.a.length;
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n3 = n2 * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n3];
        this.c = (int)((float)n3 * this.d);
        this.a = intHashtableEntryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.d;
                int n5 = (intHashtableEntry2.a & Integer.MAX_VALUE) % n3;
                intHashtableEntry2.d = intHashtableEntryArray2[n5];
                intHashtableEntryArray2[n5] = intHashtableEntry2;
            }
        }
    }

    public synchronized Object put(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.a == n3 && intHashtableEntry.b == n2) {
                Object object2 = intHashtableEntry.c;
                intHashtableEntry.c = object;
                return object2;
            }
            intHashtableEntry = intHashtableEntry.d;
        }
        if (this.b >= this.c) {
            this.rehash();
            return this.put(n2, object);
        }
        intHashtableEntry = new IntHashtableEntry();
        intHashtableEntry.a = n3;
        intHashtableEntry.b = n2;
        intHashtableEntry.c = object;
        intHashtableEntry.d = intHashtableEntryArray[n4];
        intHashtableEntryArray[n4] = intHashtableEntry;
        ++this.b;
        return null;
    }

    public Object put(Object object, Object object2) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n2 = (Integer)object;
        int n3 = n2;
        return this.put(n3, object2);
    }

    public synchronized Object remove(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.a == n3 && intHashtableEntry.b == n2) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.d = intHashtableEntry.d;
                } else {
                    intHashtableEntryArray[n4] = intHashtableEntry.d;
                }
                --this.b;
                return intHashtableEntry.c;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.d;
        }
        return null;
    }

    public Object remove(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n2 = (Integer)object;
        int n3 = n2;
        return this.remove(n3);
    }

    public synchronized void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.a;
        int n2 = intHashtableEntryArray.length;
        while (--n2 >= 0) {
            intHashtableEntryArray[n2] = null;
        }
        this.b = 0;
    }

    public synchronized Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.a = new IntHashtableEntry[this.a.length];
            int n2 = this.a.length;
            while (n2-- > 0) {
                intHashtable.a[n2] = this.a[n2] != null ? (IntHashtableEntry)this.a[n2].clone() : null;
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

