/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.swing;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class IlvToolTipManager
implements SwingConstants {
    private IlvGraphic a;
    private IlvPoint b = new IlvPoint();
    private Adapter c = new Adapter();
    private static IlvToolTipManager d;

    private IlvToolTipManager() {
    }

    public static void registerView(IlvManagerView ilvManagerView) {
        if (d == null) {
            d = new IlvToolTipManager();
        }
        ilvManagerView.addMouseListener(IlvToolTipManager.d.c);
        ilvManagerView.addMouseMotionListener(IlvToolTipManager.d.c);
    }

    public static void unregisterView(IlvManagerView ilvManagerView) {
        if (d != null) {
            ilvManagerView.removeMouseMotionListener(IlvToolTipManager.d.c);
            ilvManagerView.removeMouseListener(IlvToolTipManager.d.c);
        }
    }

    public static String createMultiLineToolTipText(String[] stringArray, int n2) {
        String string;
        switch (n2) {
            case 2: {
                string = "left";
                break;
            }
            case 4: {
                string = "right";
                break;
            }
            case 0: {
                string = "center";
                break;
            }
            default: {
                throw new IllegalArgumentException("Alignment must be LEFT, RIGHT, or CENTER");
            }
        }
        Font font = UIManager.getFont("ToolTip.font");
        StringBuffer stringBuffer = new StringBuffer("<p align=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" style=\"font-family:");
        stringBuffer.append(font.getName());
        stringBuffer.append(";font-size:");
        stringBuffer.append(font.getSize());
        stringBuffer.append("pt\">");
        String string2 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer("<html>");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer2.append(string2);
            stringBuffer2.append(stringArray[i2]);
            stringBuffer2.append("</p>");
        }
        stringBuffer2.append("</html>");
        return stringBuffer2.toString();
    }

    public static ToolTipManager getToolTipManager() {
        return ToolTipManager.sharedInstance();
    }

    private class Adapter
    extends MouseAdapter
    implements MouseMotionListener {
        private Adapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            String string;
            Cloneable cloneable;
            Object object = mouseEvent.getSource();
            if (!(object instanceof IlvManagerView)) {
                return;
            }
            IlvManagerView ilvManagerView = (IlvManagerView)object;
            if (!(ilvManagerView.getParent() instanceof JComponent)) {
                return;
            }
            IlvToolTipManager.this.b.move(mouseEvent.getX(), mouseEvent.getY());
            IlvGraphic ilvGraphic = ilvManagerView.getManager().getObject(IlvToolTipManager.this.b, ilvManagerView, true);
            JComponent jComponent = (JComponent)ilvManagerView.getParent();
            if (ilvGraphic != null) {
                cloneable = ilvManagerView.getTransformer();
                IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
                if (ilvGraphicBag instanceof IlvManager) {
                    cloneable = ((IlvManager)ilvGraphicBag).getDrawingTransformer(ilvManagerView);
                }
                string = ilvGraphic.getToolTipText(IlvToolTipManager.this.b, (IlvTransformer)cloneable);
            } else {
                string = null;
            }
            cloneable = ilvManagerView.getLocation();
            int n2 = mouseEvent.getX() + ((Point)cloneable).x;
            int n3 = mouseEvent.getY() + ((Point)cloneable).y;
            jComponent.setToolTipText(string);
            if (ilvGraphic != null) {
                MouseEvent mouseEvent2;
                if (ilvGraphic != IlvToolTipManager.this.a) {
                    if (IlvToolTipManager.this.a != null) {
                        mouseEvent2 = new MouseEvent(jComponent, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        ToolTipManager.sharedInstance().mouseExited(mouseEvent2);
                    }
                    mouseEvent2 = new MouseEvent(jComponent, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    ToolTipManager.sharedInstance().mouseEntered(mouseEvent2);
                }
                mouseEvent2 = new MouseEvent(jComponent, 503, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                ToolTipManager.sharedInstance().mouseMoved(mouseEvent2);
            } else if (IlvToolTipManager.this.a != null) {
                MouseEvent mouseEvent3 = new MouseEvent(jComponent, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                ToolTipManager.sharedInstance().mouseExited(mouseEvent3);
            }
            IlvToolTipManager.this.a = ilvGraphic;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (IlvToolTipManager.this.a == null || !(object instanceof IlvManagerView)) {
                return;
            }
            IlvManagerView ilvManagerView = (IlvManagerView)object;
            if (!(ilvManagerView.getParent() instanceof JComponent)) {
                return;
            }
            JComponent jComponent = (JComponent)ilvManagerView.getParent();
            Point point = ilvManagerView.getLocation();
            MouseEvent mouseEvent2 = new MouseEvent(jComponent, 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            ToolTipManager.sharedInstance().mousePressed(mouseEvent2);
            IlvToolTipManager.this.a = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (IlvToolTipManager.this.a == null || !(object instanceof IlvManagerView)) {
                return;
            }
            IlvManagerView ilvManagerView = (IlvManagerView)object;
            if (!(ilvManagerView.getParent() instanceof JComponent)) {
                return;
            }
            JComponent jComponent = (JComponent)ilvManagerView.getParent();
            Point point = ilvManagerView.getLocation();
            MouseEvent mouseEvent2 = new MouseEvent(jComponent, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() + point.x, mouseEvent.getY() + point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            ToolTipManager.sharedInstance().mouseExited(mouseEvent2);
            IlvToolTipManager.this.a = null;
            jComponent.setToolTipText(null);
        }
    }
}

