/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleModelImpl;
import ilog.views.css.model.IlvRuleUtils;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.model.IlvSelectorImpl;
import ilog.views.css.model.event.CSSChangeEvent;
import ilog.views.css.model.event.CSSChangeListener;
import ilog.views.css.model.internal.IlvCSSWriter;
import ilog.views.css.selector.IlvSelectorContext;
import ilog.views.event.IlvListenerList;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.IlvEventMap;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvCenteredLayout;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.symbology.IlvSymbolDescriptor;
import ilog.views.symbology.editor.IlvSymbolSelectorContext;
import ilog.views.symbology.editor.action.IlvSymbolEditorAction;
import ilog.views.symbology.editor.event.ParameterListChangedEvent;
import ilog.views.symbology.editor.event.ParameterListChangedListener;
import ilog.views.symbology.editor.event.ParameterValueChangedEvent;
import ilog.views.symbology.editor.event.ParameterValueChangedListener;
import ilog.views.symbology.editor.event.SelectionChangedEvent;
import ilog.views.symbology.editor.event.SelectionChangedListener;
import ilog.views.symbology.editor.event.SymbolChangedEvent;
import ilog.views.symbology.editor.event.SymbolChangedListener;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.rules.IlvSymbolRuleModel;
import ilog.views.symbology.editor.rules.IlvSymbolRuleStrategy;
import ilog.views.symbology.editor.tree.IlvSymbolTreeRoot;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteBaseObject;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.beans.IlvConvertForSetters;
import ilog.views.util.beans.IlvPropertyEditorManager;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.css.IlvCSSBeans;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.IlvCSSEngine;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.Util;
import ilog.views.util.css.parser.Attribute;
import ilog.views.util.css.parser.Declaration;
import ilog.views.util.image.PNGImageEncoder;
import ilog.views.util.styling.IlvCSSAttributeSelector;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSFunction;
import ilog.views.util.styling.IlvStylingException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class IlvSymbolEditorDocument {
    public static boolean invisibleGhosts = false;
    private IlvPaletteSymbol a;
    private IlvPaletteSymbol b;
    private IlvSymbolRuleModel c;
    private String d;
    private IlvPaletteManager e;
    private IlvRule f;
    private IlvGraphic g;
    private boolean h;
    private IlvManager i;
    private static HashMap j = new HashMap();
    private ArrayList k = new ArrayList();
    private IlvListenerList l = new IlvListenerList();
    private IlvListenerList m = new IlvListenerList();
    private IlvListenerList n = new IlvListenerList();
    private IlvListenerList o = new IlvListenerList();
    private SymbolCSSModel p;
    private ConditionEditor q;
    private ResourceBundle r = ResourceBundle.getBundle("ilog.views.symbology.editor.symboleditor");
    private IlvPoint s;
    private IlvRect t;
    private boolean u;
    private boolean v = false;
    private CSSHook w;
    private int x;
    private static final String y = "auto_icon_";
    public static final String designModePseudoClass = "design";
    public static final String[] designModePseudoClasses = new String[]{"design"};
    private String[] z = null;
    public static boolean confirmRuleUpdateWhenParameterRenamed = true;
    public static boolean confirmRuleUpdateWhenParameterDeleted = true;
    public static final String FrameworkComponentType = "Framework";
    public static final String DiagrammerComponentType = "Diagrammer";
    public static final String GanttComponentType = "Gantt";
    public static final String invisibleProperty = "invisible";
    public static final String unrealizedProperty = "unrealized";
    private UndoManager aa;
    private SymbolCompoundEdit ab;
    private int ac;
    private int ad;
    private boolean ae;
    private static final boolean af = false;
    static /* synthetic */ Class ah;
    static /* synthetic */ Class ai;
    static /* synthetic */ Class aj;

    public IlvSymbolEditorDocument(IlvPaletteSymbol ilvPaletteSymbol, String string, IlvPaletteManager ilvPaletteManager, ConditionEditor conditionEditor, UndoManager undoManager) throws IlvStylingException {
        this.a = (IlvPaletteSymbol)ilvPaletteSymbol.copy();
        this.b = ilvPaletteSymbol.getPalette() != null ? ilvPaletteSymbol : null;
        this.q = conditionEditor;
        this.aa = undoManager;
        this.w = new CSSHook();
        this.setComponentType(string);
        this.e = ilvPaletteManager;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        if (invisibleGhosts) {
            ilvSymbolRuleModel.getCSSBeans().registerFunction(new VisibleFunction());
            this.z = designModePseudoClasses;
        }
        if (ilvPaletteManager != null) {
            ilvPaletteManager.attach(((IlvSymbolRuleStrategy)ilvSymbolRuleModel.getCSSStrategy()).getCSSCompatible());
        }
        this.getRuleModel().getCSSBeans().setStyleSheet(ilvPaletteSymbol.getCSSURL().toExternalForm());
        IlvCSSEngine ilvCSSEngine = this.getRuleModel().getCSSBeans().getCSSengine();
        ilvCSSEngine.setAttributeHandler(new SymbolAttributeHandler(ilvCSSEngine.getAttributeHandler()));
        this.f = this.getRuleModel().getRule(this.a.getClassName(), false);
        this.i = this.createManager();
        this.i.setInsertionLayer(1);
        if (invisibleGhosts) {
            this.i.addLayer(new SymbolEditorLayer(), this.i.getInsertionLayer());
        }
        this.p = new SymbolCSSModel();
        if (!invisibleGhosts) {
            int n2;
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
            IlvRule[] ilvRuleArray = ilvSymbolRuleModel.getAllRules(true);
            for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
                String string2;
                IlvRule ilvRule = ilvRuleArray[n2];
                String[] stringArray = ilvRule.getPseudoClasses();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!stringArray[i2].equals(designModePseudoClass)) continue;
                    arrayList.add(ilvRule);
                    break;
                }
                if ((string2 = ilvRule.getDeclarationValue("class")) == null || string2.length() != 0) continue;
                try {
                    if (SymbolEditorUtilities.hasCondition(ilvRule)) {
                        ilvRule.removeDeclaration("class");
                    } else {
                        IlvRule ilvRule2 = ilvRule.createSameRule();
                        ilvRule2.getSelector().setPseudoClasses(designModePseudoClasses);
                        ilvRule2.updateRule();
                        ilvRule2.updateWeights();
                        ilvRule2 = ilvSymbolRuleModel.getRule(ilvRule2.getSelectorString(), false);
                        string2 = ilvRule2.getDeclarationValue("class");
                        ilvRule.setDeclarationValue("class", string2);
                    }
                    ilvRule.setDeclaration("visible", "false");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ilvSymbolRuleModel.removeRule((IlvRule)arrayList.get(n2));
            }
        }
        this.c();
        this.i.addObject(this.getToplevelGraphic(), true);
        this.getRuleModel().addStyleChangeListener(new CSSChangeListener(){

            public void styleChange(CSSChangeEvent cSSChangeEvent) {
                if (cSSChangeEvent.isAdjusting()) {
                    IlvSymbolEditorDocument.this.h = false;
                } else {
                    IlvSymbolEditorDocument.this.applyChanges();
                }
                IlvSymbolEditorDocument.this.a(cSSChangeEvent);
            }
        });
        this.addSymbolChangedListener(new SymbolChangedListener(){

            public void symbolChanged(SymbolChangedEvent symbolChangedEvent) {
                if (symbolChangedEvent.getChangedObject() instanceof IlvPaletteSymbolParameter) {
                    if ("name".equals(symbolChangedEvent.getProperty())) {
                        IlvSymbolEditorDocument.this.a((String)symbolChangedEvent.getOldValue(), (String)symbolChangedEvent.getNewValue());
                    } else if ("value".equals(symbolChangedEvent.getProperty()) || "type".equals(symbolChangedEvent.getProperty()) || "valueSet".equals(symbolChangedEvent.getProperty())) {
                        IlvSymbolEditorDocument.this.applyChanges();
                    }
                }
                IlvSymbolEditorDocument.this.a(symbolChangedEvent);
                IlvSymbolEditorAction.updateActions(IlvSymbolEditorDocument.this);
            }
        });
        this.i.addManagerContentChangedListener(new ManagerContentChangedListener(){

            public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
                if (managerContentChangedEvent.getType() == 1) {
                    final IlvGraphic ilvGraphic = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            IlvSymbolEditorDocument.this.i.removeObject(ilvGraphic, true);
                        }
                    });
                    IlvSymbolEditorDocument.this.addGraphic(ilvGraphic, true, null);
                }
            }
        });
    }

    public IlvManager createManager() {
        return new IlvManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IlvPaletteSymbol ilvPaletteSymbol, IlvPaletteManager ilvPaletteManager, IlvPalette ilvPalette, URL uRL) throws IOException {
        File file = null;
        File file2 = null;
        File file3 = null;
        PrintWriter printWriter = null;
        try {
            ilvPaletteSymbol.removeAllResources();
            file = File.createTempFile("tmp", ".txt");
            file2 = new File(file.getParentFile(), ilvPaletteSymbol.getName() + ".css");
            file.delete();
            file = null;
            URL uRL2 = file2.toURL();
            printWriter = Util.makeUTF8Writer(new FileOutputStream(file2));
            IlvCSSDocument ilvCSSDocument = new IlvCSSDocument(uRL2, new URL[]{uRL2});
            IlvRule[] ilvRuleArray = this.c.getAllRules(true);
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                IlvRule ilvRule = ilvRuleArray[i2];
                IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
                if (ilvCSSDeclarationArray != null) {
                    for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                        URL uRL3;
                        IlvCSSDeclaration ilvCSSDeclaration = ilvCSSDeclarationArray[i3];
                        String string = ilvCSSDeclaration.getValue();
                        if (string.startsWith("../resources/")) {
                            ilvPaletteSymbol.addResource(string);
                            continue;
                        }
                        if (string.startsWith("palettejar:file:") || string.startsWith("jar:file")) {
                            try {
                                uRL3 = new URL(string);
                                ilvPaletteSymbol.addResource(uRL3);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (!string.startsWith("file:")) continue;
                        try {
                            uRL3 = new URL(string);
                            File file4 = new File(uRL3.getFile());
                            if (!file4.isAbsolute() || !file4.exists()) continue;
                            ilvRule = ilvRule.copy();
                            String string2 = "url(" + string + ")";
                            ilvRule.setDeclarationValue(ilvCSSDeclaration.getProperty(), string2);
                            ilvPaletteSymbol.addResource(uRL3);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ilvRule.printCSS(printWriter, ilvCSSDocument);
            }
            printWriter.flush();
            ilvPaletteSymbol.setCSSURL(uRL2);
            file3 = this.setAutomaticIcon(ilvPaletteSymbol);
            ilvPaletteManager.save(ilvPalette, new File(uRL.getFile()), false, true);
            this.a(ilvPaletteManager.getWorkingDirectory());
            this.b = ilvPaletteSymbol;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (file != null) {
                file.delete();
            }
            if (file2 != null) {
                file2.delete();
            }
            if (file3 != null) {
                file3.delete();
            }
        }
    }

    public IlvPaletteSymbol getSymbol() {
        return this.a;
    }

    public IlvSymbolRuleModel getRuleModel() {
        if (this.c == null) {
            if (this.d == null) {
                throw new RuntimeException("Component type not set, cannot create rule model.");
            }
            this.c = this.b(this.d);
        }
        return this.c;
    }

    public String getComponentType() {
        return this.d;
    }

    public void setComponentType(String string) {
        this.d = string;
        this.c = null;
    }

    public IlvGraphic getToplevelGraphic() {
        return this.g;
    }

    public IlvManager getManager() {
        return this.i;
    }

    public IlvRule getToplevelRule() {
        return this.f;
    }

    public IlvSelectorContext getSelectorContext() {
        return new IlvSymbolSelectorContext(this);
    }

    public String getString(String string) {
        return this.r.getString(string);
    }

    public void applyChanges() {
        this.applyChanges(this.getRuleModel().getDeclarationsRemoved());
    }

    public void applyChanges(boolean bl) {
        if (bl && this.g instanceof IlvCompositeGraphic) {
            ((IlvCompositeGraphic)this.g).setChildren(null);
            ((IlvCompositeGraphic)this.g).setEventMaps(null);
            ((IlvCompositeGraphic)this.g).setEventMap(null);
            ((IlvCompositeGraphic)this.g).setConstraints(null);
            ((IlvCompositeGraphic)this.g).removeAll(true);
        }
        this.i.applyToObject(this.g, new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvSymbolEditorDocument.this.c();
            }
        }, null, true);
        if (bl) {
            this.fireSymbolChanged(this.g, "topLevelGraphic", null, null);
        }
    }

    public void applyChangesIfNecessary() {
        if (!this.h) {
            this.applyChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultValues(IlvRule ilvRule, IlvRule ilvRule2, IlvCSSDeclaration[] ilvCSSDeclarationArray) {
        Object object;
        IlvRule ilvRule3;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        if (ilvRule2.getSelector().getID() != null && ilvRule2.getSelector().getID().endsWith("Attachment")) {
            ilvRule3 = ilvSymbolRuleModel.getMainRuleFromID(ilvRule2.getSelector().getID());
            object = ilvSymbolRuleModel.makeBeanFromRule(ilvRule3);
        } else {
            object = ilvSymbolRuleModel.getGraphicFromRule(ilvRule);
            ilvRule3 = ilvSymbolRuleModel.getMainRuleFromGraphic((IlvGraphic)object);
        }
        if (object != null) {
            try {
                ilvSymbolRuleModel.setAdjusting(true);
                PropertyDescriptor[] propertyDescriptorArray = null;
                IlvConvertForSetters ilvConvertForSetters = null;
                IlvCSSWriter ilvCSSWriter = null;
                for (int i2 = 0; i2 < ilvCSSDeclarationArray.length; ++i2) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    String string;
                    String string2;
                    block32: {
                        Object object6;
                        string2 = ilvCSSDeclarationArray[i2].getProperty();
                        if (ilvRule3.getDeclarationValue(string2) != null) continue;
                        if (propertyDescriptorArray == null) {
                            propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
                        }
                        int n2 = -1;
                        string = string2;
                        int n3 = string2.lastIndexOf(91);
                        if (n3 > 0 && string2.endsWith("]")) {
                            object6 = string2.substring(n3 + 1, string2.length() - 2);
                            n2 = Integer.parseInt((String)object6);
                            string = string2.substring(0, n3);
                        }
                        object6 = null;
                        for (int i3 = 0; i3 < propertyDescriptorArray.length; ++i3) {
                            object5 = propertyDescriptorArray[i3];
                            if (!((FeatureDescriptor)object5).getName().equals(string)) continue;
                            object6 = object5;
                            break;
                        }
                        if (object6 == null) {
                            throw new RuntimeException("Property descriptor not found for " + string2);
                        }
                        if (n2 >= 0) {
                            object5 = ((IndexedPropertyDescriptor)object6).getIndexedReadMethod();
                            if (object5 == null) {
                                throw new RuntimeException("No indexed read method for " + string2);
                            }
                            object4 = ((Method)object5).invoke(object, new Integer(n2));
                        } else {
                            object5 = ((PropertyDescriptor)object6).getReadMethod();
                            if (object5 == null) {
                                throw new RuntimeException("No read method for " + string2);
                            }
                            object4 = ((Method)object5).invoke(object, (Object[])null);
                        }
                        if (object4 == null) {
                            object5 = "";
                        } else {
                            try {
                                object3 = null;
                                object2 = ((PropertyDescriptor)object6).getPropertyEditorClass();
                                if (object2 != null) {
                                    object3 = (PropertyEditor)((Class)object2).newInstance();
                                }
                                if (object3 == null && object4 != null) {
                                    object3 = IlvPropertyEditorManager.findEditor(object4.getClass());
                                }
                                if (object3 != null) {
                                    object3.setValue(object4);
                                    object5 = object3.getAsText();
                                    break block32;
                                }
                                try {
                                    if (ilvConvertForSetters == null) {
                                        ilvConvertForSetters = new IlvConvertForSetters();
                                    }
                                    object5 = (String)ilvConvertForSetters.convert(object4, (PropertyDescriptor)object6, ah == null ? IlvSymbolEditorDocument.class$("java.lang.String") : ah);
                                }
                                catch (Exception exception) {
                                    object5 = null;
                                }
                                if (object5 == null) {
                                    object5 = (String)IlvConvert.convert(object4, ah == null ? IlvSymbolEditorDocument.class$("java.lang.String") : ah);
                                }
                            }
                            catch (Exception exception) {
                                object5 = null;
                            }
                        }
                    }
                    if (object5 == null) {
                        if (ilvCSSWriter == null) {
                            ilvCSSWriter = new IlvCSSWriter();
                        }
                        object3 = SymbolEditorUtilities.getUniqueRuleID(this, ilvSymbolRuleModel.getAllRules(true), string);
                        object2 = "#" + (String)object3;
                        IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert((String)object2, object4, null);
                        IlvRule ilvRule4 = ilvSymbolRuleModel.getRule((String)object2, true);
                        Declaration[] declarationArray = ilvCSSCustomizerDeclarations.getDeclarations();
                        for (int i4 = 0; i4 < declarationArray.length; ++i4) {
                            ilvSymbolRuleModel.setDeclarationValue(ilvRule4, declarationArray[i4].getProperty(), declarationArray[i4].getValue());
                        }
                        IlvRule[] ilvRuleArray = ilvCSSCustomizerDeclarations.getAdditionalRules();
                        this.c(ilvRuleArray);
                        for (int i5 = 0; i5 < ilvRuleArray.length; ++i5) {
                            ilvSymbolRuleModel.addRule(ilvRuleArray[i5]);
                        }
                        object5 = "@#" + (String)object3;
                    }
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule3, string2, (String)object5);
                }
            }
            catch (Exception exception) {
            }
            finally {
                ilvSymbolRuleModel.setAdjusting(false);
            }
        }
    }

    public void setSelection(List list) {
        this.a(list, true);
    }

    private void a(List list, boolean bl) {
        int n2;
        List list2 = this.getSelection();
        boolean bl2 = false;
        for (n2 = 0; n2 < this.k.size(); n2 += 1) {
            if (!(this.k.get(n2) instanceof IlvRule)) continue;
            bl2 = true;
            break;
        }
        this.k.clear();
        if (list != null) {
            this.k.addAll(list);
        }
        n2 = 0;
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            if (!(this.k.get(i2) instanceof IlvRule)) continue;
            bl2 = true;
            if (!this.b((IlvRule)list.get(i2))) continue;
            n2 = 1;
        }
        if (n2 != this.isSelected()) {
            this.setSelected(n2 != 0);
        } else if (bl2 && !this.getRuleModel().isAdjusting()) {
            this.applyChanges();
        }
        if (bl) {
            this.a(list2);
        }
    }

    public void clearSelection() {
        this.setSelection(null);
    }

    public void setSelection(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        this.setSelection(arrayList);
    }

    private void a(Object object) {
        List list = this.getSelection();
        if (list.contains(object)) {
            list.remove(object);
            this.setSelection(list);
        }
    }

    public List getSelection() {
        return (List)this.k.clone();
    }

    public void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.l.add(selectionChangedListener);
    }

    public void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.l.remove(selectionChangedListener);
    }

    private void a(List list) {
        Object[] objectArray = this.l.getListenerList();
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(this, list);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((SelectionChangedListener)objectArray[i2]).selectionChanged(selectionChangedEvent);
        }
        this.b(list);
    }

    public void addSymbolChangedListener(SymbolChangedListener symbolChangedListener) {
        this.m.add(symbolChangedListener);
    }

    public void removeSymbolChangedListener(SymbolChangedListener symbolChangedListener) {
        this.m.remove(symbolChangedListener);
    }

    public void addParameter(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        this.a.addParameter(ilvPaletteSymbolParameter);
        this.b(ilvPaletteSymbolParameter);
    }

    public void removeParameter(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        List list = this.getRuleModel().getRulesUsingAttributeName(ilvPaletteSymbolParameter.getName());
        List list2 = this.getRuleModel().getDeclarationsUsingAttributeName(ilvPaletteSymbolParameter.getName());
        if (list.size() > 0 || list2.size() > 0) {
            if (this.e()) {
                this.a((Object)ilvPaletteSymbolParameter);
                this.a(ilvPaletteSymbolParameter);
                if (list.size() > 0) {
                    this.getRuleModel().removeRulesUsingAttributeName(ilvPaletteSymbolParameter.getName());
                }
                if (list2.size() > 0) {
                    this.getRuleModel().removeDeclarationsUsingAttributeName(ilvPaletteSymbolParameter.getName());
                }
                this.a.removeParameter(ilvPaletteSymbolParameter);
                this.c(ilvPaletteSymbolParameter);
            }
        } else {
            this.a((Object)ilvPaletteSymbolParameter);
            this.a.removeParameter(ilvPaletteSymbolParameter);
            this.c(ilvPaletteSymbolParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        String string = ilvPaletteSymbolParameter.getName();
        IlvRule ilvRule = this.getRuleModel().getRootRules(true)[0];
        IlvCSSDeclaration[] ilvCSSDeclarationArray = ilvRule.getCSSDeclarations();
        block5: for (int i2 = 0; i2 < ilvCSSDeclarationArray.length; ++i2) {
            if (!ilvCSSDeclarationArray[i2].getProperty().startsWith("eventMaps")) continue;
            String string2 = ilvCSSDeclarationArray[i2].getValue().substring(2);
            try {
                IlvRule ilvRule2 = this.getRuleModel().getRule("#" + string2, false);
                IlvCSSDeclaration[] ilvCSSDeclarationArray2 = ilvRule2.getCSSDeclarations();
                for (int i3 = 0; i3 < ilvCSSDeclarationArray2.length; ++i3) {
                    if (!ilvCSSDeclarationArray2[i3].getProperty().startsWith("actions")) continue;
                    String string3 = ilvCSSDeclarationArray2[i3].getValue().substring(2);
                    IlvRule ilvRule3 = this.getRuleModel().getRule("#" + string3, false);
                    String string4 = ilvRule3.getDeclarationValue("parameterToModify");
                    if (!string.equals(string4)) continue;
                    this.getRuleModel().setAdjusting(true);
                    try {
                        this.getRuleModel().removeDeclaration(ilvRule, ilvCSSDeclarationArray[i2].getProperty());
                        this.getRuleModel().removeRule(ilvRule2);
                        this.getRuleModel().removeRule(ilvRule3);
                        continue block5;
                    }
                    finally {
                        this.getRuleModel().setAdjusting(false);
                    }
                }
                continue;
            }
            catch (IlvStylingException ilvStylingException) {
                // empty catch block
            }
        }
    }

    public void fireSymbolChanged(Object object, String string, Object object2, Object object3) {
        Object[] objectArray = this.m.getListenerList();
        SymbolChangedEvent symbolChangedEvent = new SymbolChangedEvent(this, object, string, object2, object3);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((SymbolChangedListener)objectArray[i2]).symbolChanged(symbolChangedEvent);
        }
    }

    public void addParameterListChangedListener(ParameterListChangedListener parameterListChangedListener) {
        this.n.add(parameterListChangedListener);
    }

    public void removeParameterListChangedListener(ParameterListChangedListener parameterListChangedListener) {
        this.n.remove(parameterListChangedListener);
    }

    private void b(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        Object[] objectArray = this.n.getListenerList();
        ParameterListChangedEvent parameterListChangedEvent = new ParameterListChangedEvent(this, 1, ilvPaletteSymbolParameter);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ParameterListChangedListener)objectArray[i2]).parameterAdded(parameterListChangedEvent);
        }
        this.a(parameterListChangedEvent);
    }

    private void c(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
        Object[] objectArray = this.n.getListenerList();
        ParameterListChangedEvent parameterListChangedEvent = new ParameterListChangedEvent(this, 2, ilvPaletteSymbolParameter);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ParameterListChangedListener)objectArray[i2]).parameterRemoved(parameterListChangedEvent);
        }
        this.a(parameterListChangedEvent);
    }

    private void a(IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray) {
        Object[] objectArray = this.n.getListenerList();
        ParameterListChangedEvent parameterListChangedEvent = new ParameterListChangedEvent(this, ilvPaletteSymbolParameterArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ParameterListChangedListener)objectArray[i2]).parametersMoved(parameterListChangedEvent);
        }
        this.a(parameterListChangedEvent);
    }

    public void addParameterValueChangedListener(ParameterValueChangedListener parameterValueChangedListener) {
        this.o.add(parameterValueChangedListener);
    }

    public void removeParameterValueChangedListener(ParameterValueChangedListener parameterValueChangedListener) {
        this.o.remove(parameterValueChangedListener);
    }

    private void a(IlvPaletteSymbolParameter ilvPaletteSymbolParameter, Object object, Object object2) {
        Object[] objectArray = this.o.getListenerList();
        ParameterValueChangedEvent parameterValueChangedEvent = new ParameterValueChangedEvent(this, ilvPaletteSymbolParameter, object, object2);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((ParameterValueChangedListener)objectArray[i2]).parameterValueChanged(parameterValueChangedEvent);
        }
        this.a(parameterValueChangedEvent);
    }

    public File setAutomaticIcon(IlvPaletteSymbol ilvPaletteSymbol) throws MalformedURLException {
        File file;
        block5: {
            Image image;
            block4: {
                file = null;
                if (ilvPaletteSymbol.getIconURL() == null) break block4;
                if (new File(ilvPaletteSymbol.getIconURL().getFile()).getName().startsWith(y)) break block4;
                if (!this.a.getIconURL().getFile().endsWith("/images/")) break block5;
            }
            if ((image = IlvSymbolEditorDocument.a(this.getToplevelGraphic(), 32, 32)) instanceof RenderedImage && (file = this.a((RenderedImage)((Object)image), ilvPaletteSymbol)) != null) {
                ilvPaletteSymbol.setIconURL(file.toURL());
            }
        }
        return file;
    }

    private void a(IlvRule ilvRule, IlvRule ilvRule2, IlvGraphic ilvGraphic, IlvRect ilvRect, IlvRule[] ilvRuleArray, String string, boolean bl) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.getRuleModel().getGraphicFromRule(ilvRule);
        this.a(ilvRule, ilvCompositeGraphic, ilvRule2, ilvGraphic, ilvRect, ilvRuleArray, string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(IlvRule ilvRule, IlvCompositeGraphic ilvCompositeGraphic, IlvRule ilvRule2, IlvGraphic ilvGraphic, IlvRect ilvRect, IlvRule[] ilvRuleArray, String string, boolean bl, boolean bl2) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        int n2;
        if (!(this.getToplevelGraphic() instanceof IlvCompositeGraphic)) {
            throw new IllegalArgumentException("Parent must be a composite graphic");
        }
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        String string2 = SymbolEditorUtilities.getUniqueGraphicName(this, string);
        ilvRule2.getSelector().setType(null);
        ilvRule2.getSelector().setID(string2);
        ilvRule2.updateRule();
        ilvRule2.updateWeights();
        if (ilvGraphic instanceof IlvGeneralPath) {
            ((IlvGeneralPath)ilvGraphic).setTransformedShapeMode(true);
            ilvRule2.setDeclaration("transformedShapeMode", "true");
        }
        ilvRule2.setDeclaration("name", string2);
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        if (ilvGraphicArray == null) {
            n2 = 0;
        } else {
            n2 = ilvGraphicArray.length;
            while (ilvGraphicArray[n2 - 1] == null) {
                --n2;
            }
        }
        try {
            int n3;
            ilvSymbolRuleModel.setAdjusting(true);
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
            if (bl) {
                arrayList.add(ilvRule2);
            }
            if (ilvRuleArray != null) {
                for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                    if (ilvRuleArray[i2] == ilvRule2) continue;
                    arrayList.add(ilvRuleArray[i2]);
                }
            }
            ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + n2 + "]", "@+" + string2);
            this.a(ilvRule, ilvCompositeGraphic, string2, n2, ilvRect, false, false);
            IlvRule[] ilvRuleArray2 = arrayList.toArray(new IlvRule[0]);
            this.c(ilvRuleArray2);
            for (n3 = 0; n3 < ilvRuleArray2.length; ++n3) {
                ilvSymbolRuleModel.addRule(ilvRuleArray2[n3]);
            }
            if (ilvRect.width > 0.0f && ilvRect.height > 0.0f) {
                ilvGraphic.moveResize(ilvRect);
                ilvSymbolRuleModel.updateGeometry(ilvGraphic, ilvRule2, false, null);
            }
            if (bl2) {
                this.applyChangesIfNecessary();
                this.setSelection(ilvRule2);
            }
            n3 = n2;
            return n3;
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    private void a(IlvRule ilvRule, IlvCompositeGraphic ilvCompositeGraphic, String string, int n2, IlvRect ilvRect, boolean bl, boolean bl2) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        Object object;
        IlvAttachmentConstraint ilvAttachmentConstraint = new IlvAttachmentConstraint();
        if (ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout) {
            ilvAttachmentConstraint.setRelativeSize(bl);
            if (n2 > 0) {
                object = SymbolEditorUtilities.getAttachmentBounds(ilvCompositeGraphic.getChildren(0));
                ilvAttachmentConstraint.setOffset(new IlvPoint(ilvRect.x - ((Rectangle2D.Float)object).x, ilvRect.y - ((Rectangle2D.Float)object).y));
                if (bl) {
                    if (ilvRect.width > 0.0f) {
                        ilvAttachmentConstraint.setWidth(ilvRect.width / ((Rectangle2D.Float)object).width);
                    }
                    if (ilvRect.height > 0.0f) {
                        ilvAttachmentConstraint.setHeight(ilvRect.height / ((Rectangle2D.Float)object).height);
                    }
                }
            }
            if (bl2) {
                if (ilvRect.width > 0.0f) {
                    ilvAttachmentConstraint.setWidth(ilvRect.width);
                }
                if (ilvRect.height > 0.0f) {
                    ilvAttachmentConstraint.setHeight(ilvRect.height);
                }
            }
        }
        object = string + "Attachment";
        IlvCSSWriter ilvCSSWriter = new IlvCSSWriter();
        IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert("#" + (String)object, ilvAttachmentConstraint, null);
        this.getRuleModel().setDeclarationValue(ilvRule, "constraints[" + n2 + "]", "@+" + (String)object);
        IlvRule ilvRule2 = this.getRuleModel().getRule("#" + (String)object, true);
        Declaration[] declarationArray = ilvCSSCustomizerDeclarations.getDeclarations();
        for (int i2 = 0; i2 < declarationArray.length; ++i2) {
            this.getRuleModel().setDeclarationValue(ilvRule2, declarationArray[i2].getProperty(), declarationArray[i2].getValue());
        }
    }

    private void a(String string) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule[] ilvRuleArray = IlvRuleUtils.getRulesFromId(ilvSymbolRuleModel.getAllRules(true), string + "Attachment");
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ilvSymbolRuleModel.removeRule(ilvRuleArray[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvRule addObject(IlvGraphic ilvGraphic, String string, IlvRect ilvRect) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        try {
            this.getRuleModel().setAdjusting(true);
            IlvCSSWriter ilvCSSWriter = new IlvCSSWriter();
            IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert(string, ilvGraphic, null);
            IlvRule ilvRule = this.getRuleModel().getRule(string, true);
            ilvRule.setDeclarations(ilvCSSCustomizerDeclarations.getDeclarations());
            ilvRule.setDeclaration("name", string);
            this.a(this.getToplevelRule(), ilvRule, ilvGraphic, ilvRect, ilvCSSCustomizerDeclarations.getAdditionalRules(), string, false);
            IlvRule ilvRule2 = ilvRule;
            return ilvRule2;
        }
        finally {
            this.getRuleModel().setAdjusting(false);
        }
    }

    public void addGraphic(IlvGraphic ilvGraphic, boolean bl, IlvRect ilvRect) {
        IlvGraphic ilvGraphic2;
        String string = ilvGraphic.getName();
        if (string == null) {
            string = ilvGraphic.getClass().getName();
            int n2 = string.lastIndexOf(46);
            if (n2 > 0) {
                string = string.substring(n2 + 1);
            }
            if (string.startsWith("Ilv")) {
                string = string.substring(3);
            }
        }
        if ((ilvGraphic2 = SymbolEditorUtilities.translateGraphic(ilvGraphic, bl)) instanceof IlvGeneralPath && !bl) {
            ((IlvGeneralPath)ilvGraphic2).setPointEditionAllowed(false);
        }
        if (ilvGraphic2 instanceof IlvText && bl) {
            ((IlvText)ilvGraphic2).setAutoWrappingSizeMode(true);
        }
        if (ilvRect == null) {
            ilvRect = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic2);
        }
        try {
            this.beginAggregateUndoableEdits(MessageFormat.format(this.getString("SymbolEditor.Undo.Add"), string));
            this.addObject(ilvGraphic2, string, ilvRect);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            this.endAggregateUndoableEdits();
        }
    }

    public void addSymbol(IlvPaletteSymbol ilvPaletteSymbol, IlvPoint ilvPoint) {
        if (ilvPaletteSymbol == this.b) {
            JOptionPane.showMessageDialog(null, this.r.getString("SymbolEditor.CannotAddSymbolToItself"), this.r.getString("SymbolEditor.CannotAddSubSymbol.Title"), 0);
            return;
        }
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        try {
            Object object;
            Serializable serializable;
            ilvSymbolRuleModel.setAdjusting(true);
            String string = ilvPaletteSymbol.getName();
            IlvRule ilvRule = IlvRuleUtils.createRule(string);
            ilvRule.setDeclaration("class", ilvPaletteSymbol.createClassDeclarationValue());
            IlvConvertForSetters ilvConvertForSetters = new IlvConvertForSetters();
            for (int i2 = 0; i2 < ilvPaletteSymbol.getParameterCount(); ++i2) {
                serializable = ilvPaletteSymbol.getParameter(i2);
                object = ((IlvPaletteSymbolParameter)serializable).getValue();
                String string2 = null;
                if (object != null) {
                    if (object instanceof String) {
                        string2 = (String)object;
                    } else {
                        PropertyEditor propertyEditor = ((IlvPaletteSymbolParameter)serializable).getPropertyEditor();
                        if (propertyEditor != null) {
                            try {
                                propertyEditor.setValue(object);
                                string2 = propertyEditor.getAsText();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (string2 == null) {
                            string2 = ilvConvertForSetters.convertBack(object, object.getClass(), null);
                        }
                    }
                }
                if (string2 == null) {
                    string2 = "";
                }
                ilvRule.setDeclaration(((IlvPaletteBaseObject)serializable).getName(), string2);
            }
            IlvSymbolEditorDocument ilvSymbolEditorDocument = new IlvSymbolEditorDocument(ilvPaletteSymbol, this.getComponentType(), this.e, null, null);
            serializable = ilvSymbolEditorDocument.getToplevelGraphic();
            if (SymbolEditorUtilities.containsSubSymbol((IlvGraphic)serializable, this.b)) {
                JOptionPane.showMessageDialog(null, this.r.getString("SymbolEditor.CircularSymbolDependency"), this.r.getString("SymbolEditor.CannotAddSubSymbol.Title"), 0);
                return;
            }
            object = new IlvRect(ilvPoint.x, ilvPoint.y, 0.0f, 0.0f);
            this.a(this.getToplevelRule(), ilvRule, (IlvGraphic)serializable, (IlvRect)object, null, string, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(IlvGraphic ilvGraphic) {
        if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) {
            throw new IllegalArgumentException("Parent must be a composite graphic");
        }
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
        this.a((Object)ilvRule);
        try {
            ilvSymbolRuleModel.setAdjusting(true);
            IlvRule[] ilvRuleArray = this.b(ilvGraphic);
            this.a(ilvGraphic);
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                if (ilvSymbolRuleModel.getSharpRuleUsageCount(ilvRuleArray[i2].getSelector().getID()) != 0) continue;
                ilvSymbolRuleModel.removeRule(ilvRuleArray[i2]);
            }
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvAttachmentConstraint ilvAttachmentConstraint, IlvCompositeGraphic ilvCompositeGraphic, IlvRule ilvRule, int n2) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + n2 + "]", "@+" + ilvGraphic.getName());
        ilvCompositeGraphic.setChildren(n2, ilvGraphic);
        ilvGraphic.setGraphicBag(ilvCompositeGraphic);
        String string = ilvGraphic.getName() + "Attachment";
        try {
            if (n2 > 0) {
                boolean bl = ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout;
                if (ilvSymbolRuleModel.getRule("#" + string, bl) != null) {
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule, "constraints[" + n2 + "]", "@+" + string);
                    ilvCompositeGraphic.setConstraints(n2, ilvAttachmentConstraint);
                }
            } else {
                ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + n2 + "]");
                ilvCompositeGraphic.setConstraints(n2, null);
            }
        }
        catch (IlvStylingException ilvStylingException) {
            // empty catch block
        }
    }

    private void a(IlvGraphic ilvGraphic) {
        int n2;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
        int n3 = -1;
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        Object[] objectArray = ilvCompositeGraphic.getConstraints();
        for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
            if (ilvGraphicArray[i2] != ilvGraphic) continue;
            n3 = i2;
            break;
        }
        if (n3 == -1) {
            throw new RuntimeException("Cannot find child " + ilvGraphic.getName() + " in parent " + ilvCompositeGraphic);
        }
        IlvRule[] ilvRuleArray = ilvSymbolRuleModel.getAllRulesFromGraphic(ilvCompositeGraphic);
        for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
            IlvRule ilvRule = ilvRuleArray[n2];
            for (int i3 = n3 + 1; i3 < ilvGraphicArray.length; ++i3) {
                IlvGraphic ilvGraphic2 = ilvGraphicArray[i3];
                Object object = objectArray[i3];
                if (ilvGraphic2 != null) {
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + (i3 - 1) + "]", "@+" + ilvGraphic2.getName());
                    try {
                        if (ilvSymbolRuleModel.getRule("#" + ilvGraphic2.getName() + "Attachment", false) != null) {
                            ilvSymbolRuleModel.setDeclarationValue(ilvRule, "constraints[" + (i3 - 1) + "]", "@+" + ilvGraphic2.getName() + "Attachment");
                        }
                    }
                    catch (IlvStylingException ilvStylingException) {}
                } else {
                    ilvSymbolRuleModel.removeDeclaration(ilvRule, "children[" + (i3 - 1) + "]");
                    ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + (i3 - 1) + "]");
                }
                if (n2 != 0) continue;
                if (i3 == ilvGraphicArray.length - 1) {
                    ilvCompositeGraphic.setChildren(i3, null);
                    ilvCompositeGraphic.setConstraints(i3, null);
                }
                ilvCompositeGraphic.setChildren(i3 - 1, ilvGraphic2);
                ilvCompositeGraphic.setConstraints(i3 - 1, object);
            }
            ilvSymbolRuleModel.removeDeclaration(ilvRule, "children[" + (ilvGraphicArray.length - 1) + "]");
            ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + (ilvGraphicArray.length - 1) + "]");
        }
        if (n3 == ilvGraphicArray.length - 1) {
            ilvCompositeGraphic.setChildren(n3, null);
            ilvCompositeGraphic.setConstraints(n3, null);
        }
        if ((ilvGraphicArray = ilvCompositeGraphic.getChildren()) != null) {
            for (n2 = 0; n2 < ilvGraphicArray.length; ++n2) {
                if (ilvGraphicArray[n2] == null) continue;
                ilvGraphicArray[n2].setGraphicBag(ilvCompositeGraphic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCondition(IlvRule ilvRule) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        String string = ilvRule.getSelector().getID();
        IlvRule ilvRule2 = ilvRule.copy();
        ilvRule2.getSelector().setID(string + "Attachment");
        ilvRule2 = ilvSymbolRuleModel.getSameRule(ilvRule2);
        this.a((Object)ilvRule);
        try {
            ilvSymbolRuleModel.setAdjusting(true);
            IlvRule[] ilvRuleArray = this.a(ilvRule);
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                ilvSymbolRuleModel.removeRule(ilvRuleArray[i2]);
            }
            if (ilvRule2 != null) {
                ilvSymbolRuleModel.removeRule(ilvRule2);
            }
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    public void renameSymbol(String string) {
        String string2 = this.a.getName();
        if (!string2.equals(string)) {
            this.a.setName(string);
            this.a.setID(string);
            this.fireSymbolChanged(this.a, "name", string2, string);
        }
    }

    public void renameParameter(IlvPaletteSymbolParameter ilvPaletteSymbolParameter, String string) {
        String string2 = ilvPaletteSymbolParameter.getName();
        if (!string2.equals(string)) {
            ilvPaletteSymbolParameter.setName(string);
            ilvPaletteSymbolParameter.setID(string);
            this.fireSymbolChanged(ilvPaletteSymbolParameter, "name", string2, string);
        }
    }

    public void renameObject(IlvGraphic ilvGraphic, String string) {
        this.a(ilvGraphic, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, String string, boolean bl) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        boolean bl2 = this.ae;
        try {
            this.ae = true;
            ilvSymbolRuleModel.setAdjusting(true);
            String string2 = ilvGraphic.getName();
            if (!string2.equals(string)) {
                ilvGraphic.setName(string);
                this.a(ilvSymbolRuleModel.getAllRules(true), string2, string, true);
                if (bl) {
                    this.a(ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic), string2, string);
                }
            }
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
            this.ae = bl2;
        }
    }

    private static void b(IlvRule ilvRule, IlvRule ilvRule2) {
        String string = ilvRule2.getName();
        IlvSelector ilvSelector = ilvRule2.getSelector();
        if (ilvSelector != null) {
            if (ilvSelector.getID() != null) {
                if (string.startsWith(ilvSelector.getID() + "[")) {
                    string = string.substring(ilvSelector.getID().length() + 1);
                }
            }
            if (string.endsWith("]")) {
                string = string.substring(0, string.length() - 1);
            }
            ilvRule.setName(string);
        }
    }

    public void cut(Clipboard clipboard) {
        int n2 = this.a(false, false, false);
        if (n2 < 0) {
            return;
        }
        if (n2 > 0) {
            this.getRuleModel().setAdjusting(true);
        }
        this.copy(clipboard);
        this.delete();
        if (n2 > 0) {
            this.b();
            this.getRuleModel().setAdjusting(false);
        }
    }

    public void copy(Clipboard clipboard) {
        List list = this.getSelection();
        clipboard.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (IlvSymbolEditorDocument.isConditionSelection(e2)) {
                clipboard.a(new ConditionClipboardElement(this.a((IlvRule)e2)));
                continue;
            }
            if (this.c(e2)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (ilvGraphic == null) continue;
                clipboard.a(new GraphicClipboardElement(ilvGraphic, this.b(ilvGraphic)));
                continue;
            }
            if (!this.d(e2)) continue;
            clipboard.a(new ParameterClipboardElement((IlvPaletteSymbolParameter)e2));
        }
    }

    public void paste(Clipboard clipboard) {
        this.setSelection(clipboard.b(this));
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.a(this);
    }

    public void delete() {
        int n2 = this.a(false, false, false);
        if (n2 < 0) {
            return;
        }
        if (n2 > 0) {
            this.getRuleModel().setAdjusting(true);
        }
        List list = this.getSelection();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (IlvSymbolEditorDocument.isConditionSelection(e2)) {
                this.removeCondition((IlvRule)e2);
                continue;
            }
            if (this.c(e2)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (ilvGraphic == null) continue;
                this.removeObject(ilvGraphic);
                continue;
            }
            if (!this.d(e2)) continue;
            this.removeParameter((IlvPaletteSymbolParameter)e2);
        }
        if (n2 > 0) {
            this.b();
            this.getRuleModel().setAdjusting(false);
        }
    }

    public boolean canCopy() {
        return this.hasSelection(false);
    }

    public boolean canDelete() {
        return this.hasSelection(true);
    }

    public boolean hasSelection(boolean bl) {
        if (!(this.getToplevelGraphic() instanceof IlvCompositeGraphic)) {
            return false;
        }
        List list = this.getSelection();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (this.c(e2)) {
                IlvGraphicBag ilvGraphicBag;
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (ilvGraphic == this.getToplevelGraphic()) {
                    return false;
                }
                if (!bl || !((ilvGraphicBag = ilvGraphic.getGraphicBag()) instanceof IlvCompositeGraphic)) continue;
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphicBag;
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                boolean bl2 = true;
                for (int i3 = 0; i3 < ilvGraphicArray.length; ++i3) {
                    IlvRule ilvRule;
                    IlvGraphic ilvGraphic2 = ilvGraphicArray[i3];
                    if (ilvGraphic2 == null || list.contains(ilvRule = this.getRuleModel().getMainRuleFromGraphic(ilvGraphic2))) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                return false;
            }
            if (IlvSymbolEditorDocument.isConditionSelection(e2) || this.d(e2)) continue;
            return false;
        }
        return true;
    }

    private int a(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        List list = this.getSelection();
        int n2 = 0;
        String string = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            IlvGraphic ilvGraphic;
            IlvGraphic ilvGraphic2;
            object = list.get(i2);
            if (!this.c(object) || !((ilvGraphic2 = (IlvGraphic)((Object)(ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)object)).getGraphicBag())) instanceof IlvCompositeGraphic)) continue;
            IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic2;
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            int n3 = -1;
            for (int i3 = 0; i3 < ilvGraphicArray.length; ++i3) {
                if (ilvGraphicArray[i3] != ilvGraphic) continue;
                n3 = i3;
                break;
            }
            if (!bl && !bl2) {
                if (n3 == n2) {
                    n2 = n3 + 1;
                }
            } else if (bl) {
                if (bl3) {
                    if (n2 == 0) {
                        n2 = n3;
                    }
                } else if (n3 == 1) {
                    n2 = 1;
                }
            } else if (bl2 && n3 == n2) {
                n2 = n3 + 1;
            }
            if (n2 == 0) continue;
            string = ilvGraphicArray[n2].getName();
        }
        if (n2 != 0) {
            String string2 = MessageFormat.format(this.r.getString("SymbolEditor.ConfirmNewBase.Message"), string);
            object = this.r.getString("SymbolEditor.ConfirmNewBase.Title");
            int n4 = JOptionPane.showOptionDialog(null, string2, object, 0, 2, null, null, null);
            if (n4 == 1 || n4 == -1) {
                return -1;
            }
        }
        return n2;
    }

    private void b() {
        this.a((IlvCompositeGraphic)this.getToplevelGraphic());
    }

    private void a(IlvCompositeGraphic ilvCompositeGraphic) {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
            Object object;
            IlvGraphic ilvGraphic = ilvGraphicArray[i2];
            if (ilvGraphic == null) continue;
            if (ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout) {
                Object object2;
                Object object3;
                object = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
                if (i2 == 0) {
                    IlvRule ilvRule;
                    int n2;
                    object3 = ilvSymbolRuleModel.getAllRulesFromGraphic(ilvCompositeGraphic);
                    object3 = ilvSymbolRuleModel.getAllRules(true);
                    object2 = ilvGraphic.getName() + "Attachment";
                    ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
                    for (n2 = 0; n2 < ((IlvRule[])object3).length; ++n2) {
                        ilvRule = object3[n2];
                        if (ilvRule.getSelector() == null || !((String)object2).equals(ilvRule.getSelector().getID())) continue;
                        arrayList.add(ilvRule);
                    }
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        ilvRule = (IlvRule)arrayList.get(n2);
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "offsetX");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "offsetY");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "relativeSize");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "rotationAngle");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "rotationCenterRelativeToBase");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "rotationCenter");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "anchor");
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "hotspot");
                    }
                    ilvCompositeGraphic.doLayout();
                } else {
                    try {
                        object3 = ilvSymbolRuleModel.getRule("#" + ilvGraphic.getName() + "Attachment", true);
                        ilvSymbolRuleModel.setDeclarationValue((IlvRule)object3, "class", (ai == null ? IlvSymbolEditorDocument.class$("ilog.views.graphic.composite.layout.IlvAttachmentConstraint") : ai).getName());
                        object2 = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvCompositeGraphic);
                        ilvSymbolRuleModel.setDeclarationValue((IlvRule)object2, "constraints[" + i2 + "]", "@+" + ilvGraphic.getName() + "Attachment");
                        if (ilvCompositeGraphic.getConstraints(i2) == null) {
                            ilvCompositeGraphic.setConstraints(i2, new IlvAttachmentConstraint());
                        }
                    }
                    catch (IlvStylingException ilvStylingException) {
                        // empty catch block
                    }
                }
                ilvSymbolRuleModel.updateGeometry(ilvGraphic, (IlvRule)object, true, null);
                ilvCompositeGraphic.setConstraints(i2, null);
            }
            object = IlvSymbolDescriptor.get(ilvGraphic);
            if (!(ilvGraphic instanceof IlvCompositeGraphic) || object != null) continue;
            this.a((IlvCompositeGraphic)ilvGraphic);
        }
    }

    public void group() {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule ilvRule = null;
        try {
            Object object;
            Object object2;
            Object object3;
            ilvSymbolRuleModel.setAdjusting(true);
            IlvRect ilvRect = null;
            ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
            ArrayList<IlvAttachmentConstraint> arrayList2 = new ArrayList<IlvAttachmentConstraint>();
            ArrayList<IlvRect> arrayList3 = new ArrayList<IlvRect>();
            IlvRule ilvRule2 = null;
            IlvCompositeGraphic ilvCompositeGraphic = null;
            this.clearSelection();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                object3 = list.get(i2);
                if (!this.c(object3)) continue;
                object2 = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)object3);
                object = SymbolEditorUtilities.getAttachmentConstraint((IlvGraphic)object2);
                if (i2 == 0) {
                    ilvCompositeGraphic = (IlvCompositeGraphic)((IlvGraphic)object2).getGraphicBag();
                    ilvRule2 = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvCompositeGraphic);
                    ilvRect = SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2);
                } else {
                    ilvRect.add(SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2));
                }
                arrayList.add((IlvGraphic)object2);
                arrayList2.add((IlvAttachmentConstraint)object);
                arrayList3.add(SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2));
            }
            String string = SymbolEditorUtilities.getUniqueGraphicName(this, "Group");
            object3 = new IlvCompositeGraphic();
            ((IlvCompositeGraphic)object3).setSelectionType(3);
            ((IlvCompositeGraphic)object3).setTransformationMode(1);
            ((IlvCompositeGraphic)object3).setResizingPolicy(0);
            ((IlvGraphic)object3).setName(string);
            ilvRule = ilvSymbolRuleModel.getRule("#" + string, true);
            ilvRule.setDeclaration("class", object3.getClass().getName());
            ilvRule.setDeclaration("selectionType", String.valueOf(3));
            ilvRule.setDeclaration("transformationMode", String.valueOf(1));
            ilvRule.setDeclaration("resizingPolicy", String.valueOf(0));
            object2 = string + "Layout";
            object = ilvSymbolRuleModel.getRule("#" + (String)object2, true);
            object.setDeclaration("class", ((IlvCompositeGraphic)object3).getLayout().getClass().getName());
            ilvRule.setDeclaration("layout", "@+" + (String)object2);
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                IlvRect ilvRect2;
                IlvGraphic ilvGraphic = (IlvGraphic)arrayList.get(i3);
                IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)arrayList2.get(i3);
                this.a(ilvGraphic);
                this.a(ilvGraphic.getName());
                this.a(ilvGraphic, ilvAttachmentConstraint, (IlvCompositeGraphic)object3, ilvRule, i3);
                if (i3 > 0) {
                    ilvRect2 = (IlvRect)arrayList3.get(i3);
                    ilvGraphic.move(ilvRect2.x, ilvRect2.y);
                    this.a(ilvRule, (IlvCompositeGraphic)object3, ilvGraphic.getName(), i3, ilvRect2, ilvAttachmentConstraint.isRelativeSize(), ilvAttachmentConstraint.getSize() != null);
                    continue;
                }
                ilvRect2 = (IlvRect)arrayList3.get(i3);
                this.a(ilvRule, (IlvCompositeGraphic)object3, ilvGraphic.getName(), i3, ilvRect2, false, ilvAttachmentConstraint.getSize() != null);
            }
            ilvRect.width = 0.0f;
            ilvRect.height = 0.0f;
            this.a(ilvRule2, ilvRule, (IlvGraphic)object3, ilvRect, null, string, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
        this.setSelection(ilvRule);
    }

    private boolean a(int n2) {
        List list = this.getSelection();
        int n3 = 0;
        IlvCompositeGraphic ilvCompositeGraphic = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (this.c(e2)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) {
                    return false;
                }
                IlvCompositeGraphic ilvCompositeGraphic2 = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                if (ilvCompositeGraphic == null) {
                    ilvCompositeGraphic = ilvCompositeGraphic2;
                } else if (ilvCompositeGraphic2 != ilvCompositeGraphic) {
                    return false;
                }
                if (SymbolEditorUtilities.getCompositeChildIndex(ilvGraphic) == 0) {
                    return false;
                }
                ++n3;
                continue;
            }
            return false;
        }
        return n3 >= n2;
    }

    public boolean canGroup() {
        return this.a(2);
    }

    public void ungroup() {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        try {
            ilvSymbolRuleModel.setAdjusting(true);
            this.clearSelection();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object object;
                IlvGraphicSet ilvGraphicSet;
                Object e2 = list.get(i2);
                if (!this.c(e2)) continue;
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e2);
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvCompositeGraphic);
                if (ilvGraphic instanceof IlvCompositeGraphic) {
                    ilvGraphicSet = (IlvCompositeGraphic)ilvGraphic;
                    object = ((IlvCompositeGraphic)ilvGraphicSet).getChildren();
                    if (object != null) {
                        Object[] objectArray;
                        IlvGraphic[] ilvGraphicArray = new IlvGraphic[((IlvGraphic[])object).length];
                        System.arraycopy(object, 0, ilvGraphicArray, 0, ((IlvGraphic[])object).length);
                        object = ilvGraphicArray;
                        Object[] objectArray2 = ((IlvCompositeGraphic)ilvGraphicSet).getConstraints();
                        if (objectArray2 != null) {
                            objectArray = new Object[objectArray2.length];
                            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                            objectArray2 = objectArray;
                        }
                        objectArray = new IlvRect[((IlvGraphic[])object).length];
                        for (int i3 = 0; i3 < ((IlvGraphic[])object).length; ++i3) {
                            IlvGraphic ilvGraphic2 = object[i3];
                            if (ilvGraphic2 == null) continue;
                            objectArray[i3] = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic2);
                        }
                        IlvGraphic[] ilvGraphicArray2 = ilvCompositeGraphic.getChildren();
                        int n2 = ilvGraphicArray2.length;
                        while (ilvGraphicArray2[n2 - 1] == null) {
                            --n2;
                        }
                        ArrayList<IlvGraphic> arrayList2 = new ArrayList<IlvGraphic>();
                        for (int i4 = 0; i4 < ((IlvGraphic[])object).length; ++i4) {
                            IlvGraphic ilvGraphic3 = object[i4];
                            if (ilvGraphic3 == null) continue;
                            this.a(ilvGraphic3);
                            this.a(ilvGraphic3.getName());
                            IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)(objectArray2 != null && objectArray2.length > i4 ? objectArray2[i4] : null);
                            if (ilvAttachmentConstraint == null) {
                                ilvAttachmentConstraint = new IlvAttachmentConstraint();
                            }
                            this.a(ilvGraphic3, ilvAttachmentConstraint, ilvCompositeGraphic, ilvRule, n2);
                            if (n2 > 0) {
                                this.a(ilvRule, ilvCompositeGraphic, ilvGraphic3.getName(), n2, (IlvRect)objectArray[i4], ilvAttachmentConstraint.isRelativeSize(), ilvAttachmentConstraint.getSize() != null);
                            } else {
                                this.a(ilvGraphic3.getName());
                            }
                            arrayList.add(ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic3));
                            arrayList2.add(ilvGraphic3);
                            ++n2;
                        }
                    }
                    this.removeObject(ilvGraphic);
                    continue;
                }
                this.removeObject(ilvGraphic);
                ilvGraphicSet = (IlvGraphicSet)ilvGraphic;
                if (ilvGraphicSet.getClass().getName().equals("ilog.views.sdm.graphic.IlvURLGraphic") && ilvGraphicSet.getCardinal() == 1 && ilvGraphicSet.getObject(0) instanceof IlvGraphicSet) {
                    object = ilvGraphicSet.getName();
                    ilvGraphicSet = (IlvGraphicSet)ilvGraphicSet.getObject(0);
                    if (object != null) {
                        ilvGraphicSet.setName((String)object);
                    }
                }
                this.a(ilvGraphicSet, ilvCompositeGraphic, ilvRule);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
            this.setSelection(arrayList);
        }
    }

    private IlvGraphic a(IlvGraphicSet ilvGraphicSet, IlvCompositeGraphic ilvCompositeGraphic, IlvRule ilvRule) throws IntrospectionException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IlvStylingException {
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        String string = ilvGraphicSet.getName();
        if (string == null) {
            string = ilvGraphicSet.getClass().getName();
            int n2 = string.lastIndexOf(46);
            if (n2 > 0) {
                string = string.substring(n2 + 1);
            }
            if (string.startsWith("Ilv")) {
                string = string.substring(3);
            }
        }
        String string2 = SymbolEditorUtilities.getUniqueRuleID(this, new IlvRule[0], string);
        IlvCompositeGraphic ilvCompositeGraphic2 = new IlvCompositeGraphic();
        ilvCompositeGraphic2.setSelectionType(3);
        ilvCompositeGraphic2.setTransformationMode(1);
        ilvCompositeGraphic2.setResizingPolicy(0);
        ilvCompositeGraphic2.setName(string2);
        IlvRule ilvRule2 = ilvSymbolRuleModel.getRule("#" + string2, true);
        ilvRule2.setDeclaration("class", ilvCompositeGraphic2.getClass().getName());
        ilvRule2.setDeclaration("selectionType", String.valueOf(3));
        ilvRule2.setDeclaration("transformationMode", String.valueOf(1));
        ilvRule2.setDeclaration("resizingPolicy", String.valueOf(0));
        String string3 = string2 + "Layout";
        IlvRule ilvRule3 = ilvSymbolRuleModel.getRule("#" + string3, true);
        ilvRule3.setDeclaration("class", ilvCompositeGraphic2.getLayout().getClass().getName());
        ilvRule2.setDeclaration("layout", "@+" + string3);
        IlvRect ilvRect = null;
        for (int i2 = 0; i2 < ilvGraphicSet.getCardinal(); ++i2) {
            IlvGraphic ilvGraphic = ilvGraphicSet.getObject(i2);
            IlvGraphic ilvGraphic2 = null;
            ilvGraphic2 = ilvGraphic instanceof IlvGraphicSet ? this.a((IlvGraphicSet)ilvGraphic, ilvCompositeGraphic2, ilvRule2) : (ilvGraphic = SymbolEditorUtilities.translateGraphic(ilvGraphic, false));
            IlvRect ilvRect2 = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic2);
            if (ilvRect == null) {
                ilvRect = new IlvRect(ilvRect2);
            } else {
                ilvRect.add(ilvRect2);
            }
            if (!(ilvGraphic instanceof IlvGraphicSet)) {
                String string4 = ilvGraphic.getName();
                if (string4 == null) {
                    string4 = ilvGraphic.getClass().getName();
                    int n3 = string4.lastIndexOf(46);
                    if (n3 > 0) {
                        string4 = string4.substring(n3 + 1);
                    }
                    if (string4.startsWith("Ilv")) {
                        string4 = string4.substring(3);
                    }
                }
                string4 = SymbolEditorUtilities.getUniqueRuleID(this, new IlvRule[0], string4);
                IlvCSSWriter ilvCSSWriter = new IlvCSSWriter();
                IlvCSSWriter.IlvCSSCustomizerDeclarations ilvCSSCustomizerDeclarations = ilvCSSWriter.convert(string4, ilvGraphic, null);
                IlvRule ilvRule4 = this.getRuleModel().getRule(string4, true);
                ilvRule4.setDeclarations(ilvCSSCustomizerDeclarations.getDeclarations());
                ilvRect2.width = 0.0f;
                ilvRect2.height = 0.0f;
                this.a(ilvRule2, ilvCompositeGraphic2, ilvRule4, ilvGraphic, ilvRect2, ilvCSSCustomizerDeclarations.getAdditionalRules(), string4, false, false);
            }
            ilvCompositeGraphic2.setChildren(i2, ilvGraphic2);
        }
        ilvRect.width = 0.0f;
        ilvRect.height = 0.0f;
        this.a(ilvRule, ilvCompositeGraphic, ilvRule2, ilvCompositeGraphic2, ilvRect, null, string2, false, false);
        return ilvCompositeGraphic2;
    }

    public boolean canUngroup() {
        List list = this.getSelection();
        if (list.size() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (this.c(e2)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (SymbolEditorUtilities.isSubSymbol(ilvGraphic)) {
                    return false;
                }
                if (ilvGraphic instanceof IlvCompositeGraphic || ilvGraphic instanceof IlvGraphicSet) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void reparent(IlvRule ilvRule) {
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.getRuleModel().getGraphicFromRule(ilvRule);
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        try {
            IlvGraphic ilvGraphic;
            Object e2;
            int n2;
            ilvSymbolRuleModel.setAdjusting(true);
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            int n3 = ilvGraphicArray.length;
            while (ilvGraphicArray[n3 - 1] == null) {
                --n3;
            }
            IlvRect[] ilvRectArray = new IlvRect[list.size()];
            IlvAttachmentConstraint[] ilvAttachmentConstraintArray = new IlvAttachmentConstraint[list.size()];
            for (n2 = 0; n2 < list.size(); ++n2) {
                e2 = list.get(n2);
                ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                ilvRectArray[n2] = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic);
                ilvAttachmentConstraintArray[n2] = SymbolEditorUtilities.getAttachmentConstraint(ilvGraphic);
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                e2 = list.get(n2);
                ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) continue;
                this.a(ilvGraphic);
                this.a(ilvGraphic.getName());
                this.a(ilvGraphic, null, ilvCompositeGraphic, ilvRule, n3);
                this.a(ilvRule, ilvCompositeGraphic, ilvGraphic.getName(), n3, ilvRectArray[n2], ilvAttachmentConstraintArray[n2] != null && ilvAttachmentConstraintArray[n2].isRelativeSize(), ilvAttachmentConstraintArray[n2] != null && ilvAttachmentConstraintArray[n2].getSize() != null);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    public boolean canReparent(IlvRule ilvRule) {
        List list;
        IlvGraphic ilvGraphic;
        if (ilvRule != null) {
            ilvGraphic = this.getRuleModel().getGraphicFromRule(ilvRule);
            if (!(ilvGraphic instanceof IlvCompositeGraphic) || SymbolEditorUtilities.isSubSymbol(ilvGraphic)) {
                return false;
            }
        } else {
            ilvGraphic = null;
        }
        if ((list = this.getSelection()).size() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (this.c(e2)) {
                IlvGraphicBag ilvGraphicBag;
                IlvGraphic ilvGraphic2 = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (ilvGraphic2 == ilvGraphic) {
                    return false;
                }
                if (ilvGraphic != null) {
                    for (ilvGraphicBag = ilvGraphic.getGraphicBag(); ilvGraphicBag != null; ilvGraphicBag = ilvGraphicBag.getGraphicBag()) {
                        if (ilvGraphicBag != ilvGraphic2) continue;
                        return false;
                    }
                }
                if (ilvGraphic2.getGraphicBag() instanceof IlvCompositeGraphic) {
                    ilvGraphicBag = (IlvCompositeGraphic)ilvGraphic2.getGraphicBag();
                    if (ilvGraphic2 != ((IlvCompositeGraphic)ilvGraphicBag).getChildren(0) && ilvGraphicBag != ilvGraphic) continue;
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public void newCondition() {
        IlvRule ilvRule;
        IlvRule ilvRule2;
        List list = this.getSelection();
        if (list.size() == 1 && list.get(0) instanceof IlvRule && (ilvRule2 = this.a(ilvRule = (IlvRule)list.get(0), false)) != null) {
            ilvRule2.setMetaDeclaration("__KEEPEMPTYRULE", "true");
            IlvSymbolEditorDocument.b(ilvRule2, ilvRule2);
            this.getRuleModel().addRule(ilvRule2);
            this.setSelection(ilvRule2);
        }
    }

    public boolean newConditionEnabled() {
        List list = this.getSelection();
        return list.size() == 1 && list.get(0) instanceof IlvRule;
    }

    public void changeCondition() {
        IlvRule ilvRule;
        IlvRule ilvRule2;
        List list = this.getSelection();
        if (list.size() == 1 && IlvSymbolEditorDocument.isConditionSelection(list.get(0)) && (ilvRule2 = this.a(ilvRule = (IlvRule)list.get(0), true)) != null) {
            IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
            IlvRule ilvRule3 = ilvRule.copy();
            ilvRule3.getSelector().setID(ilvRule3.getSelector().getID() + "Attachment");
            ilvRule3.updateRule();
            ilvRule3.updateWeights();
            try {
                ilvRule3 = ilvSymbolRuleModel.getRule(ilvRule3.getSelectorString(), false);
            }
            catch (IlvStylingException ilvStylingException) {
                ilvRule3 = null;
            }
            IlvSymbolEditorDocument.b(ilvRule, ilvRule2);
            ilvSymbolRuleModel.setSelector(ilvRule, ilvRule2.getSelector());
            if (ilvRule3 != null) {
                IlvSelector ilvSelector = ilvRule.getSelector().copy();
                ilvSelector.setID(ilvSelector.getID() + "Attachment");
                ilvSymbolRuleModel.setSelector(ilvRule3, ilvSelector);
            }
        }
    }

    public boolean changeConditionEnabled() {
        List list = this.getSelection();
        return list.size() == 1 && IlvSymbolEditorDocument.isConditionSelection(list.get(0));
    }

    public void newParameter() {
        String string = SymbolEditorUtilities.getUniqueParameterName(this, this.r.getString("SymbolEditor.NewParameterName"));
        String string2 = this.r.getString("SymbolEditor.NewParameterDescription");
        IlvPaletteSymbolParameter ilvPaletteSymbolParameter = new IlvPaletteSymbolParameter(string, "", "java.lang.String", null);
        ilvPaletteSymbolParameter.setName(string);
        ilvPaletteSymbolParameter.setShortDescription(string2);
        ilvPaletteSymbolParameter.setLongDescription(string2);
        this.addParameter(ilvPaletteSymbolParameter);
        this.setSelection(ilvPaletteSymbolParameter);
    }

    public boolean newParameterEnabled() {
        List list = this.getSelection();
        if (list.size() == 1) {
            Object e2 = list.get(0);
            return this.d(e2) || this.f(e2) || this.b(e2);
        }
        return false;
    }

    public void moveUp() {
        this.a(true, false);
    }

    public boolean moveUpEnabled() {
        return this.b(true, false);
    }

    public void sendBackward() {
        this.a(true, false);
    }

    public boolean sendBackwardEnabled() {
        return this.b(true, true);
    }

    public void sendToBack() {
        this.a(true, true);
    }

    public boolean sendToBackEnabled() {
        return this.b(true, true);
    }

    public void moveDown() {
        this.a(false, false);
    }

    public boolean moveDownEnabled() {
        return this.b(false, false);
    }

    public void bringForward() {
        this.a(false, false);
    }

    public boolean bringForwardEnabled() {
        return this.b(false, true);
    }

    public void bringToFront() {
        this.a(false, true);
    }

    public boolean bringToFrontEnabled() {
        return this.b(false, true);
    }

    private void a(boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5 = this.a(bl, !bl, bl2);
        if (n5 < 0) {
            return;
        }
        List list = this.getSelection();
        IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray = null;
        boolean bl3 = list.get(0) instanceof IlvRule;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        if (bl3) {
            ilvSymbolRuleModel.setAdjusting(true);
        }
        if (!bl) {
            n4 = 0;
            n3 = list.size();
            n2 = 1;
        } else {
            n4 = list.size() - 1;
            n3 = -1;
            n2 = -1;
        }
        for (int i2 = n4; i2 != n3; i2 += n2) {
            int n6;
            int n7;
            Object object;
            IlvRule[] ilvRuleArray;
            int n8;
            Object object2;
            Object object3;
            IlvGraphic ilvGraphic;
            Object e2 = list.get(i2);
            if (this.c(e2)) {
                ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e2);
                object3 = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                object2 = ((IlvCompositeGraphic)object3).getChildren();
                for (n8 = 0; n8 < ((IlvGraphic[])object2).length && object2[n8] != ilvGraphic; ++n8) {
                }
                do {
                    int n9 = bl ? n8 - 1 : n8 + 1;
                    ilvRuleArray = object2[n9];
                    object = ((IlvCompositeGraphic)object3).getConstraints();
                    Object object4 = object[n8];
                    Object object5 = object[n9];
                    IlvEventMap[] ilvEventMapArray = ((IlvCompositeGraphic)object3).getEventMaps();
                    IlvEventMap ilvEventMap = ilvEventMapArray != null && n8 < ilvEventMapArray.length ? ilvEventMapArray[n8] : null;
                    IlvEventMap ilvEventMap2 = ilvEventMapArray != null && n9 < ilvEventMapArray.length ? ilvEventMapArray[n9] : null;
                    IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic((IlvGraphic)object3);
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + n9 + "]", "@+" + ilvGraphic.getName());
                    if (object4 != null) {
                        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "constraints[" + n9 + "]", "@+" + ilvGraphic.getName() + "Attachment");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + n9 + "]");
                    }
                    if (ilvEventMap != null) {
                        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "eventMaps[" + n9 + "]", "@+" + ilvGraphic.getName() + "EventMap");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "eventMaps[" + n9 + "]");
                    }
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule, "children[" + n8 + "]", "@+" + ilvRuleArray.getName());
                    if (object5 != null) {
                        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "constraints[" + n8 + "]", "@+" + ilvRuleArray.getName() + "Attachment");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "constraints[" + n8 + "]");
                    }
                    if (ilvEventMap2 != null) {
                        ilvSymbolRuleModel.setDeclarationValue(ilvRule, "eventMaps[" + n8 + "]", "@+" + ilvRuleArray.getName() + "EventMap");
                    } else {
                        ilvSymbolRuleModel.removeDeclaration(ilvRule, "eventMaps[" + n8 + "]");
                    }
                    IlvLayoutManager ilvLayoutManager = ((IlvCompositeGraphic)object3).getLayout();
                    if (ilvLayoutManager instanceof IlvCenteredLayout) {
                        ((IlvCompositeGraphic)object3).setLayout(new IlvAttachmentLayout());
                    }
                    ((IlvCompositeGraphic)object3).setChildren(n9, ilvGraphic);
                    ((IlvCompositeGraphic)object3).setConstraints(n9, object4);
                    ((IlvCompositeGraphic)object3).setEventMaps(n9, ilvEventMap);
                    ((IlvCompositeGraphic)object3).setChildren(n8, (IlvGraphic)ilvRuleArray);
                    ((IlvCompositeGraphic)object3).setConstraints(n8, object5);
                    ((IlvCompositeGraphic)object3).setEventMaps(n8, ilvEventMap2);
                    if (!(ilvLayoutManager instanceof IlvCenteredLayout)) continue;
                    ((IlvCompositeGraphic)object3).setLayout(ilvLayoutManager);
                    ((IlvCompositeGraphic)object3).doLayout();
                } while (bl2 && !(bl ? --n8 == 0 : ++n8 == ((IlvGraphic[])object2).length - 1));
                continue;
            }
            if (IlvSymbolEditorDocument.isConditionSelection(e2)) {
                ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e2);
                object3 = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
                n8 = object3.getIndex((IlvRule)e2);
                int n10 = bl ? n8 - 1 : n8 + 1;
                IlvRule ilvRule = (IlvRule)object3.getChildAt(n10);
                ilvRuleArray = ilvSymbolRuleModel.getAllRules(true);
                for (int i3 = 0; i3 < ilvRuleArray.length; ++i3) {
                    if (ilvRuleArray[i3] == e2) {
                        ilvRuleArray[i3] = ilvRule;
                        continue;
                    }
                    if (ilvRuleArray[i3] != ilvRule) continue;
                    ilvRuleArray[i3] = (IlvRule)e2;
                }
                ilvSymbolRuleModel.setRules(ilvRuleArray);
                try {
                    object = ilvSymbolRuleModel.getRule("_fake_" + System.currentTimeMillis(), true);
                    if (object == null) continue;
                    ilvSymbolRuleModel.removeRule((IlvRule)object);
                }
                catch (IlvStylingException ilvStylingException) {}
                continue;
            }
            if (!this.d(e2)) continue;
            int n11 = this.a.getParameterCount();
            for (n7 = 0; n7 < n11 && e2 != this.a.getParameter(n7); ++n7) {
            }
            n8 = bl ? n7 - 1 : n7 + 1;
            object2 = this.a.getParameter(n8);
            IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray2 = new IlvPaletteSymbolParameter[n11];
            ilvPaletteSymbolParameterArray = new IlvPaletteSymbolParameter[n11];
            for (n6 = 0; n6 < n11; ++n6) {
                ilvPaletteSymbolParameterArray2[n6] = this.a.getParameter(n6);
                ilvPaletteSymbolParameterArray[n6] = this.a.getParameter(n6);
            }
            ilvPaletteSymbolParameterArray2[n8] = (IlvPaletteSymbolParameter)e2;
            ilvPaletteSymbolParameterArray2[n7] = object2;
            this.a.removeAllParameters();
            for (n6 = 0; n6 < n11; ++n6) {
                this.a.addParameter(ilvPaletteSymbolParameterArray2[n6]);
            }
        }
        if (n5 > 0) {
            this.b();
        }
        if (bl3) {
            ilvSymbolRuleModel.setAdjusting(false);
        } else {
            this.a(ilvPaletteSymbolParameterArray);
        }
    }

    private boolean b(boolean bl, boolean bl2) {
        List list = this.getSelection();
        if (list.size() == 0) {
            return false;
        }
        Object object = null;
        Object var5_5 = null;
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2;
            Object e2 = list.get(i2);
            if (var5_5 == null) {
                var5_5 = e2;
            }
            if (this.c(e2)) {
                int n3;
                if (!bl2) {
                    return false;
                }
                if (!this.c((Object)var5_5)) {
                    return false;
                }
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e2);
                if (!(ilvGraphic.getGraphicBag() instanceof IlvCompositeGraphic)) {
                    return false;
                }
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic.getGraphicBag();
                if (object == null) {
                    object = ilvCompositeGraphic;
                } else if (ilvCompositeGraphic != object) {
                    return false;
                }
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                for (n2 = 0; n2 < ilvGraphicArray.length && ilvGraphicArray[n2] != ilvGraphic; ++n2) {
                }
                if (bl && n2 == 0) {
                    return false;
                }
                for (n3 = ilvGraphicArray.length - 1; ilvGraphicArray[n3] == null && n3 > 0; --n3) {
                }
                if (bl || n2 != n3) continue;
                return false;
            }
            if (IlvSymbolEditorDocument.isConditionSelection(e2)) {
                if (bl2) {
                    return false;
                }
                if (!IlvSymbolEditorDocument.isConditionSelection(var5_5)) {
                    return false;
                }
                IlvGraphic ilvGraphic = ilvSymbolRuleModel.getGraphicFromRule((IlvRule)e2);
                IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(ilvGraphic);
                if (object == null) {
                    object = ilvRule;
                } else if (ilvRule != object) {
                    return false;
                }
                n2 = ilvRule.getIndex((IlvRule)e2);
                int n4 = ilvRule.getChildCount();
                if (bl && n2 == 0) {
                    return false;
                }
                if (bl || n2 != n4 - 1) continue;
                return false;
            }
            if (this.d(e2)) {
                int n5;
                if (bl2) {
                    return false;
                }
                if (!this.d((Object)var5_5)) {
                    return false;
                }
                int n6 = this.a.getParameterCount();
                for (n5 = 0; n5 < n6 && e2 != this.a.getParameter(n5); ++n5) {
                }
                if (bl && n5 == 0) {
                    return false;
                }
                if (bl || n5 != n6 - 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void c() {
        String[] stringArray;
        if (this.g != null) {
            this.beforeApply(this.g);
        }
        if (this.u) {
            if (this.z == null) {
                String[] stringArray2 = new String[1];
                stringArray2[0] = "selected";
                stringArray = stringArray2;
            } else {
                stringArray = new String[this.z.length + 1];
                System.arraycopy(this.z, 0, stringArray, 0, this.z.length);
                stringArray[this.z.length] = "selected";
            }
        } else {
            stringArray = this.z;
        }
        IlvCSSBeans.AppliedDeclarationHook appliedDeclarationHook = this.getRuleModel().getCSSBeans().getAppliedDeclarationHook();
        this.getRuleModel().getCSSBeans().setAppliedDeclarationHook(this.w);
        this.g = (IlvGraphic)this.getRuleModel().getCSSBeans().createBeanAndApplyDeclarations(this.p, this.f, this.f, this.g, stringArray);
        this.getRuleModel().getCSSBeans().setAppliedDeclarationHook(appliedDeclarationHook);
        this.g.setName(this.a.getClassName());
        this.afterApply(this.g, this.f);
        if (this.g instanceof IlvCompositeGraphic) {
            Serializable serializable;
            IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)this.g;
            if (this.s != null && !this.v && (serializable = ilvCompositeGraphic.getChildren(0)) != null) {
                serializable.move(this.s);
            }
            ilvCompositeGraphic.doLayout();
            if (this.t != null && this.v) {
                serializable = new IlvTransformer();
                if (this.x > -1) {
                    IlvTransformer.computeTransformer(SymbolEditorUtilities.getAttachmentBounds(((IlvCompositeGraphic)this.g).getChildren(this.x)), this.t, (IlvTransformer)serializable);
                } else {
                    IlvTransformer.computeTransformer(SymbolEditorUtilities.getAttachmentBounds(this.g), this.t, (IlvTransformer)serializable);
                }
                this.g.applyTransform((IlvTransformer)serializable);
            }
        }
        this.h = true;
    }

    protected void appliedDeclarations(IlvCSSModel ilvCSSModel, Object object, Object object2, String[] stringArray, Map map, Collection collection, int n2) {
    }

    protected void beforeApply(IlvGraphic ilvGraphic) {
        IlvCompositeGraphic ilvCompositeGraphic;
        IlvGraphic[] ilvGraphicArray;
        if (invisibleGhosts) {
            ilvGraphic.removeProperty(unrealizedProperty);
            ilvGraphic.removeProperty(invisibleProperty);
        }
        if (ilvGraphic instanceof IlvCompositeGraphic && !SymbolEditorUtilities.isSubSymbol(ilvGraphic) && (ilvGraphicArray = (ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic).getChildren()) != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                IlvGraphic ilvGraphic2 = ilvGraphicArray[i2];
                if (ilvGraphic2 == null) continue;
                ilvGraphic2.setGraphicBag(ilvCompositeGraphic);
                this.beforeApply(ilvGraphic2);
                if (this.getRuleModel().getMainRuleFromGraphic(ilvGraphic2) != null) continue;
                ilvCompositeGraphic.setChildren(i2, null);
            }
        }
    }

    protected void afterApply(IlvGraphic ilvGraphic, IlvRule ilvRule) {
        block10: {
            IlvCompositeGraphic ilvCompositeGraphic;
            IlvGraphic[] ilvGraphicArray;
            String string = ilvRule.getSelector().getID();
            if (string == null) {
                string = ilvRule.getSelector().getType();
            }
            ilvGraphic.setName(string);
            if (!(ilvGraphic instanceof IlvCompositeGraphic) || SymbolEditorUtilities.isSubSymbol(ilvGraphic) || (ilvGraphicArray = (ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphic).getChildren()) == null) break block10;
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                IlvRule ilvRule2;
                IlvGraphic ilvGraphic2;
                block11: {
                    String string2;
                    block12: {
                        ilvGraphic2 = ilvGraphicArray[i2];
                        if (ilvGraphic2 == null) continue;
                        ilvGraphic2.setGraphicBag(ilvCompositeGraphic);
                        if (i2 == 0 && ilvCompositeGraphic.getLayout() instanceof IlvAttachmentLayout) {
                            ((IlvAttachmentLayout)ilvCompositeGraphic.getLayout()).setAnchor(ilvCompositeGraphic.getAttachableGraphic(ilvGraphic2));
                        }
                        ilvRule2 = null;
                        string2 = ilvRule.getDeclarationValue("children[" + i2 + "]");
                        if (string2 == null) break block11;
                        if (string2.startsWith("@#")) break block12;
                        if (string2.startsWith("@+")) break block12;
                        if (!string2.startsWith("@=")) break block11;
                    }
                    String string3 = string2.substring(2);
                    try {
                        ilvRule2 = this.getRuleModel().getRule("#" + string3, false);
                    }
                    catch (IlvStylingException ilvStylingException) {
                        // empty catch block
                    }
                }
                if (ilvRule2 == null) {
                    throw new RuntimeException("Could not find the rule that created the element " + ilvGraphic2);
                }
                if (ilvGraphic2 instanceof IlvGeneralPath && !((IlvGeneralPath)ilvGraphic2).isTransformedShapeMode()) {
                    ((IlvGeneralPath)ilvGraphic2).setTransformedShapeMode(true);
                    ilvRule2.setDeclaration("transformedShapeMode", "true");
                }
                this.afterApply(ilvGraphic2, ilvRule2);
            }
        }
    }

    public void updatePosition() {
        IlvCompositeGraphic ilvCompositeGraphic;
        IlvGraphic ilvGraphic;
        if (this.g instanceof IlvCompositeGraphic && (ilvGraphic = (ilvCompositeGraphic = (IlvCompositeGraphic)this.g).getChildren(0)) != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox();
            this.s = new IlvPoint(ilvRect.x, ilvRect.y);
        }
    }

    public void updateBBox() {
        this.t = this.x > -1 ? SymbolEditorUtilities.getAttachmentBounds(((IlvCompositeGraphic)this.g).getChildren(this.x)) : SymbolEditorUtilities.getAttachmentBounds(this.g);
    }

    private IlvSymbolRuleModel b(String string) {
        String string2 = (String)j.get(string);
        if (string2 != null) {
            try {
                IlvSymbolRuleModel ilvSymbolRuleModel = (IlvSymbolRuleModel)Class.forName(string2).newInstance();
                ilvSymbolRuleModel.setDocument(this);
                return ilvSymbolRuleModel;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while creating rule model for component type " + string, exception);
            }
        }
        throw new RuntimeException("Cannot find rule model for component type " + string);
    }

    public void runMode() {
        this.clearSelection();
        String string = (String)this.getRuleModel().getCSSBeans().getDeclarationValue(this.p, this.f, this.f, "LinkConnectionRectangle", null, null);
        this.x = string != null ? Integer.parseInt(string) : -1;
        this.o = new IlvListenerList();
        this.p.a();
        this.z = null;
        this.applyChanges();
    }

    public void designMode() {
        this.p.b();
        if (invisibleGhosts) {
            this.z = designModePseudoClasses;
        }
        this.applyChanges();
    }

    public void setRunModeParameterValue(String string, Object object) {
        this.p.a(string, object);
        IlvPaletteSymbol ilvPaletteSymbol = this.getSymbol();
        this.a(ilvPaletteSymbol.getParameter(string), null, object);
    }

    public Object getRunModeParameterValue(String string) {
        return this.p.getValueAsObject(null, string);
    }

    private void a(String string, String string2) {
        if (string2 != null && string2.equals(string)) {
            return;
        }
        IlvRule[] ilvRuleArray = this.getRuleModel().getAllRules(true);
        boolean bl = false;
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            Object object;
            Object object2;
            IlvRule ilvRule = ilvRuleArray[i2];
            boolean bl2 = true;
            block1: while (bl2) {
                IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray;
                bl2 = false;
                object2 = ilvRule.getSelector();
                if (object2 == null || (ilvCSSAttributeSelectorArray = object2.getAttributes()) == null) continue;
                for (int i3 = 0; i3 < ilvCSSAttributeSelectorArray.length; ++i3) {
                    if (!ilvCSSAttributeSelectorArray[i3].getAttributeName().equals(string)) continue;
                    bl2 = true;
                    if (!bl) {
                        if (!this.d()) {
                            return;
                        }
                        bl = true;
                        this.getRuleModel().setAdjusting(true);
                    }
                    object = new IlvSelectorImpl((IlvSelectorImpl)object2);
                    ((Attribute)object.getAttributes()[i3]).setAttributeName(string2);
                    this.getRuleModel().setSelector(ilvRule, (IlvSelector)object);
                    String string3 = ilvRule.getName();
                    string3 = this.a(string3, string, string2);
                    ilvRule.setName(string3);
                    continue block1;
                }
            }
            object2 = ilvRule.getCSSDeclarations();
            if (object2 == null) continue;
            for (int i4 = 0; i4 < ((Object)object2).length; ++i4) {
                String string4 = object2[i4].getProperty();
                object = object2[i4].getValue();
                if (string4.endsWith("parameterToModify") && ((String)object).equals(string)) {
                    if (!bl) {
                        if (!this.d()) {
                            return;
                        }
                        bl = true;
                        this.getRuleModel().setAdjusting(true);
                    }
                    this.getRuleModel().setDeclarationValue(ilvRule, string4, string2);
                    continue;
                }
                if (this.b((String)object, "@" + string) < 0) continue;
                if (!bl) {
                    if (!this.d()) {
                        return;
                    }
                    bl = true;
                    this.getRuleModel().setAdjusting(true);
                }
                object = this.a((String)object, "@" + string, "@" + string2);
                this.getRuleModel().setDeclarationValue(ilvRule, string4, (String)object);
            }
        }
        if (bl) {
            this.getRuleModel().setAdjusting(false);
        }
    }

    private boolean c(String string) {
        IlvRule[] ilvRuleArray = this.getRuleModel().getAllRules(true);
        boolean bl = false;
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            Object object;
            IlvRule ilvRule = ilvRuleArray[i2];
            boolean bl2 = true;
            while (bl2) {
                IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray;
                bl2 = false;
                object = ilvRule.getSelector();
                if (object == null || (ilvCSSAttributeSelectorArray = object.getAttributes()) == null) continue;
                for (int i3 = 0; i3 < ilvCSSAttributeSelectorArray.length; ++i3) {
                    if (!ilvCSSAttributeSelectorArray[i3].getAttributeName().equals(string)) continue;
                    bl2 = true;
                    if (bl) continue;
                    if (!this.e()) {
                        return false;
                    }
                    bl = true;
                }
            }
            object = ilvRule.getCSSDeclarations();
            if (object == null) continue;
            for (int i4 = 0; i4 < ((Object)object).length; ++i4) {
                String string2 = object[i4].getProperty();
                String string3 = object[i4].getValue();
                if (string2.endsWith("parameterToModify") && string3.equals(string) && !bl) {
                    if (!this.e()) {
                        return false;
                    }
                    bl = true;
                }
                if (this.b(string3, "@" + string) < 0 || bl) continue;
                if (!this.e()) {
                    return false;
                }
                bl = true;
            }
        }
        return true;
    }

    private int b(String string, String string2) {
        char c2;
        int n2 = string.indexOf(string2);
        if (n2 >= 0 && string.length() > n2 + string2.length() && Character.isLetterOrDigit(c2 = string.charAt(n2 + string2.length()))) {
            return -1;
        }
        return n2;
    }

    private String a(String string, String string2, String string3) {
        int n2;
        while ((n2 = this.b(string, string2)) >= 0) {
            string = string.substring(0, n2) + string3 + string.substring(n2 + string2.length());
        }
        return string;
    }

    private boolean d() {
        if (!confirmRuleUpdateWhenParameterRenamed || this.ae) {
            return true;
        }
        JCheckBox jCheckBox = new JCheckBox(this.r.getString("SymbolEditor.ConfirmUpdateRules.DontAskMeAgain"));
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                confirmRuleUpdateWhenParameterRenamed = !((JCheckBox)itemEvent.getSource()).isSelected();
            }
        });
        String string = this.r.getString("SymbolEditor.ConfirmUpdateRules.Message");
        String string2 = this.r.getString("SymbolEditor.ConfirmUpdateRules.Title");
        int n2 = JOptionPane.showOptionDialog(null, new Object[]{string, jCheckBox}, string2, 0, 3, null, null, null);
        return n2 == 0;
    }

    private boolean e() {
        if (!confirmRuleUpdateWhenParameterDeleted || this.ae) {
            return true;
        }
        JCheckBox jCheckBox = new JCheckBox(this.r.getString("SymbolEditor.ConfirmUpdateRules.DontAskMeAgain"));
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                confirmRuleUpdateWhenParameterDeleted = !((JCheckBox)itemEvent.getSource()).isSelected();
            }
        });
        String string = this.r.getString("SymbolEditor.ConfirmDeleteRules.Message");
        String string2 = this.r.getString("SymbolEditor.ConfirmDeleteRules.Title");
        int n2 = JOptionPane.showOptionDialog(null, new Object[]{string, jCheckBox}, string2, 0, 3, null, null, null);
        return n2 == 0;
    }

    private static Image a(IlvGraphic ilvGraphic, int n2, int n3) {
        int n4;
        int n5;
        IlvRect ilvRect = ilvGraphic.boundingBox();
        if (n2 > 0 && n3 > 0) {
            n5 = n2;
            n4 = n3;
            float f2 = n5 / n4;
            if (ilvRect.width > ilvRect.height * f2) {
                ilvRect.y -= (ilvRect.width / f2 - ilvRect.height) / 2.0f;
                ilvRect.height = ilvRect.width / f2;
            } else {
                ilvRect.x -= (ilvRect.height * f2 - ilvRect.width) / 2.0f;
                ilvRect.width = ilvRect.height * f2;
            }
        } else {
            n5 = (int)Math.ceil(ilvRect.width);
            n4 = (int)Math.ceil(ilvRect.height);
        }
        BufferedImage bufferedImage = new BufferedImage(n5, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n5, n4);
        IlvTransformer ilvTransformer = new IlvTransformer();
        ilvRect.width += 1.0f;
        ilvRect.height += 1.0f;
        IlvTransformer.computeTransformer(ilvRect, new IlvRect(0.0f, 0.0f, n5, n4), ilvTransformer);
        ilvGraphic.draw(graphics2D, ilvTransformer);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File a(RenderedImage renderedImage, IlvPaletteSymbol ilvPaletteSymbol) {
        OutputStream outputStream = null;
        File file = null;
        try {
            file = File.createTempFile("tmp", ".txt");
            String string = ilvPaletteSymbol.getFullID();
            int n2 = string.indexOf(46);
            if (n2 > 0) {
                string = string.substring(n2 + 1);
            }
            string = string.replace('.', '_');
            File file2 = new File(file.getParentFile(), y + string + ".png");
            file2.deleteOnExit();
            file.delete();
            file = null;
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, null);
            pNGImageEncoder.encode(renderedImage);
            Image image = IlvImageUtil.loadImage(file2.getPath());
            if (image != null) {
                image.flush();
            }
            File file3 = file2;
            return file3;
        }
        catch (Exception exception) {
            File file4 = null;
            return file4;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            if (file != null) {
                file.delete();
            }
        }
    }

    private IlvRule[] b(IlvGraphic ilvGraphic) {
        int n2;
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        IlvRule[] ilvRuleArray = ilvSymbolRuleModel.getAllRulesFromGraphic(ilvGraphic);
        IlvRule[] ilvRuleArray2 = ilvSymbolRuleModel.getAdditionalRules(ilvRuleArray);
        IlvRule[] ilvRuleArray3 = IlvRuleUtils.getRulesFromId(ilvSymbolRuleModel.getAllRules(true), ilvGraphic.getName() + "Attachment");
        for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
            arrayList.add(ilvRuleArray[n2]);
        }
        for (n2 = 0; n2 < ilvRuleArray2.length; ++n2) {
            arrayList.add(ilvRuleArray2[n2]);
        }
        for (n2 = 0; n2 < ilvRuleArray3.length; ++n2) {
            arrayList.add(ilvRuleArray3[n2]);
        }
        return arrayList.toArray(new IlvRule[0]);
    }

    private IlvRule[] a(IlvRule ilvRule) {
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        arrayList.add(ilvRule);
        IlvRule[] ilvRuleArray = this.getRuleModel().getAdditionalRules(new IlvRule[]{ilvRule});
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            arrayList.add(ilvRuleArray[i2]);
        }
        return arrayList.toArray(new IlvRule[0]);
    }

    private static IlvRule[] b(IlvRule[] ilvRuleArray) {
        IlvRule[] ilvRuleArray2 = new IlvRule[ilvRuleArray.length];
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            ilvRuleArray2[i2] = ilvRuleArray[i2].copy();
        }
        return ilvRuleArray2;
    }

    private void a(IlvRule[] ilvRuleArray, String string, String string2, boolean bl) {
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            IlvCSSDeclaration[] ilvCSSDeclarationArray;
            IlvRule ilvRule = ilvRuleArray[i2];
            IlvSelector ilvSelector = ilvRule.getSelector();
            boolean bl2 = false;
            if (ilvSelector != null) {
                if ((string + "Attachment").equals(ilvSelector.getID())) {
                    if (!bl2 && bl) {
                        ilvSelector = ilvSelector.copy();
                    }
                    ilvSelector.setID(string2 + "Attachment");
                    if (!bl) {
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                    }
                    bl2 = true;
                }
                if ((string + "Layout").equals(ilvSelector.getID())) {
                    if (!bl2 && bl) {
                        ilvSelector = ilvSelector.copy();
                    }
                    ilvSelector.setID(string2 + "Layout");
                    if (!bl) {
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                    }
                    bl2 = true;
                }
                if (string.equals(ilvSelector.getID())) {
                    if (!bl2 && bl) {
                        ilvSelector = ilvSelector.copy();
                    }
                    ilvSelector.setID(string2);
                    if (!bl) {
                        ilvRule.updateRule();
                        ilvRule.updateWeights();
                    }
                    bl2 = true;
                }
            }
            if (bl2 && bl) {
                this.getRuleModel().setSelector(ilvRule, ilvSelector);
            }
            if ((ilvCSSDeclarationArray = ilvRule.getCSSDeclarations()) == null) continue;
            for (int i3 = 0; i3 < ilvCSSDeclarationArray.length; ++i3) {
                if (!(ilvCSSDeclarationArray[i3] instanceof Declaration)) continue;
                Declaration declaration = (Declaration)ilvCSSDeclarationArray[i3];
                this.a(ilvRule, declaration, string, string2, bl, "@+", "Attachment");
                this.a(ilvRule, declaration, string, string2, bl, "@+", "Layout");
                this.a(ilvRule, declaration, string, string2, bl, "@+", "");
                this.a(ilvRule, declaration, string, string2, bl, "@#", "Attachment");
                this.a(ilvRule, declaration, string, string2, bl, "@#", "Layout");
                this.a(ilvRule, declaration, string, string2, bl, "@#", "");
                this.a(ilvRule, declaration, string, string2, bl, "@=", "Attachment");
                this.a(ilvRule, declaration, string, string2, bl, "@=", "Layout");
                this.a(ilvRule, declaration, string, string2, bl, "@=", "");
                this.a(ilvRule, declaration, string, string2, bl, "", "");
            }
        }
    }

    private void a(IlvRule ilvRule, Declaration declaration, String string, String string2, boolean bl, String string3, String string4) {
        if ((string3 + string + string4).equals(declaration.getValue()) && declaration instanceof Declaration) {
            String string5 = string3 + string2 + string4;
            if (bl) {
                this.getRuleModel().setDeclarationValue(ilvRule, declaration.getProperty(), string5);
            } else {
                declaration.setTarget(string5);
            }
        }
    }

    private void c(IlvRule[] ilvRuleArray) {
        boolean bl = true;
        IlvRule[] ilvRuleArray2 = this.getRuleModel().getAllRules(true);
        block0: while (bl) {
            bl = false;
            for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                IlvRule ilvRule = ilvRuleArray[i2];
                if (ilvRule.getSelector() == null || ilvRule.getSelector().getID() == null || SymbolEditorUtilities.hasCondition(ilvRule)) continue;
                String string = ilvRule.getSelector().getID();
                IlvRule[] ilvRuleArray3 = IlvRuleUtils.getRulesFromId(ilvRuleArray2, string);
                if (ilvRuleArray3 != null && ilvRuleArray3.length > 0) {
                    String string2 = SymbolEditorUtilities.getUniqueRuleID(this, ilvRuleArray, string);
                    this.a(ilvRuleArray, string, string2, false);
                    bl = true;
                    continue block0;
                }
                if (bl) continue block0;
            }
        }
    }

    private boolean b(Object object) {
        return object instanceof IlvPaletteSymbol;
    }

    private boolean c(Object object) {
        return object instanceof IlvRule && !SymbolEditorUtilities.hasCondition((IlvRule)object);
    }

    public static boolean isConditionSelection(Object object) {
        return object instanceof IlvRule && SymbolEditorUtilities.hasCondition((IlvRule)object);
    }

    private boolean d(Object object) {
        return object instanceof IlvPaletteSymbolParameter;
    }

    private boolean e(Object object) {
        return IlvSymbolTreeRoot.elementsNode.equals(object);
    }

    private boolean f(Object object) {
        return IlvSymbolTreeRoot.parametersNode.equals(object);
    }

    private IlvRule a(IlvRule ilvRule, boolean bl) {
        IlvRule ilvRule2 = this.q.editCondition(ilvRule, this.r.getString("SymbolEditor." + (bl ? "Change" : "New") + "ConditionDialog.Title"), !bl);
        if (ilvRule2 != null) {
            try {
                IlvRule ilvRule3 = this.getRuleModel().getRule(ilvRule2.getSelectorString(), false);
                if (ilvRule3 != null && ilvRule3 != ilvRule) {
                    JOptionPane.showMessageDialog(null, this.r.getString("SymbolEditor.ConditionExistsDialog.Message"), this.r.getString("SymbolEditor.ConditionExistsDialog.Title"), 0);
                    return null;
                }
            }
            catch (IlvStylingException ilvStylingException) {
                // empty catch block
            }
        }
        return ilvRule2;
    }

    public boolean canAlign() {
        return this.a(2);
    }

    public boolean canDistribute() {
        return this.a(3);
    }

    public void alignLeft() {
        this.a(1, false);
    }

    public void alignRight() {
        this.a(2, false);
    }

    public void alignTop() {
        this.a(4, false);
    }

    public void alignBottom() {
        this.a(8, false);
    }

    public void alignVerticalCenter() {
        this.a(64, false);
    }

    public void alignHorizontalCenter() {
        this.a(32, false);
    }

    public void distributeHorizontally() {
        this.a(96, false);
    }

    public void distributeVertically() {
        this.a(128, false);
    }

    public void sameWidth() {
        this.a(96, true);
    }

    public void sameHeight() {
        this.a(128, true);
    }

    private void a(final int n2, boolean bl) {
        Object object;
        int n3;
        IlvRect ilvRect = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        List list = this.getSelection();
        for (n3 = 0; n3 < list.size(); ++n3) {
            Object e2 = list.get(n3);
            if (!this.c(e2)) continue;
            object = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
            arrayList.add((IlvGraphic)object);
            IlvRect ilvRect2 = ((IlvGraphic)object).boundingBox();
            if (ilvRect2 == null) continue;
            if (ilvRect == null) {
                ilvRect = ilvRect2;
            } else {
                ilvRect.add(ilvRect2);
            }
            if (n2 == 96) {
                f2 += ilvRect2.width;
            } else if (n2 == 128) {
                f2 += ilvRect2.height;
            }
            if (n3 != 0) continue;
            if (n2 == 96) {
                f3 = ilvRect2.width;
                continue;
            }
            if (n2 != 128) continue;
            f3 = ilvRect2.height;
        }
        n3 = arrayList.size();
        if (n3 < 2) {
            return;
        }
        float f4 = n2 == 96 ? (ilvRect.width - f2) / (float)(n3 - 1) : (n2 == 128 ? (ilvRect.height - f2) / (float)(n3 - 1) : 0.0f);
        if (n2 == 96 || n2 == 128) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    IlvRect ilvRect = ((IlvGraphic)object).boundingBox();
                    IlvRect ilvRect2 = ((IlvGraphic)object2).boundingBox();
                    if (n2 == 96) {
                        return (int)(ilvRect.x - ilvRect2.x);
                    }
                    return (int)(ilvRect.y - ilvRect2.y);
                }
            });
        }
        object = this.getRuleModel();
        ((IlvRuleModelImpl)object).setAdjusting(true);
        float f5 = 0.0f;
        for (int i2 = 0; i2 < n3; ++i2) {
            IlvGraphic ilvGraphic = (IlvGraphic)arrayList.get(i2);
            IlvRect ilvRect3 = ilvGraphic.boundingBox();
            IlvRect ilvRect4 = new IlvRect(ilvRect3);
            if (ilvRect3 == null) continue;
            switch (n2) {
                case 1: {
                    ilvRect3.x = ilvRect.x;
                    break;
                }
                case 2: {
                    ilvRect3.x = ilvRect.x + ilvRect.width - ilvRect3.width;
                    break;
                }
                case 4: {
                    ilvRect3.y = ilvRect.y;
                    break;
                }
                case 8: {
                    ilvRect3.y = ilvRect.y + ilvRect.height - ilvRect3.height;
                    break;
                }
                case 32: {
                    ilvRect3.x = ilvRect.x + ilvRect.width / 2.0f - ilvRect3.width / 2.0f;
                    break;
                }
                case 64: {
                    ilvRect3.y = ilvRect.y + ilvRect.height / 2.0f - ilvRect3.height / 2.0f;
                    break;
                }
                case 96: {
                    if (bl) {
                        ilvRect3.width = f3;
                        break;
                    }
                    if (i2 > 0 && i2 < n3 - 1) {
                        ilvRect3.x = f5 + f4;
                    }
                    f5 = ilvRect3.x + ilvRect3.width;
                    break;
                }
                case 128: {
                    if (bl) {
                        ilvRect3.height = f3;
                        break;
                    }
                    if (i2 > 0 && i2 < n3 - 1) {
                        ilvRect3.y = f5 + f4;
                    }
                    f5 = ilvRect3.y + ilvRect3.height;
                }
            }
            if (bl) {
                ilvGraphic.resize(ilvRect3.width, ilvRect3.height);
            } else {
                ilvGraphic.move(ilvRect3.x, ilvRect3.y);
            }
            IlvRule ilvRule = ((IlvSymbolRuleModel)object).getMainRuleFromGraphic(ilvGraphic);
            ((IlvSymbolRuleModel)object).updateGeometry(ilvGraphic, ilvRule, !bl, new IlvPoint(ilvRect3.x - ilvRect4.x, ilvRect3.y - ilvRect4.y));
        }
        ((IlvRuleModelImpl)object).setAdjusting(false);
    }

    public boolean canFlipRotate() {
        List list = this.getSelection();
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (this.c(e2)) {
                IlvGraphic ilvGraphic = this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                if (!(ilvGraphic instanceof IlvGeneralPath)) {
                    return false;
                }
                ++n2;
                continue;
            }
            return false;
        }
        return n2 > 0;
    }

    public void flipHorizontal() {
        this.a(-1, 1, 0);
    }

    public void flipVertical() {
        this.a(1, -1, 0);
    }

    public void rotateRight() {
        this.a(1, 1, 1);
    }

    public void rotateLeft() {
        this.a(1, 1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2, int n3, int n4) {
        List list = this.getSelection();
        IlvSymbolRuleModel ilvSymbolRuleModel = this.getRuleModel();
        try {
            ilvSymbolRuleModel.setAdjusting(true);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object e2 = list.get(i2);
                if (!this.c(e2)) continue;
                IlvGeneralPath ilvGeneralPath = (IlvGeneralPath)this.getRuleModel().getGraphicFromRule((IlvRule)e2);
                IlvRect ilvRect = ilvGeneralPath.boundingBox();
                IlvTransformer ilvTransformer = new IlvTransformer();
                float f2 = ilvRect.x + ilvRect.width / 2.0f;
                float f3 = ilvRect.y + ilvRect.height / 2.0f;
                ilvTransformer.scale(f2, f3, n2, n3);
                ilvTransformer.rotate(f2, f3, n4 * 90);
                boolean bl = ilvGeneralPath.isTransformedShapeMode();
                ilvGeneralPath.setTransformedShapeMode(false);
                ilvGeneralPath.applyTransform(ilvTransformer);
                boolean bl2 = ilvGeneralPath.isPointEditionAllowed();
                ilvGeneralPath.setPointEditionAllowed(true);
                ilvSymbolRuleModel.updateGeometry(ilvGeneralPath, (IlvRule)e2, false, null);
                ilvGeneralPath.setPointEditionAllowed(bl2);
                ilvGeneralPath.setTransformedShapeMode(bl);
            }
        }
        finally {
            ilvSymbolRuleModel.setAdjusting(false);
        }
    }

    public UndoManager getUndoManager() {
        return this.aa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.aa == null || !this.canUndo()) {
            return;
        }
        boolean bl = this.ae;
        ++this.ac;
        try {
            this.ae = true;
            this.getRuleModel().setAdjusting(true);
            this.aa.undo();
        }
        finally {
            this.getRuleModel().setAdjusting(false);
            this.a((List)null);
            this.ae = bl;
        }
    }

    public boolean canUndo() {
        return this.aa != null && this.aa.canUndo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.aa == null || !this.canRedo()) {
            return;
        }
        boolean bl = this.ae;
        ++this.ac;
        try {
            this.ae = true;
            this.getRuleModel().setAdjusting(true);
            this.aa.redo();
        }
        finally {
            this.getRuleModel().setAdjusting(false);
            this.a((List)null);
            this.ae = bl;
        }
    }

    public boolean canRedo() {
        return this.aa != null && this.aa.canRedo();
    }

    public void beginAggregateUndoableEdits(String string) {
        ++this.ac;
        if (this.ab == null) {
            this.ab = new SymbolCompoundEdit(string);
            ++this.ad;
        }
    }

    public void endAggregateUndoableEdits() {
        ++this.ac;
        if (this.ab != null && !this.getRuleModel().isAdjusting() && this.ad == 1) {
            this.ab.end();
            this.aa.addEdit(this.ab);
            this.ab = null;
            --this.ad;
            IlvSymbolEditorAction.updateActions(this);
        }
    }

    private void a(EventObject eventObject) {
        if (this.aa == null || this.ae) {
            return;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (eventObject instanceof CSSChangeEvent) {
            CSSChangeEvent cSSChangeEvent = (CSSChangeEvent)eventObject;
            if (cSSChangeEvent.getMode() == CSSChangeEvent.ADD) {
                abstractUndoableEdit = cSSChangeEvent.getDeclarations() == null ? new AddRuleEdit((CSSChangeEvent.Add)cSSChangeEvent) : new AddDeclarationsEdit((CSSChangeEvent.Add)cSSChangeEvent);
            } else if (cSSChangeEvent.getMode() == CSSChangeEvent.DELETE) {
                abstractUndoableEdit = cSSChangeEvent.getDeclarations() == null ? new RemoveRuleEdit((CSSChangeEvent.Remove)cSSChangeEvent) : new RemoveDeclarationsEdit((CSSChangeEvent.Remove)cSSChangeEvent);
            } else if (cSSChangeEvent.getMode() == CSSChangeEvent.SELECTOR_CHANGE) {
                abstractUndoableEdit = new SelectorEdit((CSSChangeEvent.SelectorChange)cSSChangeEvent);
            }
        } else if (eventObject instanceof SymbolChangedEvent) {
            if (!"topLevelGraphic".equals(((SymbolChangedEvent)eventObject).getProperty())) {
                abstractUndoableEdit = new SymbolEdit((SymbolChangedEvent)eventObject);
            }
        } else if (eventObject instanceof ParameterListChangedEvent) {
            ParameterListChangedEvent parameterListChangedEvent = (ParameterListChangedEvent)eventObject;
            if (parameterListChangedEvent.getType() == 1) {
                abstractUndoableEdit = new AddParameterEdit(parameterListChangedEvent.getParameter());
            } else if (parameterListChangedEvent.getType() == 2) {
                abstractUndoableEdit = new RemoveParameterEdit(parameterListChangedEvent.getParameter());
            } else if (parameterListChangedEvent.getType() == 3) {
                abstractUndoableEdit = new MoveParametersEdit(parameterListChangedEvent.getOldParameters());
            }
        }
        if (eventObject instanceof CSSChangeEvent) {
            if (((CSSChangeEvent)eventObject).isAdjusting()) {
                if (this.ab == null) {
                    this.ab = new SymbolCompoundEdit("");
                }
                if (abstractUndoableEdit != null) {
                    this.ab.addEdit(abstractUndoableEdit);
                }
            } else if (((CSSChangeEvent)eventObject).getMode() == CSSChangeEvent.ADJUSTMENT_END && !this.getRuleModel().isAdjusting() && this.ad == 0) {
                this.ab.end();
                this.aa.addEdit(this.ab);
                this.ab = null;
            } else if (abstractUndoableEdit != null) {
                if (this.ab != null) {
                    this.ab.addEdit(abstractUndoableEdit);
                } else {
                    this.aa.addEdit(abstractUndoableEdit);
                }
            }
        } else if (abstractUndoableEdit != null) {
            if (this.ab != null) {
                this.ab.addEdit(abstractUndoableEdit);
            } else {
                this.aa.addEdit(abstractUndoableEdit);
            }
        }
    }

    private void b(List list) {
        if (this.aa == null || this.ae) {
            return;
        }
        SelectionEdit selectionEdit = new SelectionEdit(list, this.getSelection());
        if (this.ab != null) {
            this.ab.addEdit(selectionEdit);
        } else {
            this.aa.addEdit(selectionEdit);
        }
    }

    private void a(IlvRule ilvRule, String string, String string2) {
        if (this.aa == null) {
            return;
        }
        RenameEdit renameEdit = new RenameEdit(ilvRule, string, string2);
        if (this.ab != null) {
            this.ab.addEdit(renameEdit);
        } else {
            this.aa.addEdit(renameEdit);
        }
    }

    public void customizerChangedStyle(IlvCSSDeclaration[] ilvCSSDeclarationArray, IlvRule ilvRule) {
        if (ilvRule != null) {
            boolean bl = this.ae;
            this.ae = true;
            this.getRuleModel().removeRule(ilvRule);
            this.ae = bl;
        }
        if (this.aa == null) {
            return;
        }
        if (this.ae) {
            IlvSymbolEditorAction.updateActions(this);
            return;
        }
        StyleChangeEdit styleChangeEdit = new StyleChangeEdit(ilvCSSDeclarationArray, ilvRule);
        this.aa.addEdit(styleChangeEdit);
        IlvSymbolEditorAction.updateActions(this);
    }

    private String d(String string) {
        if (string.length() > 10) {
            string = string.substring(0, 10) + "...";
        }
        return string;
    }

    public String getDeclarationUndoPresentationName(String string, String string2) {
        return MessageFormat.format(this.getString("SymbolEditor.Undo.Change"), string, this.d(string2));
    }

    public void setSelected(boolean bl) {
        if (bl != this.u) {
            this.u = bl;
            if (!this.getRuleModel().isAdjusting()) {
                this.applyChanges();
            }
        }
    }

    public boolean isSelected() {
        return this.u;
    }

    private boolean b(IlvRule ilvRule) {
        String[] stringArray = ilvRule.getPseudoClasses();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!"selected".equals(stringArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    boolean a() {
        return this.v;
    }

    private void a(File file) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isDirectory()) {
                this.a(file2);
            }
            file2.delete();
        }
    }

    static {
        j.put(FrameworkComponentType, "ilog.views.symbology.editor.rules.IlvSymbolRuleModel");
        j.put(DiagrammerComponentType, "ilog.views.symbology.editor.diagrammer.rules.DiagrammerSymbolRuleModel");
        j.put(GanttComponentType, "ilog.views.symbology.editor.gantt.rules.GanttSymbolRuleModel");
        IlvCSSWriter.setIgnoredProperty(IlvText.class, "attributedLabel");
    }

    private class StyleChangeEdit
    extends AbstractUndoableEdit {
        private UndoableEdit a;
        private String b;
        private IlvRule c;

        public StyleChangeEdit(IlvCSSDeclaration[] ilvCSSDeclarationArray, IlvRule ilvRule) {
            try {
                if (ilvCSSDeclarationArray != null && ilvCSSDeclarationArray.length == 1) {
                    String string = ilvCSSDeclarationArray[0].getProperty();
                    String string2 = ilvCSSDeclarationArray[0].getValue();
                    if (string2.startsWith("@#") || string2.startsWith("@+") || string2.startsWith("@=")) {
                        string2 = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.ComplexValue");
                    }
                    this.b = IlvSymbolEditorDocument.this.getDeclarationUndoPresentationName(string, string2);
                } else {
                    this.b = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.StyleChanges");
                }
                this.c = ilvRule;
            }
            catch (Exception exception) {
                this.b = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.StyleChanges");
                this.c = ilvRule;
            }
        }

        public boolean replaceEdit(UndoableEdit undoableEdit) {
            this.a = undoableEdit;
            return true;
        }

        public String getPresentationName() {
            return this.b;
        }

        public boolean isSignificant() {
            return this.a.isSignificant();
        }

        public void undo() throws CannotUndoException {
            if (this.c != null) {
                IlvSymbolEditorDocument.this.getRuleModel().addRule(this.c);
            }
            this.a.undo();
            IlvSymbolEditorAction.updateActions(IlvSymbolEditorDocument.this);
        }

        public void redo() throws CannotRedoException {
            this.a.redo();
            if (this.c != null) {
                IlvSymbolEditorDocument.this.getRuleModel().removeRule(this.c);
            }
            IlvSymbolEditorAction.updateActions(IlvSymbolEditorDocument.this);
        }

        public boolean canRedo() {
            return this.a.canRedo();
        }

        public boolean canUndo() {
            return this.a.canUndo();
        }
    }

    private class SelectionEdit
    extends AbstractUndoableEdit {
        private List a;
        private List b;

        public SelectionEdit(List list, List list2) {
            this.a = list;
            this.b = list2;
        }

        public boolean isSignificant() {
            return false;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolEditorDocument.this.a(this.a, false);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.a(this.b, false);
        }
    }

    private class MoveParametersEdit
    extends AbstractUndoableEdit {
        IlvPaletteSymbolParameter[] a;
        IlvPaletteSymbolParameter[] b;

        public MoveParametersEdit(IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray) {
            this.a = ilvPaletteSymbolParameterArray;
            int n2 = IlvSymbolEditorDocument.this.a.getParameterCount();
            this.b = new IlvPaletteSymbolParameter[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b[i2] = IlvSymbolEditorDocument.this.a.getParameter(i2);
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.a(this.a);
            IlvSymbolEditorDocument.this.a(this.b);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.a(this.b);
            IlvSymbolEditorDocument.this.a(this.a);
        }

        private void a(IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray) {
            IlvSymbolEditorDocument.this.a.removeAllParameters();
            for (int i2 = 0; i2 < ilvPaletteSymbolParameterArray.length; ++i2) {
                IlvSymbolEditorDocument.this.a.addParameter(ilvPaletteSymbolParameterArray[i2]);
            }
        }
    }

    private class RemoveParameterEdit
    extends AbstractUndoableEdit {
        IlvPaletteSymbolParameter a;

        public RemoveParameterEdit(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
            this.a = ilvPaletteSymbolParameter;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolEditorDocument.this.addParameter(this.a);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.removeParameter(this.a);
        }
    }

    private class AddParameterEdit
    extends AbstractUndoableEdit {
        IlvPaletteSymbolParameter a;

        public AddParameterEdit(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
            this.a = ilvPaletteSymbolParameter;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolEditorDocument.this.removeParameter(this.a);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolEditorDocument.this.addParameter(this.a);
        }
    }

    private class SymbolEdit
    extends AbstractUndoableEdit {
        private Object a;
        private String b;
        private Object c;
        private Object d;
        private String e;

        public SymbolEdit(SymbolChangedEvent symbolChangedEvent) {
            this.a = symbolChangedEvent.getChangedObject();
            this.b = symbolChangedEvent.getProperty();
            this.c = symbolChangedEvent.getOldValue();
            this.d = symbolChangedEvent.getNewValue();
            this.e = MessageFormat.format(IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.Change"), this.b, this.d instanceof String ? IlvSymbolEditorDocument.this.d((String)this.d) : IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.ComplexValue"));
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.a(true);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.a(false);
        }

        private void a(boolean bl) {
            Object object;
            Object object2 = object = bl ? this.c : this.d;
            if (this.b.equals("name")) {
                if (this.a == IlvSymbolEditorDocument.this.a) {
                    IlvSymbolEditorDocument.this.renameSymbol((String)object);
                } else if (this.a instanceof IlvPaletteSymbolParameter) {
                    IlvSymbolEditorDocument.this.renameParameter((IlvPaletteSymbolParameter)this.a, (String)object);
                }
            } else {
                String string = Character.toUpperCase(this.b.charAt(0)) + this.b.substring(1);
                String string2 = "get" + string;
                String string3 = "set" + string;
                try {
                    Class clazz;
                    Method method = this.a.getClass().getMethod(string2, null);
                    Object object3 = method.invoke(this.a, (Object[])null);
                    if (this.b.equals("value")) {
                        clazz = aj == null ? (aj = IlvSymbolEditorDocument.class$("java.lang.Object")) : aj;
                    } else if (this.d != null) {
                        clazz = this.d.getClass();
                    } else if (this.c != null) {
                        clazz = this.c.getClass();
                    } else {
                        throw new RuntimeException("Cannot determine type of property " + this.b);
                    }
                    Method method2 = this.a.getClass().getMethod(string3, clazz);
                    method2.invoke(this.a, object);
                    IlvSymbolEditorDocument.this.fireSymbolChanged(this.a, this.b, object3, object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        public String getPresentationName() {
            return this.e;
        }
    }

    private class RenameEdit
    extends AbstractUndoableEdit {
        private IlvRule a;
        private String b;
        private String c;
        private String d;

        public RenameEdit(IlvRule ilvRule, String string, String string2) {
            this.a = ilvRule;
            this.b = string;
            this.c = string2;
            this.d = IlvSymbolEditorDocument.this.getString("SymbolEditor.Undo.Rename");
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvGraphic ilvGraphic = IlvSymbolEditorDocument.this.getRuleModel().getGraphicFromRule(this.a);
            IlvSymbolEditorDocument.this.a(ilvGraphic, this.b, false);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvGraphic ilvGraphic = IlvSymbolEditorDocument.this.getRuleModel().getGraphicFromRule(this.a);
            IlvSymbolEditorDocument.this.a(ilvGraphic, this.c, false);
        }

        public String getPresentationName() {
            return this.d;
        }
    }

    private class SelectorEdit
    extends AbstractUndoableEdit {
        private IlvRule a;
        private IlvSelector b;
        private IlvSelector c;

        public SelectorEdit(CSSChangeEvent.SelectorChange selectorChange) {
            this.a = selectorChange.getRule();
            this.b = selectorChange.getOldSelector().copy();
            this.c = this.a.getSelector().copy();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            ilvSymbolRuleModel.setSelector(this.a, this.b.copy());
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            ilvSymbolRuleModel.setSelector(this.a, this.c.copy());
        }
    }

    private class RemoveRuleEdit
    extends AbstractUndoableEdit {
        private int a;
        private ArrayList b;

        public RemoveRuleEdit(CSSChangeEvent.Remove remove) {
            this.a = IlvSymbolEditorDocument.this.ac;
            this.b = new ArrayList();
            this.b.add(remove.getRule());
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                IlvRule ilvRule = (IlvRule)this.b.get(i2);
                ilvSymbolRuleModel.addRule(ilvRule);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                IlvRule ilvRule = (IlvRule)this.b.get(i2);
                ilvSymbolRuleModel.removeRule(ilvRule);
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            AddRuleEdit addRuleEdit;
            if (undoableEdit instanceof AddRuleEdit && this.a == (addRuleEdit = (AddRuleEdit)undoableEdit).a) {
                for (int i2 = 0; i2 < addRuleEdit.b.size(); ++i2) {
                    this.b.add(addRuleEdit.b.get(i2));
                }
                return true;
            }
            return false;
        }
    }

    private class AddRuleEdit
    extends AbstractUndoableEdit {
        private int a;
        private ArrayList b;

        public AddRuleEdit(CSSChangeEvent.Add add) {
            this.a = IlvSymbolEditorDocument.this.ac;
            this.b = new ArrayList();
            this.b.add(add.getRule());
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                IlvRule ilvRule = (IlvRule)this.b.get(i2);
                ilvSymbolRuleModel.removeRule(ilvRule);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                IlvRule ilvRule = (IlvRule)this.b.get(i2);
                ilvSymbolRuleModel.addRule(ilvRule);
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof AddRuleEdit) {
                AddRuleEdit addRuleEdit = (AddRuleEdit)undoableEdit;
                if (this.a == addRuleEdit.a) {
                    for (int i2 = 0; i2 < addRuleEdit.b.size(); ++i2) {
                        this.b.add(addRuleEdit.b.get(i2));
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class RemoveDeclarationsEdit
    extends AbstractUndoableEdit {
        private IlvRule a;
        private ArrayList b = new ArrayList();
        private ArrayList c = new ArrayList();

        public RemoveDeclarationsEdit(CSSChangeEvent.Remove remove) {
            this.a = remove.getRule();
            Declaration[] declarationArray = remove.getDeclarations();
            if (declarationArray != null) {
                for (int i2 = 0; i2 < declarationArray.length; ++i2) {
                    String string = declarationArray[i2].getProperty();
                    String string2 = declarationArray[i2].getValue();
                    this.b.add(string);
                    this.c.add(string2);
                }
            }
        }

        public void undo() throws CannotUndoException {
            super.undo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                String string = (String)this.b.get(i2);
                ilvSymbolRuleModel.setDeclarationValue(this.a, string, (String)this.c.get(i2));
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                String string = (String)this.b.get(i2);
                ilvSymbolRuleModel.removeDeclaration(this.a, string);
            }
        }

        public String getPresentationName() {
            return super.getPresentationName();
        }
    }

    private class AddDeclarationsEdit
    extends AbstractUndoableEdit {
        private int a;
        private HashMap b;

        public AddDeclarationsEdit(CSSChangeEvent.Add add) {
            this.a = IlvSymbolEditorDocument.this.ac;
            this.b = new HashMap();
            Declarations declarations = new Declarations(add);
            this.b.put(declarations.a, declarations);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Iterator iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                ((Declarations)iterator.next()).undo();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Iterator iterator = this.b.values().iterator();
            while (iterator.hasNext()) {
                ((Declarations)iterator.next()).redo();
            }
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof AddDeclarationsEdit) {
                AddDeclarationsEdit addDeclarationsEdit = (AddDeclarationsEdit)undoableEdit;
                if (this.a == addDeclarationsEdit.a) {
                    Iterator iterator = addDeclarationsEdit.b.values().iterator();
                    while (iterator.hasNext()) {
                        Declarations declarations = (Declarations)iterator.next();
                        Declarations declarations2 = (Declarations)this.b.get(declarations.a);
                        if (declarations2 != null) {
                            declarations2.b(declarations);
                            continue;
                        }
                        this.b.put(declarations.a, declarations);
                    }
                    return true;
                }
            }
            return false;
        }

        private class Declarations {
            private IlvRule a;
            private ArrayList b = new ArrayList();
            private ArrayList c = new ArrayList();
            private ArrayList d = new ArrayList();

            public Declarations(CSSChangeEvent.Add add) {
                this.a = add.getRule();
                Declaration[] declarationArray = add.getDeclarations();
                if (declarationArray != null) {
                    for (int i2 = 0; i2 < declarationArray.length; ++i2) {
                        String string = declarationArray[i2].getProperty();
                        String string2 = this.a.getDeclarationValue(string);
                        String string3 = new String();
                        this.a.setDeclarationValue(string, string3);
                        this.a.resetModified(string);
                        String string4 = this.a.getDeclarationValue(string);
                        if (string4 == string3) {
                            string4 = null;
                        }
                        this.a.setDeclaration(string, string2);
                        this.b.add(string);
                        this.c.add(string4);
                        this.d.add(string2);
                    }
                }
            }

            public void undo() {
                IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    String string = (String)this.b.get(i2);
                    if (this.c.get(i2) != null) {
                        ilvSymbolRuleModel.setDeclarationValue(this.a, string, (String)this.c.get(i2));
                        this.a.resetModified(string);
                        this.a.setDeclarationValue(string, (String)this.c.get(i2));
                        continue;
                    }
                    ilvSymbolRuleModel.removeDeclaration(this.a, string);
                }
            }

            public void redo() {
                IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorDocument.this.getRuleModel();
                for (int i2 = 0; i2 < this.b.size(); ++i2) {
                    String string = (String)this.b.get(i2);
                    ilvSymbolRuleModel.setDeclarationValue(this.a, string, (String)this.d.get(i2));
                    this.a.resetModified(string);
                    this.a.setDeclarationValue(string, (String)this.d.get(i2));
                }
            }

            private void b(Declarations declarations) {
                for (int i2 = 0; i2 < declarations.b.size(); ++i2) {
                    int n2 = this.b.indexOf(declarations.b.get(i2));
                    if (n2 >= 0) {
                        this.d.set(n2, declarations.d.get(i2));
                        continue;
                    }
                    this.b.add(declarations.b.get(i2));
                    this.c.add(declarations.c.get(i2));
                    this.d.add(declarations.d.get(i2));
                }
            }
        }
    }

    private class SymbolCompoundEdit
    extends CompoundEdit {
        private int a;
        private String b;

        public SymbolCompoundEdit(String string) {
            this.a = IlvSymbolEditorDocument.this.ac;
            this.b = string;
        }

        public String getPresentationName() {
            if (this.b == null) {
                return this.a().getPresentationName();
            }
            return this.b;
        }

        private UndoableEdit a() {
            UndoableEdit undoableEdit = null;
            Iterator<UndoableEdit> iterator = this.edits.iterator();
            while (iterator.hasNext()) {
                UndoableEdit undoableEdit2 = iterator.next();
                if (!(undoableEdit2 instanceof SymbolEdit)) continue;
                undoableEdit = undoableEdit2;
            }
            return undoableEdit != null ? undoableEdit : this.lastEdit();
        }

        public String getUndoPresentationName() {
            String string = this.getPresentationName();
            if (string == null) {
                return this.a().getUndoPresentationName();
            }
            string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + string : UIManager.getString("AbstractUndoableEdit.undoText");
            return string;
        }

        public String getRedoPresentationName() {
            String string = this.getPresentationName();
            if (string == null) {
                return this.a().getRedoPresentationName();
            }
            string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + string : UIManager.getString("AbstractUndoableEdit.redoText");
            return string;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof SymbolCompoundEdit) {
                SymbolCompoundEdit symbolCompoundEdit = (SymbolCompoundEdit)undoableEdit;
                if (this.a == symbolCompoundEdit.a && this.edits.size() == 1 && symbolCompoundEdit.edits.size() == 1 && this.edits.get(0) instanceof AddDeclarationsEdit && symbolCompoundEdit.edits.get(0) instanceof AddDeclarationsEdit) {
                    this.edits.get(0).addEdit(symbolCompoundEdit.edits.get(0));
                    return true;
                }
            }
            return super.addEdit(undoableEdit);
        }
    }

    private class VisibleFunction
    extends IlvCSSFunction {
        private VisibleFunction() {
        }

        public String getName() {
            return "visible";
        }

        public Object call(Object[] objectArray, Class clazz, IlvCSSModel ilvCSSModel, Object object, Object object2, Object object3) {
            ((IlvGraphic)object2).setProperty(IlvSymbolEditorDocument.invisibleProperty, Boolean.FALSE.equals(objectArray[0]) ? Boolean.TRUE : null);
            ((IlvGraphic)object2).setProperty(IlvSymbolEditorDocument.unrealizedProperty, Boolean.FALSE.equals(objectArray[1]) ? Boolean.TRUE : null);
            return Boolean.TRUE;
        }
    }

    private class SymbolEditorLayer
    extends IlvManagerLayer {
        private boolean a;

        private SymbolEditorLayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void draw(Graphics graphics, IlvManagerView ilvManagerView) {
            try {
                this.a = true;
                super.draw(graphics, ilvManagerView);
            }
            finally {
                this.a = false;
            }
        }

        public void mapIntersects(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, final IlvTransformer ilvTransformer) {
            if (this.a) {
                ilvApplyObject = new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        if (ilvGraphic.isVisible()) {
                            if (ilvGraphic instanceof IlvCompositeGraphic) {
                                SymbolEditorLayer.this.a((IlvCompositeGraphic)ilvGraphic, (Graphics)object, ilvTransformer);
                            } else {
                                ilvGraphic.draw((Graphics)object, ilvTransformer);
                            }
                        }
                    }
                };
            }
            super.mapIntersects(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
        }

        private void a(IlvCompositeGraphic ilvCompositeGraphic, Graphics graphics, IlvTransformer ilvTransformer) {
            if (ilvCompositeGraphic.getLayout() != null && !ilvCompositeGraphic.isValid()) {
                ilvCompositeGraphic.doLayout();
            }
            double d2 = ilvTransformer != null ? Math.abs(ilvTransformer.zoomFactor()) : 1.0;
            IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
            if (ilvGraphicArray == null) {
                return;
            }
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                IlvGraphic ilvGraphic;
                if (d2 < ilvCompositeGraphic.getVisibilityThresholds(i2) || (ilvGraphic = ilvGraphicArray[i2]) == null || !ilvGraphic.isVisible()) continue;
                float f2 = 1.0f;
                if (ilvGraphic.getProperty(IlvSymbolEditorDocument.unrealizedProperty) != null) {
                    f2 /= 4.0f;
                }
                if (ilvGraphic.getProperty(IlvSymbolEditorDocument.invisibleProperty) != null) {
                    f2 /= 2.0f;
                }
                if (f2 != 1.0f) {
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
                    ((Graphics2D)graphics).setComposite(alphaComposite);
                    ilvGraphic.draw(graphics, ilvTransformer);
                    ((Graphics2D)graphics).setComposite(AlphaComposite.SrcOver);
                    continue;
                }
                ilvGraphic.draw(graphics, ilvTransformer);
            }
        }
    }

    private class SymbolAttributeHandler
    implements IlvCSSEngine.AttributeHandler {
        private IlvCSSEngine.AttributeHandler a;

        SymbolAttributeHandler(IlvCSSEngine.AttributeHandler attributeHandler) {
            this.a = attributeHandler;
        }

        public Object computeValue(IlvCSSModel ilvCSSModel, Object object, String string) {
            return this.a.computeValue(ilvCSSModel, object, string);
        }

        public int evaluate(IlvCSSModel ilvCSSModel, Object object, Attribute attribute) {
            if (IlvSymbolEditorDocument.this.getRuleModel().getCSSBeans().isProcessingSymbol()) {
                return this.a.evaluate(ilvCSSModel, object, attribute);
            }
            List list = IlvSymbolEditorDocument.this.getSelection();
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object e2 = list.get(i2);
                if (IlvSymbolEditorDocument.isConditionSelection(e2)) {
                    bl = true;
                    IlvSelector ilvSelector = ((IlvRule)e2).getSelector();
                    IlvCSSAttributeSelector[] ilvCSSAttributeSelectorArray = ilvSelector.getAttributes();
                    for (int i3 = 0; i3 < ilvCSSAttributeSelectorArray.length; ++i3) {
                        if (!attribute.isIdentical(ilvCSSAttributeSelectorArray[i3])) continue;
                        return 1;
                    }
                    continue;
                }
                if (!IlvSymbolEditorDocument.this.c(e2)) continue;
                bl2 = true;
            }
            if (bl) {
                return 0;
            }
            if (bl2) {
                return 0;
            }
            return this.a.evaluate(ilvCSSModel, object, attribute);
        }
    }

    private class SymbolCSSModel
    implements IlvCSSModel {
        HashMap a = null;

        private SymbolCSSModel() {
        }

        void a() {
            if (IlvSymbolEditorDocument.this.v) {
                return;
            }
            this.a = new HashMap();
            IlvPaletteSymbol ilvPaletteSymbol = IlvSymbolEditorDocument.this.getSymbol();
            for (int i2 = 0; i2 < ilvPaletteSymbol.getParameterCount(); ++i2) {
                IlvPaletteSymbolParameter ilvPaletteSymbolParameter = ilvPaletteSymbol.getParameter(i2);
                this.a.put(ilvPaletteSymbolParameter.getID(), ilvPaletteSymbolParameter.getValue());
            }
            IlvSymbolEditorDocument.this.v = true;
            IlvSymbolEditorDocument.this.t = null;
            IlvSymbolEditorDocument.this.setSelected(false);
        }

        void b() {
            if (!IlvSymbolEditorDocument.this.v) {
                return;
            }
            this.a = null;
            IlvSymbolEditorDocument.this.v = false;
            if (IlvSymbolEditorDocument.this.t != null) {
                IlvSymbolEditorDocument.this.applyChanges(true);
            }
            IlvSymbolEditorDocument.this.t = null;
            IlvSymbolEditorDocument.this.setSelected(false);
            IlvSymbolEditorDocument.this.getManager().deSelectAll(true);
        }

        public Object[] getChildrenAsArray(Object object) {
            return null;
        }

        public String getType(Object object) {
            return IlvSymbolEditorDocument.this.f.getType();
        }

        public String getCSSclasses(Object object) {
            return null;
        }

        public String getID(Object object) {
            return null;
        }

        public String getValue(Object object, String string) {
            Object object2 = null;
            if (IlvSymbolEditorDocument.this.v) {
                object2 = this.a.get(string);
            } else {
                IlvPaletteSymbolParameter ilvPaletteSymbolParameter = IlvSymbolEditorDocument.this.a.getParameter(string);
                if (ilvPaletteSymbolParameter != null) {
                    object2 = ilvPaletteSymbolParameter.getValue();
                }
            }
            if (object2 != null) {
                try {
                    return IlvConvert.convertToString(object2);
                }
                catch (IlvConvertException ilvConvertException) {
                    return null;
                }
            }
            return null;
        }

        public Object getValueAsObject(Object object, String string) {
            if (IlvSymbolEditorDocument.this.v) {
                return this.a.get(string);
            }
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = IlvSymbolEditorDocument.this.a.getParameter(string);
            if (ilvPaletteSymbolParameter != null) {
                return ilvPaletteSymbolParameter.getValue();
            }
            return null;
        }

        void a(String string, Object object) {
            if (!IlvSymbolEditorDocument.this.v) {
                throw new RuntimeException("setValueAsObject in design mode should not happen");
            }
            this.a.put(string, object);
        }
    }

    private class CSSHook
    implements IlvCSSBeans.AppliedDeclarationHook {
        private CSSHook() {
        }

        public void applyDeclarations(IlvCSSModel ilvCSSModel, Object object, Object object2, String[] stringArray, Map map, Collection collection, int n2) {
            IlvSymbolEditorDocument.this.appliedDeclarations(ilvCSSModel, object, object2, stringArray, map, collection, n2);
        }
    }

    private static class ParameterClipboardElement
    extends ClipboardElement {
        private IlvPaletteSymbolParameter a;

        ParameterClipboardElement(IlvPaletteSymbolParameter ilvPaletteSymbolParameter) {
            this.a = ilvPaletteSymbolParameter;
        }

        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            List list = ilvSymbolEditorDocument.getSelection();
            return list.size() == 0 || list.size() == 1 && (ilvSymbolEditorDocument.f(list.get(0)) || ilvSymbolEditorDocument.d(list.get(0)));
        }

        Object b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            IlvPaletteSymbolParameter ilvPaletteSymbolParameter = this.a.copy();
            String string = SymbolEditorUtilities.getUniqueParameterName(ilvSymbolEditorDocument, ilvPaletteSymbolParameter.getName());
            ilvPaletteSymbolParameter.setName(string);
            ilvPaletteSymbolParameter.setID(string);
            ilvSymbolEditorDocument.addParameter(ilvPaletteSymbolParameter);
            return ilvPaletteSymbolParameter;
        }
    }

    private static class ConditionClipboardElement
    extends ClipboardElement {
        private IlvRule[] a;

        ConditionClipboardElement(IlvRule[] ilvRuleArray) {
            this.a = IlvSymbolEditorDocument.b(ilvRuleArray);
        }

        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            if (this.a.length == 0) {
                return false;
            }
            List list = ilvSymbolEditorDocument.getSelection();
            if (list.size() == 0) {
                return true;
            }
            if (list.size() == 1) {
                Object e2 = list.get(0);
                if (e2 instanceof IlvRule) {
                    IlvGraphic ilvGraphic = ilvSymbolEditorDocument.getRuleModel().getGraphicFromRule(this.a[0]);
                    IlvGraphic ilvGraphic2 = ilvSymbolEditorDocument.getRuleModel().getGraphicFromRule((IlvRule)e2);
                    return ilvGraphic2 == ilvGraphic;
                }
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            IlvRule ilvRule = ilvSymbolEditorDocument.a(this.a[0], false);
            if (ilvRule == null) {
                return null;
            }
            IlvSymbolRuleModel ilvSymbolRuleModel = ilvSymbolEditorDocument.getRuleModel();
            try {
                ilvSymbolRuleModel.setAdjusting(true);
                IlvRule[] ilvRuleArray = IlvSymbolEditorDocument.b(this.a);
                IlvSymbolEditorDocument.b(ilvRuleArray[0], ilvRule);
                ilvRuleArray[0].setSelector(ilvRule.getSelector());
                ilvSymbolEditorDocument.c(ilvRuleArray);
                for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                    ilvSymbolRuleModel.addRule(ilvRuleArray[i2]);
                }
                if (ilvRuleArray.length > 0) {
                    IlvRule ilvRule2 = ilvRuleArray[0];
                    return ilvRule2;
                }
                Object var5_7 = null;
                return var5_7;
            }
            finally {
                ilvSymbolRuleModel.setAdjusting(false);
            }
        }
    }

    private static class GraphicClipboardElement
    extends ClipboardElement {
        private String a;
        private IlvRule[] b;
        private IlvPoint c;

        GraphicClipboardElement(IlvGraphic ilvGraphic, IlvRule[] ilvRuleArray) {
            this.a = ilvGraphic.getName();
            this.b = IlvSymbolEditorDocument.b(ilvRuleArray);
            IlvRect ilvRect = ilvGraphic.boundingBox();
            this.c = new IlvPoint(ilvRect.x, ilvRect.y);
        }

        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            List list = ilvSymbolEditorDocument.getSelection();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object e2 = list.get(i2);
                if (ilvSymbolEditorDocument.c(e2) || ilvSymbolEditorDocument.b(e2) || ilvSymbolEditorDocument.e(e2)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            IlvRule ilvRule;
            Object object;
            IlvSymbolRuleModel ilvSymbolRuleModel = ilvSymbolEditorDocument.getRuleModel();
            try {
                ilvSymbolRuleModel.setAdjusting(true);
                object = this.a;
                IlvRule[] ilvRuleArray = IlvSymbolEditorDocument.b(this.b);
                String string = SymbolEditorUtilities.getUniqueRuleID(ilvSymbolEditorDocument, ilvRuleArray, (String)object);
                ilvSymbolEditorDocument.a(ilvRuleArray, (String)object, string, false);
                ilvSymbolEditorDocument.c(ilvRuleArray);
                for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
                    ilvSymbolRuleModel.addRule(ilvRuleArray[i2]);
                }
                ilvRule = ilvSymbolRuleModel.getMainRuleFromID(string);
                IlvRule ilvRule2 = ilvSymbolEditorDocument.getToplevelRule();
                IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvSymbolEditorDocument.getToplevelGraphic();
                IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
                int n2 = ilvGraphicArray.length;
                while (ilvGraphicArray[n2 - 1] == null) {
                    --n2;
                }
                ilvSymbolRuleModel.setDeclarationValue(ilvRule2, "children[" + n2 + "]", "@+" + string);
                try {
                    IlvRule ilvRule3 = ilvSymbolRuleModel.getRule("#" + string + "Attachment", true);
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule3, "class", (ai == null ? (ai = IlvSymbolEditorDocument.class$("ilog.views.graphic.composite.layout.IlvAttachmentConstraint")) : ai).getName());
                    ilvSymbolRuleModel.setDeclarationValue(ilvRule2, "constraints[" + n2 + "]", "@+" + string + "Attachment");
                }
                catch (IlvStylingException ilvStylingException) {
                    // empty catch block
                }
            }
            finally {
                ilvSymbolRuleModel.setAdjusting(false);
            }
            this.c.translate(10.0f, 10.0f);
            object = ilvSymbolRuleModel.getGraphicFromRule(ilvRule);
            ((IlvGraphic)object).move(this.c.x, this.c.y);
            ilvSymbolRuleModel.updateGeometry((IlvGraphic)object, ilvRule, true, null);
            return ilvRule;
        }
    }

    private static abstract class ClipboardElement {
        private ClipboardElement() {
        }

        abstract boolean a(IlvSymbolEditorDocument var1);

        abstract Object b(IlvSymbolEditorDocument var1);
    }

    static class Clipboard {
        private ArrayList a = new ArrayList();

        Clipboard() {
        }

        void a() {
            this.a.clear();
        }

        void a(ClipboardElement clipboardElement) {
            this.a.add(clipboardElement);
        }

        void b(ClipboardElement clipboardElement) {
            this.a.remove(clipboardElement);
        }

        boolean a(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            if (this.a.size() > 0) {
                for (int i2 = 0; i2 < this.a.size(); ++i2) {
                    if (((ClipboardElement)this.a.get(i2)).a(ilvSymbolEditorDocument)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        List b(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                Object object = ((ClipboardElement)this.a.get(i2)).b(ilvSymbolEditorDocument);
                if (object == null) continue;
                arrayList.add(object);
            }
            return arrayList;
        }
    }

    public static interface ConditionEditor {
        public IlvRule editCondition(IlvRule var1, String var2, boolean var3);
    }
}

