/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor.rules;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.beans.editor.IlvShapePropertyEditor;
import ilog.views.css.model.IlvConfigNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleImpl;
import ilog.views.css.model.IlvRuleModelImpl;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachable;
import ilog.views.graphic.composite.layout.IlvAttachableGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.io.IlvPersistentObject;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.rules.IlvSymbolRuleStrategy;
import ilog.views.util.beans.editor.IlvFloatPropertyEditor;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvStylingException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class IlvSymbolRuleModel
extends IlvRuleModelImpl {
    private IlvSymbolEditorDocument a;
    private IlvRule b;
    private ParametersNode c;
    private IlvFloatPropertyEditor d = new IlvFloatPropertyEditor();
    private IlvShapePropertyEditor e = new IlvShapePropertyEditor();
    private boolean f;

    public IlvSymbolRuleModel() {
        super(new IlvSymbolRuleStrategy());
    }

    protected IlvSymbolRuleModel(IlvSymbolRuleStrategy ilvSymbolRuleStrategy) {
        super(ilvSymbolRuleStrategy);
    }

    public void setDocument(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
        this.a = ilvSymbolEditorDocument;
        ((IlvSymbolRuleStrategy)this.getCSSStrategy()).setDocument(ilvSymbolEditorDocument);
    }

    public IlvSymbolEditorDocument getDocument() {
        return this.a;
    }

    public IlvConfigNode getConfig() {
        return this.c;
    }

    public IlvRule getRootRule() {
        return this.b;
    }

    public void buildTree() {
        this.b = new IlvRuleImpl(new Rule());
        IlvRule ilvRule = this.a.getToplevelRule();
        this.a(ilvRule, this.a.getToplevelGraphic());
        this.b.addChild(ilvRule);
        this.c = new ParametersNode();
    }

    private void a(IlvRule ilvRule, IlvGraphic ilvGraphic) {
        int n2;
        ilvRule.resetTreeNode();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        for (n2 = 0; n2 < ilvRuleArray.length; ++n2) {
            if (ilvRuleArray[n2] == ilvRule || (ilvRule.getSelector().getID() == null || !ilvRule.getSelector().getID().equals(ilvRuleArray[n2].getSelector().getID())) && (ilvRule.getSelector().getType() == null || !ilvRule.getSelector().getType().equals(ilvRuleArray[n2].getSelector().getType()))) continue;
            ilvRule.addChild(ilvRuleArray[n2]);
        }
        if (ilvGraphic instanceof IlvGraphicSet) {
            for (n2 = 0; n2 < ((IlvGraphicSet)ilvGraphic).getCardinal(); ++n2) {
                IlvRule ilvRule2;
                IlvGraphic ilvGraphic2 = ((IlvGraphicSet)ilvGraphic).getObject(n2);
                if (ilvGraphic2.getName() == null || (ilvRule2 = this.getMainRuleFromGraphic(ilvGraphic2)) == null) continue;
                this.a(ilvRule2, ilvGraphic2);
                ilvRule.addChild(ilvRule2);
            }
        }
    }

    public IlvRule getMainRuleFromID(String string) {
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            if (ilvRuleArray[i2].getSelector() == null || !string.equals(ilvRuleArray[i2].getSelector().getID()) && !string.equals(ilvRuleArray[i2].getSelector().getType()) || SymbolEditorUtilities.hasCondition(ilvRuleArray[i2])) continue;
            return ilvRuleArray[i2];
        }
        return null;
    }

    public IlvRule getMainRuleFromGraphic(IlvGraphic ilvGraphic) {
        if (ilvGraphic == this.a.getToplevelGraphic()) {
            return this.a.getToplevelRule();
        }
        return this.getMainRuleFromID(ilvGraphic.getName());
    }

    public IlvRule[] getAllRulesFromGraphic(IlvGraphic ilvGraphic) {
        ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
        IlvRule[] ilvRuleArray = this.getAllRules(true);
        String string = ilvGraphic.getName();
        for (int i2 = 0; i2 < ilvRuleArray.length; ++i2) {
            if (ilvRuleArray[i2].getSelector() == null || !string.equals(ilvRuleArray[i2].getSelector().getID()) && !string.equals(ilvRuleArray[i2].getSelector().getType())) continue;
            arrayList.add(ilvRuleArray[i2]);
        }
        return arrayList.toArray(new IlvRule[0]);
    }

    public IlvGraphic getGraphicFromRule(IlvRule ilvRule) {
        if (ilvRule == this.a.getToplevelRule()) {
            return this.a.getToplevelGraphic();
        }
        if (this.a.getToplevelGraphic() instanceof IlvGraphicSet) {
            return SymbolEditorUtilities.findGraphicByName(this.a, ilvRule.getSelector().getID());
        }
        return null;
    }

    public final boolean updateGeometry(IlvGraphic ilvGraphic, IlvRule ilvRule, boolean bl, IlvPoint ilvPoint) {
        Object object;
        IlvPersistentObject ilvPersistentObject = ilvGraphic;
        while (((IlvGraphic)ilvPersistentObject).getGraphicBag() instanceof IlvCompositeGraphic) {
            object = SymbolEditorUtilities.getAttachmentConstraint((IlvGraphic)ilvPersistentObject);
            if (object != null && ((IlvAttachmentConstraint)object).getRotationAngle() != 0.0 && !bl) {
                this.a.applyChanges();
                return false;
            }
            ilvPersistentObject = (IlvGraphic)((Object)((IlvGraphic)ilvPersistentObject).getGraphicBag());
        }
        ilvPersistentObject = SymbolEditorUtilities.getAttachmentConstraint(ilvGraphic);
        this.setAdjusting(true);
        this.a(ilvGraphic, ilvRule, (IlvAttachmentConstraint)ilvPersistentObject, ilvPoint);
        if (!bl) {
            this.a(ilvGraphic, ilvRule, (IlvAttachmentConstraint)ilvPersistentObject);
        }
        object = ilvGraphic.getGraphicBag();
        while (object instanceof IlvCompositeGraphic) {
            IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)object;
            IlvRule ilvRule2 = this.getMainRuleFromGraphic(ilvCompositeGraphic);
            boolean bl2 = false;
            IlvRule ilvRule3 = this.getAttachmentConstraintRule(ilvCompositeGraphic, false);
            if (ilvRule3 != null && (ilvRule3.getDeclaration("width") != null || ilvRule3.getDeclaration("height") != null)) {
                bl2 = true;
            }
            if (bl2) {
                this.updateGeometry(ilvCompositeGraphic, ilvRule2, false, null);
            } else {
                this.a(ilvCompositeGraphic, ilvRule2, SymbolEditorUtilities.getAttachmentConstraint(ilvCompositeGraphic), null);
            }
            object = object.getGraphicBag();
        }
        if (!bl && ilvGraphic instanceof IlvCompositeGraphic && !SymbolEditorUtilities.isSubSymbol(ilvGraphic)) {
            this.a((IlvCompositeGraphic)ilvGraphic);
        }
        this.setAdjusting(false);
        return true;
    }

    private void a(IlvCompositeGraphic ilvCompositeGraphic) {
        IlvGraphic[] ilvGraphicArray = ilvCompositeGraphic.getChildren();
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < ilvGraphicArray.length; ++i2) {
                IlvRule ilvRule;
                IlvGraphic ilvGraphic = ilvGraphicArray[i2];
                if (ilvGraphic == null || (ilvRule = this.getMainRuleFromGraphic(ilvGraphic)) == null) continue;
                IlvAttachmentConstraint ilvAttachmentConstraint = SymbolEditorUtilities.getAttachmentConstraint(ilvGraphic);
                if (ilvAttachmentConstraint != null) {
                    this.a(ilvGraphic, ilvRule, ilvAttachmentConstraint, null);
                }
                if (!(ilvGraphic instanceof IlvCompositeGraphic)) continue;
                this.a((IlvCompositeGraphic)ilvGraphic);
            }
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvRule ilvRule, IlvAttachmentConstraint ilvAttachmentConstraint, IlvPoint ilvPoint) {
        if (ilvGraphic == this.a.getToplevelGraphic()) {
            this.a.updatePosition();
        } else if (ilvAttachmentConstraint != null && !this.a(ilvGraphic)) {
            IlvCompositeGraphic ilvCompositeGraphic = SymbolEditorUtilities.getComposite(ilvGraphic);
            IlvRule ilvRule2 = this.getAttachmentConstraintRule(ilvGraphic, false);
            if (ilvRule2 != null) {
                Object object;
                IlvPoint ilvPoint2 = ilvAttachmentConstraint.getOffset();
                IlvAttachable ilvAttachable = ilvCompositeGraphic.getAttachables()[0];
                IlvRect ilvRect = ilvAttachable.getAttachmentBounds();
                if (ilvAttachmentConstraint.isRelativeOffset()) {
                    ilvPoint2.x *= ilvRect.width;
                    ilvPoint2.y *= ilvRect.height;
                }
                if (ilvPoint != null) {
                    ilvPoint2.x += ilvPoint.x;
                    ilvPoint2.y += ilvPoint.y;
                } else {
                    object = ilvAttachmentConstraint.compute(ilvAttachable, ilvRect);
                    IlvAttachableGraphic ilvAttachableGraphic = ilvCompositeGraphic.getAttachableGraphic(ilvGraphic);
                    IlvPoint ilvPoint3 = ilvAttachmentConstraint.getHotSpot().getValue(ilvAttachableGraphic);
                    float f2 = ilvPoint3.x - ((Point2D.Float)object).x;
                    float f3 = ilvPoint3.y - ((Point2D.Float)object).y;
                    ilvPoint2.x += f2;
                    ilvPoint2.y += f3;
                }
                if (ilvAttachmentConstraint.isRelativeOffset()) {
                    ilvPoint2.x /= ilvRect.width;
                    ilvPoint2.y /= ilvRect.height;
                }
                if (!this.isBound(ilvRule2, "offsetX")) {
                    this.d.setValue(new Float(ilvPoint2.x));
                    object = this.d.getAsText();
                    this.setDeclarationValue(ilvRule2, "offsetX", (String)object);
                }
                if (!this.isBound(ilvRule2, "offsetY")) {
                    this.d.setValue(new Float(ilvPoint2.y));
                    object = this.d.getAsText();
                    this.setDeclarationValue(ilvRule2, "offsetY", (String)object);
                }
            }
        }
    }

    private boolean a(IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (!(ilvGraphicBag instanceof IlvCompositeGraphic)) {
            return false;
        }
        IlvCompositeGraphic ilvCompositeGraphic = (IlvCompositeGraphic)ilvGraphicBag;
        return ilvCompositeGraphic.getChildren(0) == ilvGraphic;
    }

    private void a(IlvGraphic ilvGraphic, IlvRule ilvRule, IlvAttachmentConstraint ilvAttachmentConstraint) {
        Object object;
        Object object2;
        IlvGraphic ilvGraphic2;
        if (ilvGraphic instanceof IlvGeneralPath && !this.isBound(ilvRule, "shape")) {
            ilvGraphic2 = (IlvGeneralPath)ilvGraphic;
            object2 = ((IlvGeneralPath)ilvGraphic2).getShape();
            if (((IlvGeneralPath)ilvGraphic2).isTransformedShapeMode()) {
                ((IlvGeneralPath)ilvGraphic2).setTransformedShapeMode(false);
                ((IlvGeneralPath)ilvGraphic2).setTransformedShapeMode(true);
            }
            this.e.setValue(object2);
            object = this.e.getAsText();
            this.setDeclarationValue(ilvRule, "shape", (String)object);
        }
        if (ilvGraphic instanceof IlvText && !this.isBound(ilvRule, "label")) {
            ilvGraphic2 = (IlvText)ilvGraphic;
            this.setDeclarationValue(ilvRule, "label", ((IlvText)ilvGraphic2).getLabel());
        }
        if (!(ilvAttachmentConstraint == null || ilvAttachmentConstraint.getSize() == null && ilvGraphic instanceof IlvGeneralPath)) {
            ilvGraphic2 = SymbolEditorUtilities.getComposite(ilvGraphic);
            object2 = ((IlvCompositeGraphic)ilvGraphic2).getChildren(0);
            object = SymbolEditorUtilities.getAttachmentBounds((IlvGraphic)object2);
            IlvRect ilvRect = SymbolEditorUtilities.getAttachmentBounds(ilvGraphic);
            IlvRule ilvRule2 = this.getAttachmentConstraintRule(ilvGraphic, false);
            if (ilvRule2 != null) {
                if (!this.isBound(ilvRule2, "width")) {
                    this.setDeclarationValue(ilvRule2, "width", String.valueOf(ilvAttachmentConstraint.isRelativeSize() ? ilvRect.width / ((Rectangle2D.Float)object).width : ilvRect.width));
                }
                if (!this.isBound(ilvRule2, "height")) {
                    this.setDeclarationValue(ilvRule2, "height", String.valueOf(ilvAttachmentConstraint.isRelativeSize() ? ilvRect.height / ((Rectangle2D.Float)object).height : ilvRect.height));
                }
            }
        }
    }

    public boolean isBound(IlvRule ilvRule, String string) {
        String string2 = this.getDeclarationValue(ilvRule, string);
        if (string2 == null) {
            return false;
        }
        return string2.startsWith("@");
    }

    public IlvRule getAttachmentConstraintRule(IlvGraphic ilvGraphic, boolean bl) {
        try {
            return this.getRule("#" + ilvGraphic.getName() + "Attachment", false);
        }
        catch (IlvStylingException ilvStylingException) {
            return null;
        }
    }

    public void removeDeclaration(IlvRule ilvRule, String string) {
        String string2 = ilvRule.getDeclarationValue(string);
        if (string2 != null) {
            this.f = true;
            ilvRule.resetModified(string);
            ilvRule.setDeclarationValue(string, string2);
            super.removeDeclaration(ilvRule, string);
        }
    }

    public boolean getDeclarationsRemoved() {
        boolean bl = this.f;
        this.f = false;
        return bl;
    }

    private static class ParametersNode
    extends IlvConfigNode {
        private String a = ResourceBundle.getBundle("ilog.views.symbology.editor.rules.rules").getString("SymbolEditor.Rules.Parameters");

        public String toString() {
            return this.a;
        }
    }
}

