/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import ilog.views.util.beans.editor.Messages;
import ilog.views.util.swing.font.IlvFontChooser;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvFontPropertyEditor
extends PropertyEditorSupport {
    private static String a = ResourceBundle.getBundle("ilog.views.util.swing.font.resources.messages", Locale.getDefault()).getString("IlvFontChooser.ExemplarCharacters.Short");
    private IlvFontChooser b = null;
    private Font c = Font.getFont("Dialog");
    static FontStyleDef[] d = new FontStyleDef[]{new FontStyleDef("BOLD", 1), new FontStyleDef("ITALIC", 2), new FontStyleDef("BOLDITALIC", 3), new FontStyleDef("PLAIN", 0)};

    public String getJavaInitializationString() {
        Font font = (Font)this.getValue();
        if (font == null) {
            return "null";
        }
        return "new java.awt.Font(\"" + font.getFamily() + "\", java.awt.Font." + IlvFontPropertyEditor.a(font.getStyle()) + ", " + font.getSize() + ")";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n2 = string.indexOf(45);
        int n3 = string.indexOf(45, n2 + 1);
        if (n2 < 0 || n3 < 0) {
            n2 = string.indexOf(44);
            n3 = string.indexOf(44, n2 + 1);
            if (n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException(string);
            }
        }
        try {
            String string2 = string.substring(0, n2);
            int n4 = IlvFontPropertyEditor.a(string.substring(n2 + 1, n3));
            int n5 = Integer.parseInt(string.substring(n3 + 1));
            this.setValue(new Font(string2, n4, n5));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    public String getAsText() {
        Font font = (Font)this.getValue();
        if (font == null) {
            return "null";
        }
        return font.getFamily() + "-" + IlvFontPropertyEditor.a(font.getStyle()) + "-" + font.getSize();
    }

    public void setValue(Object object) {
        this.c = (Font)object;
        super.setValue(object);
        if (this.b != null && (object != null ? this.b.getSelectedFont() == null || !object.equals(this.b.getSelectedFont()) : this.b.getSelectedFont() != null)) {
            this.b.setSelectedFont(this.c);
        }
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = graphics.getFont();
        graphics.setFont(this.c);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(a, 0, rectangle.height - n2);
        graphics.setFont(font);
    }

    public Object getValue() {
        return this.c;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.b == null) {
            this.b = new IlvFontChooser(this.c);
            this.b.putClientProperty("__PSheetDialogTitleKey", Messages.BUNDLE.getString("FontEditor.Title"));
            this.b.getSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    IlvFontPropertyEditor.this.setValue(IlvFontPropertyEditor.this.b.getSelectedFont());
                }
            });
        } else {
            if (this.c == null) {
                this.c = this.b.getSelectedFont();
            }
            this.b.setSelectedFont(this.c);
        }
        return this.b;
    }

    static int a(String string) {
        string = string.toUpperCase();
        for (int i2 = 0; i2 < d.length; ++i2) {
            if (!string.equals(IlvFontPropertyEditor.d[i2].name)) continue;
            return IlvFontPropertyEditor.d[i2].val;
        }
        throw new IllegalArgumentException(string);
    }

    static String a(int n2) {
        for (int i2 = 0; i2 < d.length; ++i2) {
            if (n2 != IlvFontPropertyEditor.d[i2].val) continue;
            return IlvFontPropertyEditor.d[i2].name;
        }
        throw new IllegalArgumentException("" + n2);
    }

    public static class FontStyleDef {
        public int val;
        public String name;

        public FontStyleDef(String string, int n2) {
            this.name = string;
            this.val = n2;
        }
    }
}

