/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections;

import java.io.Serializable;

public class IlvFloatArrayList
implements Cloneable,
Serializable {
    private static float[] a = new float[0];
    private float[] b;
    private int c;

    public IlvFloatArrayList() {
        this.b = new float[10];
        this.c = 0;
    }

    public IlvFloatArrayList(int n2) {
        this.b = new float[n2];
        this.c = 0;
    }

    public IlvFloatArrayList(float[] fArray) {
        int n2 = fArray.length;
        n2 += n2 / 4;
        this.b = new float[n2];
        this.c = fArray.length;
        System.arraycopy(fArray, 0, this.b, 0, this.c);
    }

    public int size() {
        return this.c;
    }

    public boolean isEmpty() {
        return this.c == 0;
    }

    public float get(int n2) {
        if (n2 < this.c) {
            return this.b[n2];
        }
        throw new IndexOutOfBoundsException("index " + n2 + " too large for size " + this.c);
    }

    public float set(int n2, float f2) {
        if (n2 < this.c) {
            float f3 = this.b[n2];
            this.b[n2] = f2;
            return f3;
        }
        throw new IndexOutOfBoundsException("index " + n2 + " too large for size " + this.c);
    }

    public void copyInto(float[] fArray) {
        if (this.c > 0) {
            System.arraycopy(this.b, 0, fArray, 0, this.c);
        }
    }

    public float[] toArray() {
        if (this.c > 0) {
            float[] fArray = new float[this.c];
            System.arraycopy(this.b, 0, fArray, 0, this.c);
            return fArray;
        }
        return a;
    }

    public void add(float f2) {
        this.ensureCapacity(this.c + 1);
        this.b[this.c] = f2;
        ++this.c;
    }

    public void add(int n2, float f2) {
        if (n2 < 0 && n2 > this.c) {
            throw new IndexOutOfBoundsException("index " + n2 + " inappropriate for size " + this.c);
        }
        this.ensureCapacity(this.c + 1);
        if (n2 < this.c) {
            System.arraycopy(this.b, n2, this.b, n2 + 1, this.c - n2);
        }
        this.b[n2] = f2;
        ++this.c;
    }

    public float remove(int n2) {
        if (n2 < 0 && n2 >= this.c) {
            throw new IndexOutOfBoundsException("index " + n2 + " inappropriate for size " + this.c);
        }
        float f2 = this.b[n2];
        if (n2 + 1 < this.c) {
            System.arraycopy(this.b, n2 + 1, this.b, n2, this.c - n2 - 1);
        }
        --this.c;
        return f2;
    }

    public void removeRange(int n2, int n3) {
        if (n2 < 0 || n3 > this.c || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        if (n4 > 0) {
            if (n3 < this.c) {
                System.arraycopy(this.b, n3, this.b, n2, this.c - n3);
            }
            this.c -= n4;
        }
    }

    public void clear() {
        this.c = 0;
    }

    public void trimToSize() {
        if (this.b.length > this.c) {
            if (this.c > 0) {
                float[] fArray = new float[this.c];
                System.arraycopy(this.b, 0, fArray, 0, this.c);
                this.b = fArray;
            } else {
                this.b = a;
            }
        }
    }

    public void ensureCapacity(int n2) {
        if (n2 > this.b.length) {
            int n3 = this.b.length;
            if ((n3 += n3 / 4) < n2) {
                n3 = n2;
            }
            float[] fArray = new float[n3];
            System.arraycopy(this.b, 0, fArray, 0, this.c);
            this.b = fArray;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.b[i2]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IlvFloatArrayList) {
            IlvFloatArrayList ilvFloatArrayList = (IlvFloatArrayList)object;
            if (this.c != ilvFloatArrayList.c) {
                return false;
            }
            int n2 = this.c;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Float.floatToRawIntBits(this.b[i2]) == Float.floatToRawIntBits(ilvFloatArrayList.b[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.c + 1;
        for (int i2 = 0; i2 < this.c; ++i2) {
            n2 = 31 * n2 + Float.floatToRawIntBits(this.b[i2]);
        }
        return n2;
    }

    public Object clone() {
        try {
            IlvFloatArrayList ilvFloatArrayList = (IlvFloatArrayList)super.clone();
            ilvFloatArrayList.b = this.toArray();
            return ilvFloatArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

