/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.color;

import ilog.views.util.swing.color.ColorChangedEvent;
import ilog.views.util.swing.color.ColorChangedListener;
import ilog.views.util.swing.color.IlvColorChooserCanvas;
import ilog.views.util.swing.color.IlvColorDiskPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IlvColorChooser
extends JPanel {
    private JTextField a;
    private JTextField b;
    private JTextField c;
    private boolean d;
    private JTextField e;
    private JTextField f;
    private JTextField g;
    private JTextField h;
    IlvColorDiskPanel i;
    private IlvColorChooserCanvas j;
    private Vector k = null;
    static final int[] l = new int[]{255, 128, 128, 255, 255, 128, 128, 255, 128, 0, 255, 128, 128, 255, 255, 0, 128, 255, 255, 128, 192, 255, 128, 255, 255, 0, 0, 255, 255, 0, 128, 255, 0, 0, 255, 64, 0, 255, 255, 0, 128, 192, 128, 128, 192, 255, 0, 255, 128, 64, 64, 255, 128, 64, 0, 255, 0, 0, 128, 128, 0, 64, 128, 128, 128, 255, 128, 0, 64, 255, 0, 128, 128, 0, 0, 255, 128, 0, 0, 128, 0, 0, 128, 64, 0, 0, 255, 0, 0, 160, 128, 0, 128, 128, 0, 255, 64, 0, 0, 128, 64, 0, 0, 64, 0, 0, 64, 64, 0, 0, 128, 0, 0, 64, 64, 0, 64, 64, 0, 128, 0, 0, 0, 128, 128, 0, 128, 128, 64, 128, 128, 128, 64, 128, 128, 192, 192, 192, 64, 0, 64, 255, 255, 255};

    public IlvColorChooser() {
        this(true);
    }

    public IlvColorChooser(boolean bl) {
        this.d = bl;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout(5, 0));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 5));
        jPanel.setLayout(new BorderLayout());
        this.i = new IlvColorDiskPanel(120, this.d);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)this.i, "Center");
        this.j = new IlvColorChooserCanvas();
        this.j.setSize(50, 1);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)new JLabel("Color:"), "North");
        this.j.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel4.add((Component)this.j, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(this.d ? 4 : 3, 4, 2, 2));
        jPanel5.add(new JLabel("Hue:"));
        this.e = new JTextField(3);
        jPanel5.add(this.e);
        jPanel5.add(new JLabel("Red:"));
        this.a = new JTextField(3);
        jPanel5.add(this.a);
        jPanel5.add(new JLabel("Sat.:"));
        this.f = new JTextField(3);
        jPanel5.add(this.f);
        jPanel5.add(new JLabel("Green:"));
        this.b = new JTextField(3);
        jPanel5.add(this.b);
        jPanel5.add(new JLabel("Bright.:"));
        this.g = new JTextField(3);
        jPanel5.add(this.g);
        jPanel5.add(new JLabel("Blue:"));
        this.c = new JTextField(3);
        jPanel5.add(this.c);
        if (this.d) {
            jPanel5.add(new JLabel("Alpha:"));
            this.h = new JTextField(3);
            jPanel5.add(this.h);
        }
        this.a.addActionListener(new actionResetFromRGB());
        this.b.addActionListener(new actionResetFromRGB());
        this.c.addActionListener(new actionResetFromRGB());
        this.e.addActionListener(new actionResetFromHSB());
        this.f.addActionListener(new actionResetFromHSB());
        this.g.addActionListener(new actionResetFromHSB());
        this.a.addFocusListener(new focusResetFromRGB());
        this.b.addFocusListener(new focusResetFromRGB());
        this.c.addFocusListener(new focusResetFromRGB());
        this.e.addFocusListener(new focusResetFromHSB());
        this.f.addFocusListener(new focusResetFromHSB());
        this.g.addFocusListener(new focusResetFromHSB());
        if (this.d) {
            this.h.addActionListener(new actionResetFromRGB());
            this.h.addFocusListener(new focusResetFromRGB());
        }
        jPanel3.add((Component)jPanel5, "Center");
        jPanel3.add((Component)jPanel4, "Before");
        jPanel.add((Component)jPanel3, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        JPanel jPanel7 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel7.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel("Colors:");
        jPanel7.add(jLabel);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(6, 8, 2, 2));
        for (int i2 = 0; i2 < 48; ++i2) {
            IlvColorChooserCanvas ilvColorChooserCanvas = new IlvColorChooserCanvas();
            ilvColorChooserCanvas.setBorder(BorderFactory.createLoweredBevelBorder());
            ilvColorChooserCanvas.setColor(new Color(l[3 * i2], l[3 * i2 + 1], l[3 * i2 + 2]));
            ilvColorChooserCanvas.setSize(18, 18);
            ilvColorChooserCanvas.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    IlvColorChooser.this.i.setColor(((IlvColorChooserCanvas)mouseEvent.getSource()).getColor());
                }
            });
            jPanel8.add(ilvColorChooserCanvas);
        }
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel8, gridBagConstraints);
        jPanel7.add(jPanel8);
        jPanel2.add((Component)jPanel7, "North");
        this.add((Component)jPanel2, "Before");
        this.add((Component)jPanel, "Center");
        this.i.addColorChangedListener(new ColorChooserChangedAdapter());
    }

    void a(Color color, Color color2) {
        float[] fArray;
        if (color.equals(color2)) {
            return;
        }
        String string = Integer.toString(color2.getRed());
        if (!string.equals(this.a.getText())) {
            this.a.setText(string);
        }
        if (!(string = Integer.toString(color2.getGreen())).equals(this.b.getText())) {
            this.b.setText(string);
        }
        if (!(string = Integer.toString(color2.getBlue())).equals(this.c.getText())) {
            this.c.setText(string);
        }
        if (!(string = Integer.toString((int)Math.rint((fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[0] * 360.0f))).equals(this.e.getText())) {
            this.e.setText(string);
        }
        if (!(string = Integer.toString((int)Math.rint(fArray[1] * 100.0f))).equals(this.f.getText())) {
            this.f.setText(string);
        }
        if (!(string = Integer.toString((int)Math.rint(fArray[2] * 100.0f))).equals(this.g.getText())) {
            this.g.setText(string);
        }
        if (this.d && !(string = Integer.toString(color2.getAlpha())).equals(this.h.getText())) {
            this.h.setText(string);
        }
        this.j.setColor(color2);
        this.j.repaint();
        this.b(color, color2);
    }

    private void b(Color color, Color color2) {
        if (this.k != null) {
            Enumeration enumeration = this.k.elements();
            while (enumeration.hasMoreElements()) {
                ColorChangedListener colorChangedListener = (ColorChangedListener)enumeration.nextElement();
                colorChangedListener.colorChange(new ColorChangedEvent(this, color, color2));
            }
        }
    }

    private int a(int n2, JTextField jTextField, int n3) {
        if (n2 < 0) {
            n2 = 0;
            jTextField.setText("0");
        } else if (n2 > n3) {
            n2 = n3;
            jTextField.setText(Integer.toString(n3));
        }
        return n2;
    }

    void a() {
        try {
            int n2 = Integer.parseInt(this.e.getText());
            n2 = this.a(n2, this.e, 360);
            int n3 = Integer.parseInt(this.f.getText());
            n3 = this.a(n3, this.f, 100);
            int n4 = Integer.parseInt(this.g.getText());
            n4 = this.a(n4, this.g, 100);
            int n5 = Color.HSBtoRGB((float)n2 / 360.0f, (float)n3 / 100.0f, (float)n4 / 100.0f);
            if (this.d) {
                int n6 = Integer.parseInt(this.h.getText());
                n6 = this.a(n6, this.h, 255);
                this.i.setColor(new Color((n5 | 0xFF000000) & (n6 << 24 | 0xFFFFFF), true));
            } else {
                this.i.setColor(new Color(n5));
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    void b() {
        try {
            int n2 = Integer.parseInt(this.a.getText());
            n2 = this.a(n2, this.a, 255);
            int n3 = Integer.parseInt(this.b.getText());
            n3 = this.a(n3, this.b, 255);
            int n4 = Integer.parseInt(this.c.getText());
            n4 = this.a(n4, this.c, 255);
            if (this.d) {
                int n5 = Integer.parseInt(this.h.getText());
                n5 = this.a(n5, this.h, 255);
                this.i.setColor(new Color(n2, n3, n4, n5));
            } else {
                this.i.setColor(new Color(n2, n3, n4));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public final void setColor(Color color) {
        this.i.setColor(color);
    }

    public final Color getColor() {
        return this.i.getColor();
    }

    public void addColorChangedListener(ColorChangedListener colorChangedListener) {
        if (this.k == null) {
            this.k = new Vector();
        }
        this.k.addElement(colorChangedListener);
    }

    public void removeColorChangedListener(ColorChangedListener colorChangedListener) {
        if (this.k != null) {
            this.k.removeElement(colorChangedListener);
        }
    }

    class focusResetFromHSB
    implements FocusListener {
        focusResetFromHSB() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            IlvColorChooser.this.a();
        }
    }

    class focusResetFromRGB
    implements FocusListener {
        focusResetFromRGB() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            IlvColorChooser.this.b();
        }
    }

    class actionResetFromHSB
    implements ActionListener {
        actionResetFromHSB() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IlvColorChooser.this.a();
        }
    }

    class actionResetFromRGB
    implements ActionListener {
        actionResetFromRGB() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IlvColorChooser.this.b();
        }
    }

    private class ColorChooserChangedAdapter
    implements ColorChangedListener {
        private ColorChooserChangedAdapter() {
        }

        public void colorChange(ColorChangedEvent colorChangedEvent) {
            IlvColorChooser.this.a(colorChangedEvent.getOldColor(), colorChangedEvent.getNewColor());
        }
    }
}

