/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.font;

import ilog.views.util.swing.font.DefaultFontSelectionModel;
import ilog.views.util.swing.font.FontSelectionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvFontChooser
extends JPanel {
    private static ResourceBundle a = ResourceBundle.getBundle("ilog.views.util.swing.font.resources.messages", Locale.getDefault());
    static final Font b = Font.decode(a.getString("IlvFontChooser.DefaultFont"));
    private FontSelectionModel c;
    private JComboBox d;
    private JComboBox e;
    private JCheckBox f;
    private JCheckBox g;
    private AbstractButton h;
    private boolean i = false;
    private boolean j = false;
    private static final String[] k = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};

    public IlvFontChooser() {
        this(b);
    }

    public IlvFontChooser(Font font) {
        this(new DefaultFontSelectionModel(font != null ? font : b));
    }

    public IlvFontChooser(FontSelectionModel fontSelectionModel) {
        this.c = fontSelectionModel;
        this.c.addChangeListener(new PreviewListener());
        this.setLayout(new BorderLayout());
        FontListener fontListener = new FontListener();
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "Center");
        this.d = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        jPanel.add(this.d);
        this.d.addActionListener(fontListener);
        this.e = new JComboBox<String>(k);
        this.e.setEditable(true);
        jPanel.add(this.e);
        this.e.addActionListener(fontListener);
        this.f = new JCheckBox(a.getString("IlvFontChooser.Italic"));
        jPanel.add(this.f);
        this.f.addActionListener(fontListener);
        this.g = new JCheckBox(a.getString("IlvFontChooser.Bold"));
        jPanel.add(this.g);
        this.g.addActionListener(fontListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), a.getString("IlvFontChooser.Preview")));
        this.h = new AbstractButton(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setFont(this.getFont());
                graphics2D.setColor(this.getForeground());
                Insets insets = this.getInsets();
                Rectangle rectangle = this.getBounds();
                String string = a.getString("IlvFontChooser.ExemplarCharacters.Long");
                graphics2D.drawString(string, insets.left + (rectangle.width - (int)this.getFont().getStringBounds(string, new FontRenderContext(null, false, false)).getWidth() + 4) / 2, insets.top + rectangle.height - insets.bottom + this.getFont().getSize() / 2 - 36);
                graphics2D.dispose();
            }
        };
        this.h.setPreferredSize(new Dimension(256, 72));
        this.h.setForeground(Color.black);
        this.h.setMargin(new Insets(0, 0, 0, 0));
        this.h.setFont(this.c.getSelectedFont());
        jPanel2.add(this.h);
        this.add((Component)jPanel2, "South");
        this.updateChooser();
    }

    public Font getSelectedFont() {
        return this.c.getSelectedFont();
    }

    public void setSelectedFont(Font font) {
        this.c.setSelectedFont(font);
    }

    public FontSelectionModel getSelectionModel() {
        return this.c;
    }

    public void setSelectionMode(FontSelectionModel fontSelectionModel) {
        this.c = fontSelectionModel;
    }

    protected void updateChooser() {
        this.i = true;
        if (this.c.getSelectedFont() == null) {
            this.d.setSelectedIndex(-1);
            this.e.setSelectedIndex(-1);
            this.f.setSelected(false);
            this.g.setSelected(false);
        } else {
            this.d.setEditable(true);
            this.d.setSelectedItem(this.c.getSelectedFont().getFamily());
            this.d.setEditable(false);
            this.e.setSelectedItem(Integer.toString(this.c.getSelectedFont().getSize()));
            this.f.setSelected(this.c.getSelectedFont().isItalic());
            this.g.setSelected(this.c.getSelectedFont().isBold());
        }
        this.i = false;
    }

    private class PreviewListener
    implements ChangeListener {
        private PreviewListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            IlvFontChooser.this.h.setFont(IlvFontChooser.this.c.getSelectedFont());
            IlvFontChooser.this.h.repaint();
            if (!IlvFontChooser.this.j) {
                IlvFontChooser.this.updateChooser();
            }
        }
    }

    private class FontListener
    implements ActionListener {
        private FontListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (IlvFontChooser.this.i) {
                return;
            }
            if (IlvFontChooser.this.d.getSelectedIndex() < 0) {
                return;
            }
            if (IlvFontChooser.this.e.getSelectedIndex() < 0) {
                return;
            }
            String string = (String)IlvFontChooser.this.d.getSelectedItem();
            Float f2 = Float.valueOf((String)IlvFontChooser.this.e.getSelectedItem());
            boolean bl = IlvFontChooser.this.g.isSelected();
            boolean bl2 = IlvFontChooser.this.f.isSelected();
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(4);
            hashMap.put(TextAttribute.FAMILY, string);
            hashMap.put(TextAttribute.SIZE, f2);
            hashMap.put(TextAttribute.WEIGHT, bl ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            hashMap.put(TextAttribute.POSTURE, bl2 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            IlvFontChooser.this.j = true;
            IlvFontChooser.this.c.setSelectedFont(Font.getFont(hashMap));
            IlvFontChooser.this.j = false;
        }
    }
}

