/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.text;

import java.awt.font.TextAttribute;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IlvAttributedStringUtil {
    static HashMap a = null;
    static HashMap b = null;

    private IlvAttributedStringUtil() {
    }

    public static String getString(AttributedString attributedString) {
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n3) {
            attributedCharacterIterator.setIndex(n2++);
            stringBuffer.append(attributedCharacterIterator.current());
        }
        return stringBuffer.toString();
    }

    public static int length(AttributedString attributedString) {
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        return n3 - n2;
    }

    public static AttributedString substring(AttributedString attributedString, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        try {
            return new AttributedString(attributedString.getIterator(), n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StringIndexOutOfBoundsException(n3);
        }
    }

    public static AttributedString concat(AttributedString attributedString, AttributedString attributedString2) {
        String string = IlvAttributedStringUtil.getString(attributedString);
        String string2 = IlvAttributedStringUtil.getString(attributedString2);
        AttributedString attributedString3 = new AttributedString(string + string2);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString3, 0, string.length());
        IlvAttributedStringUtil.copyAttributes(attributedString2, 0, attributedString3, string.length(), string2.length());
        return attributedString3;
    }

    public static AttributedString concat(AttributedString attributedString, AttributedString attributedString2, AttributedString attributedString3) {
        String string = IlvAttributedStringUtil.getString(attributedString);
        String string2 = IlvAttributedStringUtil.getString(attributedString2);
        String string3 = IlvAttributedStringUtil.getString(attributedString3);
        AttributedString attributedString4 = new AttributedString(string + string2 + string3);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString4, 0, string.length());
        IlvAttributedStringUtil.copyAttributes(attributedString2, 0, attributedString4, string.length(), string2.length());
        IlvAttributedStringUtil.copyAttributes(attributedString3, 0, attributedString4, string.length() + string2.length(), string3.length());
        return attributedString4;
    }

    public static AttributedString concat(String string, AttributedString attributedString) {
        if (string.length() == 0) {
            return attributedString;
        }
        String string2 = string;
        String string3 = IlvAttributedStringUtil.getString(attributedString);
        AttributedString attributedString2 = new AttributedString(string2 + string3);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString2, string2.length(), string3.length());
        return attributedString2;
    }

    public static AttributedString concat(AttributedString attributedString, String string) {
        if (string.length() == 0) {
            return attributedString;
        }
        String string2 = IlvAttributedStringUtil.getString(attributedString);
        String string3 = string;
        AttributedString attributedString2 = new AttributedString(string2 + string3);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString2, 0, string2.length());
        if (string2.length() > 0 && string3.length() > 0) {
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            attributedCharacterIterator.setIndex(string2.length() - 1);
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            attributedString2.addAttributes(map, string2.length(), string2.length() + string3.length());
        }
        return attributedString2;
    }

    public static AttributedString concat(AttributedString attributedString, String string, AttributedString attributedString2) {
        String string2 = IlvAttributedStringUtil.getString(attributedString);
        String string3 = string;
        String string4 = IlvAttributedStringUtil.getString(attributedString2);
        AttributedString attributedString3 = new AttributedString(string2 + string3 + string4);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString3, 0, string2.length());
        IlvAttributedStringUtil.copyAttributes(attributedString2, 0, attributedString3, string2.length() + string3.length(), string4.length());
        if (string2.length() > 0 && string3.length() > 0) {
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            attributedCharacterIterator.setIndex(string2.length() - 1);
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            attributedString3.addAttributes(map, string2.length(), string2.length() + string3.length());
        }
        return attributedString3;
    }

    public static void copyAttributes(AttributedString attributedString, int n2, AttributedString attributedString2, int n3, int n4) {
        if (attributedString == attributedString2) {
            new IllegalArgumentException("Source and destination must be different");
        }
        if (n4 < 0) {
            new IllegalArgumentException("Negative length");
        }
        if (n4 == 0) {
            return;
        }
        try {
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            for (int i2 = 0; i2 < n4; ++i2) {
                attributedCharacterIterator.setIndex(n2 + i2);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                attributedString2.addAttributes(map, n3 + i2, n3 + i2 + 1);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public static void debugPrint(PrintStream printStream, AttributedString attributedString) {
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = attributedCharacterIterator.getEndIndex();
        for (int i2 = attributedCharacterIterator.getBeginIndex(); i2 < n2; ++i2) {
            attributedCharacterIterator.setIndex(i2);
            printStream.print("" + attributedCharacterIterator.current() + " | ");
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            Iterator<Map.Entry<AttributedCharacterIterator.Attribute, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<AttributedCharacterIterator.Attribute, Object> entry = iterator.next();
                AttributedCharacterIterator.Attribute attribute = entry.getKey();
                Object object = entry.getValue();
                printStream.print("  " + attribute.toString());
                printStream.print("=" + object.toString());
            }
            printStream.println("");
        }
    }

    public static String getTextAttributeName(TextAttribute textAttribute) {
        Object v2;
        if (b == null) {
            IlvAttributedStringUtil.a();
        }
        if ((v2 = b.get(textAttribute)) == null) {
            throw new RuntimeException("Unknown attribute: " + textAttribute);
        }
        return (String)v2;
    }

    public static TextAttribute getTextAttribute(String string) {
        Object v2;
        if (a == null) {
            IlvAttributedStringUtil.a();
        }
        if ((v2 = a.get(string)) == null) {
            throw new RuntimeException("Unknown attribute " + string);
        }
        return (TextAttribute)v2;
    }

    private static void a(String string, TextAttribute textAttribute) {
        a.put(string, textAttribute);
        b.put(textAttribute, string);
    }

    private static void a() {
        a = new HashMap();
        b = new HashMap();
        IlvAttributedStringUtil.a("family", TextAttribute.FAMILY);
        IlvAttributedStringUtil.a("weight", TextAttribute.WEIGHT);
        IlvAttributedStringUtil.a("width", TextAttribute.WIDTH);
        IlvAttributedStringUtil.a("posture", TextAttribute.POSTURE);
        IlvAttributedStringUtil.a("size", TextAttribute.SIZE);
        IlvAttributedStringUtil.a("transform", TextAttribute.TRANSFORM);
        IlvAttributedStringUtil.a("superscript", TextAttribute.SUPERSCRIPT);
        IlvAttributedStringUtil.a("font", TextAttribute.FONT);
        IlvAttributedStringUtil.a("foreground", TextAttribute.FOREGROUND);
        IlvAttributedStringUtil.a("background", TextAttribute.BACKGROUND);
        IlvAttributedStringUtil.a("underline", TextAttribute.UNDERLINE);
        IlvAttributedStringUtil.a("strikethrough", TextAttribute.STRIKETHROUGH);
        IlvAttributedStringUtil.a("run_direction", TextAttribute.RUN_DIRECTION);
        IlvAttributedStringUtil.a("bidi_embedding", TextAttribute.BIDI_EMBEDDING);
        IlvAttributedStringUtil.a("justification", TextAttribute.JUSTIFICATION);
        IlvAttributedStringUtil.a("input method highlight", TextAttribute.INPUT_METHOD_HIGHLIGHT);
        IlvAttributedStringUtil.a("input method underline", TextAttribute.INPUT_METHOD_UNDERLINE);
        IlvAttributedStringUtil.a("swap_colors", TextAttribute.SWAP_COLORS);
        IlvAttributedStringUtil.a("numeric_shaping", TextAttribute.NUMERIC_SHAPING);
        IlvAttributedStringUtil.a("char_replacement", TextAttribute.CHAR_REPLACEMENT);
    }
}

