/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.text;

import ilog.views.util.text.IlvNFRuleSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.ResourceBundle;

public class IlvRuleBasedNumberFormat
extends NumberFormat {
    public static final int SPELLOUT = 1;
    public static final int ORDINAL = 2;
    public static final int DURATION = 3;
    private IlvNFRuleSet[] a = null;
    private IlvNFRuleSet b = null;
    private Locale c = null;
    private Collator d = null;
    private DecimalFormatSymbols e = null;
    private boolean f = false;
    private String g = null;

    private IlvRuleBasedNumberFormat() {
    }

    public IlvRuleBasedNumberFormat(String string) {
        this.a(string, Locale.getDefault());
    }

    public IlvRuleBasedNumberFormat(String string, Locale locale) {
        this.a(string, locale);
    }

    public IlvRuleBasedNumberFormat(Locale locale, int n2) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ilog.views.util.text.resources.NumberFormatRules", locale);
        String string = "";
        switch (n2) {
            case 1: {
                string = resourceBundle.getString("SpelloutRules");
                break;
            }
            case 2: {
                string = resourceBundle.getString("OrdinalRules");
                break;
            }
            case 3: {
                string = resourceBundle.getString("DurationRules");
            }
        }
        this.a(string, locale);
    }

    public IlvRuleBasedNumberFormat(int n2) {
        this(Locale.getDefault(), n2);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IlvRuleBasedNumberFormat)) {
            return false;
        }
        IlvRuleBasedNumberFormat ilvRuleBasedNumberFormat = (IlvRuleBasedNumberFormat)object;
        if (!this.c.equals(ilvRuleBasedNumberFormat.c) || this.f != ilvRuleBasedNumberFormat.f) {
            return false;
        }
        if (this.a.length != ilvRuleBasedNumberFormat.a.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (this.a[i2].equals(ilvRuleBasedNumberFormat.a[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.c.hashCode();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            n2 = 37 * n2 + this.a[i2].hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            stringBuffer.append(this.a[i2].toString());
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        String string = objectInputStream.readUTF();
        IlvRuleBasedNumberFormat ilvRuleBasedNumberFormat = new IlvRuleBasedNumberFormat(string);
        this.a = ilvRuleBasedNumberFormat.a;
        this.b = ilvRuleBasedNumberFormat.b;
    }

    public String[] getRuleSetNames() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (this.a[i2].getName().startsWith("%%")) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        for (int i3 = this.a.length - 1; i3 >= 0; --i3) {
            if (this.a[i3].getName().startsWith("%%")) continue;
            stringArray[n2++] = this.a[i3].getName();
        }
        return stringArray;
    }

    public String format(double d2, String string) throws IllegalArgumentException {
        if (string.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.a(d2, this.a(string));
    }

    public String format(long l2, String string) throws IllegalArgumentException {
        if (string.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.a(l2, this.a(string));
    }

    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        stringBuffer.append(this.a(d2, this.b));
        return stringBuffer;
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        stringBuffer.append(this.a(l2, this.b));
        return stringBuffer;
    }

    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(new BigDecimal(bigInteger), stringBuffer, fieldPosition);
    }

    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(bigDecimal.doubleValue(), stringBuffer, fieldPosition);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        String string2 = string.substring(parsePosition.getIndex());
        ParsePosition parsePosition2 = new ParsePosition(0);
        Number number = null;
        Number number2 = new Long(0L);
        ParsePosition parsePosition3 = new ParsePosition(parsePosition2.getIndex());
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            if (this.a[i2].getName().startsWith("%%")) continue;
            number = this.a[i2].parse(string2, parsePosition2, Double.MAX_VALUE);
            if (parsePosition2.getIndex() > parsePosition3.getIndex()) {
                number2 = number;
                parsePosition3.setIndex(parsePosition2.getIndex());
            }
            if (parsePosition3.getIndex() == string2.length()) break;
            parsePosition2.setIndex(0);
        }
        parsePosition.setIndex(parsePosition.getIndex() + parsePosition3.getIndex());
        return number2;
    }

    public void setLenientParseMode(boolean bl) {
        this.f = bl;
        if (!bl) {
            this.d = null;
        }
    }

    public boolean isLenientParseMode() {
        return this.f;
    }

    public void setDefaultRuleSet(String string) {
        if (string == null) {
            this.d();
        } else {
            if (string.startsWith("%%")) {
                throw new IllegalArgumentException("cannot use private rule set: " + string);
            }
            this.b = this.a(string);
        }
    }

    IlvNFRuleSet a() {
        return this.b;
    }

    Collator b() {
        if (this.d == null && this.f) {
            try {
                RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.c);
                String string = ruleBasedCollator.getRules() + this.g;
                this.d = new RuleBasedCollator(string);
                this.d.setDecomposition(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.d = null;
            }
        }
        return this.d;
    }

    DecimalFormatSymbols c() {
        if (this.e == null) {
            this.e = new DecimalFormatSymbols(this.c);
        }
        return this.e;
    }

    private final void a(String string, Locale locale) {
        int n2;
        int n3;
        this.c = locale;
        int n4 = (string = this.b(string)).indexOf("%%lenient-parse:");
        if (n4 != -1 && (n4 == 0 || string.charAt(n4 - 1) == ';')) {
            n3 = string.indexOf(";%", n4);
            if (n3 == -1) {
                n3 = string.length() - 1;
            }
            n2 = n4 + "%%lenient-parse:".length();
            while (Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            this.g = string.substring(n2, n3);
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n4));
            if (n3 + 1 < string.length()) {
                stringBuffer.append(string.substring(n3 + 1));
            }
            string = stringBuffer.toString();
        }
        n3 = 0;
        n2 = string.indexOf(";%");
        while (n2 != -1) {
            ++n3;
            ++n2;
            n2 = string.indexOf(";%", n2);
        }
        this.a = new IlvNFRuleSet[++n3];
        String[] stringArray = new String[n3];
        int n5 = 0;
        int n6 = 0;
        int n7 = string.indexOf(";%");
        while (n7 != -1) {
            stringArray[n5] = string.substring(n6, n7 + 1);
            this.a[n5] = new IlvNFRuleSet(stringArray, n5);
            ++n5;
            n6 = n7 + 1;
            n7 = string.indexOf(";%", n6);
        }
        stringArray[n5] = string.substring(n6);
        this.a[n5] = new IlvNFRuleSet(stringArray, n5);
        this.d();
        for (n7 = 0; n7 < this.a.length; ++n7) {
            this.a[n7].parseRules(stringArray[n7], this);
            stringArray[n7] = null;
        }
    }

    private String b(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 != -1 && n2 < string.length()) {
            while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            int n3 = string.indexOf(59, n2);
            if (n3 == -1) {
                stringBuffer.append(string.substring(n2));
                n2 = -1;
                continue;
            }
            if (n3 < string.length()) {
                stringBuffer.append(string.substring(n2, n3 + 1));
                n2 = n3 + 1;
                continue;
            }
            n2 = -1;
        }
        return stringBuffer.toString();
    }

    private void d() {
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            if (this.a[i2].getName().startsWith("%%")) continue;
            this.b = this.a[i2];
            return;
        }
        this.b = this.a[this.a.length - 1];
    }

    String a(double d2, IlvNFRuleSet ilvNFRuleSet) {
        StringBuffer stringBuffer = new StringBuffer();
        ilvNFRuleSet.format(d2, stringBuffer, 0);
        return stringBuffer.toString();
    }

    String a(long l2, IlvNFRuleSet ilvNFRuleSet) {
        StringBuffer stringBuffer = new StringBuffer();
        ilvNFRuleSet.format(l2, stringBuffer, 0);
        return stringBuffer.toString();
    }

    IlvNFRuleSet a(String string) throws IllegalArgumentException {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (!this.a[i2].getName().equals(string)) continue;
            return this.a[i2];
        }
        throw new IllegalArgumentException("No rule set named " + string);
    }
}

