/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import javax.swing.JTextField;

public class EditIpAddressInForm
extends EditForm {
    int _addrPos;
    int _addrTypePos;
    int _addrType = 1;
    protected String _addrVar;
    protected String _addrTypeVar;

    public EditIpAddressInForm(String[] vars, String addrVar, String addrTypeVar) {
        super(vars);
        this._addrVar = addrVar;
        this._addrTypeVar = addrTypeVar;
        this._addrPos = this.getVarIndex(this._addrVar);
        this._addrTypePos = this.getVarIndex(addrTypeVar);
    }

    protected void setComponentValue(int i, SnmpVar v) {
        if (i == this._addrPos) {
            if (this._addrType == 1 || this._addrType == 2) {
                ((JTextField)this._values[i]).setText(SnmpIpAddress.toString((byte[])((SnmpString)v).getValue()));
            } else {
                ((JTextField)this._values[i]).setText(v.toString());
            }
        } else {
            if (i == this._addrTypePos) {
                this._addrType = ((SnmpInt)v).getValue();
            }
            super.setComponentValue(i, v);
        }
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._addrPos) {
            String serverAddr = this.getComponentText(index);
            if (this._mibNodes[index].getMaxWidth() < serverAddr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() > serverAddr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " minimum length is " + this._mibNodes[index].getMinWidth());
            }
            this._addrType = ((SnmpInt)this.getComponentValue(this._addrTypePos)).getValue();
            if (this._addrType == 1 || this._addrType == 2) {
                byte[] addrB = SnmpIpAddress.parse((String)serverAddr);
                return new SnmpString(addrB);
            }
            return new SnmpString(serverAddr);
        }
        return super.getComponentValue(index);
    }
}

