/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_68;
import com.cisco.dcbu.dmdb.andiamo.elements.IPSEthPort;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;

public final class FcipStatusFetch {
    static FcipStatusFetch _Instance;
    SnmpPeer _peer;
    HashMap _gigEHash = new HashMap();
    HashMap _fcipHash = new HashMap();
    Array _fcipIndexList = new Array();
    int _maxFCIP = 0;

    private FcipStatusFetch() {
    }

    public static FcipStatusFetch getInstance() {
        if (_Instance == null) {
            _Instance = new FcipStatusFetch();
        }
        return _Instance;
    }

    public void updateFcipLeds(SnmpPeer peer) {
        block2: {
            this._peer = peer;
            VarBindList vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cfmFcipLinkExtEthIfIndex").getOid())));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get((String)"cfmFcipLinkIfIndex").getOid())));
            try {
                SnmpFetch fetch = new SnmpFetch();
                this.processResp(SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl).getVariables());
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._DefLogger.debug((Object)("failed to fetch fcip interface list: " + (Object)((Object)ex)));
            }
        }
    }

    private void processResp(VarBindList vbl) {
        block3: {
            this._gigEHash = new HashMap();
            if (vbl.size() == 0) {
                this.updateView();
                return;
            }
            VarBindList fcipOperStatVbl = this.buildFCIPList(vbl);
            try {
                SnmpPDU resp = this._peer.send(new SnmpPDU(-96, fcipOperStatVbl));
                this.updateFCIPOperStatus(resp.getVariables());
                this.updateView();
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block3;
                DefaultLogger._DefLogger.debug((Object)"failed to fetch fcip interface operStatus");
                ex.printStackTrace();
            }
        }
    }

    VarBindList buildFCIPList(VarBindList vbl) {
        VarBindList fcipOperStatVbl;
        block8: {
            int channel;
            HashMap<Integer, Integer> channelGigEHash = new HashMap<Integer, Integer>();
            this._fcipIndexList = new Array();
            fcipOperStatVbl = new VarBindList();
            VarBindList channelVbl = new VarBindList();
            for (int i = 0; i < vbl.size(); i += 2) {
                int gigEInterface = vbl.intValue(i);
                int fcipInterface = vbl.intValue(i + 1);
                if (IfIndexUtil.getType((int)gigEInterface) == 4) {
                    channel = IfIndexUtil.ifIndex2PortChannel((int)gigEInterface) + 1;
                    channelVbl.add(MibNode.get((String)"portChannelMemberList").getOid(), new int[]{channel});
                    channelGigEHash.put(new Integer(channel), new Integer(fcipInterface));
                } else {
                    this.addToList(gigEInterface &= 0xFFFF000, fcipInterface);
                }
                fcipOperStatVbl.add(MibNode.get((String)"ifOperStatus").getOid(), new int[]{fcipInterface});
            }
            if (channelVbl.size() > 0) {
                try {
                    SnmpPDU resp = this._peer.send(new SnmpPDU(-96, channelVbl));
                    for (int i = 0; i < resp.getVariables().size(); ++i) {
                        int[] oid = resp.getVariables().get(i).getOid().getValue();
                        channel = oid[oid.length - 1];
                        int[] members = SnmpIntList.valueOf((byte[])resp.getVariables().byteValue(i));
                        for (int j = 0; j < members.length; ++j) {
                            if (IfIndexUtil.getType((int)members[j]) != 2) continue;
                            int n = j;
                            members[n] = members[n] & 0xFFFF000;
                            if (channelGigEHash.get(new Integer(channel)) == null) continue;
                            this.addToList(members[j], (Integer)channelGigEHash.get(new Integer(channel)));
                        }
                    }
                }
                catch (SnmpException ex) {
                    if (!SnmpSession.isTrace()) break block8;
                    DefaultLogger._DefLogger.debug((Object)"failed to fetch channel members");
                    ex.printStackTrace();
                }
            }
        }
        return fcipOperStatVbl;
    }

    void updateFCIPOperStatus(VarBindList vbl) {
        this._fcipHash = new HashMap();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            int fcipInterface = oid[oid.length - 1];
            int operStatus = vbl.intValue(i);
            this._fcipHash.put(new Integer(fcipInterface), new Integer(operStatus));
        }
    }

    void updateView() {
        try {
            PhysicalView view = DeviceManager.getInstance().getView();
            Array elements = view.getElements();
            Graphics g = view.getOffscreenImage().getGraphics();
            Color bg = new Color(66, 66, 66);
            g.setColor(bg);
            for (int i = 0; i < elements.size(); ++i) {
                int j;
                PhysicalElement e = (PhysicalElement)elements.elementAt(i);
                int n = this._maxFCIP = e.getParent() instanceof Card_68 ? 6 : 3;
                if (!(e instanceof IPSEthPort)) continue;
                IPSEthPort port = (IPSEthPort)e;
                int[][] fcipLinks = new int[this._maxFCIP][2];
                StringBuffer sb = new StringBuffer();
                int index = e.getIndex()[0];
                Rectangle r = e.getRect();
                Array fcipList = (Array)this._gigEHash.get(new Integer(index));
                Color fcipOperColor = Color.green;
                if (fcipList != null) {
                    for (j = 0; j < this._maxFCIP; ++j) {
                        if (j >= fcipList.size()) {
                            fcipLinks[j][1] = -1;
                            fcipLinks[j][0] = -1;
                            sb.append("<br>");
                            sb.append(j + 1 + "- fcip: unused");
                            continue;
                        }
                        int fcipInterface = (Integer)fcipList.elementAt(j);
                        Object oper = this._fcipHash.get(new Integer(fcipInterface));
                        if (oper != null) {
                            fcipLinks[j][0] = fcipInterface;
                            fcipLinks[j][1] = (Integer)oper;
                            String operString = (Integer)oper == 1 ? ": up" : ": down";
                            sb.append("<br>");
                            sb.append(j + 1 + "- ");
                            sb.append(Discover.getRoot().ifIndexToName(fcipInterface));
                            sb.append(operString);
                            continue;
                        }
                        fcipLinks[j][1] = -1;
                        fcipLinks[j][0] = -1;
                    }
                    if (!port._fcipStatusToolTipText.equals(sb.toString())) {
                        port._fcipStatusChanged = true;
                        port._fcipStatusToolTipText = sb.toString();
                    } else {
                        port._fcipStatusChanged = true;
                    }
                } else {
                    for (j = 0; j < this._maxFCIP; ++j) {
                        fcipLinks[j][1] = -1;
                        fcipLinks[j][0] = -1;
                    }
                    for (j = 0; j < this._maxFCIP; ++j) {
                        sb.append("<br>");
                        sb.append(j + 1 + "- fcip: unused");
                    }
                    if (!port._fcipStatusToolTipText.equals(sb.toString())) {
                        port._fcipStatusChanged = true;
                        port._fcipStatusToolTipText = sb.toString();
                    } else {
                        port._fcipStatusChanged = true;
                    }
                }
                port.drawFcipLed(g, fcipLinks);
            }
            g.dispose();
            view.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToList(int gigEInterface, int fcipInterface) {
        Array fcipList = (Array)this._gigEHash.get(new Integer(gigEInterface));
        if (fcipList == null) {
            fcipList = new Array(1);
        }
        fcipList.addElement((Object)new Integer(fcipInterface));
        this._gigEHash.put(new Integer(gigEInterface), fcipList);
    }
}

