/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmPreferences;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ShowTech
extends JDialog
implements ActionListener {
    static final String[] LABELS = new String[]{null, "TCP Timeout:", "FileName:", null};
    static final String[] BTNS = new String[]{"Start", "Help", "Close"};
    FieldPanel _path;
    JCheckBox _zip;
    SnmpPeer _peer;
    JFrame _parent;
    Timer _timer;
    JButton[] _btns;
    JLabel _status;
    FieldPanel _timeout;
    VshThread _vshThread;

    public ShowTech(JFrame parent) {
        super(parent);
        this._parent = parent;
        JComponent[] labels = DialogUtil.buildLabels((String[])LABELS);
        JComponent[] values = new JComponent[labels.length];
        JButton btn = new JButton("...");
        btn.addActionListener(this);
        btn.setMargin(DialogUtil.getInsets());
        String fileName = DmPreferences._ShowTechFileName;
        if (fileName.equals("showtech.txt")) {
            fileName = ClientCache.getLocation() + "showtech.txt";
        }
        KTextField tf = new KTextField(fileName, 35);
        this._path = new FieldPanel(tf, (JComponent)btn);
        this._zip = new JCheckBox("Compress File (eg. showtech.txt.zip)", true);
        this._timeout = new FieldPanel(3, 30, 1, 600, "secs");
        values[0] = new DialogSeparator("Capture Show Tech Output to File");
        values[1] = this._timeout;
        values[2] = this._path;
        values[3] = this._zip;
        JPanel panel = DialogUtil.buildPanel((JComponent[])labels, (JComponent[])values);
        this._btns = DialogUtil.buildButtons((String[])BTNS, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._btns.length; ++i) {
            buttonPanel.add(this._btns[i]);
        }
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add("North", buttonPanel);
        this._status = new JLabel(" ");
        southPanel.add("South", this._status);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)panel, (JPanel)southPanel);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    public void showDialog(SnmpPeer peer) {
        this._peer = peer;
        this.setTitle(Discover.getDeviceName() + " - Show Tech");
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            if (e.getSource() instanceof Timer) {
                this._status.setText("Received " + this._vshThread.getRx() + " bytes.");
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                try {
                    String cmd = ((JButton)e.getSource()).getText();
                    switch (cmd.charAt(0)) {
                        case '.': {
                            String file = Util.getFileName((JFrame)this._parent, (String)"*.*", (int)0, (boolean)true);
                            if (file == null) break;
                            this._path.setText(file);
                            break;
                        }
                        case 'S': {
                            int opt;
                            int timeout;
                            String path = DmPreferences._ShowTechFileName = this._path.getText();
                            try {
                                timeout = Integer.parseInt(this._timeout.getText());
                            }
                            catch (Exception ex) {
                                Util.errorMessage((Component)this, (String)("TCP Timeout: " + ex.getMessage()));
                                return;
                            }
                            boolean zip = this._zip.isSelected();
                            if (path.length() == 0) {
                                Util.errorMessage((Component)this, (String)"No path specified");
                                return;
                            }
                            File pathFile = new File(path);
                            File zipFile = new File(path + ".zip");
                            if ((pathFile.exists() || zip && zipFile.exists()) && (opt = JOptionPane.showConfirmDialog(this, "File exists, do you want to overwrite?", this.getTitle(), 0)) == 1) {
                                return;
                            }
                            this._vshThread = new VshThread(this, path, timeout, zip);
                            this._status.setText(" ");
                            this._btns[0].setEnabled(false);
                            this._status.setText("Starting");
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this._vshThread.start();
                            this._timer = new Timer(2000, this);
                            this._timer.start();
                            break;
                        }
                        case 'H': {
                            try {
                                String htmlFile = "showTech";
                                DeviceManager.getInstance().helpDialog(htmlFile);
                            }
                            catch (Exception ex) {
                                Util.errorMessage((Component)this._parent, (String)ex.getMessage());
                            }
                            break;
                        }
                        case 'C': {
                            int opt;
                            if (!this._btns[0].isEnabled() && (opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", this.getTitle(), 0)) == 1) {
                                return;
                            }
                            this.stop();
                            this.setVisible(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    System.gc();
                                }
                            });
                        }
                    }
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, (Exception)ex);
                    if (!SnmpSession.isTrace()) break block17;
                    DefaultLogger._DefLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    void stop() {
        this._btns[0].setEnabled(true);
        if (this._timer != null) {
            this._timer.stop();
        }
        if (this._vshThread != null && this._vshThread._vsh != null) {
            this._vshThread._vsh.disconnect();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    class VshThread
    extends Thread {
        Vsh _vsh;
        int _timeout;
        String _path;
        JDialog _dlg;
        boolean _zip;
        OutputStream _out;

        VshThread(JDialog dlg, String path, int timeout, boolean zip) {
            this._dlg = dlg;
            this._path = path;
            this._timeout = timeout;
            this._zip = zip;
        }

        int getRx() {
            if (this._vsh != null) {
                return this._vsh.getRx();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void zip() throws IOException {
            try (ZipOutputStream out = null;){
                String zipfile = this._path + ".zip";
                out = new ZipOutputStream(new FileOutputStream(zipfile));
                out.setMethod(8);
                File f = new File(this._path);
                try (FileInputStream in = new FileInputStream(f);){
                    int count;
                    long lastModified = f.lastModified() + 1999L;
                    ZipEntry ze = new ZipEntry(f.getName());
                    ze.setTime(lastModified);
                    out.putNextEntry(ze);
                    byte[] buffer = new byte[8192];
                    while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, count);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int timeout = -1;
            try {
                this._out = new FileOutputStream(this._path);
                this._vsh = Vsh.get((JFrame)ShowTech.this._parent, (SnmpPeer)ShowTech.this._peer, (boolean)ExternalTools.isUseSSH());
                if (this._vsh != null) {
                    timeout = this._vsh.getTcpTimeout();
                    this._vsh.setTcpTimeout(this._timeout * 1000);
                    this._vsh.resetRx();
                    this._vsh.send("show tech-support details\n");
                    this._vsh.read(this._out);
                    this._out.close();
                    this._out = null;
                    String prompt = this._vsh.getPrompt();
                    RandomAccessFile raf = new RandomAccessFile(this._path, "r");
                    int len = (int)raf.length();
                    int offset = len - 1 - prompt.length() - 10;
                    if (offset <= 0) {
                        if (SnmpSession.isTrace()) {
                            DefaultLogger._DefLogger.debug((Object)("Show Tech File Size is " + len));
                            DefaultLogger._DefLogger.debug((Object)("Seek offset = " + offset));
                        }
                        throw new IOException(this._path + " file is corrupted");
                    }
                    raf.seek(offset);
                    byte[] b = new byte[prompt.length() + 10];
                    raf.readFully(b);
                    String lastLines = new String(b).trim();
                    if (!lastLines.endsWith(prompt)) {
                        Util.errorMessage((Component)this._dlg, (String)"Incomplete output, timed out.");
                        if (SnmpSession.isTrace()) {
                            DefaultLogger._DefLogger.debug((Object)("Show Tech Output expected " + prompt));
                            DefaultLogger._DefLogger.debug((Object)lastLines);
                        }
                    }
                    raf.close();
                    if (this._zip) {
                        this.zip();
                        new File(this._path).delete();
                    }
                }
            }
            catch (Exception ex) {
                if (ShowTech.this.isVisible()) {
                    Util.errorMessage((Component)this._dlg, (Exception)ex);
                }
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this._vsh != null) {
                if (timeout != -1) {
                    this._vsh.setTcpTimeout(timeout);
                }
                Vsh.put((Vsh)this._vsh);
            }
            ShowTech.this._timer.stop();
            ShowTech.this._status.setText("Done");
            ShowTech.this.setCursor(Cursor.getDefaultCursor());
            ShowTech.this._btns[0].setEnabled(true);
        }
    }
}

