/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.jnm.VshBase;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.regex.Matcher;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ShowTechTacPac
extends JDialog
implements ActionListener,
ItemListener {
    static final String[] LABELS = new String[]{null, "Protocol", "TCP Timeout:", "Management Inteface:", "ServerAddress:", "UserName: ", "UserPassword: ", "FileName:"};
    static final String[] BTNS = new String[]{"Start", "Help", "Close"};
    static final int SERVERIP = 4;
    static final int USERNAME = 5;
    static final int PASSWORD = 6;
    static final int LOCAL_TFTP = 0;
    static final int SFTP = 1;
    static final int DEFAULT_MGMTINTERFACE = 0;
    static final int VRF_MGMT_MGMTINTERFACE = 1;
    static final int VRF_DEFAULT_MGMTINTERFACE = 2;
    KTextField _fileName;
    SnmpPeer _peer;
    JFrame _parent;
    Timer _timer;
    JButton[] _btns;
    JLabel _status;
    RadioButtonPanel _protocol;
    FieldPanel _timeout;
    RadioButtonPanel _mgmtInterface;
    KTextField _serverIP;
    KTextField _userName;
    JPasswordField _password;
    VshThread _vshThread;
    JLabel[] _labels;
    long tStart = 0L;
    static JLabel FileNameTip = new JLabel(" (Path may need to be relative to TFTP root)");

    public ShowTechTacPac(JFrame parent) {
        super(parent);
        this._parent = parent;
        this._labels = DialogUtil.buildLabels((String[])LABELS);
        JComponent[] values = new JComponent[this._labels.length];
        this._protocol = new RadioButtonPanel((Object[])new String[]{"Local DCNM-SAN TFTP", "SFTP"}, 3);
        this._fileName = new KTextField(35);
        JPanel fileNamePanel = new JPanel(new BorderLayout());
        fileNamePanel.add((Component)FileNameTip, "East");
        fileNamePanel.add((Component)this._fileName, "West");
        this._timeout = new FieldPanel(3, 15, 1, 60, "min");
        this._mgmtInterface = new RadioButtonPanel((Object[])new String[]{"default", "vrf management", "vrf default"}, 4);
        this._serverIP = new KTextField(30);
        this._userName = new KTextField(30);
        this._password = new JPasswordField(30);
        values[0] = new DialogSeparator("Download Show Tech Tac-Pac gzip File");
        values[1] = this._protocol;
        values[2] = this._timeout;
        values[3] = this._mgmtInterface;
        values[4] = this._serverIP;
        values[5] = this._userName;
        values[6] = this._password;
        values[7] = fileNamePanel;
        this._protocol.addChangeListener((ItemListener)this);
        this._serverIP.setText(NetUtil.getLocalServerHostAddress());
        this._mgmtInterface.setSelected(0);
        JPanel panel = DialogUtil.buildPanel((JComponent[])this._labels, (JComponent[])values);
        this._btns = DialogUtil.buildButtons((String[])BTNS, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < this._btns.length; ++i) {
            buttonPanel.add(this._btns[i]);
        }
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add("North", buttonPanel);
        this._status = new JLabel(" ");
        southPanel.add("South", this._status);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)panel, (JPanel)southPanel);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this._userName.setEnabled(this._protocol.getSelected() == 1);
            this._password.setEnabled(this._protocol.getSelected() == 1);
            this._serverIP.setEnabled(this._protocol.getSelected() == 1);
            FileNameTip.setVisible(this._protocol.getSelected() == 0);
            this._labels[5].setEnabled(this._protocol.getSelected() == 1);
            this._labels[6].setEnabled(this._protocol.getSelected() == 1);
            this._labels[4].setEnabled(this._protocol.getSelected() == 1);
            this._fileName.setText(this._peer.getAddress().getHostAddress() + "-showtech.gz");
        }
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    public void showDialog(SnmpPeer peer) {
        this._peer = peer;
        this._fileName.setText(this._peer.getAddress().getHostAddress() + "-showtech.gz");
        this.setTitle(Discover.getDeviceName() + " - Show Tech Tac-Pac");
        this._protocol.setSelected(1);
        FileNameTip.setVisible(false);
        this._protocol.getButton(0).setEnabled(TFTP.canStartServer());
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block15: {
            if (e.getSource() instanceof Timer) {
                this.tStart += 3L;
                this._status.setText("Saving show tech, elapsed time " + this.tStart + " sec ...");
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                try {
                    String cmd = ((JButton)e.getSource()).getText();
                    switch (cmd.charAt(0)) {
                        case 'S': {
                            int timeout;
                            String fileName = this._fileName.getText();
                            String mgmtInterface = !this._mgmtInterface.isEnabled() ? "" : (this._mgmtInterface.getSelected() == 0 ? "" : (this._mgmtInterface.getSelected() == 1 ? " vrf management" : " vrf default"));
                            String serverIP = this._serverIP.getText() + mgmtInterface;
                            String userName = this._userName.getText();
                            String password = this._password.getText();
                            try {
                                timeout = Integer.parseInt(this._timeout.getText());
                            }
                            catch (Exception ex) {
                                Util.errorMessage((Component)this, (String)("TCP Timeout: " + ex.getMessage()));
                                return;
                            }
                            if (fileName.length() == 0) {
                                Util.errorMessage((Component)this, (String)"No fileName specified");
                                return;
                            }
                            this._vshThread = new VshThread(this, fileName, timeout, serverIP, userName, password);
                            this._status.setText(" ");
                            this._btns[0].setEnabled(false);
                            this._status.setText("Starting");
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this._vshThread.start();
                            this._timer = new Timer(3000, this);
                            this._timer.start();
                            break;
                        }
                        case 'H': {
                            try {
                                String htmlFile = "showTech";
                                DeviceManager.getInstance().helpDialog(htmlFile);
                            }
                            catch (Exception ex) {
                                Util.errorMessage((Component)this._parent, (String)ex.getMessage());
                            }
                            break;
                        }
                        case 'C': {
                            int opt;
                            if (!this._btns[0].isEnabled() && (opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to quit?", this.getTitle(), 0)) == 1) {
                                return;
                            }
                            this.stop();
                            this.setVisible(false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    System.gc();
                                }
                            });
                        }
                    }
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, (Exception)ex);
                    if (!SnmpSession.isTrace()) break block15;
                    DefaultLogger._DefLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    void stop() {
        this._btns[0].setEnabled(true);
        if (this._timer != null) {
            this._timer.stop();
        }
        if (this._vshThread != null && this._vshThread._vsh != null) {
            this._vshThread._vsh.disconnect();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    class VshThread
    extends Thread {
        VshBase _vsh;
        int _timeout;
        String _fileName;
        String _serverIP;
        String _userName;
        String _password;
        JDialog _dlg;

        VshThread(JDialog dlg, String fileName, int timeout, String serverIP, String userName, String password) {
            this._dlg = dlg;
            this._fileName = fileName;
            this._timeout = timeout;
            this._serverIP = serverIP;
            this._userName = userName;
            this._password = password;
        }

        int getRx() {
            if (this._vsh != null) {
                return this._vsh.getRx();
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int timeout = -1;
            int origTimeout = Vsh.getTimeout();
            try {
                this._vsh = Vsh.getNew((JFrame)ShowTechTacPac.this._parent, (String)ShowTechTacPac.this._peer.getAddress().getHostAddress(), (String)ShowTechTacPac.this._peer.getUserName(), (String)ShowTechTacPac.this._peer.getAuthPassword(), (boolean)ExternalTools.isUseSSH(), (String)"com.cisco.dcbu.lib.jnm.VshBase", null);
                if (this._vsh != null) {
                    this._vsh.setTcpTimeout(this._timeout * 60 * 1000);
                    String showtechFile = null;
                    StringBuffer errorInfo = new StringBuffer();
                    ShowTechTacPac.this._status.setText("Start...");
                    ShowTechTacPac.this.tStart = 0L;
                    if (ShowTechTacPac.this._protocol.getSelected() == 1) {
                        if (this._userName.trim().length() == 0) {
                            throw new Exception("Please specify User Name");
                        }
                        if (this._password.trim().length() == 0) {
                            throw new Exception("Please specify Password");
                        }
                        if (this._fileName.trim().length() == 0) {
                            throw new Exception("Please specify fileName");
                        }
                        if (this._fileName.startsWith("/")) {
                            this._fileName = this._fileName.substring(1);
                        }
                        showtechFile = this._vsh.tacpacSwitch(ShowTechTacPac.this._peer.getAddress().getHostAddress(), this._fileName, this._serverIP, this._userName, this._password, "", 3, null, errorInfo);
                    } else {
                        showtechFile = this._vsh.tacpacSwitch(ShowTechTacPac.this._peer.getAddress().getHostAddress(), this._fileName, null, null, "", 1, null, errorInfo);
                    }
                    if (showtechFile == null) {
                        throw new Exception("Failed to get Show Tech. " + errorInfo.toString());
                    }
                    JOptionPane.showMessageDialog(this._dlg, "Show tech saved at " + showtechFile.replaceAll(Matcher.quoteReplacement(File.separator + File.separator), Matcher.quoteReplacement(File.separator)));
                }
            }
            catch (Exception ex) {
                if (ShowTechTacPac.this.isVisible()) {
                    Util.errorMessage((Component)this._dlg, (Exception)ex);
                }
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                Vsh.setTimeout((int)origTimeout);
            }
            if (this._vsh != null) {
                if (timeout != -1) {
                    this._vsh.setTcpTimeout(timeout);
                }
                this._vsh.disconnect();
                this._vsh = null;
            }
            ShowTechTacPac.this._timer.stop();
            ShowTechTacPac.this._status.setText("Done");
            ShowTechTacPac.this.setCursor(Cursor.getDefaultCursor());
            ShowTechTacPac.this._btns[0].setEnabled(true);
            Vsh.setTimeout((int)origTimeout);
        }
    }
}

