/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.event.InsertEventTarget;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.EditUserTable;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditEventTargetTable
extends EditTable {
    private int SECURITY = 2;
    private int MODEL = 3;
    private int TYPE = 4;
    private int INFORM_TO = 5;
    private int INFORM_RETRY = 6;
    int[] _snmpTargetParamsSecurityModelOid = MibNode.get((String)"snmpTargetParamsSecurityModel").getOid();
    MibEnum[] _snmpTargetParamsSecurityModelEnums = MibNode.get((String)"snmpTargetParamsSecurityModel").getEnums();

    public EditEventTargetTable(String[] vars) {
        super(vars);
    }

    protected void buildTable() {
        super.buildTable();
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[this.MODEL] = false;
        this._tableModel.setEditable(isEditable);
    }

    protected void postProcessing() throws SnmpException {
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            if (!(row[this.SECURITY] instanceof SnmpString)) continue;
            byte[] b = ((SnmpString)row[this.SECURITY]).getValue();
            int[] index = new int[b.length];
            for (int j = 0; j < b.length; ++j) {
                index[j] = b[j] & 0xFF;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(this._snmpTargetParamsSecurityModelOid, index)));
        }
        if (vbl.size() == 0) {
            return;
        }
        SnmpPDU resp = SnmpFetch.get((SnmpPeer)this.getPeer(), (VarBindList)vbl);
        if (resp == null || resp.getVariables().size() == 0) {
            return;
        }
        vbl = resp.getVariables();
        for (int i = 0; i < vbl.size() && i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            row[this.MODEL] = MibEnum.getLabel((MibEnum[])this._snmpTargetParamsSecurityModelEnums, (int)vbl.intValue(i));
            this._tableModel.setNoSuchInstance(i, this.MODEL, false);
        }
    }

    protected void delete() throws SnmpException {
        int[] selected = this._table.getSelectedRows();
        int[][] index = new int[selected.length][];
        for (int i = 0; i < selected.length; ++i) {
            String security;
            Object securityParam = this._tableModel.getValueAt(selected[i], this.SECURITY);
            if (!(securityParam instanceof SnmpString) || (security = ((SnmpString)securityParam).toString()).equals("v1") || security.equals("v2c") || security.equals("v3")) continue;
            byte[] b = ((SnmpString)securityParam).getValue();
            int[] paramIndex = new int[b.length];
            for (int j = 0; j < paramIndex.length; ++j) {
                paramIndex[j] = b[j] & 0xFF;
            }
            index[i] = paramIndex;
        }
        SnmpPDU deletePdu = this.usmV3TrapUserDelete();
        super.delete();
        this.securityParamDelete(index);
        if (deletePdu.getVariables().size() > 0) {
            this.getPeer().send(deletePdu);
        }
    }

    void securityParamDelete(int[][] index) throws SnmpException {
        if (index.length == 0) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(index.length));
        for (int i = 0; i < index.length; ++i) {
            if (index[i] == null) continue;
            pdu.addVar(new SnmpOID(InsertEventTarget._snmpTargetParamsRowStatusOid, index[i]), (SnmpVar)new SnmpInt(this._deleteValue));
        }
        if (pdu.getVariables().size() > 0) {
            SnmpFetch.set((SnmpPeer)this.getPeer(), (SnmpPDU)pdu);
        }
    }

    SnmpPDU usmV3TrapUserDelete() throws SnmpException {
        int[] index;
        SnmpPDU deletePdu = new SnmpPDU(-93, new VarBindList());
        SnmpPDU getPdu = new SnmpPDU(-96, new VarBindList());
        int[] selected = this._table.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            String ip = (String)this._tableModel.getValueAt(selected[i], 1);
            int slash = ip.indexOf(47);
            this.getPeer().getSession();
            byte[] myEngineId = SnmpSession.formEngineId((byte[])SnmpIpAddress.parse((String)ip.substring(0, slash)));
            index = EditUserTable.getUserIndex(myEngineId, "TrapUserV3");
            if (!(this._tableModel.getValueAt(selected[i], 2) instanceof SnmpString) || !((SnmpString)this._tableModel.getValueAt(selected[i], 2)).toString().equals("v3")) continue;
            getPdu.addNull(new SnmpOID(InsertEventTarget._usmUserCloneFromOid, index));
        }
        if (getPdu.getVariables().size() > 0) {
            SnmpPDU resp = this.getPeer().send(getPdu);
            for (int i = 0; i < resp.getVariables().size(); ++i) {
                SnmpVar v = resp.getVar(0);
                if (v.getType() == 5) continue;
                int[] oid = resp.getVariables().get(i).getOid().getValue();
                index = new int[oid.length - InsertEventTarget._usmUserCloneFromOid.length];
                System.arraycopy(oid, InsertEventTarget._usmUserCloneFromOid.length, index, 0, index.length);
                deletePdu.addVar(new SnmpOID(InsertEventTarget._usmUserStatusOid, index), (SnmpVar)new SnmpInt(6));
            }
        }
        return deletePdu;
    }

    protected DmTableModel buildTableModel() {
        return new SnmpDestTableModel();
    }

    class SnmpDestTableModel
    extends DmTableModel {
        SnmpDestTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            if ((col == EditEventTargetTable.this.INFORM_TO || col == EditEventTargetTable.this.INFORM_RETRY) && row < EditEventTargetTable.this._data.size()) {
                Object o = this.getValueAt(row, EditEventTargetTable.this.TYPE);
                return o != null && o.toString().length() > 0 && o.toString().charAt(0) == 'i';
            }
            return super.isCellActive(row, col);
        }
    }
}

