/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class EditFCCForm
extends EditForm {
    static final String[] _Labels = new String[]{null, "Priority:"};
    Timer _timer;
    VshThread _thread;
    int _timeElapsed;

    public EditFCCForm(String[] vars) {
        super(vars);
    }

    protected void build() {
        this._labels = DialogUtil.buildLabels((String[])_Labels);
        this._values = new JComponent[_Labels.length];
        this._values[0] = new JCheckBox("Enable");
        this._values[1] = new FieldPanel(5, 1, 7, null);
        this.addChangeListener(0);
        this.addChangeListener(1);
        this.layoutForm();
        ((JPanel)this._container).setBorder(DialogUtil._Margin);
        this.buildButtons();
        ((FieldPanel)this._values[1]).setText("4");
        this.getButton('R').setVisible(false);
        this.enableButton('A', false);
    }

    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt((Object)"Apply", 0);
        return btns;
    }

    protected void get() {
        this.enableButton('A', false);
        ((JCheckBox)this._values[0]).setSelected(false);
        ((FieldPanel)this._values[1]).setText("4");
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (e.getSource() instanceof Timer) {
            this._timeElapsed += 2;
            this.setStatus("In progress..." + this._timeElapsed + " secs");
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            switch (((JButton)e.getSource()).getText().charAt(0)) {
                case 'A': {
                    this._thread = new VshThread((JDialog)this.getParent(), ((JCheckBox)this._values[0]).isSelected(), ((FieldPanel)this._values[1]).getInt());
                    this.setStatus(" ");
                    this.setStatus("Starting");
                    this._parent.setCursor(Cursor.getPredefinedCursor(3));
                    this._thread.start();
                    this._timer = new Timer(2000, (ActionListener)((Object)this));
                    this._timer.start();
                    break;
                }
                case 'C': {
                    if (this._thread != null) {
                        this._thread.abort();
                    }
                    if (this._timer != null) {
                        this._timer.stop();
                    }
                    this.dispose();
                    super.doIt(ch, e);
                    break;
                }
                case 'H': {
                    DeviceManager.getInstance().helpDialog("fcc");
                    break;
                }
                default: {
                    super.doIt(ch, e);
                }
            }
        }
    }

    class VshThread
    extends Thread {
        Vsh _vsh;
        JDialog _dlg;
        boolean _abort;
        String _cmd;

        VshThread(JDialog dlg, boolean enable, int priority) {
            this._dlg = dlg;
            this._cmd = enable ? "fcc priority " + priority + "\nfcc" : "no fcc";
        }

        void abort() {
            this._abort = true;
            if (EditFCCForm.this._timer != null) {
                EditFCCForm.this._timer.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._vsh = Vsh.get((JFrame)DeviceManager.getInstance(), (SnmpPeer)EditFCCForm.this.getPeer(), (boolean)ExternalTools.isUseSSH());
                if (this._vsh != null) {
                    if (this._abort) {
                        EditFCCForm.this.setStatus("Aborted");
                        return;
                    }
                    this._vsh.send("conf t\n");
                    this._vsh.learn();
                    if (!this._abort) {
                        DefaultLogger._DefLogger.debug((Object)this._cmd);
                        this._vsh.sendAndReply(this._cmd + "\n");
                        String reply = this._vsh.getReply();
                        if (reply.indexOf("%") != -1) {
                            int detected = reply.indexOf("detected") == -1 ? reply.length() : reply.indexOf("detected");
                            throw new Exception(reply.substring(reply.indexOf("%") + 1, detected));
                        }
                        EditFCCForm.this.setStatus("Success");
                    } else {
                        EditFCCForm.this.setStatus("Aborted");
                    }
                    this._vsh.send("exit\n");
                    this._vsh.expect("#");
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this._dlg, (Exception)ex);
                EditFCCForm.this.setStatus("Failed");
                if (SnmpSession.isTrace()) {
                    DefaultLogger._DefLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                if (this._vsh != null) {
                    Vsh.put((Vsh)this._vsh);
                }
            }
            if (EditFCCForm.this._timer != null) {
                EditFCCForm.this._timer.stop();
            }
            EditFCCForm.this._parent.setCursor(Cursor.getDefaultCursor());
            EditFCCForm.this.enableButton('A', true);
            EditFCCForm.this._timeElapsed = 0;
        }
    }
}

