/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.dialogs.EditCFSFuncForm;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;

public class EditFlexAttachGlobalForm
extends EditCFSFuncForm {
    static final int GLOBAL_VIRTUALWWN = 1;
    static final int[] ifOperStatusOid = MibNode.get((String)"ifOperStatus").getOid();

    public EditFlexAttachGlobalForm(String[] vars) {
        super(vars);
    }

    protected boolean validateFormChanges(String[][] warnVars, String[] message) throws Exception {
        PhysicalView view = DeviceManager.getInstance().getView();
        Array elements = view.getElements();
        SnmpPDU getPDU = new SnmpPDU(-96, new VarBindList());
        for (int i = 0; i < elements.size(); ++i) {
            PhysicalElement e = (PhysicalElement)elements.elementAt(i);
            if (!(e instanceof Port)) continue;
            getPDU.addVar(new SnmpVarBind(new SnmpOID(ifOperStatusOid, e.getIndex())));
        }
        if (getPDU.getVariables().size() > 0) {
            SnmpPDU respPDU = this.getPeer().send(getPDU);
            StringBuffer sb = new StringBuffer();
            if (respPDU != null && respPDU.getVariables().size() > 0) {
                for (int i = 0; i < respPDU.getVariables().size(); ++i) {
                    if (respPDU.getVariables().intValue(i) != 1) continue;
                    int[] oid = respPDU.getVariables().get(i).getOid().getValue();
                    if (sb.toString().length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(Discover.getRoot().ifIndexToName(oid[oid.length - 1]));
                }
            }
            if (sb.toString().length() > 0) {
                StringBuffer msg = new StringBuffer("The following port(s) is not down: ");
                msg.append(sb.toString());
                msg.append("\nDo you want to continue ?");
                return super.validateFormChanges(warnVars, new String[]{msg.toString()});
            }
        }
        return true;
    }
}

