/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.EditIfPortForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel.EditChannelIfTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.table.TableCellRenderer;

public class EditIfTrunkConfigTable
extends EditTable {
    static final int TRUNKADMIN = 1;
    static final int TRUNKOPER = 2;
    static final int ALLOWVSAN = 3;
    static final int ACTIVEVSAN = 4;
    static final int OPERMODE = 5;
    Array _changed2k4kVars;

    public EditIfTrunkConfigTable(String[] vars) {
        super(vars);
    }

    protected int[] getIndex() {
        if (this.isSpecificInstance()) {
            if (this.isMultiple()) {
                return new int[]{0x4000000 + this.getMultipleIndex(0)[0] - 1};
            }
            if (super.getIndex() != null) {
                return new int[]{0x4000000 + super.getIndex()[0] - 1};
            }
        }
        return EditChannelIfTable._IfIndex;
    }

    protected int[] getIndexFor(MibNode mibNode, int[] index) {
        if (this.isSpecificInstance()) {
            String channelIfString = "channel" + index[0];
            int channelIf = Discover.getRoot().nameToIfIndex(channelIfString);
            int[] newIndex = new int[index.length];
            newIndex[0] = channelIf - 1;
            return newIndex;
        }
        return super.getIndexFor(mibNode, index);
    }

    protected void build() {
        super.build();
        this._table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new PortIndexRenderer(this.getPeer()));
    }

    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        int[] oid = pdu.getVariables().get(3).getOid().getValue();
        int[] index = new int[]{oid[EditIfPortForm._allowed2kOid.length]};
        pdu = EditIfPortForm.addVsan4kVar(pdu, index, 3);
        super.sendGetPdu(pdu);
    }

    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            if (this._state == -95 && !this.isEnd(this._firstOid, vb) || this._state == -96) {
                pdu = EditIfPortForm.appendVsan4kTo2kVar(pdu, 1, 2, pdu.getVariables().size() - 2, 3, pdu.getVariables().size() - 1, true);
            }
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        pdu = EditIfPortForm.splitVar2k4k(pdu, 1);
        this.getPeer().setFrag(pdu);
    }

    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int[] firstOid = new int[req.length - 1];
        System.arraycopy(req, 0, firstOid, 0, firstOid.length);
        return !SnmpOID.startsWith((int[])firstOid, (int[])vb.getOid().getValue()) || IfIndexUtil.getType((int)oid[oid.length - 1]) != 4;
    }

    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        this._changed2k4kVars = new Array();
        super.fetchAllSetRows(cells, model);
    }

    protected void addVarfetchAllSetRows(VarBindList vbl, int[] index, int row, int col) {
        if (SnmpOID.equals((int[])this._mibNodes[col].getOid(), (int[])EditIfPortForm._allowed2kOid)) {
            this._changed2k4kVars.addElement((Object)new SnmpOID(EditIfPortForm._allowed4kOid, index));
            this._changed2k4kVars.addElement((Object)new SnmpOID(EditIfPortForm._active4kOid, index));
        }
        super.addVarfetchAllSetRows(vbl, index, row, col);
    }

    protected SnmpPDU sendFetchAllSetRowsPDU(VarBindList vbl) throws SnmpException {
        for (int i = 0; i < this._changed2k4kVars.size(); ++i) {
            vbl.add(new SnmpVarBind((SnmpOID)this._changed2k4kVars.elementAt(i)));
        }
        SnmpPDU respPDU = super.sendFetchAllSetRowsPDU(vbl);
        vbl = respPDU.getVariables();
        int count = vbl.size() - this._changed2k4kVars.size();
        for (int i = count - 1; i >= 0; --i) {
            if (!SnmpOID.startsWith((int[])vbl.get(i).getOid().getValue(), (int[])EditIfPortForm._allowed2kOid)) continue;
            SnmpVarBind allow2kVb = vbl.get(i);
            SnmpVarBind active2kVb = vbl.get(i + 1);
            SnmpVarBind allow4kVb = vbl.get(vbl.size() - 2);
            SnmpVarBind active4kVb = vbl.get(vbl.size() - 1);
            SnmpVar v2k = allow2kVb.getVar();
            if (v2k.getType() != 5) {
                try {
                    PortInterfaceUtil.getInstance((int)1).getVsan((SnmpString)v2k, (SnmpString)allow4kVb.getVar(), true);
                    PortInterfaceUtil.getInstance((int)1).getVsan((SnmpString)active2kVb.getVar(), (SnmpString)active4kVb.getVar(), false);
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            vbl.removeRange(vbl.size() - 2, vbl.size());
        }
        return respPDU;
    }

    protected DmTableModel buildTableModel() {
        return new SnmpIfPortTableModel();
    }

    static class SnmpIfPortTableModel
    extends DmTableModel {
        SnmpIfPortTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            if (col == 3 || col == 4) {
                Object trunkAdmin = this.getValueAt(row, 1);
                return trunkAdmin != null && (trunkAdmin.toString().charAt(0) == 't' || trunkAdmin.toString().charAt(0) == 'a');
            }
            return super.isCellActive(row, col);
        }

        public Object getValueForNoSuchInstance(MibNode mibNode, String tc, SnmpVar v, String var, int row) {
            if (var.equals("fcIfActiveVsanUpList2k")) {
                return "n/a";
            }
            return super.getValueForNoSuchInstance(mibNode, tc, v, var, row);
        }
    }
}

