/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.EditIfPortForm;
import com.cisco.dcbu.lib.jnm.InterfaceIndexWithFicon;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import javax.swing.table.TableCellRenderer;

public class EditVsanListTable
extends EditTable {
    static int _allowVsanPos;
    static int _activeVsanPos;
    int[] _allowVsan4kOid;
    int[] _activeVsan4kOid;
    int _type;
    boolean _isTunnelBase;

    public EditVsanListTable(String[] vars, int type, String allowVsan2k, String activeVsan2k, String allowVsan4k, String activeVsan4k) {
        this(vars, type, allowVsan2k, activeVsan2k, allowVsan4k, activeVsan4k, false);
    }

    public EditVsanListTable(String[] vars, int type, String allowVsan2k, String activeVsan2k, String allowVsan4k, String activeVsan4k, boolean isTunnelBase) {
        super(vars);
        this._type = type;
        this._isTunnelBase = isTunnelBase;
        _allowVsanPos = this.getVarIndex(allowVsan2k) + 1;
        _activeVsanPos = this.getVarIndex(activeVsan2k) + 1;
        this._allowVsan4kOid = MibNode.get((String)allowVsan4k).getOid();
        this._activeVsan4kOid = MibNode.get((String)activeVsan4k).getOid();
    }

    protected void build() {
        super.build();
        this._table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new PortIndexRenderer(this.getPeer()));
    }

    protected boolean isAtEnd(int[] firstOid, SnmpVarBind vb, boolean isMultiple, SnmpPDU pdu) {
        if (this._isTunnelBase) {
            if (vb.getError() == 21) {
                return true;
            }
            return !SnmpOID.startsWith((int[])firstOid, (int[])vb.getOid().getValue());
        }
        return super.isAtEnd(firstOid, vb, isMultiple, pdu);
    }

    protected boolean isSkip(SnmpPDU pdu, boolean isMultiple, int multipleIndexNo) {
        if (this._isTunnelBase) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            int[] oid = vb.getOid().getValue();
            if (isMultiple) {
                return oid[oid.length - 1] != this.getMultipleIndex(multipleIndexNo)[0];
            }
            if (this.getIndex() != null) {
                return oid[oid.length - 1] != this.getIndex()[0];
            }
        }
        return super.isSkip(pdu, isMultiple, multipleIndexNo);
    }

    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        if (_allowVsanPos != -1) {
            int[] oid = pdu.getVariables().get(_allowVsanPos).getOid().getValue();
            int firstOidLen = MibNode.get((String)this._vars[_allowVsanPos - 1]).getOid().length;
            int[] index = new int[]{0};
            if (oid.length > firstOidLen) {
                index = new int[oid.length - firstOidLen];
                System.arraycopy(oid, firstOidLen, index, 0, index.length);
            }
            pdu.addNull(new SnmpOID(this._allowVsan4kOid, index));
            pdu.addNull(new SnmpOID(this._activeVsan4kOid, index));
        }
        super.sendGetPdu(pdu);
    }

    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut && _allowVsanPos != -1 && _activeVsanPos != -1) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            if (this._state == -95 && !this.isAtEnd(this._firstOid, vb, this.isMultiple(), pdu) || this._state == -96) {
                pdu = EditIfPortForm.appendVsan4kTo2kVar(pdu, 1, _allowVsanPos - 1, pdu.getVariables().size() - 2, _activeVsanPos - 1, pdu.getVariables().size() - 1, true);
            }
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            int firstOidLen = MibNode.get((String)this._vars[_allowVsanPos - 1]).getOid().length;
            int[] index = new int[]{0};
            if (oid.length > firstOidLen) {
                index = new int[oid.length - firstOidLen];
                System.arraycopy(oid, firstOidLen, index, 0, index.length);
            }
            PortInterfaceUtil.getInstance((int)this._type).addVsan4k2Pdu(pdu, vb.getOid(), vb.getVar(), index);
        }
        this.getPeer().set(pdu);
    }

    protected DmTableModel buildTableModel() {
        return new SnmpVsanListTableModel();
    }

    class SnmpVsanListTableModel
    extends DmTableModel {
        SnmpVsanListTableModel() {
        }

        public Object toCell(MibNode mibNode, SnmpVar v, String var, int row) {
            if (var.equals("cfmFcipLinkIfIndex")) {
                try {
                    return new InterfaceIndexWithFicon((SnmpInt)v, this.getIfIndexIf(0), EditVsanListTable.this.getPeer());
                }
                catch (SnmpException ex) {
                    return null;
                }
            }
            return super.toCell(mibNode, v, var, row);
        }
    }
}

