/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fc.EditVsanGenTable;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class InsertVsan
extends InsertForm
implements ItemListener {
    static final MibEnum[] _features = MibNode.get((String)"cfcFeatureCtrlIndex").getEnums();
    MdsPortChooser _ports;
    FieldPanel _domainId;
    JLabel _domainIdLabel;
    JCheckBox _ficon;
    JCheckBox _allPortProhibit;
    static final int VSANNAME = 1;
    static final int LOADBALANCING = 2;
    static final int INTEROPERVALUE = 3;
    static final int ADMINSTATE = 4;
    static final int INORDERDELIVERY = 5;
    static final int FICON = 6;
    int MEMBERSHIP = 7;
    static final int DOMAINID = 8;
    static final int ALL_PORT_PROHIBIT = 9;
    MibNode _domainIdNode = MibNode.get((String)"dmConfigDomainId");
    JLabel _memberLabel;
    boolean _isNPVMode = DmSystem.getIsNPVMode();
    boolean _isSupportFICON = DmId.isSupportFICON(Discover.getSysObjectID()) && !this._isNPVMode;
    boolean _isFiconColExist = this.getVarIndex("cficonVsanHostControl") != -1;

    public InsertVsan(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (mibVar.equals("vsanName")) {
            String units = (String)SnmpTableModel._Units.get(mibVar);
            JLabel l = new JLabel(" " + units);
            l.setFont(ChangedCellRenderer.getNormalFont());
            return new FieldPanel(20, (JComponent)l);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected void build() {
        super.build();
        if (this._isSupportFICON) {
            this._ficon.addItemListener(this);
            if (EditVsanGenTable._IsDefPortBlkSupport) {
                this._allPortProhibit.setEnabled(false);
            }
            this._domainIdLabel.setEnabled(false);
            this._domainId.setEnabled(false);
        }
        this._memberLabel.setEnabled(false);
        ((RadioButtonPanel)this._values[3]).addChangeListener((ItemListener)new InteropItemListener());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected;
        boolean bl = isSelected = e.getStateChange() == 1;
        if (e.getSource() == this._ficon) {
            this._domainIdLabel.setEnabled(isSelected);
            this._domainId.setEnabled(isSelected);
            JToggleButton srcdestId = ((RadioButtonPanel)this._values[2]).getButton(0);
            JToggleButton oxId = ((RadioButtonPanel)this._values[2]).getButton(1);
            srcdestId.setSelected(isSelected);
            oxId.setEnabled(!isSelected);
            if (!isSelected) {
                oxId.setSelected(!isSelected);
            }
            this._values[3].setEnabled(!isSelected);
            this._labels[3].setEnabled(!isSelected);
            if (isSelected) {
                ((JCheckBox)this._values[5]).setSelected(isSelected);
            }
            ((JCheckBox)this._values[5]).setEnabled(!isSelected);
            if (EditVsanGenTable._IsDefPortBlkSupport) {
                this._allPortProhibit.setEnabled(isSelected);
            }
            this._memberLabel.setEnabled(isSelected);
            this._ports.getField().setEnabled(!isSelected);
        }
    }

    protected int[] getLastIndex() {
        Array data = this._table.getTableModel().getData();
        if (data.size() == 0) {
            return new int[]{1};
        }
        Object[] list = new Integer[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            list[i] = new Integer(((SnmpOID)row[0]).getValue()[0]);
        }
        int[] nextVsan = this.getLowestAvailVsan(list);
        if (nextVsan != null) {
            nextVsan[0] = nextVsan[0] - 1;
        }
        return nextVsan;
    }

    private int[] getLowestAvailVsan(Object[] list) {
        int next;
        Arrays.sort(list);
        int nextVsan = (Integer)list[0] + 1;
        for (int i = 1; i < list.length && ((next = ((Integer)list[i]).intValue()) <= nextVsan || nextVsan == 4094); ++i) {
            nextVsan = next + 1;
        }
        if (nextVsan <= this._mibNodes[0].getHi()) {
            return new int[]{nextVsan};
        }
        return null;
    }

    protected void layoutForm() {
        JComponent[] labels = new JLabel[this._labels.length + (this._isSupportFICON ? 2 : 1) + (EditVsanGenTable._IsDefPortBlkSupport ? 1 : 0)];
        System.arraycopy(this._labels, 0, labels, 0, this._labels.length);
        labels[this.MEMBERSHIP] = new JLabel("Interface Members:", 4);
        JComponent[] values = new JComponent[this._values.length + (this._isSupportFICON ? 2 : 1) + (EditVsanGenTable._IsDefPortBlkSupport ? 1 : 0)];
        System.arraycopy(this._values, 0, values, 0, this._values.length);
        if (this._isSupportFICON) {
            labels[8] = this._domainIdLabel = new JLabel("DomainId:", 4);
            this._ficon = new JCheckBox("FICON");
            values[6] = this._ficon;
            this._domainId = new FieldPanel(this._domainIdNode.getMaxWidth(), 1, this._domainIdNode.getHi(), (String)SnmpTableModel._Units.get("dmConfigDomainId"));
            values[8] = this._domainId;
            if (EditVsanGenTable._IsDefPortBlkSupport) {
                this._allPortProhibit = new JCheckBox("All Port Prohibited");
                values[9] = this._allPortProhibit;
            }
        } else if (DmId.isN5K(Discover.getSysObjectID()) && values[6] != null) {
            values[6].setVisible(false);
        }
        this._ports = new MyMdsPortChooser(Discover.getDeviceName(), false, (IfIndexIf)Discover.getRoot(), DmSystem.getCardAttributes(), new PortEditorFilter(new int[]{1, 153, 152}), this.getPeer(), 6);
        this._memberLabel = new JLabel(" (Please use PortChooser to configure ficon members)");
        this._memberLabel.setFont(ChangedCellRenderer.getNormalFont());
        JPanel memberPanel = new JPanel(new BorderLayout());
        memberPanel.add((Component)this._memberLabel, "East");
        memberPanel.add((Component)this._ports, "West");
        values[this.MEMBERSHIP] = memberPanel;
        DialogUtil.buildPanel((Container)this._container, (JComponent[])labels, (JComponent[])values);
    }

    public void dispose() {
        if (this._ports != null) {
            this._ports.dismiss();
        }
        super.dispose();
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 1) {
            String vsanName = ((FieldPanel)this._values[index]).getText();
            if (vsanName.equals("")) {
                return null;
            }
            if (vsanName.indexOf(32) != -1) {
                return new SnmpString(vsanName.replace(' ', '_'));
            }
        } else if (index == 6) {
            return null;
        }
        return super.getComponentValue(index);
    }

    protected SnmpVar[] getInsertValue() throws Exception {
        if (this._isSupportFICON && this._ficon.isSelected()) {
            StringBuffer sb = new StringBuffer();
            if (this._domainId.getText().equals("")) {
                sb.append("specify DomainId ");
            }
            if (!((JCheckBox)this._values[5]).isSelected()) {
                if (sb.length() > 0) {
                    sb.append("and ");
                }
                sb.append("enable InorderDelivery ");
            }
            if (sb.length() > 0) {
                throw new Exception("Please " + sb.toString() + "when FICON enabled");
            }
        }
        if (this._isSupportFICON && this._ficon.isSelected() && ((RadioButtonPanel)this._values[2]).getSelected() != 0) {
            throw new Exception("Please select srcIdDestId LoadBalancing when FICON enabled");
        }
        return super.getInsertValue();
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        boolean isInterop4;
        SnmpPDU pdu = this.buildInsertPDU(index, values);
        SnmpIntList list = null;
        if (!this._ports.getText().equals("")) {
            boolean isFICON = this._isSupportFICON && this._ficon.isSelected() && InsertVsan.isFiconFeatureEnabled(this.getPeer());
            String string = isFICON ? this.trimList(this._ports.getText()) : this._ports.getText();
            Discover.getInstance();
            list = new SnmpIntList(string, (IfIndexIf)Discover.getRoot(), DmSystem.getSlotMembers(), DmSystem.getIfNameTypes());
        }
        if (!this._isSupportFICON) {
            this.getPeer().set(pdu);
        } else if (!this._domainId.getText().equals("") && !this._ficon.isSelected()) {
            this._domainId.getField().setText(this._domainId.getText().trim());
            this.getPeer().set(pdu);
            pdu.reset();
            pdu.addVar(new SnmpOID(MibNode.get((String)"dmConfigDomainIdType").getOid(), index), (SnmpVar)new SnmpInt(1));
            pdu.addVar(new SnmpOID(this._domainIdNode.getOid(), index), (SnmpVar)new SnmpInt(this._domainId.getInt()));
            this.getPeer().set(pdu);
        } else if (this._ficon.isSelected()) {
            boolean isFiconEnabled = InsertVsan.isFiconFeatureEnabled(this.getPeer());
            StringBuffer sb = new StringBuffer();
            sb.append("FICON requires static domain Ids, in-order delivery, zone permit, and fabric binding.\n");
            sb.append("This will be disruptive if you specify an existing Vsan with operational traffic.\n");
            sb.append("It can take up to 10 secs to enable FICON and Fabric Binding\n(FICON is not supported on the 9124 Family.)\n\n");
            sb.append("Continue?");
            if (JOptionPane.showConfirmDialog((Component)this.getParent(), sb.toString(), this._parent.getTitle(), 0) != 0) {
                return;
            }
            this._domainId.getField().setText(this._domainId.getText().trim());
            int[] errCode = new int[1];
            try {
                InsertVsan.createFiconVsan(this.getPeer(), (JDialog)this._parent, isFiconEnabled, this._isSupportFICON, index[0], values[1], values[2], values[3], values[4], (SnmpVar)new SnmpInt(this._domainId.getInt()), (SnmpVar)(EditVsanGenTable._IsDefPortBlkSupport ? new SnmpInt(this._allPortProhibit.isSelected() ? 1 : 2) : null), true, errCode);
            }
            catch (SnmpException ex) {
                if (errCode[0] == 2) {
                    this._table.fetchRow(index);
                }
                throw new SnmpException(ex.getMessage());
            }
        } else {
            this.getPeer().set(pdu);
        }
        if (list != null) {
            int[] ports = SnmpIntList.valueOf((byte[])list.getValue());
            pdu = new SnmpPDU(-93, new VarBindList());
            int[] vsanIfVsan = MibNode.get((String)"vsanIfVsan").getOid();
            for (int i = 0; i < ports.length; ++i) {
                pdu.addVar(new SnmpOID(vsanIfVsan, ports[i]), (SnmpVar)new SnmpInt(index[0]));
            }
            try {
                this.getPeer().set(pdu);
            }
            catch (SnmpException ex) {
                this.rollback(index, this._isSupportFICON && this._ficon.isSelected());
                Util.errorMessage((Component)this.getParent(), (String)ex.getMessage());
                return;
            }
        }
        if ((isInterop4 = ((RadioButtonPanel)this._values[3]).getButton(4).isSelected()) && !DmSystem.getIsNPVMode()) {
            SnmpPDU getPDU = new SnmpPDU(-96, new VarBindList(1));
            getPDU.addVar(new SnmpOID(MibNode.get((String)"cffFcFeElementName").getOid(), 0));
            try {
                SnmpPDU resp = this.getPeer().send(getPDU);
                byte[] swWWN = resp.getVariables().byteValue(0);
                pdu.reset();
                pdu.addVar(new SnmpOID(MibNode.get((String)"wwnmVsanWwnRowStatus").getOid(), index), (SnmpVar)new SnmpInt(4));
                pdu.addVar(new SnmpOID(MibNode.get((String)"wwnmVsanWwn").getOid(), index), (SnmpVar)new SnmpString(WwnDictionary.generateInterop4Wwn((byte[])swWWN, (int)index[0])));
                this.getPeer().set(pdu);
            }
            catch (SnmpException ex) {
                // empty catch block
            }
        }
        this._table.fetchRow(index);
    }

    protected void tableInsertRowFetch(int[] index) throws Exception {
    }

    protected void updatePanelLater(DMPanel panel) {
        SwingUtilities.invokeLater(new UpdatePanel(panel));
    }

    public static boolean isFiconFeatureEnabled(SnmpPeer peer) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlOpStatus").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"ficon")));
        SnmpPDU resp = peer.send(pdu);
        return resp.getVariables().intValue(0) == 2;
    }

    public static boolean isSysLogServerAvailable(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList(1);
        int[] cseSyslogServerAddress = MibNode.get((String)"cseSyslogServerAddress").getOid();
        vbl.add(cseSyslogServerAddress);
        SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl, (int)1);
        vbl = resp.getVariables();
        return vbl.size() != 0;
    }

    public static void createFiconVsan(SnmpPeer peer, JDialog parent, boolean isFiconFeatureEnabled, boolean isFiconSupported, int vsanId, SnmpVar name, SnmpVar loadBalancing, SnmpVar interOperValue, SnmpVar adminState, SnmpVar domainId, SnmpVar isPortProhibit, boolean isNewVsan, int[] errCode) throws SnmpException {
        errCode[0] = 1;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"vsanRowStatus").getOid(), vsanId));
        pdu.addNull(new SnmpOID(MibNode.get((String)"vsanAdminState").getOid(), vsanId));
        pdu.addNull(new SnmpOID(MibNode.get((String)"zoneDefaultZoneBehaviour").getOid(), 0));
        SnmpPDU resp = peer.send(pdu);
        if (isNewVsan && resp.getVariables().intValue(0) == 1) {
            throw new SnmpException("Vsan already exists");
        }
        if (resp.getVariables().intValue(0) != 1) {
            SnmpPDU vsanCreatePDU = new SnmpPDU(-93, new VarBindList());
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanRowStatus").getOid(), vsanId), (SnmpVar)new SnmpInt(4));
            if (name == null) {
                name = new SnmpString("FICON" + vsanId);
            }
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanName").getOid(), vsanId), name);
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanLoadBalancingType").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            if (interOperValue != null) {
                vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanInterOperValue").getOid(), vsanId), interOperValue);
            }
            if (Discover.getSysVersionWithMinor().compareTo("1.3(4)") >= 0) {
                vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanInorderDelivery").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            }
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanAdminState").getOid(), vsanId), adminState);
            peer.set(vsanCreatePDU);
        } else {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"vsanLoadBalancingType").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            if (Discover.getSysVersionWithMinor().compareTo("1.3(4)") >= 0) {
                pdu.addVar(new SnmpOID(MibNode.get((String)"vsanInorderDelivery").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            }
            if (resp.getVariables().intValue(1) != 1) {
                pdu.addVar(new SnmpOID(MibNode.get((String)"vsanAdminState").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            }
            peer.set(pdu);
        }
        errCode[0] = 2;
        pdu = new SnmpPDU(-93, new VarBindList());
        if (resp.getVariables().intValue(2) != 1) {
            pdu.addVar(new SnmpOID(MibNode.get((String)"zoneDefaultZoneBehaviour").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
        }
        if (pdu.getVariables().size() > 0) {
            peer.set(pdu);
        }
        pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlOpStatus").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"fabricBinding")));
        resp = peer.send(pdu);
        if (resp.getVariables().intValue(0) != 2) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlAction").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"fabricBinding")), (SnmpVar)new SnmpInt(2));
            peer.set(pdu);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        pdu = new SnmpPDU(-96, new VarBindList());
        int[] fbIndex = new int[]{1, vsanId};
        pdu.addNull(new SnmpOID(MibNode.get((String)"cpsmFabricBindActivate").getOid(), fbIndex));
        resp = peer.send(pdu);
        if (resp.getVariables().intValue(0) != 3) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"cpsmFabricBindActivate").getOid(), fbIndex), (SnmpVar)new SnmpInt(3));
            peer.set(pdu);
        }
        if (!isFiconFeatureEnabled) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlAction").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"ficon")), (SnmpVar)new SnmpInt(2));
            peer.set(pdu);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (isNewVsan) {
            SnmpPDU domainIdPDU = new SnmpPDU(-93, new VarBindList());
            domainIdPDU.addVar(new SnmpOID(MibNode.get((String)"dmConfigDomainIdType").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            domainIdPDU.addVar(new SnmpOID(MibNode.get((String)"dmConfigDomainId").getOid(), vsanId), domainId);
            domainIdPDU.addVar(new SnmpOID(MibNode.get((String)"dmRestart").getOid(), vsanId), (SnmpVar)new SnmpInt(2));
            peer.set(domainIdPDU);
        }
        pdu = new SnmpPDU(-93, new VarBindList());
        if (isPortProhibit != null) {
            pdu.addVar(new SnmpOID(MibNode.get((String)"cficonDefaultPortBlock").getOid(), 0), isPortProhibit);
        }
        pdu.addVar(new SnmpOID(MibNode.get((String)"cficonVsanEntryStatus").getOid(), vsanId), (SnmpVar)new SnmpInt(4));
        peer.set(pdu);
        errCode[0] = 0;
        Discover.getInstance();
        if (!FiconPortByIfIndexCache.getInstance((SnmpPeer)Discover.getPeer()).getIsFiconEnabled()) {
            FiconPortByIfIndexCache.getInstance((SnmpPeer)peer).setIsFiconEnabled(true, Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
        }
    }

    protected void insert() throws Exception {
        super.insert();
        Array data = this._table.getTableModel().getData();
        Object[] list = new Integer[data.size() + 1];
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            list[i] = new Integer(((SnmpOID)row[0]).getValue()[0]);
        }
        list[list.length - 1] = new Integer(Integer.parseInt(this.getComponentText(0)));
        int[] nextVsan = this.getLowestAvailVsan(list);
        if (nextVsan != null) {
            this.setComponentText(0, Integer.toString(nextVsan[0]));
        }
        this._ports.setText("");
    }

    void rollback(int[] index, boolean isFicon) throws Exception {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(this._mibNodes.length + 1));
        if (isFicon) {
            pdu.addVar(new SnmpOID(MibNode.get((String)"cficonVsanEntryStatus").getOid(), index), (SnmpVar)new SnmpInt(6));
        }
        pdu.addVar(new SnmpOID(MibNode.get((String)"vsanRowStatus").getOid(), index), (SnmpVar)new SnmpInt(6));
        this.getPeer().set(pdu);
    }

    private String trimList(String list) {
        StringBuffer sb = new StringBuffer();
        boolean isSkip = false;
        for (int i = 0; i < list.length(); ++i) {
            if (list.charAt(i) == '(') {
                boolean bl = isSkip = !isSkip;
            }
            if (!isSkip) {
                sb.append(list.charAt(i));
            }
            if (list.charAt(i) != ')') continue;
            isSkip = !isSkip;
        }
        return sb.toString();
    }

    class InteropItemListener
    implements ItemListener {
        InteropItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof JToggleButton && e.getStateChange() == 1) {
                String label = ((JToggleButton)source).getText();
                RadioButtonPanel bp = (RadioButtonPanel)InsertVsan.this._values[4];
                if (label.endsWith("4")) {
                    bp.getButton(1).setSelected(true);
                } else {
                    bp.getButton(0).setSelected(true);
                }
            }
        }
    }

    class MyMdsPortChooser
    extends MdsPortChooser {
        MyMdsPortChooser(String windowTitle, boolean exclusive, IfIndexIf ifIndexIf, PortEditorCardAttribute[] slotmembers, PortEditorFilter filters, SnmpPeer peer, int type) {
            super(windowTitle, 3, exclusive, ifIndexIf, slotmembers, filters, peer, type);
        }

        protected void setIsFiconPortDialog(boolean isFicon) {
            boolean isFICON = InsertVsan.this._isSupportFICON && InsertVsan.this._ficon.isSelected();
            super.setIsFiconPortDialog(isFICON);
        }

        protected void setSelected(SnmpIntList value) {
            String list = InsertVsan.this.trimList(this.getField().getText());
            try {
                value = new SnmpIntList(list, MibVariableFormat._IfIndexIf);
            }
            catch (Exception ex) {
                value = null;
            }
            super.setSelected(value);
        }

        public void actionPerformed(ActionEvent e) {
            boolean isFICON;
            boolean bl = isFICON = InsertVsan.this._isSupportFICON && InsertVsan.this._ficon.isSelected();
            if (isFICON) {
                FiconPortByIfIndexCache.getInstance((SnmpPeer)this._peer).buildCache(Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
                if (!FiconPortByIfIndexCache.getInstance((SnmpPeer)this._peer).getIsFiconEnabled()) {
                    StringBuffer sb = new StringBuffer("FICON Port Chooser not available.");
                    if (Discover.isSysVersionGreaterThanEqual((String)"3.0(0)")) {
                        sb.append("\nPlease first enable 'ficon' feature at Admin -> Feature Control.");
                    }
                    Util.errorMessage((Component)InsertVsan.this._parent, (String)sb.toString());
                    return;
                }
            }
            super.actionPerformed(e);
        }
    }

    static class UpdatePanel
    implements Runnable {
        DMPanel _panel;

        public UpdatePanel(DMPanel panel) {
            this._panel = panel;
        }

        @Override
        public void run() {
            ((EditTable)this._panel).updateTable1();
        }
    }
}

