/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.fcip.EditFcipIfTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ficon.FiconLogicalCellEditor;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import javax.swing.table.TableCellRenderer;

public class EditFcipIfFiconTable
extends EditFcipIfTable {
    static final int PORTVSAN = 2;
    static final int OPER = 3;
    int FICONPORT;
    boolean _isFiconEnabled;

    public EditFcipIfFiconTable(String[] vars) {
        super(vars);
        this.FICONPORT = vars.length;
    }

    public EditFcipIfFiconTable(String[] vars, boolean isGigEFcip) {
        super(vars);
        this._isGigEFcip = isGigEFcip;
        this.FICONPORT = vars.length;
    }

    protected void buildTable() {
        this._isFiconEnabled = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getIsFiconEnabled();
        super.buildTable();
        if (!this._isFiconEnabled) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(this.FICONPORT));
        }
    }

    @Override
    protected void build() {
        super.build();
        if (this._isFiconEnabled) {
            if (Discover.isSysVersionlessThan((String)"3.0(0)")) {
                String portAndRange = "(" + DmSystem.getFiconPortLogicRange() + ")";
                this._table.setMultiLineColumn(this.FICONPORT, new String[]{"FICON Address", portAndRange});
            } else {
                this._table.getColumnModel().getColumn(this.FICONPORT).setCellEditor(new FiconLogicalCellEditor(this.getPeer()));
            }
        }
        this._table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new PortIndexRenderer(this.getPeer()));
    }

    protected void postProcessing() throws SnmpException {
        if (Discover.getSysVersionInterim().compareTo("1.3") < 0) {
            return;
        }
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int ficonPort = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(this._tableModel.getIndex(i)[0]);
            row[this.FICONPORT] = new SnmpFiconPort(ficonPort);
            this._tableModel.setNoSuchInstance(i, this.FICONPORT, false);
        }
    }

    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        int i;
        super.fetchAllSetRows(cells, model);
        if (cells == null || cells.size() == 0 || Discover.getSysVersionInterim().compareTo("1.3") < 0) {
            return;
        }
        Array changedRows = new Array();
        int preRow = -1;
        for (i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._row == preRow) continue;
            changedRows.addElement((Object)new Cell(cell._row, this.FICONPORT));
            preRow = cell._row;
        }
        for (i = 0; i < changedRows.size(); ++i) {
            Cell fetchCell = (Cell)changedRows.elementAt(i);
            int ficonPort = FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).getFiconPort(this._tableModel.getIndex(fetchCell._row)[0]);
            Object[] row = (Object[])model.getData().elementAt(fetchCell._row);
            row[this.FICONPORT] = new SnmpFiconPort(ficonPort);
            this._tableModel.setNoSuchInstance(i, this.FICONPORT, false);
        }
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int i;
        Array ficonPortList = new Array();
        VarBindList vbl = pdu.getVariables();
        Array changedCells = this._tableModel.getChanged();
        for (i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = vbl.get(i);
            SnmpOID oid = vb.getOid();
            if (!oid.startsWith(FiconPortByIfIndexCache._cficonPortIfIndexOid)) continue;
            int ficonPort = ((SnmpInt)vb.getVar()).getValue();
            int ifIndex = oid.getValue()[oid.getValue().length - 1];
            vbl.remove(i);
            if (ficonPort == -1) {
                Cell cell = (Cell)changedCells.elementAt(i);
                Object[] values = (Object[])this._data.elementAt(cell._row);
                Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
                SnmpFiconPort oldFiconPort = (SnmpFiconPort)changed[this.FICONPORT];
                vbl.add(i, new SnmpVarBind(new SnmpOID(FiconPortByIfIndexCache._cficonPortIfIndexOid, oldFiconPort.getValue()), (SnmpVar)new SnmpInt(0)));
            } else {
                vbl.add(i, new SnmpVarBind(new SnmpOID(FiconPortByIfIndexCache._cficonPortIfIndexOid, ficonPort), (SnmpVar)new SnmpInt(ifIndex)));
            }
            ficonPortList.addElement((Object)new ficonPortIfIndex(ficonPort, ifIndex));
        }
        this.getPeer().set(pdu);
        if (ficonPortList.size() > 0) {
            for (i = 0; i < ficonPortList.size(); ++i) {
                FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).setFiconPort(((ficonPortIfIndex)ficonPortList.elementAt(i)).getIfIndex(), ((ficonPortIfIndex)ficonPortList.elementAt(i)).getFiconPort());
            }
        }
    }

    protected DmTableModel buildTableModel() {
        return new fcipFiconTableModel();
    }

    static class ficonPortIfIndex {
        int _ficonPort;
        int _ifIndex;

        public ficonPortIfIndex(int ficonPort, int ifIndex) {
            this._ficonPort = ficonPort;
            this._ifIndex = ifIndex;
        }

        public int getFiconPort() {
            return this._ficonPort;
        }

        public int getIfIndex() {
            return this._ifIndex;
        }
    }

    class fcipFiconTableModel
    extends DmTableModel {
        fcipFiconTableModel() {
        }

        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (col == EditFcipIfFiconTable.this.FICONPORT) {
                return (SnmpVar)this.getValueAt(row, col);
            }
            return super.getChangedCell(row, col);
        }

        protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
            if (col == 2) {
                int value = ((SnmpInt)v).getValue();
                if (value < 1 || value > 4094) {
                    throw new Exception(name + " should be in range " + 1 + ".." + 4094);
                }
                return v;
            }
            return super.checkCell(v, mibNode, name, row, col);
        }

        public boolean isCellActive(int row, int col) {
            if (col == 2) {
                Object o = this.getValueAt(row, 3);
                return o == null || !o.toString().equals("TE");
            }
            return super.isCellActive(row, col);
        }
    }
}

