/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fcip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.lib.jnm.InterfaceIndexWithFicon;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.util.ArrayList;

public class EditFcipTunnelAddTable
extends EditTable {
    boolean is_6_2_5 = Discover.isSysVersionGreaterThanEqual((String)"6.2(5)");
    int QOSCTL = this.is_6_2_5 ? 4 : 3;
    int QOSDATA = this.is_6_2_5 ? 5 : 4;
    int IP_COMP = this.is_6_2_5 ? 6 : 5;
    int TAPE_ACCELERATOR = this.is_6_2_5 ? 8 : 7;
    int BUFFER_SIZE = this.is_6_2_5 ? 9 : 8;
    static final int[] cfmFcipLinkExtCntrlQOSFieldOid = MibNode.get((String)"cfmFcipLinkExtCntrlQOSField").getOid();
    static final int[] cfmFcipLinkExtDataQOSFieldOid = MibNode.get((String)"cfmFcipLinkExtDataQOSField").getOid();
    static final int[] _cfmFcipLinkExtIPCompOid = MibNode.get((String)"cfmFcipLinkExtIPComp").getOid();
    static final int COMP_MODE_NONE = 1;
    static final int COMP_MODE_AUTO = 4;
    static final int COMP_MODE_MODE2 = 6;
    static final int COMP_MODE_MODE1 = 5;
    boolean _isTunnelBase;
    MibEnum[] _enumsIpComp_2_0;
    boolean is5_0_1a = Discover.isSysVersionGreaterThanEqual((String)"5.0(0)");
    boolean is5_2_6 = Discover.isSysVersionGreaterThanEqual((String)"5.2(6)");

    public EditFcipTunnelAddTable(String[] vars, boolean isTunnelBase) {
        super(vars);
        this._isTunnelBase = isTunnelBase;
    }

    protected boolean isAtEnd(int[] firstOid, SnmpVarBind vb, boolean isMultiple, SnmpPDU pdu) {
        if (this._isTunnelBase) {
            if (vb.getError() == 21) {
                return true;
            }
            return !SnmpOID.startsWith((int[])firstOid, (int[])vb.getOid().getValue());
        }
        return super.isAtEnd(firstOid, vb, isMultiple, pdu);
    }

    protected boolean isSkip(SnmpPDU pdu, boolean isMultiple, int multipleIndexNo) {
        if (this._isTunnelBase) {
            SnmpVarBind vb = pdu.getVariables().get(0);
            int[] oid = vb.getOid().getValue();
            if (isMultiple) {
                return oid[oid.length - 1] != this.getMultipleIndex(multipleIndexNo)[0];
            }
            if (this.getIndex() != null) {
                return oid[oid.length - 1] != this.getIndex()[0];
            }
        }
        return super.isSkip(pdu, isMultiple, multipleIndexNo);
    }

    void addVb(SnmpPDU pdu, int curr, int row, int col, int[] oid) {
        int[] index = this._tableModel.getIndex(row);
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(oid, index), (SnmpVar)((SnmpGauge)this._tableModel.getValueAt(row, col)));
        pdu.getVariables().add(curr, vb);
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Array changedCells = this._tableModel.getChanged();
        int cellCt = changedCells.size();
        for (int i = cellCt - 1; i >= 0; --i) {
            Cell cell = (Cell)changedCells.elementAt(i);
            if (cell._col == this.QOSDATA) {
                if (i < 1 || ((Cell)changedCells.elementAt((int)(i - 1)))._row != cell._row || ((Cell)changedCells.elementAt((int)(i - 1)))._col != this.QOSCTL) {
                    this.addVb(pdu, i, cell._row, cell._col - 1, cfmFcipLinkExtCntrlQOSFieldOid);
                } else {
                    --i;
                }
            }
            if (cell._col != this.QOSCTL) continue;
            this.addVb(pdu, i + 1, cell._row, cell._col + 1, cfmFcipLinkExtDataQOSFieldOid);
        }
        super.sendPdu(pdu);
    }

    protected MibEnum[] getApplicableEnums(MibNode mibNode) {
        MibEnum[] enums = super.getApplicableEnums(mibNode);
        if (!DmId.isN5K(Discover.getSysObjectID()) && this.is5_0_1a && MibNode.equals((int[])_cfmFcipLinkExtIPCompOid, (int[])mibNode.getOid()) == 0) {
            ArrayList<MibEnum> al = new ArrayList<MibEnum>();
            for (int i = 0; i < enums.length; ++i) {
                int mode = enums[i].getValue();
                if (mode != 1 && mode != 4 && mode != 6 && (mode != 5 || !this.is5_2_6)) continue;
                al.add(enums[i]);
            }
            enums = al.toArray(new MibEnum[0]);
        }
        return enums;
    }

    protected DmTableModel buildTableModel() {
        return new SnmpFcipAddTableModel();
    }

    class SnmpFcipAddTableModel
    extends DmTableModel {
        SnmpFcipAddTableModel() {
        }

        public boolean isCellActive(int row, int col) {
            if (row < EditFcipTunnelAddTable.this._data.size() && col == EditFcipTunnelAddTable.this.BUFFER_SIZE) {
                Object o = this.getValueAt(row, EditFcipTunnelAddTable.this.TAPE_ACCELERATOR);
                return o != null && (Boolean)o != false;
            }
            return super.isCellActive(row, col);
        }

        public Object toCell(MibNode mibNode, SnmpVar v, String var, int row) {
            if (var.equals("cfmFcipLinkIfIndex")) {
                try {
                    return new InterfaceIndexWithFicon((SnmpInt)v, this.getIfIndexIf(0), EditFcipTunnelAddTable.this.getPeer());
                }
                catch (SnmpException ex) {
                    return null;
                }
            }
            return super.toCell(mibNode, v, var, row);
        }

        protected SnmpVar checkCell(SnmpVar v, MibNode mibNode, String name, int row, int col) throws Exception {
            if (col == EditFcipTunnelAddTable.this.BUFFER_SIZE && ((SnmpUnsignedInt)v).getValue() == 0L) {
                return v;
            }
            return super.checkCell(v, mibNode, name, row, col);
        }
    }
}

