/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class InsertFICONFile
extends InsertForm {
    private static final int VSANID = 0;
    private JComboBox _vsanCb;

    public InsertFICONFile(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        try {
            if (index == 0) {
                this._vsanCb = new JComboBox<String>(InsertFICONFile.getFiconVsans(this.getPeer()));
                return this._vsanCb;
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this._parent, (String)ex.getMessage());
            this._parent.dispose();
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 0) {
            return new SnmpInt(Integer.parseInt(this._vsanCb.getSelectedItem().toString()));
        }
        return super.getComponentValue(index);
    }

    static String[] getFiconVsans(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get((String)"cficonVsanHostControl").getOid());
        SnmpPDU resp = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            throw new SnmpException("You need a FICON VSAN first");
        }
        String[] vsans = new String[vbl.size()];
        for (int i = 0; i < vsans.length; ++i) {
            vsans[i] = Integer.toString(vbl.getVb(i).getOid().getIndexFromEnd(0));
        }
        return vsans;
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        int[] cficonCfgFileRowStatus = MibNode.get((String)"cficonCfgFileRowStatus").getOid();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(cficonCfgFileRowStatus, index), (SnmpVar)new SnmpInt(4));
        pdu.setIgnoreSetCount(true);
        this.getPeer().set(pdu);
        pdu = new SnmpPDU(-93, new VarBindList());
        for (int i = 2; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this._mibNodes[i].isEditable()) continue;
            pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), index), values[i]);
        }
        pdu.addVar(new SnmpOID(cficonCfgFileRowStatus, index), (SnmpVar)new SnmpInt(1));
        pdu.setIgnoreSetCount(true);
        this.getPeer().set(pdu);
    }
}

