/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ficon;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class InsertFICONVsan
extends InsertForm {
    static final MibEnum[] _features = MibNode.get((String)"cfcFeatureCtrlIndex").getEnums();
    private static final int VSANID = 0;
    private static final int DOMAINID = 1;
    private static final int MEMBERS = 2;

    public InsertFICONVsan(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    protected void build() {
        super.build();
        this.setComponentText(1, "1");
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            return new FieldPanel(3, 1, 1, 239);
        }
        if (index == 2) {
            return new KTextField(0);
        }
        if (index == 0) {
            return new FieldPanel(5, 1, 4093, null);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    protected String getFormLabel(String mibVar, int index) {
        if (index == 2) {
            return "Interface Members";
        }
        return super.getFormLabel(mibVar, index);
    }

    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        String members = ((KTextField)this._values[2]).getText();
        int[] ifIndexArr = SnmpIntList.parse((String)members, (IfIndexIf)MibVariableFormat._IfIndexIf);
        if (JOptionPane.showConfirmDialog((Component)this.getParent(), "FICON requires static domain Ids, in-order delivery, zone permit, and fabric binding.\nThis will be disruptive if you specify an existing Vsan with operational traffic.\nWe will also enable FICON and Fabric Binding features if needed - this can take up to 10 secs.\nContinue?", this._parent.getTitle(), 0) != 0) {
            return;
        }
        int vsanId = index[0];
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"vsanRowStatus").getOid(), vsanId));
        pdu.addNull(new SnmpOID(MibNode.get((String)"vsanAdminState").getOid(), vsanId));
        pdu.addNull(new SnmpOID(MibNode.get((String)"zoneDefaultZoneBehaviour").getOid(), 0));
        SnmpPDU resp = this.getPeer().send(pdu);
        if (resp.getVariables().intValue(0) != 1) {
            SnmpPDU vsanCreatePDU = new SnmpPDU(-93, new VarBindList());
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanRowStatus").getOid(), vsanId), (SnmpVar)new SnmpInt(4));
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanName").getOid(), vsanId), (SnmpVar)new SnmpString("FICON" + vsanId));
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanLoadBalancingType").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            vsanCreatePDU.addVar(new SnmpOID(MibNode.get((String)"vsanInorderDelivery").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            this.getPeer().set(vsanCreatePDU);
        } else if (resp.getVariables().intValue(1) != 1) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"vsanAdminState").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
            this.getPeer().set(pdu);
        }
        pdu = new SnmpPDU(-93, new VarBindList());
        if (resp.getVariables().intValue(2) != 1) {
            pdu.addVar(new SnmpOID(MibNode.get((String)"zoneDefaultZoneBehaviour").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
        }
        if (pdu.getVariables().size() > 0) {
            this.getPeer().set(pdu);
        }
        pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlOpStatus").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"fabricBinding")));
        resp = this.getPeer().send(pdu);
        if (resp.getVariables().intValue(0) != 1) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlAction").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"fabricBinding")), (SnmpVar)new SnmpInt(2));
            this.getPeer().set(pdu);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        pdu = new SnmpPDU(-96, new VarBindList());
        int[] fbIndex = new int[]{1, vsanId};
        pdu.addNull(new SnmpOID(MibNode.get((String)"cpsmFabricBindActivate").getOid(), fbIndex));
        resp = this.getPeer().send(pdu);
        if (resp.getVariables().intValue(0) != 3) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"cpsmFabricBindActivate").getOid(), fbIndex), (SnmpVar)new SnmpInt(3));
            this.getPeer().set(pdu);
        }
        pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlOpStatus").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"ficon")));
        resp = this.getPeer().send(pdu);
        if (resp.getVariables().intValue(0) != 1) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get((String)"cfcFeatureCtrlAction").getOid(), MibEnum.getValue((MibEnum[])_features, (String)"ficon")), (SnmpVar)new SnmpInt(2));
            this.getPeer().set(pdu);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        SnmpPDU domainIdPDU = new SnmpPDU(-93, new VarBindList());
        domainIdPDU.addVar(new SnmpOID(MibNode.get((String)"dmConfigDomainIdType").getOid(), vsanId), (SnmpVar)new SnmpInt(1));
        domainIdPDU.addVar(new SnmpOID(MibNode.get((String)"dmConfigDomainId").getOid(), vsanId), this.getComponentValue(1));
        this.getPeer().set(domainIdPDU);
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get((String)"cficonVsanEntryStatus").getOid(), index), (SnmpVar)new SnmpInt(4));
        this.getPeer().set(pdu);
        if (members != null && members.trim().length() > 0) {
            int[] vsanIfVsanOid = MibNode.get((String)"vsanIfVsan").getOid();
            SnmpPDU pduMemberInsert = new SnmpPDU(-93, new VarBindList());
            for (int i = 0; i < ifIndexArr.length; ++i) {
                pduMemberInsert.addVar(new SnmpOID(vsanIfVsanOid, ifIndexArr[i]), (SnmpVar)new SnmpInt(vsanId));
            }
            try {
                this.getPeer().set(pduMemberInsert);
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this._parent, (String)("Failed to assign members: " + ex.getMessage()));
            }
        }
        Discover.getInstance();
        if (!FiconPortByIfIndexCache.getInstance((SnmpPeer)Discover.getPeer()).getIsFiconEnabled()) {
            FiconPortByIfIndexCache.getInstance((SnmpPeer)this.getPeer()).setIsFiconEnabled(true, Discover.isSysVersionGreaterThanEqual((String)"3.0(0)"));
        }
        this._parent.dispose();
    }
}

