/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class EditIpCloudForm
extends EditForm {
    static final int AUTO = 0;
    static final int DELAY = 1;
    static final int COMMAND = 3;
    static final int STATUS = 4;
    static final int SUCCESSFUL = 1;
    static final int IN_PROGRESS = 3;
    static final int[] _cIpNetworkDiscoverySpinLockOid = MibNode.get((String)"cIpNetworkDiscoverySpinLock").getOid();
    static final MibEnum[] _cIpNetworkDiscoveryCommandEnum = MibNode.get((String)"cIpNetworkDiscoveryCommand").getEnums();
    boolean _isManualDiscovery = false;
    SnmpPDU _discoveryStatusPDU;
    protected Timer _statusTimer;
    int _elapsedPollTime;

    public EditIpCloudForm(String[] vars) {
        super(vars);
    }

    protected SnmpPDU getSetPDU() throws Exception {
        this._isManualDiscovery = this.isChanged(3);
        SnmpPDU pdu = super.getSetPDU();
        if (this.isChanged(3)) {
            SnmpPDU spinLockPdu = new SnmpPDU(-96, new VarBindList());
            spinLockPdu.addNull(new SnmpOID(_cIpNetworkDiscoverySpinLockOid, 0));
            SnmpPDU resp = this.getPeer().send(spinLockPdu);
            SnmpInt nSpinLock = (SnmpInt)resp.getVar(0);
            pdu.addVar(new SnmpOID(_cIpNetworkDiscoverySpinLockOid, 0), (SnmpVar)nSpinLock);
        }
        return pdu;
    }

    protected void set() throws Exception {
        super.set();
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        this.enableButton('A', false);
        if (this._isManualDiscovery) {
            this._discoveryStatusPDU = new SnmpPDU(-96, new VarBindList());
            this._discoveryStatusPDU.addNull(new SnmpOID(MibNode.get((String)"cIpNetworkDiscoveryCmdStatus").getOid(), new int[]{0}));
            this._elapsedPollTime = 0;
            this._statusTimer = new Timer(3000, (ActionListener)((Object)this));
            this._statusTimer.start();
        }
    }

    void pollSwitch() throws Exception {
        if (this._parent == null) {
            this._statusTimer.stop();
            return;
        }
        SnmpPDU resp = this.getPeer().send(this._discoveryStatusPDU);
        if (resp.getVar(0).getType() == 5) {
            throw new Exception("IP Cloud discovery failed: unknown");
        }
        int state = ((SnmpInt)resp.getVar(0)).getValue();
        if (state == 3) {
            this.setStatus(this._elapsedPollTime + " secs");
            return;
        }
        this._statusTimer.stop();
        this._parent.setCursor(Cursor.getDefaultCursor());
        if (state != 1) {
            this.setStatus(" ");
            int failCause = ((SnmpInt)resp.getVar(0)).getValue();
            throw new Exception("IP Cloud discovery failed: " + MibEnum.getLabel((MibEnum[])MibNode.get((String)"cIpNetworkDiscoveryCmdStatus").getEnums(), (int)failCause));
        }
        this.setStatus("IP Cloud discovery successful [" + this._elapsedPollTime + " secs]");
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (e.getSource() == this._statusTimer) {
            try {
                this._elapsedPollTime += 3;
                this.pollSwitch();
            }
            catch (Exception ex) {
                this._statusTimer.stop();
                throw ex;
            }
        } else {
            super.doIt(ch, e);
        }
    }
}

